create table IF NOT EXISTS  Quality_QualityRecord
(	
	ID integer  primary key ,  				--ID主键
	DepartmentID varchar(50),				--部門ID
	DepartmentAncestorName nvarchar(100),	--部門名称
	DepartmentName nvarchar(100),			--部門名称

	QualityCheckStandardID bigint,			--模板ID	
	QualityCheckStandardName nvarchar(255),	--模板名称

	CheckUserID bigint,						--检查人UserID
	CheckUserName	nvarchar(255),			--检查人

	ReviseUserID bigint,						--整改UserID
    ReviseUserName	nvarchar(255),			--整改人

    ReCheckUserID bigint,						--复查UserID
    ReCheckUserName	nvarchar(255),			--复查人

	CycErrEndDate datetime,
	CycErrBeginDate datetime,
	CheckDate datetime,						--检查时间
	CheckSumScore decimal(18,2),			--检查得分
	CheckModeName nvarchar(1000),			--检查方法
	SubmitStatus tinyint,					--提交状态
    SchduleRule char(10) default('0011')	--是否必须描述拍照
);
create table IF NOT EXISTS  Quality_QualityRecord_Parent
(	
	ID integer  primary key autoincrement ,  --ID主键
	RecordID bigint,						--记录ID　	外键 Quality_QualityRecord(ID)
	ParentID bigint ,  						--核查项父级ID
	ParentItemName nvarchar(255),			--父级名称
	ParentAncestorName nvarchar(255),		--父级名称
	ItemCount int,							--核查项数	
	ItemScore decimal(18,2),				--核查总数
	CheckScore decimal(18,2),				--核查得数
	InvolveItemScore decimal(18,2),				--涉及总分
	InvolveCheckScore decimal(18,2),				--涉及得分
    IsChecked  tinyint default(0),			--是否已核查
    IsUpLoad tinyint default(0)			--是否上传　0未上传　1已上传
);
CREATE Index IF NOT EXISTS  Quality_QualityRecord_Parent_Idx_RecordID on Quality_QualityRecord_Parent(RecordID DESC);
create table IF NOT EXISTS  Quality_QualityRecord_Detail
(	
	ID integer  primary key ,  			--ID主键
	RecordID bigint,					--记录ID		  外键 Quality_QualityRecord(ID)
	ParentID bigint,  					--核查项父级ID

	ItemID bigint,						--核查项ID
	ItemName nvarchar(255),				--核查项名称
	AncestorName nvarchar(255),			--核查项名称
	ItemScore decimal(18,2),			--核查项分数

	IsPass int,							--是否合格
	PassCount int,						--合格样本量
	AllCount int,						--总样本量
	CheckScore decimal(18,2),			--核查项得分
	CheckRemark nvarchar(500),			--核查备注
	CheckRemark2 nvarchar(500),			--核查备注
	CheckMethod nvarchar(500),			--核查方法

    IsChecked  tinyint default(0),		--是否已核查
	CheckDate datetime,					--核查时间
	ReviseLimit datetime,               --整改期限
	PassScoreRate decimal(18,2),		--合格分数比例
	ShowInvolve int,					--是否显示涉及选项
	IsInvolve int,						--是否涉及
	IsDoubt int,						--是否问题项
	IsMustItem int,						--是否必做项
	IsRedLine tinyint default(0),		--是否红线项
    ReviseRequirement nvarchar(500),	--整改建议
    IsUpLoad tinyint default(0),	    --是否上传　0未上传　1已上传
    FileID bigint,                      --附件FileID
    FileIDCount int                     --附件数量
);
CREATE Index IF NOT EXISTS Quality_QualityRecord_Detail_Idx_RecordParentID on Quality_QualityRecord_Detail(RecordID DESC,ParentID DESC);
CREATE Index IF NOT EXISTS Quality_QualityRecord_Detail_Idx_RecordID on Quality_QualityRecord_Detail(RecordID DESC);