create table IF NOT EXISTS  QualityRecord_Rectify
(	
    ID bigint primary key,                  --记录ID
    DepartmentID nvarchar(80),              --受检部门ID
    DepartmentAncestorName nvarchar(255),   --受检部门名称
    DepartmentName nvarchar(255),           --受检部门名称
    QualityCheckStandardID bigint,          --模板ID
    QualityCheckStandardName nvarchar(255), --模板名称
    CheckUserID bigint,                     --核查人ID
    ReCheckUserID bigint,                     --复查人ID
    ReCheckUserName nvarchar(80),             --复查人
    CheckUserName nvarchar(80),             --核查人
    ReviseUserName nvarchar(80),             --整改人
    CheckDate nvarchar(80),                 --核查时间
    TotalQuantity int,                      --总检查数
    NoPassQuantity int,                     --不合格数
    PassQuantity int,                       --合格
    NoInvolveQuantity int,                  --到期整改项数
    ExpiredQuantity int,                    --不涉及
    RevisedQuantity int,                    --已整改
    DoubtQuantity int,                      --问题项
    UnRevisedQuantity int,                      --问题项
    UnReviewPassCount int,                  --复查后不合格项
    IsRectify int                            --是否已整改
);
CREATE Index IF NOT EXISTS QualityRecord_Rectify_Idx_ID on QualityRecord_Rectify(ID DESC);

create table IF NOT EXISTS  QualityRecord_Rectify_Detail
(
    ID bigint primary key,                  --记录ID
    IsPass int,                             --是不合格
    IsChecked int,                          --是否已整改
    CheckRemark nvarchar(500),              --核查说明
    ItemID bigint,                          --核查明细记录ID
    ItemName nvarchar(255),                 --核查明细记录名称
    AncestorName nvarchar(500),             --部门名
    ParentID bigint,                        --父级ID
    CheckMethod nvarchar(500),              --核查方法
    RecordID bigint,                        --核查记录ID
    PassScoreRate decimal(18,2),            --合格分数比例
    IsInvolve int,                          --是否不涉及
    ShowInvolve int,                        --是否显示涉及
    CheckScore decimal(18,2),               --得分
    ReviewResult nvarchar(500),             --复查结果
    ReviewRemark nvarchar(500),             --结果说明
    RevisePlan nvarchar(255),               --整改计划
    CheckDate nvarchar(80),                 --核查时间
    ReviseLimit nvarchar(80),                 --核查时间
    ReviseRequirement nvarchar(255),        --整改建议
    ReviseDate nvarchar(80),                 --整改时间
    ReviseResult nvarchar(255),        --整改结果
    ReviseMeasure nvarchar(255),        --整改建议
    CorrectMeasure nvarchar(255),
    IsRevisedPass nvarchar(255),        --整改建议
    FileID bigint,                          --整改附件
    PlanState int,
    IsRevisedNoPass int,
    IsRevisedNew int,
    IsDoubt int,                            --问题项
    IsReviewedPass int,                     --是否复查合格
    IsReviewedNoPass int,                   --  2 为新 0 已复核过但为不合格 1 已复核合格
    IsReviewedNew int,                      --是否未复查
    IsExpired int,                          --是的到期
    FileID4 bigint,                         --复查附件
    FileID3 bigint,                         --整改附件
    FileID4Count int,                       --复查附件数量
    FileID3Count int,                       --整改附件数量
    IsUpload int,                           --是否上传
    ReviseLimitFate int                     --整改期限天数
);
CREATE Index IF NOT EXISTS QualityRecord_Rectify_Detail_Idx_ID on QualityRecord_Rectify_Detail(ID DESC);
