create Table IF NOT EXISTS Wygl_Service_CommonKeyWord
(
	ID bigint primary key,  		--ID主键
	KeyWord nvarchar(80),		    --关键字
	SearchDate datetime		        --搜索时间
);
CREATE Index IF NOT EXISTS Wygl_Service_CommonKeyWord_Idx_ID on Wygl_Service_CommonKeyWord(ID DESC);

create Table IF NOT EXISTS Wygl_Service_DataDic
(
    ID bigint primary key,  		--ID主键
    ParamValue nvarchar(30),  		--值
    ParamValueName nvarchar(30),  	--名称
    ParamTypeID nvarchar(30),  		--数据字段编号
    OrderID int,  		            --排序编号
    ParamFlag nvarchar(30),  		--属性
    ParamFlagName nvarchar(30)   	--属性名称
);

create Table IF NOT EXISTS Wygl_Service_List
(
	BusinessID bigint primary key,  --业务记录编号
	ServicesID nvarchar(30),        --流程流水号
    PrecinctID bigint,              --所在项目
    CustomerTypeID nvarchar(30),    --受理类型
    CustomerID bigint,              --客户编号
    CustomerName nvarchar(30),      --客户姓名
    CustomerRoomID nvarchar(30),    --房间编号
    ServiceLevel int,               --维修级别
    LevelName nvarchar(30),         --维修级别名称
    ProgressStatus nvarchar(30),    --流程状态
    ServiceStateName nvarchar(30),  --流程状态名称
    CustomerRoomName nvarchar(80),  --房号
    ContactPhone nvarchar(30),      --联系人号码
    ContactAddress nvarchar(80),    --联系地址
    ServiceTypeID int,              --维修类别
    ServiceTypeName nvarchar(30),   --维修类别名称
    Sources nvarchar(30),           --受理形式
    Title nvarchar(80),             --维修内容摘要
    Content nvarchar(80),           --维修内容
    AppointDate nvarchar(80),       --期望上门时间
    ReceptionDate nvarchar(80),     --受理时间
    ReceptionUserID bigint,         --受理人编号
    FlowID bigint,                  --流程模版编号
    PhotoAnnexID bigint,            --现场照片附件编号
    ProgressID bigint,              --流程编号
    Site int,                       --维修部位
    UpgradeTimes int,               --升级次数
    IsDelay int,                    --是否超时
    ReportPhoto bigint,             --受理照片编号
    LastFollowID int,               --大于0说明有跟进
    IsBuildReason int,              --责任方主体
    CreateDate nvarchar(30),
    CreateUserName nvarchar(30),

    --20180424:新增客户标签
    CustomerClass nvarchar(10),     --业主标签
    CustomerClassName nvarchar(30), --业主标签名称
    --20180801:空值时事务状态为待接单否则为待处理
    SubUserName nvarchar(30)        --当期处理人
);
CREATE Index IF NOT EXISTS Wygl_Service_List_Idx_BusinessID on Wygl_Service_List(BusinessID DESC);

create Table IF NOT EXISTS Wygl_Service_Detail
(
	ServiceID bigint primary key,  	--报事编号
    CurrStepID int,  		        --当前步骤编号
    ActionId int,  		            --动作ID
    BindUsers nvarchar(30),  		--提交下一步的处理人
    Advice nvarchar(80),  		    --处理意见
    ActionFlag int,  		        --ActionFlag?
    BusinessID bigint,              --业务记录编号
    ServicesID nvarchar(30),  		--流程流水号
    PrecinctID bigint,  		    --所在项目
    CustomerTypeID nvarchar(30),  	--客户类型
    CustomerID bigint,  		    --客户编号
    CustomerName nvarchar(30),  	--客户姓名
    ContactName nvarchar(30),  	--联系人姓名
    CustomerRoomID nvarchar(80),  	--房间编号
    ProgressStatus nvarchar(30),  	--流程状态
    ServiceState nvarchar(10),      --流程状态
    ServiceStateName nvarchar(30),  --流程状态名称
    IsHouseHolder int,  		    --是否当前业主房产
    CustomerRoomName nvarchar(80),  --房号
    ContactPhone nvarchar(30),  	--联系人号码
    ContactAddress nvarchar(80),  	--联系地址
    ServiceTypeID bigint,  		    --维修类别
    ServiceTypeName nvarchar(30),  	--维修类别名称
    ServiceLevel int,  		        --维修级别
    LevelName nvarchar(30),  		--维修级别名称
    Sources nvarchar(30),  		    --受理形式
    Title nvarchar(80),  		    --维修内容摘要
    TypeName nvarchar(80),  		--维修内容摘要(根据报事分类)
    Content nvarchar(80),  		    --维修内容
    AppointDate nvarchar(80),  		--期望上门时间
    ReceptionDate nvarchar(80),  	--受理时间
    ReceptionUserID bigint,  		--受理人编号
    FlowID bigint,  		        --流程模版编号
    ProgressID bigint,  		    --流程编号
    Site int,  		                --维修部位
    UpgradeTimes int,  		        --升级次数
    DispatchingUserID bigint,  		--派单人编号
    DispatchingUserName nvarchar(30),  	--派单人姓名
    DispatchingRemark nvarchar(80),  	--派单说明
    BaseFinishTime nvarchar(80),  		--要求完成时间
    DistributeDate nvarchar(80),  		--派工时间
    OrderUserID nvarchar(30),  		--接单人编号
    OrderUserName nvarchar(30),  	--接单人姓名
    ArriveDate nvarchar(80),  		--到达时间
    AccomplishTime nvarchar(80),  	--完成时间
    WorkHour int,  		            --处理工时
    SpotCircs nvarchar(80),  		--处理结果
    IsNightService int,  		    --是否夜间服务
    IsDirectReply int,  		    --是否直接解答
    ProblemReason nvarchar(80),  	--原因分析
    Solution nvarchar(80),  		--措施对策
    PaidWay int,  		            --付款方式
    PaidDateTime nvarchar(80),  	--付款时间
    FeedBackCount int,  		    --回访次数
    LastID bigint,  		        --老流程编号
    CancelReason int,  		        --作废原因
    ReceptionUseTime int,  		    --受理用时
    ProcessUseTime int,  		    --处理用时
    IsToUpgrade int,  		        --是否被升级
    FeedBackUserName nvarchar(30),  --回访人
    FeedBackUserID nvarchar(30),  	--回访人编号
    Satisfaction int,  		        --满意度
    Timeliness int,  		        --及时性
    BackResult int,  		        --回访结果
    CustomerIdea nvarchar(80),  	--客户反馈
    SatisfactionWX int,  		    --满意度微信
    CustomerIdeaWX nvarchar(80),  	--客户反馈微信
    Attitude int,  		            --是否礼貌
    ServiceKind int,  		        --受理类型
    IsChargePay int,  		        --有偿无偿
    ExpectedDate nvarchar(80),  	--期望完成时间
    ReceptionUserName nvarchar(30),  	--受理人姓名
    StyleID nvarchar(30),  		    --报事类型
    ProgressStatusValue nvarchar(30),  	--ProgressStatusValue?
    LastFeedBackID bigint,  		--上次回访ID
    FeedBackArrangeUserID bigint,  		   --回访安排人ID
    FeedBackArrangeUserName nvarchar(30),  --回访安排人姓名
    FeedBackArrangeDateTime nvarchar(80),  --回访安排时间
    PhotoAnnexID bigint,  		    --处理前照片
    DealPhoto bigint,  		        --处理后照片
    ConfirmationForm bigint,  		--客户确认单
    ReportPhoto bigint,  		    --受理照片
    DelayDays int,                  --延迟天数
    IsBuildReason int,              --责任方主体
    IsDelay int,                    --是否超时
    IsEdit int,  		            --是否修改

    --20160324:派工步骤新增用料金额，新增审核、验收步骤
    BackOrderUserID nvarchar(80),          --处理人编号
    BackOrderUserName nvarchar(80),        --处理人
    SubUserID long,                        --当期处理人编号
    SubUserName nvarchar(80),              --当期处理人
    MobilePhone nvarchar(80),              --当期处理人电话
    WyglEquipID long,                      --设备id
    EquipID long,                          --设备id
    EquipNo nvarchar(80),                  --设备编号
    EquipName nvarchar(80),                --设备名称
    Location nvarchar(80),                 --安装位置
    DoupCompanyName nvarchar(80),          --维保单位
    QualityDate nvarchar(80),              --质保日期
    MaterialsAmount float,                 --用料金额
    ReceptionUserPhone nvarchar(80),       --受理人电话
    CheckDate nvarchar(80),                --审核时间
    CheckUserID long,                      --审核人id
    CheckUserName nvarchar(80),            --审核人名称
    CheckDepartment long,                  --审核人部门id
    CheckDepartmentName nvarchar(80),      --审核人部门
    CheckRemark nvarchar(80),              --审核说明
    AcceptanceUserID long,                 --验收人id
    AcceptanceUserName nvarchar(80),       --验收人
    AcceptanceDate nvarchar(80),           --验收时间
    AcceptanceResult int,                  --验收结果
    AcceptanceRemark nvarchar(80),         --验收说明
    AcceptancePhoto long,                  --验收照片

    --20160505:新增复核步骤
    ReviewDate nvarchar(80),               --复核时间
    ReviewUserID long,                     --复核人id
    ReviewUserName nvarchar(80),           --复核人名称
    ReviewDepartment long,                 --复核部门id
    ReviewDepartmentName nvarchar(80),     --复核人部门
    ReviewRemark nvarchar(80),             --复核说明

    --20160527:升级在后台执行，去除升级接口
    UpgradeType int,                       --升级类型,1发起升级流程2发起投诉升级流程3无需处理直接闭单
    UpgradeServiceTypeID long,             --升级报事类型,工程不合格升级时不用传

    --20170614:新增联系单位和预约两个步骤
    ContactUnitName nvarchar(80),          --联系单位名称
    ContactDateTime nvarchar(80),          --联系时间
    ContactFeedBackDetail nvarchar(80),    --联系反馈情况
    ThirdUnit int,                         --是否第三方 0 为否
    ThirdUnitPhoto bigint,                 --第三方上传附件
    ThirdContactUnitName nvarchar(80),     --第三方单位名称
    ThirdContactFeedBackDetail nvarchar(80),  --第三方反馈情况
    SiteSurvey int,                        --现场勘察 0 为否
    SiteDateTime nvarchar(80),             --预约 联系时间
    SiteFeedBackDetail nvarchar(80),       --预约 反馈时间
    SiteReservationDateTime nvarchar(80),  --预约 上门时间

    --20180424:新增客户标签
    CustomerClass nvarchar(10),            --业主标签
    CustomerClassName nvarchar(30),        --业主标签名称

    --20180615
    CustomerUserID bigint,
    CustomerDepartmentID nvarchar(30),
    CustomerDepartmentName nvarchar(30)
);
CREATE Index IF NOT EXISTS Wygl_Service_Detail_Idx_BusinessID on Wygl_Service_Detail(BusinessID DESC);

create Table IF NOT EXISTS Wygl_Service_StepNow
(
    _id integer primary key autoincrement ,     --自增长，用于排序
    ServiceID bigint,  	            --报事编号
    IsCanAccept int,  		        --是否可以接单
    CanNotAcceptReason int,  		--不能接单原因
    StepID int,  		            --步骤编号
    StepName nvarchar(30),  		--步骤名称
    FixStepUserWay int,  		    --选人方式
    UserID bigint,  		        --当前处理人
    OperatorStatus int,  		    --步骤状态
    StartDate nvarchar(80),  		--接收时间
    StartDealDate nvarchar(80),  	--接单时间
    DealDate nvarchar(80),  		--处理完成时间
    InterfaceID nvarchar(30),  		--步骤能填写的内容模块编号
    ActionName nvarchar(30),  		--动作名称
    ActionId int,  		            --动作编号
    PreInterfaceID nvarchar(30),  	--步骤历史可显示模块
    JumpInterfaceID nvarchar(30),  	--当前动作下一步显示模块
    IsAcceptance int,               --抽检状态
    PrevDealDate nvarchar(80)       --前一环节的提交时间
);
CREATE Index IF NOT EXISTS Wygl_Service_StepNow_Idx_ServiceID on Wygl_Service_StepNow(ServiceID DESC);

create Table IF NOT EXISTS Wygl_Service_Process
(
    ServiceID bigint,  	            --报事编号
    UserID bigint,                  --步骤人ID
    UserName nvarchar(30),          --步骤人
    StepID bigint,                  --步骤ID
    StepName nvarchar(30),          --步骤名称
    StartDate nvarchar(80),         --开始时间
    DealDate nvarchar(80),          --解决时间
    Advice nvarchar(150),           --建议
    ID bigint primary key,          --步骤记录ID
    PhotoUrl nvarchar(150)          --头像
);

create Table IF NOT EXISTS Wygl_Service_ServiceCommit
(
	ServiceID integer primary key ,
	CurrStepID bigint,
	ActionId bigint,
	ContactAddress nvarchar(200),
    ContactPhone nvarchar(30),
    Content nvarchar(200),
    ContactName nvarchar(30),
    CustomerName nvarchar(30),
    CustomerID bigint,
    CustomerRoomID bigint,
    PrecinctID bigint,
    PrecinctName nvarchar(80),
    ReceptionDate nvarchar(200),
    ReceptionUserID bigint,
    Site bigint,
    SiteName nvarchar(20),
    AppointDate nvarchar(200),
    AppointBeginTime nvarchar(200),
    AppointEndTime nvarchar(200),
    ExpectedDate nvarchar(200),
    StyleID nvarchar(80),
    FlowID bigint,
    ServiceKind bigint,
    IsNightService bigint,
    IsNightServiceName nvarchar(20),
    DispatchingUserName nvarchar(30),
    DispatchingUserID bigint,
    CustomerClass nvarchar(80),
    CustomerClassName nvarchar(80),
    ServiceTypeName nvarchar(80),
    ServiceTypeID bigint,
    ServiceLevel bigint,
    ServiceLevelName nvarchar(30),
    Sources nvarchar(30),
    SaveDate nvarchar(30),
    SourcesName nvarchar(30),
    IsChargePay int,
    FileName nvarchar(80),
    BindUsers nvarchar(80),
    Advice nvarchar(80),
    IsDirectReply bigint,
    SpotCircs nvarchar(80),
    WyglEquipID bigint,
    Title nvarchar(30),
    CustomerUserID bigint,
    CustomerDepartmentID nvarchar(30),
    CustomerDepartmentName nvarchar(30),
    MaintainEquipID bigint,
    MaintainEquipName nvarchar(80)
);