package com.ccb.deviceservice.aidl.deviceinfo;

import com.ccb.deviceservice.aidl.deviceinfo.TusnData;

/**
 * ն豸Ϣ
 * @author: baoxl
 */
interface IDeviceInfo {
	/**
	 * ȡնк
	 * @return ն豸к
	 */
	String getSerialNo();
	
	/**
	 * ȡնIMSI
	 * @return նIMSI
	 */
	String getIMSI();
	
	/**
	 * ȡնIMEI
	 * @return նIMEI
	 */
	String getIMEI();
	
	/**
	 * ȡSIMICCID
	 * @return նSIMICCID
	 */
	String getICCID();
	
	/**
	 * ȡ
	 * @return ն˳
	 */
	String getManufacture();
	
	/**
	 * ȡն豸ͺ
	 * @return ն豸ͺ
	 */
	String getModel();
	
	/**
	 * ȡնAndroidϵͳ汾
	 * @return նAndroidϵͳ汾
	 */
	String getAndroidOSVersion();
	
	/**
	 * ȡնAndroidں˰汾
	 * @return նAndroidں˰汾
	 */
	String getAndroidKernelVersion();
	
	/**
	 * ȡնROM汾
	 * @return նϵͳROM汾
	 */
	String getROMVersion();
	
	/**
	 * ȡն˹̼汾
	 * @return ն˹̼汾
	 */
	String getFirmwareVersion();
	
	/**
	 * ȡնӲ汾
	 * @return նӲ汾
	 */
	String getHardwareVersion();
	
	/**
	 * նϵͳʱ
	 * @param date - ڣʽyyyyMMdd
	 * @param time - ʱ䣬ʽHHmmss
	 * @return ³ɹtrueʧܷfalse
	 **/
	boolean updateSystemTime(String date, String time);
	
	/**
	 * ȡնΨһն˺TUSN
	 * @param mode ģʽ, Ԥ Ϊ0
	 * @param input ָ TUSN MAC ʱ()Χ:4~10ֽ
	 * @return ɹTUSNݣʧܷnull
	 **/
	TusnData getTUSN(int mode, in byte[] input);

	/**
	 * ⰴ
	 * @param bundle - 
	 * <ul>
	 * <li>enableKey(boolean) - ǷʾĬfalse</li>
	 * </ul>
	 **/
	void setVirtualKey(in Bundle bundle);
	
    /**
     * ȡӲкţӲкųΪ32ֽ<br/>
     * ӲкŹ̶Ϊ32ֽڣԷֳ3ÿһĵһֽΪֽڣʾֽĳȡ
     * ΪַܹʾֽͳһΪ09ASCIIʾ'0'~'F'
     * ֮ûи룬еӲкδ32ֽڣȫδֽڲ030HȡʱжϳΪ0ʱʾûˡ
     * ӲкŵĵһֽΪSʾ˾Ʒ
     * ӲкŵĵһʾƷ𡱣E510E520E530E550W280Pȣ
     * Ӳкŵĵڶʾ汾ͺšеİ汾ͺͬ1.00
     * ӲкŵĵʾƷƵġкšекͬ099L0J0Q
     * Ŀǰǹ̶ģƷرעĵط򣬷򲹡0
     * 磺S7APOS A8472A1850630317000000000
     * @param deviceName - 豸ƣ̣
     * @see com.ccb.deviceservice.aidl.pinpad.Constant
     * @return նӲк
     */
	String getHardWareSn(String deviceName);
	
	/**
	 * ״̬״̬
	 * @param enable - Ƿʹ
	 * @return ɹtrueʧܷfalse
	 **/
	boolean enableStatusBar(boolean enable);
	
}
