package com.ccb.deviceservice.aidl.insertreader;

import com.ccb.deviceservice.aidl.insertreader.PowerUpResult;

/**
 * ӴʽIC
 * @author: baoxl
 */
interface IInsertCardReader {
	/**
	 * ϵ
	 * @param mode C ϵģʽ
     * <ul>
     * <li>MODE_EMV(0x01) - EMVģʽ</li>
     * <li>MODE_BPS_576(0x02) - 57600</li>
     * <li>MODE_BPS_384(0x03) - 38400</li>
     * <li>MODE_BPS_192(0x04) - 19200</li>
     * <li>MODE_SHB(0x05) -籣ģʽ</li>
     * <li>MODE_ISO(0x06) - ISO淶ģʽ</li>
     * <li>MODE_TCR(0x07) - ISO淶ϵ磬9600ʣ֧PPS </li>
     * <li>MODE_DEFAULT(0x01) -Ĭϵģʽͬ{@link #MODE_EMV} </li>
	 * </ul>
	 * @param voltage C ϵѹ
     * <ul>
     * <li>VOL_3(0x01) -ϵѹ3V </li>
     * <li>VOL_5(0x02) -ϵѹ5V </li>
     * <li>VOL_18(0x03) -ϵѹ1.8V </li>
     * <li>VOL_DEFAULT(VOL_5) -Ĭϵѹ5Vͬ{@link #VOL_5} </li>
     * </ul>
     * @param result C ϵ
	 * @return ϵɹtrueϵʧfalse
	 */
	boolean powerUp(int mode, int voltage, out PowerUpResult result);
	
	/**
	 * µ
	 * @return رճɹtrueʧfalse
	 */
	boolean powerDown();
	
	/**
	 * ƬǷλ
	 * @return λtrueλfalse
	 */
	boolean isCardIn();
	
	/**
	 * APDUͨѶ
	 * @param apdu - apdu
	 * @return ɹؿƬӦݣʧܷnull
	 */
	byte[] exchangeApdu(in byte[] apdu);
}
