package com.ccb.deviceservice.aidl.pboc;

import com.ccb.deviceservice.aidl.pboc.OnWaitCardListener;
import com.ccb.deviceservice.aidl.pboc.OnUPCardListener;
import com.ccb.deviceservice.aidl.pboc.OnPBOCHandler;
import com.ccb.deviceservice.aidl.pboc.OnOnlineResultHandler;
import com.ccb.deviceservice.aidl.pboc.CandidateAppInfo;

/**
 * PBOCڽ׶<br/>
 * ڿصEMV̡
 * @author: baoxl
 */
interface IPBOC {
    /**
     * PBOC쿨
     * @param cardOption - ֵ֧ĿͣICͷǽӿ
     * <ul>
     * <li>supportMagCard(boolean) - Ƿִ֧</li>
     * <li>supportICCard(boolean) - Ƿ֧IC</li>
     * <li>supportRFCard(boolean) - Ƿַ֧ǽӿ</li>
     * <li>deviceName(String) - ǽӶ豸ǽӲμRFDeviceName</li>
     * <li>insertDeviceName(String) - Ӵʽ豸μConstant.DeviceName</li>
     * </ul>
     * @param timeout - ʱʱ
     * @param listener - 쿨
     */
	void waitCard(in Bundle cardOption, int timeout, OnWaitCardListener listener);
	
    /**
     * ֹͣPBOC쿨
     */   
	void stopWaitCard();
	
    /**
     * ȡֻоƬ
     * @param listener - 
     */
    void readUPCard(OnUPCardListener listener);
	
    /**
     * PBOC
     * @param transType - 
     * <ul>
     * <li>EC_BALANCE(1) - ѯֽ</li>
     * <li>TRANSFER(2) - ת</li>
     * <li>EC_LOAD(3) - ָ˻Ȧ</li>
     * <li>EC_LOAD_U(4) - ƶ˻Ȧ</li>
     * <li>EC_LOAD_CASH(5) - ֽȦ/ֵֽ</li>
     * <li>EC_LOAD_CASH_VOID(6) - Ȧ泷</li>
     * <li>PURCHASE(7) - </li>
     * <li>Q_PURCHASE(8) - ֧</li>
     * <li>CHECK_BALANCE(9) - ѯ</li>
     * <li>PRE_AUTH(10) - ԤȨ</li>
     * <li>SALE_VOID(11) - ѳ</li>
     * <li>SIMPLE_PROCESS(12) - ̽</li>
     * <li>Q_QUERY(13) - qPBOCѯ</li>
     * <li>ICC_QUERY(20) - ־ѯ</li>  
     * </ul>
     * @param intent - 
     * <ul>
     * <li>cardType(int)ͣCARD_INSERT(0)-ӴʽICCARD_RF(1)-ǽӴʽ</li>
     * <li>authAmount(int)Ȩ׽</li>
     * <li>isSupportQ(boolean)Ƿ֧QPBOC</li>
     * <li>isSupportEC(boolean)Ƿֵֽ֧</li>
     * <li>isSupportSM(boolean)Ƿֹ֧</li>
     * <li>isECLoad(boolean)ǷȡȦ־</li>
     * <li>isQPBOCForceOnline(boolean)QPBOCǷ֧ǿ</li>
     * <li>isPBOCForceOnline(boolean)ӴǷ֧ǿ</li>
     * <li>merchantName(String)̻</li>
     * <li>merchantId(String)̻</li>
     * <li>terminalId(String)ն˺</li>
     * <li>outputEmvLog(boolean)Ƿں־sd</li>
     * <li>needCheckRFLimit(boolean)ǽ޶</li>
     * <li>isForceInputPin(boolean)Ƿǿ</li>
     * <li>needCDCVM(boolean)Ƿ֧cdcvm</li>
     * <li>isPreAgain(boolean)ǷγAmex Express Payʹ</li>
     * </ul>
     * @param handler - PBOC̻ص
     */
	void startPBOC(int transType, in Bundle intent, OnPBOCHandler handler);
	
    /**
     * ֹPBOC
     */   
	void abortPBOC();
		
    /**
     * AID
     * @param operation - ʶɾ
     * <ul>
     * <li>1 </li>
     * <li>2ɾ </li>
     * <li>3 </li>
     * </ul>
     * @param aid - AIDAIDTLVַ
     * @return ɹtrueʧfalse
     */
    boolean updateAID(int operation, String aid);

    /**
     * CAԿ
     * @param operation - ʶɾ
     * <ul>
     * <li>1 </li>
     * <li>2ɾ </li>
     * <li>3 </li>
     * </ul>
     * @param rid - CAԿ
     * @return ɹtrueʧfalse
     */
    boolean updateRID(int operation, String rid);
	
    /**
     * ӦѡӦÿƬ
     * @param index - ӦѡŴ1ʼ0Ϊȡ
     */    
    void importAppSelect(int index);
    
    /**
     * 
     * @param amount - ׽
     */    
    void importAmount(int amount);
    
    /**
     * 뿨ϢȷϽ
     * @param pass - Ƿͨ
     */    
    void importCardConfirmResult(boolean pass);
    
    /**
     * PIN
     * @param option(int) - ѡ
     * <ul>
     * <li> CANCEL(0) - ȡ </li>
     * <li> CONFIRM(1) - ȷ </li>
     * </ul>
     * @param pin - PIN
     */    
    void importPin(int option, in byte[] pin);
    
    /**
     * ֤
     * @param option - ȷϽ
     * <ul>
     * <li> CANCEL(0) - ȡBYPASS) </li>
     * <li> CONFIRM(1) - ȷϳֿ </li>
     * <li> NOTMATCH(2) - Ϣ </li>
     * </ul>
     */    
    void importCertConfirmResult(int option);
    
    /**
     * Ӧ
     * @param onlineResult - 
     * <ul>
     * <li> isOnline(boolean) - Ƿ</li>
     * <li> respCode(String) - Ӧ</li>
     * <li> authCode(String) - Ȩ </li>
     * <li> field55(String) - 55Ӧ</li>
     * </ul>
     * @param handler - 
     */
    void inputOnlineResult(in Bundle onlineResult, OnOnlineResultHandler handler);

    /**
     * TLVں˲
     * @param tlvList òTLVб
     */
    void setEMVData(in List<String> tlvList);
    
    /**
	 * ȡPBOCںTLVб
	 * @param taglist - Ҫõtagб
	 * @return tlvݣnullʾû
	 */
	String getAppTLVList(in String[] taglist);
	
    /**
	 * ȡƬEMVԪ
	 * @param tagName - ǩ
	 * @return ƬEMV
	 */
	byte[] getCardData(String tagName);
	
	/**
	 * ȡPBOCݣ翨šЧڡƬкŵȡ<br/>
	 * <em>EMVִеӦ̲ܻȡӦĿƬݣ򷵻ؿա</em>
	 * @param tagName - ǩ
	 * <ul>
     * <li> PAN(Stirng) - </li>
     * <li> TRACK2(Stirng) - ŵ</li>
     * <li> CARD_SN(Stirng) - Ƭк </li>
     * <li> EXPIRED_DATE(Stirng) - Ч</li>
     * <li> DATE(Stirng) - </li>
     * <li> TIME(Stirng) - ʱ</li>
     * <li> BALANCE(String) - ֽ</li>
     * <li> CURRENCY(String) - </li>
     * <li> CARD_ORG(String) - ֯</li>
     * <li> CVM(String) - ֿ֤</li>
     * <li> CARD_PRODUCT_TYPE(String) - Ʒ𣬸ֵConstant.CardProductType</li>
     * </ul>
	 * @return PBOCں˷ص
	 */
	String getPBOCData(String tagName);
	
    /**
	 * ȡƬѡӦϢ<br/>
	 * ڵǩͺСǩܡ
	 * @return ƬѡӦϢ{@link CandidateAppInfo}
	 */
	CandidateAppInfo getCandidateAppInfo();
}
