package com.ccb.deviceservice.aidl.rfreader;

import com.ccb.deviceservice.aidl.rfreader.OnPassListener;

/**
 * ǽӴʽIC
 * @author: baoxl
 */
interface IRFCardReader {
	/**
	 * ǽѰϵ<br/>
	 * @param listener - Ѱ
	 */
	void waitCard(OnPassListener listener);
	
	/**
	 * ֹͣѰ
	 * @return رճɹtrueʧfalse
	 */
	void stopWait();
	
	/**
	 * ƬǷλ
	 * @return λtrueλfalse
	 */
	boolean isExist();
	
	/**
	 * Ƭ<br/>
	 * @param driver - 
	 * <ul>
     * <li>"S50" - S50</li>
     * <li>"S70" - S70</li>
     * <li>"CPU" - CPU</li>
     * <li>"PRO" - PROS5O_PROS70_PRO</li>
	 * </ul>
	 * @param responseData - ƬӦ
	 * @return 0ʾɹʧܡ
	 */
	int activate(String driver, out byte[] responseData);
	
	/**
	 * ر豸ٴβѰʼ<br/>
	 */
	void halt();
	
	/**
	 * APDUͨѶ
	 * @param apdu - apdu
	 * @return ɹؿƬӦݡ
	 */
	byte[] exchangeApdu(in byte[] apdu);
	
	/**
	 * ֤(ݿ)
	 * <ul>
	 * <li>Կִжд޸ĵĲʱȽ֤ͬʱֻ֤һڶԲͬвʱҪ֤</li><br/>
	 * <li>ýӿҪָ֤ľλ</li>
	 * </ul>
	 * @param blockNo ţ0ʼ
	 * @param keyType Կ KEY_A  KEY_B
	 * @param key     Կ6ֽڳ
	 * @return ɹ0x00ʧ
	 */
	int authBlock(int blockNo, int keyType, in byte[] key);
	
    /**
	 * ֤()<br/>
	 * <ul>
	 * <li>Կִжд޸ĵĲʱȽ֤ͬʱֻ֤һڶԲͬвʱҪ֤</li><br/>
	 * <li>ýӿֻҪָҪԶԸĵ3(0)֤</li>
	 * </ul>
	 * @param sectorNo 	ţ0ʼ
	 * @param keyType	Կ KEY_A  KEY_B
	 * @param key		Կ,6ֽڳ
	 * @return ɹ0x00ʧ
	 */
	int authSector(int sectorNo, int keyType, in byte[] key);
	
	/**
	 * 
	 * @param blockNo - 
	 * @param data - ȡصĿ(16ֽ)
	 * @return ɹ0x00ʧ
	 */
	int readBlock(int blockNo, out byte[] data);
	
	/**
	 * д<br/>
	 * <ul>
	 * <li>16ֽڵݣûдﵽֽΪǴ</li>
	 * </ul>
	 * @param blockNo - 
	 * @param data - ָдָĿ
	 * @return ɹ0x00ʧ
	 */
	int writeBlock(int blockNo, in byte[] data);
	
	/**
	 * ֵ</br>
	 * ֵָһֵ<br/>
	 * @param blockNo - 
	 * @param value - 
	 * @return ɹ0x00ʧ
	 */
	int increaseValue(int blockNo, int value);
	
	/**
	 * ֵ</br>
	 * һֵмȥֵָ<br/>
	 * @param blockNo - 
	 * @param value - 
	 * @return ɹ0x00ʧ
	 */
	int decreaseValue(int blockNo, int value);
}
