package com.ccb.deviceservice.aidl.serialport;

/**
 * 豸<br/>
 * ʵִշܡ
 * @author: baoxl
 */
interface ISerialPort {
	/**
	 * 򿪴
	 * @return ɹtrueʧfalse
	 */
	boolean open();
	
	/**
	 * رմ
	 * @return ɹtrueʧfalse
	 */
	boolean close();
	
	/**
	 * ʼ
	 * @param bps	
	 * <ul>
     * <li>BPS_1200(0x01) - 1200</li>
     * <li>BPS_2400(0x02) - 2400</li>
     * <li>BPS_4800(0x03) - 4800</li>
     * <li>BPS_9600(0x04) - 9600</li>
     * <li>BPS_14400(0x05) - 14400 </li>
     * <li>BPS_28800(0x06) - 28800 </li>
     * <li>BPS_19200(0x07) - 19200</li>  
     * <li>BPS_57600(0x08) - 57600 </li>
     * <li>BPS_115200(0x09) - 115200ʣȱʡ</li>
     * <li>BPS_38400(0x0A) - 38400</li> 
     * </ul>
	 * @param par	Ч
	 * <ul>
     * <li>PAR_NOPAR('N') - Ч飨ȱʡ</li>
     * <li>PAR_EVEN('E') - żЧ</li>
     * <li>PAR_ODD('O') - Ч</li>
     * </ul>
	 * @param dbs	λ
	 * <ul>
     * <li>DBS_7(0x07) - 7λλ</li>
     * <li>DBS_8(0x08) - 8λλȱʡ</li>
     * </ul>
	 * @return ɹtrueʧfalse
	 */
	boolean init(int bps, int par, int dbs); 
	
	/**
	 * ()
	 * @param buffer	
	 * @param timeout	ʱʱ䣬
	 * @return ʵʶȡݳȣʧܷ-1
	 */
	int read(inout byte[] buffer, int timeout);
	
    /**
	 * д()
	 * @param data		Ҫ͵
	 * @param timeout	ʱʱ䣬
	 * @return ʵдݳȣʧܷ-1
	 */
	int write(in byte[] data, int timeout);
	
	/**
	 * ջ
	 * @return ɹtrueʧfalse
	 */
	boolean clearInputBuffer();
	
	/**
	 * 鿴ǷΪ
	 * @param input	trueΪ뻺falseΪ
	 * @return ɹtrueʧfalse
	 */
	 boolean isBufferEmpty(boolean input);
}
