package com.ccb.deviceservice.aidl.signpanel;

import com.ccb.deviceservice.aidl.signpanel.BytesValue;
import com.ccb.deviceservice.aidl.signpanel.IntValue;
import com.ccb.deviceservice.aidl.signpanel.OnSignListener;

/**
 * ǩְ豸<br/>
 * ʵǩְ幦ܡ
 * @author: caizl
 */
interface ISignPanel {

	/**
	 * ǩ
	 */
	boolean open();
	
	/**
	 * ʼǩ
	 * @param param - 
	 * <ul>
	 * <li>pecialCode(String) - ׵Ľ룬͸ǩڸͼϳ</li>
	 * <li>timeout(int) - ȴӦϢʱʱ䡣λ </li>
	 * </ul>
	 * @param listener - ǩ̼
	 */
	void startSign(in Bundle param, OnSignListener listener);
	
	/**
	 * رǩ
	 */
	void close();
	
	/**
	 * ò
	 * @param key - μConstant.Parameter
	 * @param value - ֵ
	 * @return ɹ:true,ʧ:false
	 */
	boolean setParameter(int key, int value);
	
	/**
	 * ȡֵ
	 * @param key - 
	 * @param value - ֵ
	 * @return ɹ:true,ʧ:false
	 */
	boolean getParameter(int key, out IntValue value);
	
	/**
	 * PBMλͼݻBMPֵɫλͼݽJBIGѹýӿݲ֧֣Ԥ
	 * @param data - Ҫѹ
	 * @param dataType - ѹǰݵĸʽConstant.DataType
	 * @param compData - ѹ
	 * @return ɹ:true,ʧ:false
	 */
	boolean jbigCompression(in byte[] data, out IntValue dataType, out BytesValue compData);
	
	/**
	 * ѹĶֵλͼݽнѹѹݿPBMʽɫBMPʽ
	 * @param data - Ҫнѹ
	 * @param dataType - ѹݵĸʽConstant.DataType
	 * @param decompData - ѹ
	 * @return ɹ:true,ʧ:false
	 */
	boolean jbigDecompression(in byte[] data, int dataType, out BytesValue decompData);
	
	/**
	 * BMPPBMʽתΪPOSɴӡݸʽ
	 * @param data - ҪдӡݣĿǰֵֻ֧ɫBMPλͼݺPBMļݣ
	 * @param printData - תĴӡ
	 * @return ɹ:true,ʧ:false
	 */
	boolean transBitmapToPrinter(in byte[] data, out BytesValue printData);
	
	/**
	 * ĶֵλͼתʺϽλͼ,Ҫڽ240x80СǩϢͼƬʺϽʽӡĴС,ĿǰתĴС̶Ϊ120x40
	 * @param srcBmp - ɫbmp λͼݣҪ:>=120,>=40
	 * @param outBmp - תʺBMPλͼ
	 * @param width - תλͼĿ
	 * @param height - תλͼĸ߶
	 * @param size - תλͼĴС
	 * @return ɹ:true,ʧ:false
	 * @deprecated ýӿֻ򳡾õʷ
	 */
	boolean bmpResizeForStylusPrinter(in byte[] srcBmp, out BytesValue outBmp, out IntValue width, out IntValue height, out IntValue size);
	
}
