> 本模块为简易的权限申请模块，且在为Fa2提供更舒服的权限申请。本模块同步支持中/英调用。

### 快速使用该模块
 最简单的使用方法如下

> 英文调用
```lua
SimplePermissions:with()--启动权限申请
:allPermission()--请求清单里面的全部权限
:start()
```
> 中文调用
```lua
SimplePermissions:启动()--启动权限申请
:请求全部权限()--请求清单里面的全部权限
:开始()
```
 这样子调用会直接请求权限，但无法监听是否请求成功或者失败。

### 申请某个权限

要只想申请某个权限也很简单
调用

```lua
:permission("android.permission.READ_EXTERNAL_STORAGE","android.permission.WRITE_EXTERNAL_STORAGE")
```
或者
```lua
:请求权限("android.permission.READ_EXTERNAL_STORAGE","android.permission.WRITE_EXTERNAL_STORAGE")
```
支持多参数和table调用

### 添加权限申请回调

在上面的``start()``方法之后，你可以添加``:callback(callbackFunction)``函数用于添加权限申请回调

```lua
:callback(function(isSuccessAll,successList,failList)
print(isSuccessAll,dump(successList),dump(failList))
end)
```
或
```lua
:回调(function(是否全部请求成功,请求成功权限权限,请求失败权限列表)
  print(是否全部请求成功,dump(请求成功权限权限),dump(请求失败权限列表))end)
  
```
传入的三个参数分别为

请求的全部权限是否成功, 请求成功的权限列表, 请求失败的权限列表

### 检查是否含有权限

检查权限的代码如下(直接调用)

```lua
print(SimplePermissions.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE"))
```
或者
```lua
print(权限请求框架.检查权限("android.permission.WRITE_EXTERNAL_STORAGE"))
```

同时也支持多参和table调用,如果传入多个参数调用的话 返回的值是没含有权限的列表，即

```lua
print(#SimplePermissions.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE","android.permission.READ_EXTERNAL_STORAGE")==0)--是否全部请求成功
```
### 实例

以下代码演示了如何请求读取和写入内部存储

```lua
local requiresPermissions=SimplePermissions.Permission.Group.STORAGE
--1.2版本内置一些基础权限的字符串，详情可以拆包查看
--{"android.permission.WRITE_EXTERNAL_STORAGE",  "android.permission.READ_EXTERNAL_STORAG"}
 if (#SimplePermissions.checkPermission(requiresPermissions)==0) then  
  print("已同意请求以上权限!") 
 else 
  SimplePermissions:with()--启动权限申请 
 :permission(requiresPermissions)--请求权限    
 :start()  
 :callback(function(a,b,c) 
      if a then   
         print("已同意请求以上权限!")     
      else   
         print("好家伙，你不同意权限。。")   
      end
   end)
end
```
