lock_value () {
  chmod 644 $2
  echo $1 > $2
  chmod 444 $2
}

gpu_freq(){
  # echo 'gpu_freq' $state
  if [[ "$state" == "-1" ]]; then
    echo -1 > /proc/gpufreqv2/fix_target_opp_index
  else
    freq_row=$(grep "$state," /proc/gpufreqv2/stack_signed_opp_table)
    # echo $freq_row
    # echo "[${freq_row:1:2}]" /proc/gpufreqv2/fix_target_opp_index
    echo ${freq_row:1:2} > /proc/gpufreqv2/fix_target_opp_index
  fi
}

gpu_freq_cur_khz() {
 gpu_freq_cur Khz
}
gpu_freq_cur() {
 opp=$(grep ':' /proc/gpufreqv2/fix_target_opp_index | cut -f2 -d ':')
 if [[ "$opp" == "" ]]; then
   echo ''
 else
   opp=$(printf "%02d" $opp)
   freq_row=$(grep "\[$opp\*\]" /proc/gpufreqv2/stack_signed_opp_table)
   echo -n ${freq_row:11:7}$1
 fi
}

ddr_freq () {
  if [[ -d /sys/devices/platform/soc/1c00f000.dvfsrc ]]; then
    dir='/sys/devices/platform/soc/1c00f000.dvfsrc'
    dvfsrc=${dir}/mtk-dvfsrc-devfreq/devfreq/mtk-dvfsrc-devfreq
  elif [[ -d /sys/class/devfreq/mtk-dvfsrc-devfreq ]]; then
    dvfsrc=/sys/class/devfreq/mtk-dvfsrc-devfreq
  else
    dir='/sys/devices/platform/1c00f000.dvfsrc'
    dvfsrc=${dir}/mtk-dvfsrc-devfreq/devfreq/mtk-dvfsrc-devfreq
  fi
  echo $state > $dvfsrc/min_freq
}

ddr_freq_fixed () {
  if [[ -d /sys/devices/platform/soc/1c00f000.dvfsrc ]]; then
    dir='/sys/devices/platform/soc/1c00f000.dvfsrc'
  else
    dir='/sys/devices/platform/1c00f000.dvfsrc'
  fi
  dvfsrc=${dir}/1c00f000.dvfsrc:dvfsrc-helper/dvfsrc_force_vcore_dvfs_opp

  echo $state > $dvfsrc
}

# gpu_freq_max [oppIndex]
gpu_freq_max() {
  lock_value $state /sys/kernel/ged/hal/custom_upbound_gpu_freq
}
# gpu_freq_max_freq [freqKHZ]
gpu_freq_max_freq() {
  lock_value $state /sys/kernel/ged/hal/custom_upbound_gpu_freq

  state=-1
  gpu_freq
}
gpu_freq_max_freq_cur(){
  cur=$(cat /sys/kernel/ged/hal/custom_upbound_gpu_freq)
  cur=$(printf "%02d" $cur)
  freq_row=$(grep "\[$cur\*\]" /proc/gpufreqv2/stack_signed_opp_table)
  echo -n ${freq_row:11:7}$1
}
gpu_freq_max_freq_cur_khz(){
  gpu_freq_max_freq_cur Khz
}

verify_sc(){
  sc=$(pgrep scene-scheduler)
  if [[ "$sc" != "" ]]; then
    echo '检测到SCENE的性能调节策略正在运行，本次修改可能很快会被覆盖甚至不会成功！' 1>&2
    killall scene-scheduler 2>/dev/null
  fi
}
set_dcs_mode(){
  verify_sc
  dcs_mode=/sys/kernel/ged/hal/dcs_mode
  chmod 777 $dcs_mode
  echo $state > $dcs_mode
  chmod 444 $dcs_mode
}
set_ged_kpi(){
  verify_sc
  ged_kpi=/sys/module/sspm_v3/holders/ged/parameters/is_GED_KPI_enabled
  chmod 777 $ged_kpi
  echo $state > $ged_kpi
  chmod 444 $ged_kpi
}
set_fpsgo(){
  verify_sc
  fpsgo=/sys/kernel/fpsgo/common/fpsgo_enable
  chmod 777 $fpsgo
  echo $state > $fpsgo
  chmod 444 $fpsgo
}

lock_val() {
  chmod 664 $2 2>/dev/null
  echo $1 > $2
  chmod 000 $2 2>/dev/null
}
ulock_val(){
  chmod 664 $2 2>/dev/null
  echo $1 > $2
}
