platform=`getprop ro.board.platform | tr 'A-Z' 'a-z'`
mode="$state"

if [[ "$MAGISK_PATH" == "" ]]; then
  MAGISK_PATH="/data/adb/modules/scene_systemless"
fi

# 方案2 - 替换到 /data
thermal_dir="/data/vendor/thermal"
install_dir="$thermal_dir/config"
mode_state_save="$install_dir/thermal.current.ini"
resource_dir="./kr-script/miui/thermal_conf3/$platform/$mode"

thermal_files=(
)

# 覆盖 thermal_files
# source ./kr-script/miui/thermal_conf3/$platform/thermal_files.sh
source ./kr-script/miui/thermal_conf3/download.sh

clear_old() {
  old_dir="${MAGISK_PATH}/system/vendor/etc"
  old_state_save="$old_dir/thermal.current.ini"
  if [[ -f $old_state_save ]]; then
    echo '清理旧版文件'
    for thermal in ${thermal_files[@]}; do
      if [[ -f $old_dir/$thermal ]]; then
        rm -f $old_dir/$thermal
      fi
    done
    rm -f "$old_state_save" 2> /dev/null

    echo '建议稍后重启手机' 1>&2
    echo '#################################'
  fi
}

uninstall_thermal() {
  clear_old

  echo "从 $install_dir 目录"
  echo '卸载已安装的自定义配置……'
  echo ''

  # 如果thermal目录被覆盖为文件，一般是刷了温控屏蔽模块所致
  if [[ -f "$thermal_dir" ]]; then
    chattr -i "$thermal_dir" # 2> /dev/null
    rm -f "$thermal_dir"
    echo '发现关键目录被破坏，Scene已尝试自动纠正此错误' 2> /dev/null
    echo '现在需要先重启手机，使确保系统温控功能恢复正常' 2> /dev/null
    echo '如果你刷入的其它第三方温控还未删除，请先将其删除再重启手机' 2> /dev/null
    exit 3
  fi

  if [[ -f "$install_dir" ]]; then
    chattr -i "$install_dir" # 2> /dev/null
    rm -f "$install_dir"
    echo '系统目录遭到破坏，切换温控可能无法顺利进行' 1>&2
    echo '你大概需要重启手机，温控配置才[有可能]生效~' 1>&2
    sleep 8
  elif [[ -d "$install_dir" ]]; then
    chattr -R -i "$install_dir" # 2> /dev/null
    rm -rf "$install_dir/*" 2> /dev/null
  fi

  rm $install_dir/* 2>/dev/null
  rm -f "$mode_state_save" 2> /dev/null

  echo ''
}

install_thermal() {
  uninstall_thermal

  echo '检测模块间是否存在冲突……'
  echo ''

  # 检查其它模块是否更改温控
  local magisk_dir=`echo $MAGISK_PATH | awk -F '/[^/]*$' '{print $1}'`
  local modules=`ls $magisk_dir`
  for module in ${modules[@]}; do
    if [[ ! "$magisk_dir/$module" = "$MAGISK_PATH" ]] && [[ -d "$magisk_dir/$module" ]] && [[ ! -f "$magisk_dir/$module/disable" ]]; then
      if [[ "$module" != "uperf" ]] && [[ "$module" != "extreme_gt" ]]; then
        find_result=`find "$magisk_dir/$module" -name "*thermal*" -type f`
        if [[ -n "$find_result" ]]; then
          echo '发现其它修改温控的模块：' $module 1>&2
          echo "$find_result" 1>&2
          echo '请删除以上位置的文件，或禁用相关模块！' 1>&2
          echo '否则，Scene无法正常替换系统温控！' 1>&2
          exit 5
        fi
      fi
    fi
  done

  download_files

  echo ''
  echo '#################################'
  cat $resource_dir/info.txt
  echo ''
  echo '#################################'
  echo ''
  echo ''

  if [[ ! -d "$install_dir" ]]; then
    mkdir -p "$install_dir"
  fi

  # for thermal in ${thermal_files[@]}; do
  #   if [[ -f "$resource_dir/$thermal" ]]; then
  #     echo '复制' $thermal
  #     cp "$resource_dir/$thermal" "$install_dir/$thermal"
  #     chmod 644 "$install_dir/$thermal"
  #   elif [[ -f "$resource_dir/general.conf" ]]; then
  #     echo '复制' $thermal
  #     cp "$resource_dir/general.conf" "$install_dir/$thermal"
  #     chmod 644 "$install_dir/$thermal"
  #   fi
  #   dos2unix "$install_dir/$thermal" 2> /dev/null
  # done

  # ls $resource_dir | while read thermal; do
  echo "$all_file_names" | dos2unix | while read thermal; do
    if [[ -f "$resource_dir/$thermal" ]]; then
      echo '复制' $thermal
      cp "$resource_dir/$thermal" "$install_dir/$thermal"
      chmod 444 "$install_dir/$thermal"
    elif [[ -f "$resource_dir/general.conf" ]]; then
      echo '复制' $thermal
      cp "$resource_dir/general.conf" "$install_dir/$thermal"
      chmod 444 "$install_dir/$thermal"
    else
      echo '跳过' $thermal
    fi
    dos2unix "$install_dir/$thermal" 2> /dev/null
  done

  echo "$mode" > "$mode_state_save"

  echo 'OK~'
  echo ''
  echo '留意，如果你使用的不是官方原版系统，或曾使用其它工具或模块更改温控，此操作可能不会生效'
  echo '如遇温控切换不生效情况，可尝试重启手机，如果重启后依然无效，那……' 1>&2
}

if [[ "$mode" == "default" ]]; then
  uninstall_thermal
else
  install_thermal
fi
