/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.device.yearclass;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;

public class DeviceInfo {
    public static final int DEVICEINFO_UNKNOWN = -1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUMaxFreqKHz() {
        int maxFreq;
        block13: {
            maxFreq = -1;
            try {
                for (int i = 0; i < DeviceInfo.getNumberOfCPUCores(); ++i) {
                    String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoMaxFreqFile = new File(filename);
                    if (!cpuInfoMaxFreqFile.exists()) continue;
                    byte[] buffer = new byte[128];
                    try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; buffer[endIndex] >= 48 && buffer[endIndex] <= 57 && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                }
                if (maxFreq != -1) break block13;
                try (FileInputStream stream = new FileInputStream("/proc/cpuinfo");){
                    int freqBound = DeviceInfo.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1000) > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
            }
            catch (IOException e) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static long getTotalMemory(Context c) {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            if (memInfo != null) {
                return memInfo.totalMem;
            }
            return -1L;
        }
        long totalMem = -1L;
        try (FileInputStream stream = new FileInputStream("/proc/meminfo");){
            totalMem = DeviceInfo.parseFileForValue("MemTotal", stream);
            totalMem *= 1024L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return totalMem;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i = 0; i < length; ++i) {
                int textIndex;
                if (buffer[i] != 10 && i != 0) continue;
                if (buffer[i] == 10) {
                    // empty if block
                }
                for (int j = ++i; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return DeviceInfo.extractValue(buffer, j);
                }
            }
        }
        catch (IOException e) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (buffer[index] >= 48 && buffer[index] <= 57) {
                int start = index++;
                while (index < buffer.length && buffer[index] >= 48 && buffer[index] <= 57) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }
}

