/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.device.yearclass;

import android.content.Context;
import com.facebook.device.yearclass.DeviceInfo;
import java.util.ArrayList;
import java.util.Collections;

public class YearClass {
    public static final int CLASS_UNKNOWN = -1;
    public static final int CLASS_2008 = 2008;
    public static final int CLASS_2009 = 2009;
    public static final int CLASS_2010 = 2010;
    public static final int CLASS_2011 = 2011;
    public static final int CLASS_2012 = 2012;
    public static final int CLASS_2013 = 2013;
    public static final int CLASS_2014 = 2014;
    private static final long MB = 0x100000L;
    private static final int MHZ_IN_KHZ = 1000;
    private static volatile Integer mYearCategory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int get(Context c) {
        if (mYearCategory != null) return mYearCategory;
        Class<YearClass> clazz = YearClass.class;
        synchronized (YearClass.class) {
            if (mYearCategory != null) return mYearCategory;
            mYearCategory = YearClass.categorizeByYear(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mYearCategory;
        }
    }

    private static void conditionallyAdd(ArrayList<Integer> list, int value) {
        if (value != -1) {
            list.add(value);
        }
    }

    private static int categorizeByYear(Context c) {
        ArrayList<Integer> componentYears = new ArrayList<Integer>();
        YearClass.conditionallyAdd(componentYears, YearClass.getNumCoresYear());
        YearClass.conditionallyAdd(componentYears, YearClass.getClockSpeedYear());
        YearClass.conditionallyAdd(componentYears, YearClass.getRamYear(c));
        if (componentYears.isEmpty()) {
            return -1;
        }
        Collections.sort(componentYears);
        if ((componentYears.size() & 1) == 1) {
            return componentYears.get(componentYears.size() / 2);
        }
        int baseIndex = componentYears.size() / 2 - 1;
        return componentYears.get(baseIndex) + (componentYears.get(baseIndex + 1) - componentYears.get(baseIndex)) / 2;
    }

    private static int getNumCoresYear() {
        int cores = DeviceInfo.getNumberOfCPUCores();
        if (cores < 1) {
            return -1;
        }
        if (cores == 1) {
            return 2008;
        }
        if (cores <= 3) {
            return 2011;
        }
        return 2012;
    }

    private static int getClockSpeedYear() {
        long clockSpeedKHz = DeviceInfo.getCPUMaxFreqKHz();
        if (clockSpeedKHz == -1L) {
            return -1;
        }
        if (clockSpeedKHz <= 528000L) {
            return 2008;
        }
        if (clockSpeedKHz <= 620000L) {
            return 2009;
        }
        if (clockSpeedKHz <= 1020000L) {
            return 2010;
        }
        if (clockSpeedKHz <= 1220000L) {
            return 2011;
        }
        if (clockSpeedKHz <= 1520000L) {
            return 2012;
        }
        if (clockSpeedKHz <= 2020000L) {
            return 2013;
        }
        return 2014;
    }

    private static int getRamYear(Context c) {
        long totalRam = DeviceInfo.getTotalMemory(c);
        if (totalRam <= 0L) {
            return -1;
        }
        if (totalRam <= 0xC000000L) {
            return 2008;
        }
        if (totalRam <= 0x12200000L) {
            return 2009;
        }
        if (totalRam <= 0x20000000L) {
            return 2010;
        }
        if (totalRam <= 0x40000000L) {
            return 2011;
        }
        if (totalRam <= 0x60000000L) {
            return 2012;
        }
        if (totalRam <= 0x80000000L) {
            return 2013;
        }
        return 2014;
    }
}

