/*
 * Decompiled with CFR 0.152.
 */
package com.distriqt.core.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.distriqt.core.utils.FREUtils;
import com.distriqt.core.utils.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;

public class Assets {
    public static final String TAG = Assets.class.getName();

    public static boolean exists(Context context, String path) {
        try {
            String assetName = path.substring(0, 1).equals("/") ? path.substring(1) : path;
            context.getAssets().open(assetName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static File getAssetFile(Context context, String path) {
        String assetName = path.substring(0, 1).equals("/") ? path.substring(1) : path;
        String assetFileName = assetName.replace("/", "_");
        return Assets.getAssetFile(context, path, assetFileName);
    }

    public static File getAssetFile(Context context, String path, String assetFileName) {
        if (!Assets.exists(context, path)) {
            return null;
        }
        try {
            String assetName = path.substring(0, 1).equals("/") ? path.substring(1) : path;
            File cachedVersion = new File(context.getCacheDir(), assetFileName);
            LogUtil.d("com.distriqt.Core", TAG, "COPYING ASSET TO CACHE: %s -> %s", path, cachedVersion.getAbsolutePath());
            FileOutputStream outputStream = new FileOutputStream(cachedVersion);
            InputStream assetInputStream = context.getAssets().open(assetName);
            Assets.copyFile(assetInputStream, outputStream);
            outputStream.close();
            assetInputStream.close();
            return cachedVersion;
        }
        catch (Exception e) {
            FREUtils.handleException(null, e);
            return null;
        }
    }

    public static String getAssetFilePath(Context context, String assetName) {
        try {
            File f = Assets.getAssetFile(context, assetName);
            if (f != null) {
                return f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static AssetFileDescriptor getAssetFileDescriptor(Context context, String path) {
        if (!Assets.exists(context, path)) {
            return null;
        }
        try {
            String assetName = path.substring(0, 1).equals("/") ? path.substring(1) : path;
            FREUtils.log(TAG, String.format("opening %s", assetName), new Object[0]);
            return context.getAssets().openFd(assetName);
        }
        catch (FileNotFoundException e) {
            FREUtils.handleException(null, e);
        }
        catch (Exception e) {
            FREUtils.handleException(null, e);
        }
        return null;
    }

    public static void listAssets(Context context) {
        FREUtils.log(TAG, " ==================== LIST ASSETS : BEGIN =========================", new Object[0]);
        AssetManager assetManager = context.getAssets();
        Assets.listAssetsInDirectory(assetManager, "");
        FREUtils.log(TAG, " ==================== LIST ASSETS : END   =========================", new Object[0]);
    }

    private static void listAssetsInDirectory(AssetManager assetManager, String path) {
        try {
            if (path.equals("images") || path.equals("webkit") || path.equals("sounds") || path.equals("META-INF")) {
                return;
            }
            String[] files = assetManager.list(path);
            for (int i = 0; i < files.length; ++i) {
                FREUtils.log(TAG, String.format(Locale.UK, "%s/%s", path, files[i]), new Object[0]);
                Assets.listAssetsInDirectory(assetManager, path + (path.length() > 0 ? "/" : "") + files[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File copyFileToPublicCache(Context context, String path) {
        FREUtils.log(TAG, "copyFileToPublicCache( %s )", path);
        try {
            File f = new File(path);
            if (f.exists()) {
                FREUtils.log(TAG, "copyFileToPublicCache(): %s", f.getName());
                File of = new File(context.getExternalCacheDir(), f.getName());
                FileOutputStream outputStream = new FileOutputStream(of);
                FileInputStream inputStream = new FileInputStream(new File(path));
                Assets.copyFile(inputStream, outputStream);
                return of;
            }
        }
        catch (Exception e) {
            FREUtils.handleException(null, e);
        }
        return null;
    }

    private static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }
}

