/*
 * Decompiled with CFR 0.152.
 */
package com.distriqt.core.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

public class ImageConversion {
    public static void YUV_NV21_TO_RGB(byte[] argb, byte[] yuv, int width, int height) {
        int frameSize = width * height;
        boolean ii = false;
        boolean ij = false;
        boolean di = true;
        boolean dj = true;
        int a = 0;
        int i = 0;
        int ci = 0;
        while (i < height) {
            int j = 0;
            int cj = 0;
            while (j < width) {
                int y = 0xFF & yuv[ci * width + cj];
                int v = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 0];
                int u = 0xFF & yuv[frameSize + (ci >> 1) * width + (cj & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int r = (int)(1.164f * (float)(y - 16) + 1.596f * (float)(v - 128));
                int g = (int)(1.164f * (float)(y - 16) - 0.813f * (float)(v - 128) - 0.391f * (float)(u - 128));
                int b = (int)(1.164f * (float)(y - 16) + 2.018f * (float)(u - 128));
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                argb[a++] = (byte)b;
                argb[a++] = (byte)g;
                argb[a++] = (byte)r;
                argb[a++] = -1;
                ++j;
                ++cj;
            }
            ++i;
            ++ci;
        }
    }

    public static void JPEG_TO_RGB(byte[] argb, byte[] data, int width, int height) throws Exception {
        if (width > 2048 || height > 2048) {
            throw new Exception("Image is too large to store in memory");
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap image = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        int[] buffer = new int[width * height];
        image.getPixels(buffer, 0, width, 0, 0, width, height);
        int a = 0;
        for (int i = 0; i < height; ++i) {
            int k = width * i;
            for (int j = 0; j < width; ++j) {
                int pixel = buffer[k + j];
                argb[a++] = (byte)(0xFF & pixel);
                argb[a++] = (byte)(0xFF & pixel >> 8);
                argb[a++] = (byte)(0xFF & pixel >> 16);
                argb[a++] = (byte)(0xFF & pixel >> 24);
            }
        }
    }

    public static int BGRA_TO_ARGB(int bgra) {
        int argb = (0xFF0000 & bgra) >> 16 | (0xFF00 & bgra) >> 8 | (0xFF & bgra) << 8 | 0xFF000000;
        return argb;
    }
}

