/*
 * Decompiled with CFR 0.152.
 */
package com.distriqt.core.utils;

import android.app.Activity;
import android.util.Base64;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import javax.crypto.Cipher;

public final class VDK {
    public static boolean v(Activity activity, String inputKey, int extensionId) {
        Boolean success = false;
        String keyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxYaXDdu7Jr6PRciuK0oOj+Eg5gNeFxDvRpXxjm8L7Md3bYA0Dq361W58SZ3udgUIRqx/czLBiq2fEp2eAcz1WHCJ7rHxo9j8/FyDZhcW7ENmRaLh+x1bqhymA/5xTnVJNDxV2pigUiwe0/EWW+1TMXQrIFYQnWndeGJsg+0Q4D1oSr3r7RbJzy/ZWdJwAVR8jaFcXQftq758lwKtJ/MhLiCp3ZhETtZQQXND6/1FhWu8yvOhzGfWJzPlHS+mPI9ph5XTD6zQ/9Ze2bWFZ/XRxisRhOcgNbuO2cB730jkrOE3+FkA2kd/gN49dRXtl1D2MNmuKQXHJl2dIfSCNsjR0QIDAQAB";
        try {
            if (inputKey.length() > 40) {
                String hash = inputKey.substring(0, 40);
                String dataString = inputKey.substring(40);
                byte[] dataEncoded = Base64.decode((String)dataString, (int)0);
                byte[] keyBytes = Base64.decode((byte[])keyString.getBytes("utf-8"), (int)0);
                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, publicKey);
                byte[] decrpytedData = null;
                decrpytedData = VDK.removePadding(cipher.doFinal(dataEncoded));
                String decrpytedDataString = new String(decrpytedData, "UTF-8");
                String[] details = decrpytedDataString.split("\\|");
                if (details.length > 2) {
                    String type = details[0];
                    String key = details[1];
                    if (type.equals("s")) {
                        String appId = activity.getPackageName();
                        if (VDK.matchAppId(appId, key) && VDK.containsId(details, extensionId) && VDK.SHA1(key).equals(hash)) {
                            success = true;
                        }
                    } else if (type.equals("t")) {
                        long now = System.currentTimeMillis();
                        long expiry = Long.parseLong(key);
                        if (expiry > now && VDK.containsId(details, extensionId) && VDK.SHA1(key).equals(hash)) {
                            success = true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    private static boolean containsId(String[] details, int extensionId) {
        for (int i = 2; i < details.length; ++i) {
            try {
                int extIdNumber = Integer.parseInt(details[i]);
                if (extIdNumber != extensionId) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean matchAppId(String appId, String keyId) {
        String appIdL = appId.toLowerCase(Locale.UK);
        String keyIdL = keyId.toLowerCase(Locale.UK);
        if (keyIdL.equals(appIdL)) {
            return true;
        }
        if ((keyIdL + ".debug").equals(appIdL)) {
            return true;
        }
        if (appId.substring(0, 3).toLowerCase(Locale.UK).equals("air")) {
            return VDK.matchAppId(appId.substring(4), keyId);
        }
        String modId = keyId.replaceAll("(\\.)([0-9])", "$1A$2").replaceAll("-", "_");
        if (!modId.equals(keyId)) {
            return VDK.matchAppId(appId, modId);
        }
        return false;
    }

    private static byte[] removePadding(byte[] data) {
        int startIndex;
        for (startIndex = 0; data[startIndex] == 0 && startIndex < data.length - 1; ++startIndex) {
        }
        if (data[startIndex] == 1 || data[startIndex] == 2) {
            ++startIndex;
            for (int k = 1; k < data.length && data[k] != 0; ++k) {
                ++startIndex;
            }
            ++startIndex;
        }
        byte[] cleaned = new byte[data.length - startIndex];
        for (int i = 0; i < data.length - startIndex; ++i) {
            cleaned[i] = data[startIndex + i];
        }
        return cleaned;
    }

    private static String SHA1(String text) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        byte[] sha1hash = md.digest();
        return VDK.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (byte b : data) {
            int halfbyte = b >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                buf.append(0 <= halfbyte && halfbyte <= 9 ? (char)(48 + halfbyte) : (char)(97 + (halfbyte - 10)));
                halfbyte = b & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

