/*
 * Decompiled with CFR 0.152.
 */
package com.android.billingclient.api;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseHistoryRecord {
    private final String mOriginalJson;
    private final String mSignature;
    private final JSONObject mParsedJson;

    public PurchaseHistoryRecord(String jsonPurchaseInfo, String signature) throws JSONException {
        this.mOriginalJson = jsonPurchaseInfo;
        this.mSignature = signature;
        this.mParsedJson = new JSONObject(this.mOriginalJson);
    }

    public String getSku() {
        return this.mParsedJson.optString("productId");
    }

    public long getPurchaseTime() {
        return this.mParsedJson.optLong("purchaseTime");
    }

    public String getPurchaseToken() {
        return this.mParsedJson.optString("token", this.mParsedJson.optString("purchaseToken"));
    }

    @Nullable
    public String getDeveloperPayload() {
        return this.mParsedJson.optString("developerPayload");
    }

    public String getOriginalJson() {
        return this.mOriginalJson;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public String toString() {
        return "PurchaseHistoryRecord. Json: " + this.mOriginalJson;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurchaseHistoryRecord)) {
            return false;
        }
        PurchaseHistoryRecord purchase = (PurchaseHistoryRecord)o;
        return TextUtils.equals((CharSequence)this.mOriginalJson, (CharSequence)purchase.getOriginalJson()) && TextUtils.equals((CharSequence)this.mSignature, (CharSequence)purchase.getSignature());
    }

    public int hashCode() {
        return this.mOriginalJson.hashCode();
    }
}

