//=============================================================================
// Drill_SceneMain.js
//=============================================================================

/*:
 * @plugindesc [v1.5]        面板 - 全自定义主菜单面板
 * @author Drill_up
 * 
 * @Drill_LE_param "角色固定框样式-%d"
 * @Drill_LE_parentKey ""
 * @Drill_LE_var "DrillUp.g_SMa_styleList_length"
 * 
 * @Drill_LE_param "角色框设置-%d"
 * @Drill_LE_parentKey "---角色框设置%d至%d---"
 * @Drill_LE_var "DrillUp.g_SMa_bind_length"
 * 
 * 
 * @help  
 * =============================================================================
 * +++ Drill_SceneMain +++
 * 作者：Drill_up
 * 如果你有兴趣，也可以来看看更多我写的drill插件哦ヽ(*。>Д<)o゜
 * https://rpg.blue/thread-409713-1-1.html
 * =============================================================================
 * 可完全自己定义的主菜单设置。
 * 【支持插件关联资源的打包、加密】
 * 
 * -----------------------------------------------------------------------------
 * ----插件扩展
 * 插件必须基于核心，被扩展的部分插件可以不加。
 * 基于：
 *   - Drill_CoreOfWindowAuxiliary  系统 - 窗口辅助核心
 *   - Drill_CoreOfGaugeMeter       系统 - 参数条核心
 *   - Drill_CoreOfGaugeNumber      系统 - 参数数字核心
 *   - Drill_CoreOfSelectableButton 系统 - 按钮组核心
 * 被扩展：
 *   - Drill_WindowMenuButton       控件 - 主菜单选项按钮管理器
 *     通过该插件，你可以更灵活地添加/修改主菜单的选项/按钮。
 *   - MOG_TimeSystem               地图UI - 时间系统
 *     通过该插件，你可以显示游戏世界时间。
 * 
 * -----------------------------------------------------------------------------
 * ----设定注意事项
 * 1.插件的作用域：菜单界面。
 *   可以设置主菜单面板(界面)的内容。
 * 2.具体细节主要去看看 "18.面板 > 关于全自定义主菜单界面.docx"。
 *   文档中有相关图解，比纯文字容易理解。
 * 3.该面板属于菜单面板，可以被菜单背景、菜单魔法圈等插件作用到。
 *   该面板关键字为：Scene_Menu
 *   更多关键字内容，见 "17.主菜单 > 菜单关键字.docx"。
 * 结构：
 *   (1.配置分五个主要功能部件：
 *      时间显示、金钱显示、菜单选项、角色头像按钮、角色固定框
 * 参数条：
 *   (1.参数值：　固定绑定角色属性。
 *      遮罩：　　可自定义。
 *      旋转：　　可自定义。
 *      段上限：　固定绑定角色属性，只有1段。
 *      流动效果：固定瞬间缩短。
 *      凹槽条：　关闭。
 *      弹出条：　关闭。
 *      粒子：　　可自定义。
 *      游标：　　可自定义。
 *      加满动画：可自定义。
 *   (2.参数条样式配置在 参数条核心 中配置。
 *      部分特定的属性需要在该插件中扩展修改。
 *      你需要先配置参数条样式，才能将样式id对应到指定的 槽样式 中。
 *   (3.如果你有不同想法，参数条可以设置多段、游标、凹槽条 等。
 * 参数数字：
 *   (1.参数值：　固定绑定角色属性。
 *      旋转：　　可自定义。
 *      滚动效果：可自定义。
 *      符号：　　可自定义。
 *      前缀后缀：可自定义。
 *      对齐方式：可自定义。
 *      额定值：　固定绑定角色属性。
 *      额定符号：可自定义。
 *   (2.参数数字样式配置在 参数数字核心 中配置。
 *      部分特定的属性需要在该插件中扩展修改。
 *      你需要先配置参数数字样式，才能将样式id对应到指定的 槽样式 中。
 *   (3."x19"或"+100/100"等数字组合写法，都在核心中配置样式，该插件只
 *      关联样式id。
 * 菜单选项：
 *   (1.菜单选项可以设置为 窗口 或者 按钮组 。
 *   (2.其中菜单按钮组的 样式 在按钮组核心中设置。
 *      你可以在 按钮组核心 中，开启debug规划轨迹，看到红线。
 *   (3.注意按钮组的排列方式，你需要根据排列实际情况，配置合适的键
 *      盘模式。270度朝上的直线排列，使用的是反向上下切换键盘模式。
 * 按钮关键字：
 *   (1.菜单选项的按钮贴图序列中，需要根据 关键字 来控制一一对应。
 *      如果关键字没有对应上，则使用默认的贴图。
 * 按钮管理：
 *   (1.该控制面板只提供按钮美化，并 不控制 按钮是否可用/隐藏。
 *   (2.你可以使用 数据库 > 系统 > 菜单指令 控制按钮可用情况。
 *      也可以使用插件 控件-主菜单选项按钮管理器 修改/添加按钮。 
 * 角色固定框：
 *   (1.角色前视图可以是单张图片，也可以为多张形成的gif。
 *      我知道你们都想弄动态的立绘╭(°A°`)╮……很多人都问过，旧版本的
 *      解决方案是用多层菜单gif，只是比较麻烦。
 * 设计：
 *   (1.首先要明确自己想要什么样的主菜单，设计时注意不要为了复杂
 *      而复杂，有的主菜单简单干净，反而会比复杂的菜单观感更好。
 * 插件影响：
 *   (1.该插件不会影响其他主菜单控制插件，
 *      但是会受到相关主菜单插件的不确定影响，最好关闭那些插件。
 *   (2.目前已知的为：
 *      rmmv默认AltMenu插件会造成主菜单每次只能显示一两个按钮。
 * 
 * -----------------------------------------------------------------------------
 * ----关联文件
 * 资源路径：img/Menu__main （Menu后面有两个下划线）
 * 资源路径：img/Menu__actorFaces （Menu后面有两个下划线）
 * 先确保项目img文件夹下是否有Menu__main文件夹。
 * 先确保项目img文件夹下是否有Menu__actorFaces文件夹。
 * 要查看所有关联资源文件的插件，可以去看看"插件清单.xlsx"。
 * 如果没有，需要自己建立。需要配置资源文件：
 *
 * 资源-整体布局                      （Menu__main文件夹）
 * 
 * 金钱 窗口布局 资源-贴图            （Menu__main文件夹）
 * 金钱 参数数字                      （Menu__main文件夹）
 *  
 * 菜单选项 窗口布局 资源-贴图        （Menu__main文件夹）
 * 菜单选项 按钮组 默认按钮贴图       （Menu__main文件夹）
 * 菜单选项 按钮组 按钮贴图序列       （Menu__main文件夹）
 *  
 * 角色固定框 按钮组 资源-固定框背景  （Menu__main文件夹）
 * 角色固定框 按钮组 资源-固定框前景  （Menu__main文件夹）
 * 角色固定框 按钮组 生命条           （Menu__main文件夹）
 * 角色固定框 按钮组 魔法条           （Menu__main文件夹）
 * 角色固定框 按钮组 怒气条           （Menu__main文件夹）
 * 角色固定框 按钮组 经验条           （Menu__main文件夹）
 * 角色固定框 按钮组 生命数字         （Menu__main文件夹）
 * 角色固定框 按钮组 魔法数字         （Menu__main文件夹）
 * 角色固定框 按钮组 怒气数字         （Menu__main文件夹）
 * 角色固定框 按钮组 经验数字         （Menu__main文件夹）
 * 角色固定框 按钮组 等级数字         （Menu__main文件夹）
 * 
 * 角色头像 按钮组 默认按钮贴图       （Menu__actorFaces文件夹）
 * 角色头像 按钮组 按钮贴图序列       （Menu__actorFaces文件夹）
 *
 * 角色框设置-1 资源-角色前视图       （Menu__actorFaces文件夹）
 * 角色框设置-2 资源-角色前视图       （Menu__actorFaces文件夹）
 * 角色框设置-3 资源-角色前视图       （Menu__actorFaces文件夹）
 * …………
 *
 * 1.框架资源都在Menu__main文件夹中。
 * 2.角色图标、头像资源都在Menu__actorFaces文件夹中。
 *
 * -----------------------------------------------------------------------------
 * ----可选设定
 * 你可以使用下面的插件指令：
 * （冒号两边都有一个空格）
 * 
 * 插件指令：>主菜单面板 : 打开面板
 * 
 * 插件指令：>主菜单面板 : 菜单选项按钮组 : 改变位置[100,200]
 * 插件指令：>主菜单面板 : 菜单选项按钮组 : 改变样式[2]
 * 插件指令：>主菜单面板 : 角色框设置[5] : 改变样式[2]
 * 插件指令：>主菜单面板 : 角色框设置[5] : 改变前视图[2,3,4]
 * 插件指令：>主菜单面板 : 角色框设置[5] : 还原默认前视图配置
 * 
 * 1.由于面板打开后，游戏是暂停的，所以你只能在地图界面中执行指令。
 * 2.角色框设置中"改变前视图[2,3,4]"数字对应 备用角色前视图列表 的编号，
 *   可以输入多张图片，这些图片将作为gif序列改变替换到指定角色的前视图设置。
 *
 * -----------------------------------------------------------------------------
 * ----可选设定 - 获取时间
 * 你可以使用下面的插件指令：
 * （冒号两边都有一个空格）
 * 
 * 插件指令：>主菜单面板 : 累积游戏时长(秒) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 累积游戏时长(分) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 累积游戏时长(时) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 累积游戏时长(总秒数) : 给予值 : 变量[21]
 * 
 * 插件指令：>主菜单面板 : 真实时间(秒) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 真实时间(分) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 真实时间(时) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 真实时间(日) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 真实时间(月) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 真实时间(年) : 给予值 : 变量[21]
 * 
 * 插件指令：>主菜单面板 : 游戏世界时间(秒) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 游戏世界时间(分) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 游戏世界时间(时) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 游戏世界时间(日) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 游戏世界时间(月) : 给予值 : 变量[21]
 * 插件指令：>主菜单面板 : 游戏世界时间(年) : 给予值 : 变量[21]
 * 
 * 1."累积游戏时长_时"的值可以超过24小时（比如值为200），
 *   因为累积时长不统计天数。
 * 2."游戏世界时间"需要相关的插件支持才能得到值，否则返回-1。
 * 
 * -----------------------------------------------------------------------------
 * ----插件性能
 * 测试仪器：   4G 内存，Intel Core i5-2520M CPU 2.5GHz 处理器
 *              Intel(R) HD Graphics 3000 集显 的垃圾笔记本
 *              (笔记本的3dmark综合分：571，鲁大师综合分：48456)
 * 总时段：     20000.00ms左右
 * 对照表：     0.00ms  - 40.00ms （几乎无消耗）
 *              40.00ms - 80.00ms （低消耗）
 *              80.00ms - 120.00ms（中消耗）
 *              120.00ms以上      （高消耗）
 * 工作类型：   持续执行
 * 时间复杂度： o(n^3)*o(场景元素) 每帧
 * 测试方法：   直接进入主菜单面板进行测试。
 * 测试结果：   该菜单面板中，基本元素消耗为：【44.39ms】
 * 
 * 1.插件只在自己作用域下工作消耗性能，在其它作用域下是不工作的。
 *   测试结果并不是精确值，范围在给定值的10ms范围内波动。
 *   更多性能介绍，去看看 "0.性能测试报告 > 关于插件性能.docx"。
 * 2.该插件为一个界面，在该插件的界面中，地图界面、战斗界面处于完全
 *   暂停状态，所以该界面占用的图形资源、计算资源充足，消耗也低。
 * 
 * -----------------------------------------------------------------------------
 * ----更新日志
 * [v1.0]
 * 完成插件ヽ(*。>Д<)o゜
 * [v1.1]
 * 修复了显示直线排列的状态出错的bug，以及设置不显示空角色时全部角色框不显示的bug。
 * 将 键盘无障碍 功能移动到 按钮组核心 中可供修改更多效果。
 * [v1.2]
 * 添加了外部干扰插件的检测。
 * [v1.3]
 * 添加了drill指针的控制。
 * [v1.4]
 * 添加了插件指令获取时间给变量的功能。
 * [v1.5]
 * 添加了角色框 职业、昵称 的显示功能。
 * 
 * 
 * @param ----杂项----
 * @desc
 *
 * @param 资源-整体布局
 * @parent ----杂项----
 * @desc 主菜单布局的图片资源。
 * @default 主菜单-布局
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param 是否显示所在地图名
 * @parent ----杂项----
 * @type boolean
 * @on 显示
 * @off 关闭
 * @desc true - 显示，false - 关闭。
 * @default true
 * 
 * @param 平移-所在地图名 X
 * @parent 是否显示所在地图名
 * @desc x轴方向平移，单位像素。0为贴在最左边。
 * @default 545
 *
 * @param 平移-所在地图名 Y
 * @parent 是否显示所在地图名
 * @desc y轴方向平移，单位像素。0为贴在最上面。
 * @default 575
 *
 * @param 所在地图名字体大小
 * @parent 是否显示所在地图名
 * @type number
 * @min 1
 * @desc 地图名称的字体大小。
 * @default 24
 * 
 * @param 所在地图名对齐方式
 * @parent 是否显示所在地图名
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 所在地图名的对齐方式。
 * @default 居中
 * 
 * 
 * @param ----时间显示----
 * @desc
 * 
 * @param 是否显示累积游戏时长
 * @parent ----时间显示----
 * @type boolean
 * @on 显示
 * @off 关闭
 * @desc true - 显示，false - 关闭。
 * @default true
 * 
 * @param 平移-累积游戏时长 X
 * @parent 是否显示累积游戏时长
 * @desc x轴方向平移，单位像素。0为贴在最左边。
 * @default 520
 * 
 * @param 平移-累积游戏时长 Y
 * @parent 是否显示累积游戏时长
 * @desc y轴方向平移，单位像素。0为贴在最上面。
 * @default 75
 * 
 * @param 累积游戏时长的时间格式
 * @parent 是否显示累积游戏时长
 * @desc 字符串'HH'表示小时，'mm'表示分钟，'ss'表示秒。其他的任意组合。
 * @default HH:mm:ss
 * 
 * @param 累积游戏时长字体大小
 * @parent 是否显示累积游戏时长
 * @type number
 * @min 1
 * @desc 游戏时长的字体大小。
 * @default 20
 * 
 * @param 是否显示真实时间
 * @parent ----时间显示----
 * @type boolean
 * @on 显示
 * @off 关闭
 * @desc true - 显示，false - 关闭。
 * @default true
 * 
 * @param 平移-真实时间 X
 * @parent 是否显示真实时间
 * @desc x轴方向平移，单位像素。0为贴在最左边。
 * @default 430
 * 
 * @param 平移-真实时间 Y
 * @parent 是否显示真实时间
 * @desc y轴方向平移，单位像素。0为贴在最上面。
 * @default 50
 * 
 * @param 真实时间的时间格式
 * @parent 是否显示真实时间
 * @desc 字符串'yyyy'表示年，'MM'表示月，'dd'表示日，'HH'表示小时，'mm'表示分钟，'ss'表示秒。其他的任意组合。
 * @default yyyy年MM月dd日 HH:mm:ss
 * 
 * @param 真实时间字体大小
 * @parent 是否显示真实时间
 * @type number
 * @min 1
 * @desc 游戏时长的字体大小。
 * @default 20
 * 
 * @param 是否显示游戏世界时间
 * @parent ----时间显示----
 * @type boolean
 * @on 显示
 * @off 关闭
 * @desc true - 显示，false - 关闭。需要 MOG_TimeSystem 地图UI-时间系统 插件支持。
 * @default true
 * 
 * @param 平移-游戏世界时间 X
 * @parent 是否显示游戏世界时间
 * @desc x轴方向平移，单位像素。0为贴在最左边。需要 MOG_TimeSystem 地图UI-时间系统 插件支持。
 * @default 430
 * 
 * @param 平移-游戏世界时间 Y
 * @parent 是否显示游戏世界时间
 * @desc y轴方向平移，单位像素。0为贴在最上面。需要 MOG_TimeSystem 地图UI-时间系统 插件支持。
 * @default 25
 * 
 * @param 游戏世界时间的时间格式
 * @parent 是否显示游戏世界时间
 * @desc 字符串'yyyy'年，'MM'月，'dd'日，'HH'小时，'mm'分钟，'ss'秒。其他的任意组合。需要 MOG_TimeSystem 时间系统 插件支持。
 * @default yyyy年MM月dd日 HH:mm:ss
 * 
 * @param 游戏世界时间字体大小
 * @parent 是否显示游戏世界时间
 * @type number
 * @min 1
 * @desc 游戏时长的字体大小。需要 MOG_TimeSystem 地图UI-时间系统 插件支持。
 * @default 20
 * 
 * 
 * @param ----金钱显示----
 * @desc
 *
 * @param 金钱显示模式
 * @parent ----金钱显示----
 * @type select
 * @option 参数数字模式
 * @value 参数数字模式
 * @option 窗口模式
 * @value 窗口模式
 * @desc 金钱显示的模式。
 * @default 参数数字模式
 * 
 * @param 金钱参数数字
 * @parent ----金钱显示----
 * @desc 金钱为 参数数字模式 时，金钱参数数字的配置数据。
 * @type struct<DrillSMaGoldNumber>
 * @default {"金钱数字 X":"275","金钱数字 Y":"588","---主体---":"","资源-基本符号":"金钱数字-基本符号","资源-扩展符号":"","---符号---":"","额外符号前缀":"","额外符号后缀":"","---排列---":"","对齐方式":"右对齐","最大符号数量":"20","符号间间距":"-2","排列宽度模式":"不限制宽度","排列限制宽度":"300","---滚动效果---":"","滚动模式":"瞬间变化","弹性变化速度":"10.0"}
 * 
 * @param 金钱窗口
 * @parent ----金钱显示----
 * @desc 金钱为 窗口模式 时，金钱窗口的配置数据。
 * @type struct<DrillSMaGoldWindow>
 * @default {"金钱窗口 X":"60","金钱窗口 Y":"555","金钱窗口宽度":"240","金钱窗口高度":"70","金钱窗口字体大小":"22","金钱窗口移动动画":"{\"移动类型\":\"弹性移动\",\"移动时长\":\"20\",\"移动延迟\":\"0\",\"---起点---\":\"\",\"坐标类型\":\"相对坐标\",\"起点-相对坐标 X\":\"0\",\"起点-相对坐标 Y\":\"100\",\"起点-绝对坐标 X\":\"0\",\"起点-绝对坐标 Y\":\"0\"}","金钱窗口布局":"{\"布局类型\":\"默认皮肤\",\"---单张背景贴图---\":\"\",\"资源-贴图\":\"主菜单-金钱窗口\",\"贴图位置修正 X\":\"0\",\"贴图位置修正 Y\":\"0\"}"}
 * 
 * 
 * 
 * @param ----菜单选项----
 * @desc
 * 
 * @param 菜单选项模式
 * @parent ----菜单选项----
 * @type select
 * @option 按钮组模式
 * @value 按钮组模式
 * @option 窗口模式
 * @value 窗口模式
 * @desc 菜单选项的模式。
 * @default 窗口模式
 * 
 * @param 菜单选项按钮组
 * @parent ----菜单选项----
 * @desc 菜单选项为 按钮组模式 时，菜单选项按钮组的配置数据。
 * @type struct<DrillSMaCommandButton>
 * @default {}
 * 
 * @param 菜单选项窗口
 * @parent ----菜单选项----
 * @desc 菜单选项为 窗口模式 时，菜单选项窗口的配置数据。
 * @type struct<DrillSMaCommandWindow>
 * @default {"菜单选项窗口 X":"300","菜单选项窗口 Y":"150","菜单选项窗口宽度":"240","菜单选项窗口高度":"340","菜单选项窗口列数":"1","菜单选项窗口字体大小":"22","菜单选项窗口移动动画":"{\"移动类型\":\"弹性移动\",\"移动时长\":\"20\",\"移动延迟\":\"0\",\"---起点---\":\"\",\"坐标类型\":\"相对坐标\",\"起点-相对坐标 X\":\"-80\",\"起点-相对坐标 Y\":\"0\",\"起点-绝对坐标 X\":\"0\",\"起点-绝对坐标 Y\":\"0\"}","菜单选项窗口布局":"{\"布局类型\":\"默认皮肤\",\"---单张背景贴图---\":\"\",\"资源-贴图\":\"主菜单-菜单选项窗口\",\"贴图位置修正 X\":\"0\",\"贴图位置修正 Y\":\"0\"}","菜单选项对齐方式":"居中"}
 * 
 * 
 * @param ----角色头像按钮----
 * @desc
 *
 * @param 流程-只一个角色时是否跳过选头像
 * @parent ----角色头像按钮----
 * @type boolean
 * @on 跳过
 * @off 关闭
 * @desc 只有一个角色时，点击 技能、装备、状态 时，不用选角色头像，直接进入。去文档 "18.面板 > 关于全自定义主菜单界面.docx"看看。
 * @default false
 * 
 * @param 角色头像按钮组
 * @parent ----角色头像按钮----
 * @desc 角色头像按钮组的配置数据。
 * @type struct<DrillSMaActorButton>
 * @default {}
 * 
 * @param 可显示的角色头像数量
 * @parent ----角色头像按钮----
 * @type number
 * @min 1
 * @desc 如果你的队伍中有超过20多个角色，那么头像按钮组会变得拥挤不堪，这里你可以设置可显示数量，用于限制过多角色头像显示。
 * @default 4
 * 
 * 
 * @param ----角色固定框----
 * @desc
 * 
 * @param ---角色固定框样式---
 * @parent ----角色固定框----
 * @default
 * 
 * @param 角色固定框样式-1
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default {"标签":"--一般面板样式--","----参数条----":"","生命-是否显示参数条":"true","生命-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"50\",\"平移-参数条 Y\":\"88\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-生命条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"2.2\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","魔法-是否显示参数条":"true","魔法-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"65\",\"平移-参数条 Y\":\"111\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-魔法条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"2.5\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","怒气-是否显示参数条":"true","怒气-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"50\",\"平移-参数条 Y\":\"135\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-怒气条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"2.8\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","经验-是否显示参数条":"true","经验-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"65\",\"平移-参数条 Y\":\"158\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-经验条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"3.0\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","----参数数字----":"","生命-是否显示参数数字":"true","生命-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"174\",\"平移-参数数字 Y\":\"87\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-生命数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"3.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","魔法-是否显示参数数字":"true","魔法-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"189\",\"平移-参数数字 Y\":\"110\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-魔法数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"3.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","怒气-是否显示参数数字":"true","怒气-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"174\",\"平移-参数数字 Y\":\"134\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-怒气数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"3.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","经验-是否显示参数数字":"true","经验-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"189\",\"平移-参数数字 Y\":\"157\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-经验数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"10.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","等级-是否显示参数数字":"true","等级-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"73\",\"平移-参数数字 Y\":\"52\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-等级数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"居中\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"10.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"false\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","----外框----":"","资源-固定框背景":"","平移-固定框背景 X":"0","平移-固定框背景 Y":"0","资源-固定框前景":"主菜单-角色面板","平移-固定框前景 X":"0","平移-固定框前景 Y":"0","----姓名显示----":"","是否显示姓名":"true","平移-姓名 X":"94","平移-姓名 Y":"51","姓名字体大小":"20","----状态显示----":"","是否显示状态":"true","平移-状态 X":"229","平移-状态 Y":"62","状态显示模式":"单一闪烁","状态对齐方式":"左对齐","状态间距":"0","最大显示状态数量":"4"}
 * 
 * @param 角色固定框样式-2
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default {"标签":"--无tp条样式--","----参数条----":"","生命-是否显示参数条":"true","生命-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"50\",\"平移-参数条 Y\":\"98\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-生命条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"2.2\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","魔法-是否显示参数条":"true","魔法-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"57\",\"平移-参数条 Y\":\"124\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-魔法条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"2.5\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","怒气-是否显示参数条":"false","怒气-参数条配置":"{}","经验-是否显示参数条":"true","经验-参数条配置":"{\"---主体---\":\"\",\"平移-参数条 X\":\"65\",\"平移-参数条 Y\":\"151\",\"整体旋转角度\":\"0\",\"资源-参数条\":\"主菜单-经验条\",\"资源-参数条遮罩\":\"\",\"---加满动画---\":\"\",\"是否启用加满动画\":\"true\",\"加满方式\":\"匀速加满\",\"加满持续时间\":\"20\",\"加满延迟\":\"10\",\"---段---\":\"\",\"是否使用流动效果\":\"true\",\"流动方向\":\"从右往左\",\"流动速度\":\"3.0\",\"流动段划分模式\":\"三等份划分\",\"段长度\":\"0\",\"---粒子效果---\":\"\",\"是否启用粒子效果\":\"false\",\"资源-粒子\":\"参数条-默认粒子\",\"粒子出现模式\":\"底部出现\",\"粒子X速度\":\"0\",\"粒子Y速度\":\"-1.5\",\"粒子数量\":\"20\",\"粒子持续时间\":\"20\",\"---游标---\":\"\",\"是否启用游标\":\"false\",\"资源-游标\":\"[\\\"参数条-默认游标\\\"]\",\"动画帧间隔\":\"4\",\"是否倒放\":\"false\",\"偏移-游标 X\":\"0\",\"偏移-游标 Y\":\"0\",\"游标显示模式\":\"一直显示\",\"遮罩是否能遮挡游标\":\"false\"}","----参数数字----":"","生命-是否显示参数数字":"true","生命-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"174\",\"平移-参数数字 Y\":\"97\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-生命数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"3.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","魔法-是否显示参数数字":"true","魔法-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"180\",\"平移-参数数字 Y\":\"123\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-魔法数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"3.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","怒气-是否显示参数数字":"false","怒气-参数数字配置":"{}","经验-是否显示参数数字":"true","经验-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"189\",\"平移-参数数字 Y\":\"150\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-经验数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"右对齐\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"10.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"true\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","等级-是否显示参数数字":"true","等级-参数数字配置":"{\"---主体---\":\"\",\"平移-参数数字 X\":\"73\",\"平移-参数数字 Y\":\"52\",\"整体旋转角度\":\"0\",\"资源-基本符号\":\"主菜单-等级数值\",\"资源-扩展符号\":\"\",\"---符号---\":\"\",\"是否显示负号\":\"true\",\"额外符号前缀\":\"\",\"额外符号后缀\":\"\",\"---排列---\":\"\",\"对齐方式\":\"居中\",\"最大符号数量\":\"20\",\"符号间间距\":\"0\",\"排列宽度模式\":\"不限制宽度\",\"排列限制宽度\":\"300\",\"---滚动效果---\":\"\",\"滚动模式\":\"弹性滚动\",\"弹性变化速度\":\"10.0\",\"---额定值---\":\"\",\"是否显示额定值\":\"false\",\"达到条件时符号\":\"不变化\",\"资源-额定基本符号\":\"\",\"资源-额定扩展符号\":\"\"}","----外框----":"","资源-固定框背景":"","平移-固定框背景 X":"0","平移-固定框背景 Y":"0","资源-固定框前景":"主菜单-角色面板(无tp)","平移-固定框前景 X":"0","平移-固定框前景 Y":"0","----姓名显示----":"","是否显示姓名":"true","平移-姓名 X":"94","平移-姓名 Y":"51","姓名字体大小":"20","----状态显示----":"","是否显示状态":"true","平移-状态 X":"229","平移-状态 Y":"62","状态显示模式":"单一闪烁","状态对齐方式":"左对齐","状态间距":"0","最大显示状态数量":"4"}
 * 
 * @param 角色固定框样式-3
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 角色固定框样式-4
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 角色固定框样式-5
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 角色固定框样式-6
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 角色固定框样式-7
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 角色固定框样式-8
 * @parent ---角色固定框样式---
 * @type struct<DrillSMaActorBoardStyle>
 * @desc 角色固定框的样式配置。
 * @default 
 * 
 * @param 固定框组
 * @parent ----角色固定框----
 * @type struct<DrillSMaActorBoardArrange>
 * @desc 多个角色固定框时，排列方式等配置。
 * @default {"---主体---":"","平移-固定框组 X":"0","平移-固定框组 Y":"0","角色框数量上限":"2","无角色时是否仍然显示框":"true","无角色时设置":"{\"标签\":\"--空角色框--\",\"---绑定---\":\"\",\"绑定的样式\":\"1\",\"---角色前视图---\":\"\",\"是否显示角色前视图\":\"false\",\"资源-角色前视图\":\"[]\",\"帧间隔\":\"4\",\"是否倒放\":\"false\",\"平移-角色前视图 X\":\"0\",\"平移-角色前视图 Y\":\"0\"}","固定框组移动动画":"{\"移动类型\":\"弹性移动\",\"移动时长\":\"50\",\"移动延迟\":\"0\",\"依次移动延迟间隔\":\"20\",\"---起点---\":\"\",\"坐标类型\":\"各固定框的相对坐标\",\"起点-相对坐标 X\":\"0\",\"起点-相对坐标 Y\":\"80\",\"起点-统一坐标 X\":\"408\",\"起点-统一坐标 Y\":\"312\"}","---排列---":"","排列方式":"固定离散排列","==直线排列==":"","直线间距":"192","直线W间距":"48","直线旋转角度":"0","==环形排列==":"","环形半径":"192","环形起始角":"0","环形终止角":"360","==矩阵排列==":"","矩阵列数":"4","矩阵列宽":"192","矩阵行高":"192","==固定离散排列==":"","固定离散位置序列":"[\"10,250\",\"590,250\"]"}
 * 
 * @param 备用角色前视图列表
 * @parent ----角色固定框----
 * @desc 备用的角色前视图列表，通过插件指令"改变前视图"可以切换指定角色的前视图。
 * @default []
 * @require 1
 * @dir img/Menu__actorFaces/
 * @type file[]
 * 
 * @param ---角色框设置 1至20---
 * @parent ----角色固定框----
 * @default
 * 
 * @param 角色框设置-1
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-2
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-3
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-4
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-5
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-6
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-7
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-8
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-9
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-10
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-11
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-12
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-13
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-14
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-15
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-16
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-17
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-18
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-19
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-20
 * @parent ---角色框设置 1至20---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param ---角色框设置21至40---
 * @parent ----角色固定框----
 * @default
 * 
 * @param 角色框设置-21
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-22
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-23
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-24
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-25
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-26
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-27
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-28
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-29
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-30
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-31
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-32
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-33
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-34
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-35
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-36
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-37
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-38
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-39
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-40
 * @parent ---角色框设置21至40---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param ---角色框设置41至60---
 * @parent ----角色固定框----
 * @default
 * 
 * @param 角色框设置-41
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-42
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-43
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-44
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-45
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-46
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-47
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-48
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-49
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-50
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-51
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-52
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-53
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-54
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-55
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-56
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-57
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-58
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-59
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default 
 * 
 * @param 角色框设置-60
 * @parent ---角色框设置41至60---
 * @type struct<DrillSMaActorBoardBind>
 * @desc 该配置的id与角色id一一对应。
 * @default
 * 
 */
/*~struct~DrillWindowMoving:
 *
 * @param 移动类型
 * @type select
 * @option 不移动
 * @value 不移动
 * @option 匀速移动
 * @value 匀速移动
 * @option 增减速移动
 * @value 增减速移动
 * @option 弹性移动
 * @value 弹性移动
 * @desc 移动类型基于 弹道核心-两点式 移动。更多内容可以去看看 "1.系统 > 关于弹道.docx"。
 * @default 匀速移动
 *
 * @param 移动时长
 * @type number
 * @min 1
 * @desc 起点位置回到原位置所需的时间，单位帧。（1秒60帧）
 * @default 20
 *
 * @param 移动延迟
 * @type number
 * @min 0
 * @desc 开始移动前的等待时间，单位帧。（1秒60帧）
 * @default 0
 *
 * @param ---起点---
 * @default 
 *
 * @param 坐标类型
 * @parent ---起点---
 * @type select
 * @option 相对坐标
 * @value 相对坐标
 * @option 绝对坐标
 * @value 绝对坐标
 * @desc 起点的坐标类型。
 * @default 相对坐标
 *
 * @param 起点-相对坐标 X
 * @parent ---起点---
 * @desc 相对坐标以原位置为基准，负数向右，正数向左，单位像素。
 * @default 100
 * 
 * @param 起点-相对坐标 Y
 * @parent ---起点---
 * @desc 相对坐标以原位置为基准，负数向上，正数向下，单位像素。
 * @default 0
 * 
 * @param 起点-绝对坐标 X
 * @parent ---起点---
 * @desc 绝对坐标以屏幕的位置为准，0表示贴在最左边，单位像素。
 * @default 0
 * 
 * @param 起点-绝对坐标 Y
 * @parent ---起点---
 * @desc 绝对坐标以屏幕的位置为准，0表示贴在最上面，单位像素。
 * @default 0
 * 
 * 
 */
/*~struct~DrillWindowLayout:
 *
 * @param 布局类型
 * @type select
 * @option 默认皮肤
 * @value 默认皮肤
 * @option 单张背景贴图
 * @value 单张背景贴图
 * @option 隐藏布局
 * @value 隐藏布局
 * @desc 窗口布局的类型。
 * @default 单张背景贴图
 *
 * @param ---单张背景贴图---
 * @default 
 *
 * @param 资源-贴图
 * @parent ---单张背景贴图---
 * @desc 窗口的背景贴图的资源。
 * @default 背景贴图
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param 贴图位置修正 X
 * @parent ---单张背景贴图---
 * @desc 修正图片的位置用。以窗口的点为基准，负数向右，正数向左，单位像素。
 * @default 0
 *
 * @param 贴图位置修正 Y
 * @parent ---单张背景贴图---
 * @desc 修正图片的位置用。以窗口的点为基准，负数向上，正数向下，单位像素。
 * @default 0
 * 
 * 
 */
/*~struct~DrillCursor:
 * 
 * @param 是否启用菜单指针
 * @parent ---drill插件---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭，菜单指针可以指向你当前选中的项。需要Drill_MenuCursor插件支持。
 * @default true
 * 
 * @param 是否锁定菜单指针样式
 * @parent 是否启用菜单指针
 * @type boolean
 * @on 锁定
 * @off 不锁定
 * @desc true - 锁定，false - 不锁定，窗口可以指定一个指针样式来装饰。需要Drill_MenuCursor插件支持。
 * @default false
 * 
 * @param 锁定的菜单指针样式
 * @parent 是否启用菜单指针
 * @type number
 * @min 1
 * @desc 锁定时，指定的指针样式id，具体见Drill_MenuCursor插件中对应的配置。
 * @default 1
 * 
 * @param 是否启用闪烁白矩形
 * @parent ---drill插件---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭，你可以开关rmmv默认选项的白色闪烁矩形。需要Drill_MenuCursorBorder插件支持。
 * @default true
 * 
 * @param 是否启用菜单边框
 * @parent ---drill插件---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭，菜单选项边框装饰当前选中的矩形项。需要Drill_MenuCursorBorder插件支持。
 * @default true
 * 
 * @param 是否锁定菜单边框样式
 * @parent 是否启用菜单边框
 * @type boolean
 * @on 锁定
 * @off 不锁定
 * @desc true - 锁定，false - 不锁定，窗口可以指定一个选项边框样式来装饰。需要Drill_MenuCursorBorder插件支持。
 * @default false
 * 
 * @param 锁定的菜单边框样式
 * @parent 是否启用菜单边框
 * @type number
 * @min 1
 * @desc 锁定时，指定的矩形边框样式id，具体见Drill_MenuCursorBorder插件中对应的配置。
 * @default 1
 * 
 * @param 是否启用滚动条
 * @parent ---drill插件---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭，你可以关闭装饰当前窗口的菜单滚动条。需要Drill_MenuScrollBar插件支持。
 * @default true
 * 
 * @param 是否锁定滚动条样式
 * @parent 是否启用滚动条
 * @type boolean
 * @on 锁定
 * @off 不锁定
 * @desc true - 锁定，false - 不锁定，窗口可以指定一个滚动条样式来装饰。需要Drill_MenuScrollBar插件支持。
 * @default false
 * 
 * @param 锁定的滚动条样式
 * @parent 是否启用滚动条
 * @type number
 * @min 1
 * @desc 锁定时，指定的滚动条样式id，具体见Drill_MenuScrollBar插件中对应的配置。
 * @default 1
 *
 */
 /*~struct~DrillSMaGoldWindow:
 * 
 * @param 金钱窗口 X
 * @desc 金钱窗口的位置。x轴方向平移，单位像素。0为贴在最左边。
 * @default 15
 *
 * @param 金钱窗口 Y
 * @desc 金钱窗口的位置。y轴方向平移，单位像素。0为贴在最上面。
 * @default 180
 *
 * @param 金钱窗口宽度
 * @type number
 * @min 50
 * @desc 窗口的高宽设置。注意，实际文本域的高宽要比该设置小一些，因为有内边距。具体去看看 "17.主菜单 > 窗口与布局.docx"。
 * @default 230
 *
 * @param 金钱窗口高度
 * @type number
 * @min 50
 * @desc 窗口的高宽设置。注意，实际文本域的高宽要比该设置小一些，因为有内边距。具体去看看 "17.主菜单 > 窗口与布局.docx"。
 * @default 240
 *
 * @param 金钱窗口字体大小
 * @type number
 * @min 1
 * @desc 金钱窗口的字体大小。图标无法根据字体大小变化。
 * @default 22
 *
 * @param 金钱窗口移动动画
 * @type struct<DrillWindowMoving>
 * @desc 窗口会从某个点跑回自己的原位置。
 * @default {"移动类型":"弹性移动","移动时长":"20","移动延迟":"0","---起点---":"","坐标类型":"相对坐标","起点-相对坐标 X":"-80","起点-相对坐标 Y":"0","起点-绝对坐标 X":"0","起点-绝对坐标 Y":"0"}
 * 
 * @param 金钱窗口布局
 * @type struct<DrillWindowLayout>
 * @desc 控制窗口框架与窗口背景。
 * @default {"布局类型":"单张背景贴图","---单张背景贴图---":"","资源-贴图":"主菜单-金钱窗口","贴图位置修正 X":"0","贴图位置修正 Y":"0"}
 * 
 * 
 */
/*~struct~DrillSMaGoldNumber:
 * 
 * @param 金钱数字 X
 * @desc 金钱数字的位置。x轴方向平移，单位像素。0为贴在最左边。
 * @default 15
 *
 * @param 金钱数字 Y
 * @desc 金钱数字的位置。y轴方向平移，单位像素。0为贴在最上面。
 * @default 180
 * 
 * @param ---主体---
 * @desc 
 * 
 * @param 资源-基本符号
 * @parent ---主体---
 * @desc 基本符号的图片资源。注意，资源会被分成14等分，分别表示数字和加减乘除（0123456789+-x/）。
 * @default 金钱数字-基本符号
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param 资源-扩展符号
 * @parent ---主体---
 * @desc 扩展符号的图片资源，注意，资源会被分成14等分。通过字母表示扩展符号（abcdefghijklmn）。
 * @default 金钱数字-扩展符号
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param ---符号---
 * @desc 
 * 
 * @param 额外符号前缀
 * @parent ---符号---
 * @desc 除了当前显示的数字字符，额外显示的符号前缀。
 * @default 
 * 
 * @param 额外符号后缀
 * @parent ---符号---
 * @desc 除了当前显示的数字字符，额外显示的符号后缀。
 * @default 
 *
 * @param ---排列---
 * @desc 
 * 
 * @param 对齐方式
 * @parent ---排列---
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 符号的对齐方式。
 * @default 右对齐
 *
 * @param 最大符号数量
 * @parent ---排列---
 * @type number
 * @min 1
 * @desc 最多显示的符号数量，比如"1000"中有4个符号，"-100/-110"中有9个符号。
 * @default 20
 * 
 * @param 符号间间距
 * @parent ---排列---
 * @desc 符号贴图之间的间距，可以为负数，负数的间距将会更加紧凑。
 * @default 0
 *
 * @param 排列宽度模式
 * @parent ---排列---
 * @type select
 * @option 不限制宽度
 * @value 不限制宽度
 * @option 缩放限制
 * @value 缩放限制
 * @option 挤压限制
 * @value 挤压限制
 * @desc 排列符号是宽度的模式。超出宽度时，缩放限制会横向缩放。挤压限制则会减小间距。
 * @default 不限制宽度
 *
 * @param 排列限制宽度
 * @parent 排列宽度模式
 * @desc 模式中设置限制时，符号的最大宽度。
 * @default 300
 * 
 * @param ---滚动效果---
 * @desc 
 *
 * @param 滚动模式
 * @parent ---滚动效果---
 * @type select
 * @option 瞬间变化
 * @value 瞬间变化
 * @option 弹性滚动
 * @value 弹性滚动
 * @desc 滚动效果指 数字的值变化后，数值滚动到指定值的动画效果。
 * @default 瞬间变化
 * 
 * @param 弹性变化速度
 * @parent ---滚动效果---
 * @desc 值为比例除数，值越小，速度越快。值越大，速度越慢。
 * @default 10.0
 * 
 * 
 */
/*~struct~DrillSMaCommandWindow:
 * 
 * @param 菜单选项窗口 X
 * @desc 菜单选项窗口的位置。x轴方向平移，单位像素。0为贴在最左边。
 * @default 15
 *
 * @param 菜单选项窗口 Y
 * @desc 菜单选项窗口的位置。y轴方向平移，单位像素。0为贴在最上面。
 * @default 180
 *
 * @param 菜单选项窗口宽度
 * @type number
 * @min 50
 * @desc 窗口的高宽设置。注意，实际文本域的高宽要比该设置小一些，因为有内边距。具体去看看 "17.主菜单 > 窗口与布局.docx"。
 * @default 230
 *
 * @param 菜单选项窗口高度
 * @type number
 * @min 50
 * @desc 窗口的高宽设置。注意，实际文本域的高宽要比该设置小一些，因为有内边距。具体去看看 "17.主菜单 > 窗口与布局.docx"。
 * @default 240
 * 
 * @param 菜单选项窗口列数
 * @type number
 * @min 1
 * @desc 菜单选项窗口的列数。
 * @default 1
 *
 * @param 菜单选项窗口字体大小
 * @type number
 * @min 1
 * @desc 菜单选项窗口的字体大小。图标无法根据字体大小变化。
 * @default 22
 *
 * @param 菜单选项窗口移动动画
 * @type struct<DrillWindowMoving>
 * @desc 窗口会从某个点跑回自己的原位置。
 * @default {"移动类型":"弹性移动","移动时长":"20","移动延迟":"0","---起点---":"","坐标类型":"相对坐标","起点-相对坐标 X":"-80","起点-相对坐标 Y":"0","起点-绝对坐标 X":"0","起点-绝对坐标 Y":"0"}
 * 
 * @param 菜单选项窗口布局
 * @type struct<DrillWindowLayout>
 * @desc 控制窗口框架与窗口背景。
 * @default {"布局类型":"单张背景贴图","---单张背景贴图---":"","资源-贴图":"主菜单-菜单选项窗口","贴图位置修正 X":"0","贴图位置修正 Y":"0"}
 * 
 * @param 菜单选项对齐方式
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 选项文本的对齐方式。
 * @default 左对齐
 * 
 * @param 菜单选项窗口指针与边框
 * @type struct<DrillCursor>
 * @desc 窗口的指针设置与选项边框设置。
 * @default {}
 * 
 * 
 */
/*~struct~DrillSMaCommandButton:
 * 
 * @param 平移-按钮组 X
 * @desc x轴方向平移，单位像素。0为贴在最左边。
 * @default 408
 * 
 * @param 平移-按钮组 Y
 * @desc y轴方向平移，单位像素。0为贴在最上面。
 * @default 312
 * 
 * @param 按钮组样式
 * @type number
 * @min 0
 * @desc 按钮组对应的样式配置，对应 按钮组核心 的样式id。
 * @default 1
 * 
 * @param ---按钮贴图---
 * @desc 
 *
 * @param DEBUG-按钮关键字搜索
 * @parent ---按钮贴图---
 * @type boolean
 * @on 开启
 * @off 关闭
 * @desc 如果你实在找不到关键字，但是有默认按钮显示了，你可以开启这个，进入主菜单，会按顺序显示所有按钮的关键字。
 * @default false
 *
 * @param 默认按钮贴图
 * @parent ---按钮贴图---
 * @desc 默认按钮的图片资源。
 * @default 按钮-默认贴图
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param 按钮贴图序列
 * @parent ---按钮贴图---
 * @type struct<DrillSMaCommandButtonSeq>[]
 * @desc 按钮贴图通过 菜单按钮关键字 绑定，显示了指定关键字的按钮，则显示相应的按钮贴图。
 * @default ["{\"标签\":\"--道具--\",\"指定按钮\":\"道具\",\"关键字\":\"\",\"按钮贴图\":\"btn_道具\"}","{\"标签\":\"--技能--\",\"指定按钮\":\"技能\",\"关键字\":\"\",\"按钮贴图\":\"btn_技能\"}","{\"标签\":\"--装备--\",\"指定按钮\":\"装备\",\"关键字\":\"\",\"按钮贴图\":\"btn_装备\"}","{\"标签\":\"--状态--\",\"指定按钮\":\"状态\",\"关键字\":\"\",\"按钮贴图\":\"btn_状态\"}","{\"标签\":\"--队形--\",\"指定按钮\":\"队形\",\"关键字\":\"\",\"按钮贴图\":\"btn_队形\"}","{\"标签\":\"--选项--\",\"指定按钮\":\"选项\",\"关键字\":\"\",\"按钮贴图\":\"btn_选项\"}","{\"标签\":\"--保存--\",\"指定按钮\":\"保存\",\"关键字\":\"\",\"按钮贴图\":\"btn_保存\"}","{\"标签\":\"--游戏结束--\",\"指定按钮\":\"游戏结束\",\"关键字\":\"\",\"按钮贴图\":\"btn_游戏结束\"}"]
 * 
 * @param ---激活的按钮---
 * @desc 
 * 
 * @param 按钮激活后是否出列
 * @parent ---激活的按钮---
 * @type boolean
 * @on 开启
 * @off 关闭
 * @desc 在选项按钮组出现后，点击确认选择了一个按钮时，该按钮会出列，移动到一个相对坐标位置。
 * @default true
 * 
 * @param 激活后出列变化时长
 * @parent ---激活的按钮---
 * @type number
 * @min 0
 * @desc 出列时间的时长。
 * @default 20
 * 
 * @param 激活后出列绝对坐标 X
 * @parent ---激活的按钮---
 * @desc x轴方向平移，单位像素。0为贴在最左边。单位像素。。
 * @default 150
 * 
 * @param 激活后出列绝对坐标 Y
 * @parent ---激活的按钮---
 * @desc y轴方向平移，单位像素。0为贴在最上面。单位像素。
 * @default 467
 * 
 */
/*~struct~DrillSMaCommandButtonSeq:
 * 
 * @param 标签
 * @desc 只用于方便区分查看的标签，不作用在插件中。
 * @default --新的按钮关键字对应--
 * 
 * @param 指定按钮
 * @type select
 * @option 道具(Button_item)
 * @value 道具
 * @option 技能(Button_skill)
 * @value 技能
 * @option 装备(Button_equip)
 * @value 装备
 * @option 状态(Button_status)
 * @value 状态
 * @option 队形(Button_formation)
 * @value 队形
 * @option 选项(Button_options)
 * @value 选项
 * @option 保存(Button_save)
 * @value 保存
 * @option 游戏结束(Button_gameEnd)
 * @value 游戏结束
 * @option 自定义(Button_……)
 * @value 自定义
 * @desc 按钮的关键字。
 * @default 自定义
 * 
 * @param 关键字
 * @parent 指定按钮
 * @desc 不多废话，去看文档 "17.主菜单 > 菜单关键字.docx"。  看 = 能解决问题； 不看 = 不能解决,到处问人,没人理你。
 * @default Button_xxx
 * 
 * @param 按钮贴图
 * @desc 自定义按钮的图片资源。
 * @default 按钮贴图xxx
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * 
 */
/*~struct~DrillSMaActorButton:
 * 
 * @param 平移-按钮组 X
 * @desc x轴方向平移，单位像素。0为贴在最左边。
 * @default 408
 * 
 * @param 平移-按钮组 Y
 * @desc y轴方向平移，单位像素。0为贴在最上面。
 * @default 312
 * 
 * @param 按钮组样式
 * @type number
 * @min 0
 * @desc 按钮组对应的样式配置，对应 按钮组核心 的样式id。
 * @default 1
 * 
 * @param ---头像按钮贴图---
 * @desc 
 * 
 * @param 默认头像按钮贴图
 * @parent ---头像按钮贴图---
 * @desc 默认按钮的图片资源。
 * @default 头像按钮-默认
 * @require 1
 * @dir img/Menu__actorFaces/
 * @type file
 *
 * @param 头像按钮贴图序列
 * @parent ---头像按钮贴图---
 * @desc 角色头像序列与角色id是一一对应的，比如序列中编号5头像表示id为5的角色，即量子妹。
 * @default []
 * @require 1
 * @dir img/Menu__actorFaces/
 * @type file[]
 * 
 * 
 */
/*~struct~DrillSMaActorBoardStyle:
 * 
 * @param 标签
 * @desc 只用于方便区分查看的标签，不作用在插件中。
 * @default --新的角色固定框样式--
 * 
 * @param ----参数条----
 * @desc 
 * 
 * @param 生命-是否显示参数条
 * @parent ----参数条----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 生命-参数条配置
 * @parent 生命-是否显示参数条
 * @type struct<DrillActorMeter>
 * @desc 角色固定框中，生命参数条的配置信息。其中，固定段数为1，且段上限为生命上限。
 * @default {}
 * 
 * @param 魔法-是否显示参数条
 * @parent ----参数条----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 * 
 * @param 魔法-参数条配置
 * @parent 魔法-是否显示参数条
 * @type struct<DrillActorMeter>
 * @desc 角色固定框中，魔法参数条的配置信息。其中，固定段数为1，且段上限为魔法上限。
 * @default {}
 * 
 * @param 怒气-是否显示参数条
 * @parent ----参数条----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 怒气-参数条配置
 * @parent 怒气-是否显示参数条
 * @type struct<DrillActorMeter>
 * @desc 角色固定框中，怒气参数条的配置信息。其中，固定段数为1，且段上限为怒气上限。
 * @default {}
 * 
 * @param 经验-是否显示参数条
 * @parent ----参数条----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 经验-参数条配置
 * @parent 经验-是否显示参数条
 * @type struct<DrillActorMeter>
 * @desc 角色固定框中，经验参数条的配置信息。其中，固定段数为1，且段上限为下一级所需经验。
 * @default {}
 * 
 * 
 * @param ----参数数字----
 * @desc 
 * 
 * @param 生命-是否显示参数数字
 * @parent ----参数数字----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 * 
 * @param 生命-参数数字配置
 * @parent 生命-是否显示参数数字
 * @type struct<DrillActorNumber>
 * @desc 角色固定框中，生命参数数字的配置信息。其中，额定值即为生命上限的值，固定满血视作为"达到条件"。
 * @default {}
 * 
 * @param 魔法-是否显示参数数字
 * @parent ----参数数字----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 魔法-参数数字配置
 * @parent 魔法-是否显示参数数字
 * @type struct<DrillActorNumber>
 * @desc 角色固定框中，魔法参数数字的配置信息。其中，额定值即为魔法上限的值，固定满魔视作为"达到条件"。
 * @default {}
 * 
 * @param 怒气-是否显示参数数字
 * @parent ----参数数字----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 怒气-参数数字配置
 * @parent 怒气-是否显示参数数字
 * @type struct<DrillActorNumber>
 * @desc 角色固定框中，怒气参数数字的配置信息。其中，额定值即为怒气上限的值，固定满怒气视作为"达到条件"。
 * @default {}
 * 
 * @param 经验-是否显示参数数字
 * @parent ----参数数字----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 经验-参数数字配置
 * @parent 经验-是否显示参数数字
 * @type struct<DrillActorNumber>
 * @desc 角色固定框中，经验参数数字的配置信息。其中，额定值即为下一级经验的值，固定全等级满经验视作为"达到条件"。
 * @default {}
 * 
 * @param 等级-是否显示参数数字
 * @parent ----参数数字----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 等级-参数数字配置
 * @parent 等级-是否显示参数数字
 * @type struct<DrillActorNumber>
 * @desc 角色固定框中，等级参数数字的配置信息。其中，额定值即为最大等级的值，固定满等级视作为"达到条件"。
 * @default {}
 * 
 * 
 * @param ----外框----
 * @desc 
 *
 * @param 资源-固定框背景
 * @parent ----外框----
 * @desc 固定框背景的图片资源。
 * @default 角色固定框背景-默认
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param 平移-固定框背景 X
 * @parent ----外框----
 * @desc 修正校对背景的位置用，x轴方向平移，单位像素。
 * @default 0
 *
 * @param 平移-固定框背景 Y
 * @parent ----外框----
 * @desc 修正校对背景的位置用，y轴方向平移，单位像素。
 * @default 0
 *
 * @param 资源-固定框前景
 * @parent ----外框----
 * @desc 固定框前景的图片资源，可以遮住生命条、魔法条、怒气条。
 * @default 角色固定框前景-默认
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param 平移-固定框前景 X
 * @parent ----外框----
 * @desc 修正校对前景的位置用，x轴方向平移，单位像素。
 * @default 0
 *
 * @param 平移-固定框前景 Y
 * @parent ----外框----
 * @desc 修正校对前景的位置用，y轴方向平移，单位像素。
 * @default 0
 * 
 * @param ----姓名显示----
 * @desc 
 * 
 * @param 是否显示姓名
 * @parent ----姓名显示----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default true
 *
 * @param 平移-姓名 X
 * @parent ----姓名显示----
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 94
 *
 * @param 平移-姓名 Y
 * @parent ----姓名显示----
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 51
 * 
 * @param 姓名字体大小
 * @parent ----姓名显示----
 * @type number
 * @min 1
 * @desc 姓名的字体大小。
 * @default 20
 * 
 * @param 姓名对齐方式
 * @parent ----姓名显示----
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 姓名的对齐方式。
 * @default 左对齐
 * 
 * @param ----职业显示----
 * @desc 
 * 
 * @param 是否显示职业
 * @parent ----职业显示----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 平移-职业 X
 * @parent ----职业显示----
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 164
 *
 * @param 平移-职业 Y
 * @parent ----职业显示----
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 51
 * 
 * @param 职业字体大小
 * @parent ----职业显示----
 * @type number
 * @min 1
 * @desc 职业的字体大小。
 * @default 20
 * 
 * @param 职业对齐方式
 * @parent ----职业显示----
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 职业的对齐方式。
 * @default 左对齐
 * 
 * @param ----昵称显示----
 * @desc 
 * 
 * @param 是否显示昵称
 * @parent ----昵称显示----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default false
 *
 * @param 平移-昵称 X
 * @parent ----昵称显示----
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 164
 *
 * @param 平移-昵称 Y
 * @parent ----昵称显示----
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 74
 * 
 * @param 昵称字体大小
 * @parent ----昵称显示----
 * @type number
 * @min 1
 * @desc 昵称的字体大小。
 * @default 20
 * 
 * @param 昵称对齐方式
 * @parent ----昵称显示----
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 居中
 * @value 居中
 * @option 右对齐
 * @value 右对齐
 * @desc 昵称的对齐方式。
 * @default 左对齐
 * 
 * @param ----状态显示----
 * @desc 
 * 
 * @param 是否显示状态
 * @parent ----状态显示----
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default true
 *
 * @param 平移-状态 X
 * @parent ----状态显示----
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 229
 *
 * @param 平移-状态 Y
 * @parent ----状态显示----
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 62
 *
 * @param 状态显示模式
 * @parent ----状态显示----
 * @type select
 * @option 单一闪烁
 * @value 单一闪烁
 * @option 直线并排
 * @value 直线并排
 * @desc 状态显示的模式。
 * @default 单一闪烁
 *
 * @param 状态对齐方式
 * @parent 状态显示模式
 * @type select
 * @option 左对齐
 * @value 左对齐
 * @option 右对齐
 * @value 右对齐
 * @option 上对齐
 * @value 上对齐
 * @option 下对齐
 * @value 下对齐
 * @desc 直线并排的状态的对齐方式。
 * @default 左对齐
 *
 * @param 状态间距
 * @parent 状态显示模式
 * @type number
 * @min 0
 * @desc 直线并排的状态之间的间距，单位像素。
 * @default 0
 *
 * @param 最大显示状态数量
 * @parent 状态显示模式
 * @type number
 * @min 1
 * @desc 直线并排能显示的状态的最大数量。超过数量的状态图标不会被显示。
 * @default 4
 * 
 */
/*~struct~DrillSMaActorBoardBind:
 * 
 * @param 标签
 * @desc 只用于方便区分查看的标签，不作用在插件中。
 * @default --新的角色框设置--
 * 
 * @param ---绑定---
 * @desc 
 * 
 * @param 绑定的样式
 * @parent ---绑定---
 * @desc 设置这个角色对应的框样式。
 * @type number
 * @min 1
 * @default 1
 * 
 * @param ---角色前视图---
 * @desc 
 * 
 * @param 是否显示角色前视图
 * @parent ---角色前视图---
 * @type boolean
 * @on 显示
 * @off 隐藏
 * @desc true - 显示，false - 隐藏
 * @default true
 * 
 * @param 资源-角色前视图
 * @parent ---角色前视图---
 * @desc 角色的前视图，与角色一一对应。可以是单张图片，也可以是多张组成的gif。
 * @default ["角色前视图-默认"]
 * @require 1
 * @dir img/Menu__actorFaces/
 * @type file[]
 *
 * @param 帧间隔
 * @parent ---角色前视图---
 * @type number
 * @min 1
 * @desc gif每帧播放间隔时间，单位帧。（1秒60帧）
 * @default 4
 *
 * @param 是否倒放
 * @parent ---角色前视图---
 * @type boolean
 * @on 倒放
 * @off 不倒放
 * @desc true - 倒放，false - 不倒放
 * @default false
 * 
 * @param 平移-角色前视图 X
 * @parent ---角色前视图---
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。可为负数。
 * @default 10
 *
 * @param 平移-角色前视图 Y
 * @parent ---角色前视图---
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。可为负数。
 * @default 10
 * 
 * 
 */
/*~struct~DrillSMaActorBoardArrange:
 * 
 * @param ---主体---
 * @desc 
 * 
 * @param 平移-固定框组 X
 * @parent ---主体---
 * @desc 以固定框组整体的位置为基准，x轴方向平移，0为贴在最左边。单位像素。
 * @default 0
 *
 * @param 平移-固定框组 Y
 * @parent ---主体---
 * @desc 以固定框组整体的位置为基准，y轴方向平移，0为贴在最上面。单位像素。
 * @default 0
 * 
 * @param 角色框数量上限
 * @parent ---主体---
 * @desc 主菜单中显示的角色框数量上限。
 * @type number
 * @min 1
 * @default 4
 * 
 * @param 无角色时是否仍然显示框
 * @parent ---主体---
 * @type boolean
 * @on 显示
 * @off 不显示
 * @desc true - 显示，false - 不显示
 * @default true
 * 
 * @param 无角色时设置
 * @parent 无角色时是否仍然显示框
 * @type struct<DrillSMaActorBoardBind>
 * @desc 指定槽位没有角色时，空角色的配置。
 * @default {"标签":"--空角色框--","---绑定---":"","绑定的样式":"1","---角色前视图---":"","是否显示角色前视图":"false","资源-角色前视图":"","平移-角色前视图 X":"0","平移-角色前视图 Y":"0"}
 * 
 * @param 固定框组移动动画
 * @parent ---主体---
 * @type struct<DrillActorGroupMoving>
 * @desc 固定框会从某个点跑回自己的原位置。
 * @default {"移动类型":"弹性移动","移动时长":"50","移动延迟":"0","依次移动延迟间隔":"20","---起点---":"","坐标类型":"各固定框的相对坐标","起点-相对坐标 X":"0","起点-相对坐标 Y":"80","起点-统一坐标 X":"408","起点-统一坐标 Y":"312"}
 * 
 * @param ---排列---
 * @desc 
 * 
 * @param 排列方式
 * @parent ---排列---
 * @type select
 * @option 直线排列
 * @value 直线排列
 * @option 环形排列
 * @value 环形排列
 * @option 矩阵排列
 * @value 矩阵排列
 * @option 固定离散排列
 * @value 固定离散排列
 * @desc 选项文本的对齐方式。
 * @default 直线排列
 * 
 * @param ==直线排列==
 * @parent ---排列---
 * @desc 
 *
 * @param 直线间距
 * @parent ==直线排列==
 * @type number
 * @min 0
 * @desc 直线排列时，角色框间的间距。单位像素。
 * @default 192
 *
 * @param 直线W间距
 * @parent ==直线排列==
 * @desc 直线排列时，偶数个角色框的垂直方向间距。单位像素。设置0则角色框组成一条直线。可为负数。
 * @default 48
 *
 * @param 直线旋转角度
 * @parent ==直线排列==
 * @type number
 * @min 0
 * @desc 直线排列时，排列延长线的旋转角度，单位角度。（逆时针，90度朝下，270度朝上）
 * @default 0
 * 
 * @param 是否限制最大长度
 * @parent ==直线排列==
 * @type boolean
 * @on 限制
 * @off 关闭
 * @desc true - 限制，false - 关闭。限制长度后，如果 角色框数*间距 超过了最大长度，将会缩短间距，确保挤压在一起。
 * @default false
 *
 * @param 直线最大长度
 * @parent 是否限制最大长度
 * @desc 限制指定长度后，如果 角色框数*间距 超过了最大长度，将会缩短间距，确保挤压在一起。
 * @default 600
 * 
 * @param ==环形排列==
 * @parent ---排列---
 * @desc 
 *
 * @param 环形半径
 * @parent ==环形排列==
 * @type number
 * @min 0
 * @desc 环形排列时，角色框围绕的半径。单位像素。
 * @default 192
 * 
 * @param 环形起始角
 * @parent ==环形排列==
 * @type number
 * @min 0
 * @max 360
 * @desc 环形排列时，第一个角色框所在的角度位置。
 * @default 0
 * 
 * @param 环形终止角
 * @parent ==环形排列==
 * @type number
 * @min 0
 * @max 360
 * @desc 环形排列时，最后一个角色框所在的角度位置。
 * @default 360
 * 
 * @param ==矩阵排列==
 * @parent ---排列---
 * @desc 
 *
 * @param 矩阵列数
 * @parent ==矩阵排列==
 * @type number
 * @min 1
 * @desc 矩阵排列时，矩阵的列数。行数会根据列数自动匹配。
 * @default 4
 * 
 * @param 矩阵列宽
 * @parent ==矩阵排列==
 * @type number
 * @min 0
 * @desc 矩阵排列时，矩阵列之间的宽度。
 * @default 192
 *
 * @param 矩阵行高
 * @parent ==矩阵排列==
 * @type number
 * @min 0
 * @desc 矩阵排列时，矩阵行之间的高度。
 * @default 192
 * 
 * @param ==固定离散排列==
 * @parent ---排列---
 * @desc 
 * 
 * @param 固定离散位置序列
 * @parent ==固定离散排列==
 * @type text[]
 * @desc 固定离散排列时，填入 x,y 的坐标的序列。例如：200,200，不填则默认0,0。
 * @default []
 *
 *
 */
 /*~struct~DrillActorMeter:
 * 
 * @param ---主体---
 * @desc 
 *
 * @param 平移-参数条 X
 * @parent ---主体---
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 10
 *
 * @param 平移-参数条 Y
 * @parent ---主体---
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 10
 *
 * @param 整体旋转角度
 * @parent ---主体---
 * @type number
 * @min 0
 * @desc 参数条的整体旋转角度，单位角度。中心锚点在左上角。（逆时针，90度朝下，270度朝上）
 * @default 0
 *
 * @param 资源-参数条
 * @parent ---主体---
 * @desc 参数条的图片资源，菜单界面中，强制 段数为1。
 * @default 参数条-默认
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param 资源-参数条遮罩
 * @parent ---主体---
 * @desc 参数条的遮罩资源。注意，如果开启了流动效果，凹槽条的长度需要适配 段长度。
 * @default 
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param ---加满动画---
 * @desc 
 * 
 * @param 是否启用加满动画
 * @parent ----加满动画---
 * @type boolean
 * @on 播放
 * @off 不播放
 * @desc true - 播放，false - 不播放
 * @default true
 *
 * @param 加满方式
 * @parent 是否启用加满动画
 * @type select
 * @option 匀速加满
 * @value 匀速加满
 * @option 弹性加满
 * @value 弹性加满
 * @desc 参数条加满的方式。
 * @default 匀速加满
 *
 * @param 加满持续时间
 * @parent 是否启用加满动画
 * @type number
 * @min 1
 * @desc 动画将在时间内加满参数条，单位帧。（1秒60帧）
 * @default 20
 *
 * @param 加满延迟
 * @parent 是否启用加满动画
 * @type number
 * @min 0
 * @desc 浮动框出现后，播放加满动画的延迟时间，单位帧。（1秒60帧）
 * @default 10
 *
 * @param ---段---
 * @desc 
 *
 * @param 是否使用流动效果
 * @parent ---段---
 * @type boolean
 * @on 流动
 * @off 不流动
 * @desc 注意，设置流动后，素材长度会取三分之一或按指定段长度划分。
 * @default false
 *
 * @param 流动方向
 * @parent 是否使用流动效果
 * @type select
 * @option 从右往左
 * @value 从右往左
 * @option 从左往右
 * @value 从左往右
 * @desc 流动效果的流动方向。
 * @default 从右往左
 *
 * @param 流动速度
 * @parent 是否使用流动效果
 * @desc 段 流动的速度，单位像素/帧。可为小数。
 * @default 0.5
 *
 * @param 流动段划分模式
 * @parent 是否使用流动效果
 * @type select
 * @option 三等份划分
 * @value 三等份划分
 * @option 指定段长度划分
 * @value 指定段长度划分
 * @desc 使用流动效果时，对资源的划分模式。
 * @default 三等份划分
 * 
 * @param 段长度
 * @parent 流动段划分模式
 * @type number
 * @min 0
 * @desc 流动段划分模式中 选择"指定段长度切片"时，段的实际长度。
 * @default 0
 *
 * @param ---粒子效果---
 * @desc 
 *
 * @param 是否启用粒子效果
 * @parent ---粒子效果---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭。
 * @default false
 *
 * @param 资源-粒子
 * @parent ---粒子效果---
 * @desc 生命条中的粒子效果的粒子图片资源。
 * @default 参数条-默认粒子
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param 粒子出现模式
 * @parent ---粒子效果---
 * @type select
 * @option 随机出现
 * @value 随机出现
 * @option 左侧出现
 * @value 左侧出现
 * @option 右侧出现
 * @value 右侧出现
 * @option 顶部出现
 * @value 顶部出现
 * @option 底部出现
 * @value 底部出现
 * @desc 上下左右分别对应长方形的四个边的区域。
 * @default 底部出现
 *
 * @param 粒子X速度
 * @parent ---粒子效果---
 * @desc 粒子在x轴方向移动的速度。可为小数，可为负数。
 * @default 0
 *
 * @param 粒子Y速度
 * @parent ---粒子效果---
 * @desc 粒子在y轴方向移动的速度。可为小数，可为负数。
 * @default -1.5
 *
 * @param 粒子数量
 * @parent ---粒子效果---
 * @type number
 * @min 0
 * @desc 条中出现的粒子的数量。
 * @default 20
 *
 * @param 粒子持续时间
 * @parent ---粒子效果---
 * @type number
 * @min 1
 * @desc 粒子出现到粒子消失的时间。如果粒子离开参数条边界，则视为该粒子已经消失。
 * @default 20
 *
 * @param ---游标---
 * @desc 
 *
 * @param 是否启用游标
 * @parent ---游标---
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭。
 * @default false
 *
 * @param 资源-游标
 * @parent ---游标---
 * @desc 参数条中游标的图片资源。可以为单张，也可以为多张形成gif。
 * @default ["参数条-默认游标"]
 * @require 1
 * @dir img/Menu__main/
 * @type file[]
 *
 * @param 动画帧间隔
 * @parent ---游标---
 * @type number
 * @min 1
 * @desc 多帧游标的播放帧间隔，间隔越小，播放速度越快。
 * @default 4
 *
 * @param 是否倒放
 * @parent ---游标---
 * @type boolean
 * @on 倒放
 * @off 正常播放
 * @desc true - 倒放，false - 正常播放。多帧游标的播放顺序。
 * @default false
 *
 * @param 偏移-游标 X
 * @parent ---游标---
 * @desc 以游标浮动的位置为基准，x轴方向偏移，单位像素。
 * @default 0
 *
 * @param 偏移-游标 Y
 * @parent ---游标---
 * @desc 以游标浮动的位置为基准，y轴方向偏移，单位像素。
 * @default 0
 *
 * @param 游标显示模式
 * @parent ---游标---
 * @type select
 * @option 亮光模式
 * @value 亮光模式
 * @option 闪烁模式
 * @value 闪烁模式
 * @option 受伤模式
 * @value 受伤模式
 * @option 增量模式
 * @value 增量模式
 * @option 变化模式
 * @value 变化模式
 * @option 一直显示
 * @value 一直显示
 * @desc 游标的显示模式，详细介绍见文档 "13.UI > 关于参数条.docx"中游标介绍。
 * @default 一直显示
 *
 * @param 遮罩是否能遮挡游标
 * @parent ---游标---
 * @type boolean
 * @on 遮挡
 * @off 不遮挡
 * @desc 如果你希望游标和参数条一样，能被遮罩遮挡，可以设置ture开启遮挡。
 * @default false
 * 
 *
 */
 /*~struct~DrillActorNumber:
 *
 * @param ---主体---
 * @desc 
 *
 * @param 平移-参数数字 X
 * @parent ---主体---
 * @desc 以样式框的位置为基准，x轴方向平移，单位像素。
 * @default 10
 *
 * @param 平移-参数数字 Y
 * @parent ---主体---
 * @desc 以样式框的位置为基准，y轴方向平移，单位像素。
 * @default 10
 *
 * @param 整体旋转角度
 * @parent ---主体---
 * @type number
 * @min 0
 * @desc 参数数字的整体旋转角度，单位角度。中心锚点在左上角。
 * @default 0
 * 
 * @param 资源-基本符号
 * @parent ---主体---
 * @desc 基本符号的图片资源。注意，资源会被分成14等分，分别表示数字和加减乘除（0123456789+-x/）。
 * @default 基本符号-默认
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param 资源-扩展符号
 * @parent ---主体---
 * @desc 扩展符号的图片资源，注意，资源会被分成14等分。通过字母表示扩展符号（abcdefghijklmn）。
 * @default 扩展符号-默认
 * @require 1
 * @dir img/Menu__main/
 * @type file
 *
 * @param ---符号---
 * @desc 
 * 
 * @param 是否显示负号
 * @parent ---符号---
 * @type boolean
 * @on 显示
 * @off 不显示
 * @desc 如果参数值出现了负数值，会显示负号。
 * @default true
 * 
 * @param 额外符号前缀
 * @parent ---符号---
 * @desc 在当前显示的数字字符，前缀额外显示的 额外符号。注意，这里不是输入HP就能显示HP，去看文档！
 * @default 
 * 
 * @param 额外符号后缀
 * @parent ---符号---
 * @desc 在当前显示的数字字符，后缀额外显示的 额外符号。注意，这里不是输入HP就能显示HP，去看文档！
 * @default 
 *
 * @param ---排列---
 * @desc 
 *
 * @param 对齐方式
 * @parent ---排列---
 * @type select
 * @option 右对齐
 * @value 右对齐
 * @option 居中
 * @value 居中
 * @option 左对齐
 * @value 左对齐
 * @desc 符号的对齐方式。
 * @default 右对齐
 *
 * @param 最大符号数量
 * @parent ---排列---
 * @type number
 * @min 1
 * @desc 最多显示的符号数量，比如"1000"中有4个符号，"-100/-110"中有9个符号。
 * @default 20
 * 
 * @param 符号间间距
 * @parent ---排列---
 * @desc 符号贴图之间的间距，可以为负数，负数的间距将会更加紧凑。
 * @default 0
 *
 * @param 排列宽度模式
 * @parent ---排列---
 * @type select
 * @option 不限制宽度
 * @value 不限制宽度
 * @option 缩放限制
 * @value 缩放限制
 * @option 挤压限制
 * @value 挤压限制
 * @desc 排列符号是宽度的模式。超出宽度时，缩放限制会横向缩放。挤压限制则会减小间距。
 * @default 不限制宽度
 *
 * @param 排列限制宽度
 * @parent 排列宽度模式
 * @desc 模式中设置限制时，符号的最大宽度。
 * @default 300
 * 
 * @param ---滚动效果---
 * @desc 
 *
 * @param 滚动模式
 * @parent ---滚动效果---
 * @type select
 * @option 瞬间变化
 * @value 瞬间变化
 * @option 弹性滚动
 * @value 弹性滚动
 * @desc 滚动效果指 数字的值变化后，数值滚动到指定值的动画效果。
 * @default 弹性滚动
 * 
 * @param 弹性变化速度
 * @parent ---滚动效果---
 * @desc 值为比例除数，值越小，速度越快。值越大，速度越慢。
 * @default 10.0
 *
 * @param ---额定值---
 * @desc 
 * 
 * @param 是否显示额定值
 * @parent ---额定值---
 * @type boolean
 * @on 显示
 * @off 不显示
 * @desc true - 显示，false - 不显示。"100/200"中，200为额定值，不显示额定值则只显示"100"。
 * @default false
 * 
 * @param 达到条件时符号
 * @parent ---额定值---
 * @type select
 * @option 所有符号变为额定符号
 * @value 所有符号变为额定符号
 * @option 有效符号变为额定符号
 * @value 有效符号变为额定符号
 * @option 只参数符号变为额定符号
 * @value 只参数符号变为额定符号
 * @option 不变化
 * @value 不变化
 * @desc 满足额定条件后，变化的符号情况。
 * @default 不变化
 * 
 * @param 资源-额定基本符号
 * @parent ---额定值---
 * @desc 满足额定条件时基本符号的图片资源。注意，资源会被分成14等分，分别表示数字和加减乘除（0123456789+-x/）。
 * @default 
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 * @param 资源-额定扩展符号
 * @parent ---额定值---
 * @desc 满足额定条件时扩展符号的图片资源，注意，资源会被分成14等分。通过字母表示扩展符号（abcdefghijklmn）。
 * @default 
 * @require 1
 * @dir img/Menu__main/
 * @type file
 * 
 *
 */
/*~struct~DrillActorGroupMoving:
 *
 * @param 移动类型
 * @type select
 * @option 不移动
 * @value 不移动
 * @option 匀速移动
 * @value 匀速移动
 * @option 增减速移动
 * @value 增减速移动
 * @option 弹性移动
 * @value 弹性移动
 * @desc 移动类型基于 弹道核心-两点式 移动。更多内容可以去看看 "1.系统 > 关于弹道.docx"。
 * @default 匀速移动
 *
 * @param 移动时长
 * @type number
 * @min 1
 * @desc 起点位置回到原位置所需的时间，单位帧。（1秒60帧）
 * @default 50
 *
 * @param 移动延迟
 * @type number
 * @min 0
 * @desc 开始移动前的等待时间，单位帧。（1秒60帧）
 * @default 0
 * 
 * @param 依次移动延迟间隔
 * @type number
 * @min 0
 * @desc 每个角色框比前一个角色框延迟移动的间隔时间。
 * @default 20
 *
 * @param ---起点---
 * @default 
 *
 * @param 坐标类型
 * @parent ---起点---
 * @type select
 * @option 各固定框的相对坐标
 * @value 各固定框的相对坐标
 * @option 统一的坐标
 * @value 统一的坐标
 * @desc 起点的坐标类型。
 * @default 各固定框的相对坐标
 * 
 * @param 起点-相对坐标 X
 * @parent ---起点---
 * @desc 相对坐标以原位置为基准，负数向右，正数向左，单位像素。
 * @default 0
 * 
 * @param 起点-相对坐标 Y
 * @parent ---起点---
 * @desc 相对坐标以原位置为基准，负数向上，正数向下，单位像素。
 * @default 80
 * 
 * @param 起点-统一坐标 X
 * @parent ---起点---
 * @desc 绝对坐标以屏幕的位置为准，0表示贴在最左边，单位像素。
 * @default 408
 * 
 * @param 起点-统一坐标 Y
 * @parent ---起点---
 * @desc 绝对坐标以屏幕的位置为准，0表示贴在最上面，单位像素。
 * @default 312
 * 
 */
 
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
//		插件简称		SMa (Gauge_Button)
//		临时全局变量	DrillUp.g_SMa_xxx
//		临时局部变量	this._drill_SMa_xxx
//		存储数据变量	$gameSystem._drill_SMa_xxx
//		全局存储变量	无
//		覆盖重写方法	Scene_Menu.prototype.commandFormation
//						Scene_Menu.prototype.commandPersonal（半覆写）
//						Window_MenuStatus.prototype.processCursorMove（半覆写）
//						Window_MenuCommand.prototype.processCursorMove（半覆写）
//
//		工作类型		持续执行
//		时间复杂度		o(n^3)*o(场景元素) 每帧
//		性能测试因素	直接进入主菜单面板进行测试。
//		性能测试消耗	44.39ms  58.25ms
//		最坏情况		如果有很多角色固定框，且都有x4的参数条和x5的参数数字，可能会有些性能影响。
//		备注			4个角色固定框的时候，每隔几秒会有一个性能大消耗，然后复原，但是有时候不会出现这种情况，原因不明。
//
//插件记录：
//		★大体框架与功能如下：
//			主菜单面板：
//				->原装结构
//					->菜单选项窗口	
//					->金钱窗口		
//					->角色控制窗口
//				->常规
//					->整体布局
//					->所在地
//					x->内部魔法圈
//				->时间显示
//					->累积游戏时长
//					->真实时间
//					->游戏世界时间
//					->日期/时间 格式化
//				->金钱数字
//				->菜单选项按钮集
//					->按钮组样式
//						->排列
//							->单一指针激活
//							->流式滚动
//						->选项名称
//						->移动动画
//						->激活的按钮
//						->选中的按钮
//							->选中时变化方式
//							->按钮选择指针
//							->点击选中/进入
//						->输入设备
//							->鼠标自动选中
//							->无障碍滚动
//				->角色头像按钮集	
//					->流程-只一个角色时是否跳过选头像
//					->按钮组样式
//				->角色固定框	
//					->固定框样式
//						->前景、背景
//						->参数条、参数数字
//							->等级数字
//							->经验条
//							->经验数字/下一级数字
//							->生命条
//							->生命数字/最大生命数字
//							->魔法条
//							->魔法数字/最大魔法数字
//							->怒气条
//							->怒气数字最大怒气数字
//						->角色属性
//							->角色名
//							->状态图标
//					->绑定
//						->角色前视图（gif）
//					->固定框组
//						->排列
//						->空角色槽位
//						->空角色前视图
//				->队形面板
//				->插件指令
//					->获取真实时间
//					->修改按钮样式
//					->修改按钮组位置
//					->修改角色固定框样式
//				->其它
//					->mog时间系统的框
//		
//		★配置参数结构体如下：
//			~struct~DrillWindowMoving:			窗口移动动画（窗口辅助核心-通用）
//			~struct~DrillWindowLayout:			窗口布局（窗口辅助核心-通用）
//
//			~struct~DrillSMaGoldWindow:			金钱窗口（窗口辅助核心）
//			~struct~DrillSMaGoldNumber:			金钱数字（参数数字核心）
//			
//			~struct~DrillSMaCommandWindow:		菜单选项窗口（窗口辅助核心）
//			~struct~DrillSMaCommandButton:		菜单选项按钮组（按钮组核心）
//			~struct~DrillSMaCommandButtonSeq:	菜单选项按钮组 > 序列（按钮组核心）
//			
//			~struct~DrillSMaActorButton:		角色头像按钮组（按钮组核心）
//			
//			~struct~DrillSMaActorBoardBind:		角色框设置
//			~struct~DrillSMaActorBoardStyle:	角色固定框样式
//			~struct~DrillActorMeter:			角色固定框样式 > 参数条（参数条核心）
//			~struct~DrillActorNumber:			角色固定框样式 > 参数数字（参数数字核心）
//			~struct~DrillSMaActorBoardArrange:	角色固定框组设置
//			~struct~DrillActorGroupMoving:		角色固定框组设置 > 固定框组移动动画
//
//			
//		★私有类如下：
//			* Drill_SMa_ActorSprite      角色固定框
//			* Scene_Drill_SMa_Formation  对象界面
//			* Window_Drill_SMa_Formation 队形窗口
//
//		★必要注意事项：
//			1.插件中引用了大量核心，并且部分参数专门固定化。
//			  【不要以该插件为模板复制制作新的菜单界面】
//		
//		★其它说明细节：
//			1.  2020-9-19：
//				这个插件写了8个星期。每次写一点，然后就去做别的事情了，因为兴趣低迷。
//				虽说基本功能都已经完成，但是仍然感觉插件里的部分重复的地方无法抹除。
//				灵活性几乎被扩展到极限，但代价是所有部件都需要详细的文档说明。
//				角色固定框，几乎把整个boss固定框都给嵌进来了，当时决定开一个角色固定框核心，后来发现这并不是好的选择，
//				由于定制化太高，核心的参数会越来越零散，反而更难把控核心的专一性，所以放弃了。
//			2.队形面板几乎没有什么可以改变的地方，大部分照抄mog。
//
//		★存在的问题：
//			暂无
//
//
 
//=============================================================================
// ** 变量获取
//=============================================================================
　　var Imported = Imported || {};
　　Imported.Drill_SceneMain = true;
　　var DrillUp = DrillUp || {}; 
    DrillUp.parameters = PluginManager.parameters('Drill_SceneMain');
	
	

//=============================================================================
// * 外部影响插件检测
//=============================================================================
if( typeof(_Scene_Menu_create) != "undefined" || typeof(_Window_MenuActor_initialize) != "undefined" ){
	
	alert(
		"【Drill_SceneMain.js 面板 - 全自定义主菜单面板】\n"+
		"检测到你开启了 AltMenuScreen插件 或 基于该插件写的派生插件 。\n"+
		"请及时关闭这类插件，其会对 菜单选项按钮 的显示造成干扰。"
	);
};

//=============================================================================
// * >>>>基于插件检测>>>>
//=============================================================================
if( Imported.Drill_CoreOfWindowAuxiliary &&
	Imported.Drill_CoreOfGaugeMeter &&
	Imported.Drill_CoreOfGaugeNumber &&
	Imported.Drill_CoreOfSelectableButton	){
	
		
	//==============================
	// * 变量获取 - 金钱显示 - 金钱窗口参数（必须写在前面）
	//				（~struct~DrillSMaGoldWindow）
	//==============================
	DrillUp.drill_SMa_initGoldWindow = function( dataFrom ) {
		var data = {};
		data['x'] = Number( dataFrom["金钱窗口 X"] || 0);
		data['y'] = Number( dataFrom["金钱窗口 Y"] || 0);
		data['width'] = Number( dataFrom["金钱窗口宽度"] || 100);
		data['height'] = Number( dataFrom["金钱窗口高度"] || 100);
		data['fontsize'] = Number( dataFrom["金钱窗口字体大小"] || 22);
		if( dataFrom["金钱窗口移动动画"] != "" &&
			dataFrom["金钱窗口移动动画"] != undefined ){
			var slideAnim = JSON.parse( dataFrom["金钱窗口移动动画"] );
			data['slideMoveType'] = String( slideAnim["移动类型"] || "匀速移动");
			data['slideTime'] = Number( slideAnim["移动时长"] || 20);
			data['slideDelay'] = Number( slideAnim["移动延迟"] || 0);
			data['slidePosType'] = String( slideAnim["坐标类型"] || "相对坐标");
			data['slideX'] = Number( slideAnim["起点-相对坐标 X"] || -100);
			data['slideY'] = Number( slideAnim["起点-相对坐标 Y"] || 0);
			data['slideAbsoluteX'] = Number( slideAnim["起点-绝对坐标 X"] || 0);
			data['slideAbsoluteY'] = Number( slideAnim["起点-绝对坐标 Y"] || 0);
		}
		if( dataFrom["金钱窗口布局"] != "" &&
			dataFrom["金钱窗口布局"] != undefined ){
			var layout = JSON.parse( dataFrom["金钱窗口布局"] );
			data['layoutType'] = String( layout["布局类型"] || "默认皮肤");
			data['layoutSrc'] = String( layout["资源-贴图"] || "");
			data['layoutSrcFile'] = "img/Menu__main/";
			data['layoutX'] = Number( layout["贴图位置修正 X"] || -100);
			data['layoutY'] = Number( layout["贴图位置修正 Y"] || 0);
		}
		return data;
	}
	//==============================
	// * 变量获取 - 金钱显示 - 金钱数字参数（必须写在前面）
	//				（~struct~DrillSMaGoldNumber）
	//==============================
	DrillUp.drill_SMa_initGoldNumber = function( dataFrom ) {
		var data = {};
		data = DrillUp.drill_COGN_initStyle( dataFrom );	//使用数字核心初始化部分参数
		data['x'] = Number( dataFrom["金钱数字 X"] || 0);
		data['y'] = Number( dataFrom["金钱数字 Y"] || 0);
		data['symbol_src_file'] = "img/Menu__main/";
		data['symbolEx_src_file'] = "img/Menu__main/";
		return data;
	}
	
	//==============================
	// * 变量获取 - 指针与边框
	//				（~struct~DrillCursor）
	//==============================
	DrillUp.drill_SMa_initMenuCursor = function( dataFrom ) {
		var data = {};
		//data['mog_enabled'] = String( dataFrom["是否启用mog菜单指针"] || "true") == "true";
		//data['mog_borderEnabled'] = String( dataFrom["是否启用mog菜单边框"] || "true") == "true";
		data['MCu_enabled'] = String( dataFrom["是否显示菜单指针"] || "true") == "true";
		data['MCu_lock'] = String( dataFrom["是否锁定菜单指针样式"] || "false") == "true";
		data['MCu_style'] = Number( dataFrom["锁定的菜单指针样式"] || 1);
		data['MCB_rectEnabled'] = String( dataFrom["是否启用闪烁白矩形"] || "true") == "true";
		data['MCB_enabled'] = String( dataFrom["是否启用菜单边框"] || "true") == "true";
		data['MCB_lock'] = String( dataFrom["是否锁定菜单边框样式"] || "false") == "true";
		data['MCB_style'] = Number( dataFrom["锁定的菜单边框样式"] || 1);
		data['MSB_enabled'] = String( dataFrom["是否启用滚动条"] || "true") == "true";
		data['MSB_lock'] = String( dataFrom["是否锁定滚动条样式"] || "false") == "true";
		data['MSB_style'] = Number( dataFrom["锁定的滚动条样式"] || 1);
		return data;
	}
	//==============================
	// * 变量获取 - 菜单选项 - 菜单选项窗口参数（必须写在前面）
	//				（~struct~DrillSMaCommandWindow）
	//==============================
	DrillUp.drill_SMa_initCommandWindow = function( dataFrom ) {
		var data = {};
		data['x'] = Number( dataFrom["菜单选项窗口 X"] || 0);
		data['y'] = Number( dataFrom["菜单选项窗口 Y"] || 0);
		data['width'] = Number( dataFrom["菜单选项窗口宽度"] || 100);
		data['height'] = Number( dataFrom["菜单选项窗口高度"] || 100);
		data['col'] = Number( dataFrom["菜单选项窗口列数"] || 1);
		data['fontsize'] = Number( dataFrom["菜单选项窗口字体大小"] || 22);
		if( dataFrom["菜单选项窗口移动动画"] != "" &&
			dataFrom["菜单选项窗口移动动画"] != undefined ){
			var slideAnim = JSON.parse( dataFrom["菜单选项窗口移动动画"] );
			data['slideMoveType'] = String( slideAnim["移动类型"] || "匀速移动");
			data['slideTime'] = Number( slideAnim["移动时长"] || 20);
			data['slideDelay'] = Number( slideAnim["移动延迟"] || 0);
			data['slidePosType'] = String( slideAnim["坐标类型"] || "相对坐标");
			data['slideX'] = Number( slideAnim["起点-相对坐标 X"] || -100);
			data['slideY'] = Number( slideAnim["起点-相对坐标 Y"] || 0);
			data['slideAbsoluteX'] = Number( slideAnim["起点-绝对坐标 X"] || 0);
			data['slideAbsoluteY'] = Number( slideAnim["起点-绝对坐标 Y"] || 0);
		}
		if( dataFrom["菜单选项窗口布局"] != "" &&
			dataFrom["菜单选项窗口布局"] != undefined ){
			var layout = JSON.parse( dataFrom["菜单选项窗口布局"] );
			data['layoutType'] = String( layout["布局类型"] || "默认皮肤");
			data['layoutSrc'] = String( layout["资源-贴图"] || "");
			data['layoutSrcFile'] = "img/Menu__main/";
			data['layoutX'] = Number( layout["贴图位置修正 X"] || -100);
			data['layoutY'] = Number( layout["贴图位置修正 Y"] || 0);
		}
		data['align'] = String( dataFrom["菜单选项对齐方式"] || "左对齐");
		if( dataFrom["菜单选项窗口指针与边框"] != "" &&
			dataFrom["菜单选项窗口指针与边框"] != undefined ){
			var cursor = JSON.parse( dataFrom["菜单选项窗口指针与边框"] );
			data['cursor'] = DrillUp.drill_SMa_initMenuCursor( cursor );
		}else{
			data['cursor'] = DrillUp.drill_SMa_initMenuCursor( {} );
		}
		return data;
	}
	//==============================
	// * 变量获取 - 菜单选项 - 菜单选项按钮组（必须写在前面）
	//				（~struct~DrillSMaCommandButton）
	//==============================
	DrillUp.drill_SMa_initCommandButton = function( dataFrom ) {
		var data = {};
		data['debug_search'] = String( dataFrom["DEBUG-按钮关键字搜索"] || "false") == "true";
		
		data['x'] = Number( dataFrom["平移-按钮组 X"] || 0);
		data['y'] = Number( dataFrom["平移-按钮组 Y"] || 0);
		data['style_id'] = Number( dataFrom["按钮组样式"] || 0);
		data['btn_constructor'] = "Window_Command";
		data['btn_src_file'] = "img/Menu__main/";
		data['btn_src_default'] = String( dataFrom["默认按钮贴图"] || "");
		if( dataFrom["按钮贴图序列"] != "" &&
			dataFrom["按钮贴图序列"] != undefined ){
			var seq = JSON.parse( dataFrom["按钮贴图序列"] );
			data['btn_src'] = [];
			data['btn_srcKeyword'] = [];
			for( var i=0; i < seq.length; i++ ){
				var seq_data = JSON.parse( seq[i] );
				var keyword = ""
				var tarWord = String( seq_data["指定按钮"] );
				if( tarWord == "道具" ){ keyword = "item";
				}else if( tarWord == "技能" ){ keyword = "skill";
				}else if( tarWord == "装备" ){ keyword = "equip";
				}else if( tarWord == "状态" ){ keyword = "status";
				}else if( tarWord == "队形" ){ keyword = "formation";
				}else if( tarWord == "选项" ){ keyword = "options";
				}else if( tarWord == "保存" ){ keyword = "save";
				}else if( tarWord == "游戏结束" ){ keyword = "gameEnd";
				}else{
					keyword = String( seq_data["关键字"] );
					keyword = keyword.replace("Button_","");
					keyword = keyword.replace("button_","");
				}
				data['btn_srcKeyword'].push( keyword );
				data['btn_src'].push( String( seq_data["按钮贴图"] ));
			}
		}else{
			data['btn_src'] = [];
			data['btn_srcKeyword'] = [];
		}
		data['active_enableMouseOk'] = true;	//（鼠标ok点击 开启）
		data['active_hide'] = false;			//（激活后是否瞬间隐藏，克隆选中按钮用）
		data['active_out'] = String( dataFrom["按钮激活后是否出列"] || "false") == "true";
		data['active_out_time'] = Number( dataFrom["激活后出列变化时长"] || 20);
		data['active_out_x'] = Number( dataFrom["激活后出列绝对坐标 X"] || 150);
		data['active_out_y'] = Number( dataFrom["激活后出列绝对坐标 Y"] || 467);
		return data;
	}
	
	
	//==============================
	// * 变量获取 - 角色头像 - 角色头像按钮组（必须写在前面）
	//				（~struct~DrillSMaActorButton）
	//==============================
	DrillUp.drill_SMa_initActorAvatarButton = function( dataFrom ) {
		var data = {};
		data['x'] = Number( dataFrom["平移-按钮组 X"] || 0);
		data['y'] = Number( dataFrom["平移-按钮组 Y"] || 0);
		data['style_id'] = Number( dataFrom["按钮组样式"] || 0);
		data['btn_constructor'] = "Window_Selectable";
		data['btn_src_file'] = "img/Menu__actorFaces/";
		data['btn_src_default'] = String( dataFrom["默认头像按钮贴图"] || "");
		if( dataFrom["头像按钮贴图序列"] != "" &&
			dataFrom["头像按钮贴图序列"] != undefined ){
			data['btn_src'] = JSON.parse( dataFrom["头像按钮贴图序列"] );
		}else{
			data['btn_src'] = [];
		}
		data['btn_srcKeyword'] = [];
		data['active_enableMouseOk'] = true;	//（鼠标ok点击 开启）
		data['active_hide'] = false;			//（激活后是否瞬间隐藏，克隆选中按钮用）
		data['active_out'] = false;				//（激活后不出列）
		return data;
	}
	
	
	//==============================
	// * 变量获取 - 角色固定框样式 - 参数条
	//				（~struct~DrillActorMeter）
	//==============================
	DrillUp.drill_SMa_initActorBoardMeter = function( dataFrom ) {
		var data = {};
		// > 主体
		//		data['anchor_x']（关闭）
		//		data['anchor_y']（关闭）
		//		data['visible']（后面函数赋值）
		data['x'] = Number( dataFrom["平移-参数条 X"] || 0 );
		data['y'] = Number( dataFrom["平移-参数条 Y"] || 0 );
		data['rotation'] = Number( dataFrom["整体旋转角度"] || 0 );
		data['meter_src'] = String( dataFrom["资源-参数条"] || "" );
		data['meter_src_file'] = "img/Menu__main/";
		data['meter_src_mask'] = String( dataFrom["资源-参数条遮罩"] || "" );
		// > 分段条（段）
		//		data['level_max']（后面函数赋值）
		data['level_count'] = 1;
		data['level_isLoop'] = true;
		data['shorten_mode'] = "瞬间缩短";
		data['shorten_speed'] = 2.5;
		data['flow_enable'] = String( dataFrom["是否使用流动效果"] || "true") === "true";
		data['flow_dir'] = String( dataFrom["流动方向"] || "从右往左");
		data['flow_speed'] = Number( dataFrom["流动速度"] || 1.0 );
		data['flow_srcMode'] = String( dataFrom["流动段划分模式"] || "三等份划分");
		data['flow_levelLength'] = Number( dataFrom["段长度"] || 0 );
		// > 凹槽条（关闭）
		// > 弹出条（关闭）
		// > 粒子
		data['par_enable'] = String( dataFrom["是否启用粒子效果"] || "true") === "true";
		data['par_src'] = String( dataFrom["资源-粒子"] || "" );
		data['par_src_file'] = "img/Menu__main/";
		data['par_mode'] = String( dataFrom["粒子出现模式"] || "底部出现");
		data['par_speedX'] = Number( dataFrom["粒子X速度"] || 0);
		data['par_speedY'] = Number( dataFrom["粒子Y速度"] || -1.5);
		data['par_count'] = Number( dataFrom["粒子数量"] || 20);
		data['par_life'] = Number( dataFrom["粒子持续时间"] || 20);
		// > 游标
		data['vernier_enable'] = String( dataFrom["是否启用游标"] || "false") === "true";
		if( dataFrom["资源-游标"] != undefined && dataFrom["资源-游标"] != "" ){
			data['vernier_src'] = JSON.parse( dataFrom["资源-游标"] );
		}else{
			data['vernier_src'] = [];
		}
		data['vernier_src'] = "img/Menu__main/";
		data['vernier_gif_interval'] = Number( dataFrom["动画帧间隔"] || 0);
		data['vernier_gif_backrun'] = String( dataFrom["是否倒放"] || "true") === "true";
		data['vernier_x'] = Number( dataFrom["偏移-游标 X"] || 0);
		data['vernier_y'] = Number( dataFrom["偏移-游标 Y"] || 0);
		data['vernier_mode'] = String( dataFrom["游标显示模式"] || "一直显示");
		data['vernier_reset'] = false;
		data['vernier_maskCover'] = String( dataFrom["遮罩是否能遮挡游标"] || "false") === "true";
		// > 加满动画
		data['filling_enable'] = String( dataFrom["是否启用加满动画"] || "false") === "true";
		data['filling_mode'] = String( dataFrom["加满方式"] || "匀速加满");
		data['filling_time'] = Number( dataFrom["加满持续时间"] || 90);
		data['filling_delay'] = Number( dataFrom["加满延迟"] || 30);
		return data;
	}
	//==============================
	// * 变量获取 - 角色固定框样式 - 参数数字
	//				（~struct~DrillActorNumber）
	//==============================
	DrillUp.drill_SMa_initActorBoardNumber = function( dataFrom ) {
		var data = {};
		// > 主体
		//		data['visible']（后面函数赋值）
		data['x'] = Number( dataFrom["平移-参数数字 X"] || 0 );
		data['y'] = Number( dataFrom["平移-参数数字 Y"] || 0 );
		data['rotation'] = Number( dataFrom["整体旋转角度"] || 0 );
		data['symbol_src'] = String( dataFrom["资源-基本符号"] || "" );
		data['symbol_src_file'] = "img/Menu__main/";
		data['symbolEx_src'] = String( dataFrom["资源-扩展符号"] || "" );
		data['symbolEx_src_file'] = "img/Menu__main/";
		// > 符号
		data['symbol_hasNegative'] = String( dataFrom["是否显示负号"] || "true") === "true";
		data['symbol_prefix'] = String( dataFrom["额外符号前缀"] || "") ;
		data['symbol_suffix'] = String( dataFrom["额外符号后缀"] || "") ;
		// > 排列
		data['section_align'] = String( dataFrom["对齐方式"] || "右对齐") ;
		data['section_spriteLength'] = Number( dataFrom["最大符号数量"] || 20 );
		data['section_interval'] = Number( dataFrom["符号间间距"] || 0 );
		data['section_widthMode'] = String( dataFrom["排列宽度模式"] || "不限制宽度");
		data['section_widthLimit'] = Number( dataFrom["排列限制宽度"] || 300 );
		// > 滚动效果
		data['rolling_mode'] = String( dataFrom["滚动模式"] || "弹性滚动");
		data['rolling_speed'] = Number( dataFrom["弹性变化速度"] || 10.0 );
		// > 额定值
		data['specified_enable'] = String( dataFrom["是否显示额定值"] || "false") === "true";	//显示即启用
		data['specified_visible'] = String( dataFrom["是否显示额定值"] || "false") === "true";
		data['specified_conditionNum'] = 100;
		data['specified_conditionType'] = "大于等于额定值时" ;
		data['specified_remainChange'] = true;
		data['specified_changeType'] = String( dataFrom["达到条件时符号"] || "不变化") ;
		data['specified_symbol_src'] = String( dataFrom["资源-额定基本符号"] || "" );
		data['specified_symbol_src_file'] = "img/Menu__main/";
		data['specified_symbolEx_src'] = String( dataFrom["资源-额定扩展符号"] || "" );
		data['specified_symbolEx_src_file'] = "img/Menu__main/";
		
		return data;
	}
	//==============================
	// * 变量获取 - 角色固定框样式
	//				（~struct~DrillSMaActorBoardStyle）
	//==============================
	DrillUp.drill_SMa_initActorBoardStyle = function( dataFrom ) {
		var data = {};
		// > 参数条
		data['hp_meter_enable'] = String( dataFrom["生命-是否显示参数条"] || "false") === "true";
		if( dataFrom["生命-参数条配置"] != undefined && 
			dataFrom["生命-参数条配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["生命-参数条配置"] );
			data['hp_meter_param'] = DrillUp.drill_SMa_initActorBoardMeter( temp_param );
		}else{
			data['hp_meter_param'] = {};
		}
		data['mp_meter_enable'] = String( dataFrom["魔法-是否显示参数条"] || "false") === "true";
		if( dataFrom["魔法-参数条配置"] != undefined && 
			dataFrom["魔法-参数条配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["魔法-参数条配置"] );
			data['mp_meter_param'] = DrillUp.drill_SMa_initActorBoardMeter( temp_param );
		}else{
			data['mp_meter_param'] = {};
		}
		data['tp_meter_enable'] = String( dataFrom["怒气-是否显示参数条"] || "false") === "true";
		if( dataFrom["怒气-参数条配置"] != undefined && 
			dataFrom["怒气-参数条配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["怒气-参数条配置"] );
			data['tp_meter_param'] = DrillUp.drill_SMa_initActorBoardMeter( temp_param );
		}else{
			data['tp_meter_param'] = {};
		}
		data['exp_meter_enable'] = String( dataFrom["经验-是否显示参数条"] || "false") === "true";
		if( dataFrom["经验-参数条配置"] != undefined && 
			dataFrom["经验-参数条配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["经验-参数条配置"] );
			data['exp_meter_param'] = DrillUp.drill_SMa_initActorBoardMeter( temp_param );
		}else{
			data['exp_meter_param'] = {};
		}
		// > 参数数字
		data['hp_symbol_visible'] = String( dataFrom["生命-是否显示参数数字"] || "false") === "true";
		if( dataFrom["生命-参数数字配置"] != undefined && 
			dataFrom["生命-参数数字配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["生命-参数数字配置"] );
			data['hp_symbol_param'] = DrillUp.drill_SMa_initActorBoardNumber( temp_param );
		}else{
			data['hp_symbol_param'] = {};
		}
		data['mp_symbol_visible'] = String( dataFrom["魔法-是否显示参数数字"] || "false") === "true";
		if( dataFrom["魔法-参数数字配置"] != undefined && 
			dataFrom["魔法-参数数字配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["魔法-参数数字配置"] );
			data['mp_symbol_param'] = DrillUp.drill_SMa_initActorBoardNumber( temp_param );
		}else{
			data['mp_symbol_param'] = {};
		}
		data['tp_symbol_visible'] = String( dataFrom["怒气-是否显示参数数字"] || "false") === "true";
		if( dataFrom["怒气-参数数字配置"] != undefined && 
			dataFrom["怒气-参数数字配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["怒气-参数数字配置"] );
			data['tp_symbol_param'] = DrillUp.drill_SMa_initActorBoardNumber( temp_param );
		}else{
			data['tp_symbol_param'] = {};
		}
		data['exp_symbol_visible'] = String( dataFrom["经验-是否显示参数数字"] || "false") === "true";
		if( dataFrom["经验-参数数字配置"] != undefined && 
			dataFrom["经验-参数数字配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["经验-参数数字配置"] );
			data['exp_symbol_param'] = DrillUp.drill_SMa_initActorBoardNumber( temp_param );
		}else{
			data['exp_symbol_param'] = {};
		}
		data['lv_symbol_visible'] = String( dataFrom["等级-是否显示参数数字"] || "false") === "true";
		if( dataFrom["等级-参数数字配置"] != undefined && 
			dataFrom["等级-参数数字配置"] != "" ){
			var temp_param = JSON.parse( dataFrom["等级-参数数字配置"] );
			data['lv_symbol_param'] = DrillUp.drill_SMa_initActorBoardNumber( temp_param );		//等级不一定有最大值
		}else{
			data['lv_symbol_param'] = {};
		}
		// > 外框
		data['background_src'] = String( dataFrom["资源-固定框背景"] || "" );
		data['background_x'] = Number( dataFrom["平移-固定框背景 X"] || 0 );
		data['background_y'] = Number( dataFrom["平移-固定框背景 Y"] || 0 );
		data['foreground_src'] = String( dataFrom["资源-固定框前景"] || "" );
		data['foreground_x'] = Number( dataFrom["平移-固定框前景 X"] || 0 );
		data['foreground_y'] = Number( dataFrom["平移-固定框前景 Y"] || 0 );
		// > 姓名显示
		data['name_visible'] = String( dataFrom["是否显示姓名"] || "true") === "true";
		data['name_x'] = Number( dataFrom["平移-姓名 X"] || 0 );
		data['name_y'] = Number( dataFrom["平移-姓名 Y"] || 0 );
		data['name_fontsize'] = Number( dataFrom["姓名字体大小"] || 20 );
		data['name_align'] = String( dataFrom["姓名对齐方式"] || "左对齐");
		// > 职业显示
		data['career_visible'] = String( dataFrom["是否显示职业"] || "false") === "true";
		data['career_x'] = Number( dataFrom["平移-职业 X"] || 0 );
		data['career_y'] = Number( dataFrom["平移-职业 Y"] || 0 );
		data['career_fontsize'] = Number( dataFrom["职业字体大小"] || 20 );
		data['career_align'] = String( dataFrom["职业对齐方式"] || "左对齐");
		// > 昵称显示
		data['nickname_visible'] = String( dataFrom["是否显示昵称"] || "false") === "true";
		data['nickname_x'] = Number( dataFrom["平移-昵称 X"] || 0 );
		data['nickname_y'] = Number( dataFrom["平移-昵称 Y"] || 0 );
		data['nickname_fontsize'] = Number( dataFrom["昵称字体大小"] || 20 );
		data['nickname_align'] = String( dataFrom["昵称对齐方式"] || "左对齐");
		// > 状态显示
		data['state_enable'] = String( dataFrom["是否显示状态"] || "true") === "true";
		data['state_x'] = Number( dataFrom["平移-状态 X"] || 0 );
		data['state_y'] = Number( dataFrom["平移-状态 Y"] || 0 );
		data['state_mode'] = String( dataFrom["状态显示模式"] || "单一闪烁");
		data['state_align'] = String( dataFrom["状态对齐方式"] || "左对齐");
		data['state_spacing'] = Number( dataFrom["状态间距"] || 0 );
		data['state_max'] = Number( dataFrom["最大显示状态数量"] || 4 );
		
		return data;
	}
	//==============================
	// * 变量获取 - 角色框设置
	//				（~struct~DrillSMaActorBoardBind）
	//==============================
	DrillUp.drill_SMa_initActorBoardBind = function( dataFrom ) {
		var data = {};
		// > 绑定
		data['style_id'] = Number( dataFrom["绑定的样式"] || 1 );
		// > 常规
		//		下列参数被放在 固定框组 中配置。
		//		data['visible']（初始是否显示）
		//		data['frame_x']（平移-固定框 X）
		//		data['frame_y']（平移-固定框 Y）
		//		dataFrom["整体移动动画"]
		// > 角色前视图
		data['pic_visible'] = String( dataFrom["是否显示角色前视图"] || "true") === "true";
		if( dataFrom["资源-角色前视图"] != undefined &&
			dataFrom["资源-角色前视图"] != "" ){
			data['pic_src'] = JSON.parse( dataFrom["资源-角色前视图"] || [] );
		}else{
			data['pic_src'] = [];
		}
		data['pic_interval'] = Number( dataFrom["帧间隔"] || 4 );
		data['pic_back_run'] = String( dataFrom["是否倒放"] || "false") === "true";
		data['pic_x'] = Number( dataFrom["平移-角色前视图 X"] || 0 );
		data['pic_y'] = Number( dataFrom["平移-角色前视图 Y"] || 0 );
		
		return data;
	}
	//==============================
	// * 变量获取 - 角色固定框组设置
	//				（~struct~DrillSMaActorBoardArrange）
	//==============================
	DrillUp.drill_SMa_initActorBoardArrange = function( dataFrom ) {
		var data = {};
		// > 主体
		data['x'] = Number( dataFrom["平移-固定框组 X"] || 0 );
		data['y'] = Number( dataFrom["平移-固定框组 Y"] || 0 );
		data['visible_rowCount'] = Number( dataFrom["角色框数量上限"] || 4 );
		data['visible_force'] = String( dataFrom["无角色时是否仍然显示框"] || "true") === "true";
		if( dataFrom["无角色时设置"] != undefined &&
			dataFrom["无角色时设置"] != "" ){
			data['visible_emptyActor'] = JSON.parse(dataFrom["无角色时设置"]);
			data['visible_emptyActor'] = DrillUp.drill_SMa_initActorBoardBind( data['visible_emptyActor'] );
		}else{
			data['visible_emptyActor'] = {};
		}
		if( dataFrom["固定框组移动动画"] != undefined &&
			dataFrom["固定框组移动动画"] != "" ){
			var slideAnimFrom = JSON.parse( dataFrom["固定框组移动动画"] || {} );
			var slideAnim = {};
			slideAnim['slideMoveType'] = String(slideAnimFrom["移动类型"] || "匀速移动");
			slideAnim['slideTime'] = Number(slideAnimFrom["移动时长"] || 20);
			slideAnim['slideDelay'] = Number(slideAnimFrom["移动延迟"] || 0);
			slideAnim['slideOrderlyDelay'] = Number(slideAnimFrom["依次移动延迟间隔"] || 0);
			slideAnim['slidePosType'] = String(slideAnimFrom["坐标类型"] || "各固定框的相对坐标");
			slideAnim['slideX'] = Number(slideAnimFrom["起点-相对坐标 X"] || -100);
			slideAnim['slideY'] = Number(slideAnimFrom["起点-相对坐标 Y"] || 0);
			slideAnim['slideAbsoluteX'] = Number(slideAnimFrom["起点-统一坐标 X"] || 0);
			slideAnim['slideAbsoluteY'] = Number(slideAnimFrom["起点-统一坐标 Y"] || 0);
			data['board_slideAnim'] = slideAnim;
		}else{
			data['board_slideAnim'] = {};
		}
		// > 排列
		data['arrange_mode'] = String( dataFrom["排列方式"] || "直线排列");
		data['arrange_spacing'] = Number( dataFrom["直线间距"] || 10);
		data['arrange_wSpacing'] = Number( dataFrom["直线W间距"] || 0);
		data['arrange_angle'] = Number( dataFrom["直线旋转角度"] || 0);
		data['arrange_limitEnable'] = String( dataFrom["是否限制最大长度"] || "false") == "true";
		data['arrange_limitLength'] = Number( dataFrom["直线最大长度"] || 600);
		data['arrange_radius'] = Number( dataFrom["环形半径"] || 10);
		data['arrange_angleStart'] = Number( dataFrom["环形起始角"] || 0);
		data['arrange_angleEnd'] = Number( dataFrom["环形终止角"] || 0);
		data['arrange_col'] = Number( dataFrom["矩阵列数"] || 1);
		data['arrange_width'] = Number( dataFrom["矩阵列宽"] || 10);
		data['arrange_height'] = Number( dataFrom["矩阵行高"] || 10);
		if( dataFrom["固定离散位置序列"] != "" &&
			dataFrom["固定离散位置序列"] != undefined ){
			data['arrange_squeeze'] = JSON.parse( dataFrom["固定离散位置序列"] );
		}else{
			data['arrange_squeeze'] = [];
		}
		
		return data;
	}
	
	
	/*-----------------杂项------------------*/
	DrillUp.g_SMa_layout_src = String(DrillUp.parameters["资源-整体布局"] || "");
	DrillUp.g_SMa_mapName_enable = String(DrillUp.parameters["是否显示所在地图名"] || "true") == "true";
	DrillUp.g_SMa_mapName_x = Number(DrillUp.parameters["平移-所在地图名 X"] || 0);	
	DrillUp.g_SMa_mapName_y = Number(DrillUp.parameters["平移-所在地图名 Y"] || 0);	
	DrillUp.g_SMa_mapName_fontSize = Number(DrillUp.parameters["所在地图名字体大小"] || 22);
	DrillUp.g_SMa_mapName_align = String(DrillUp.parameters["所在地图名对齐方式"] || "居中");

	/*-----------------时间显示------------------*/	
	DrillUp.g_SMa_playTime_enable = String(DrillUp.parameters["是否显示累积游戏时长"] || "true") == "true";
	DrillUp.g_SMa_playTime_x = Number(DrillUp.parameters["平移-累积游戏时长 X"] || 0);	
	DrillUp.g_SMa_playTime_y = Number(DrillUp.parameters["平移-累积游戏时长 Y"] || 0);	
	DrillUp.g_SMa_playTime_format = String(DrillUp.parameters["累积游戏时长的时间格式"] || "HH:mm:ss");	
	DrillUp.g_SMa_playTime_fontSize = Number(DrillUp.parameters["累积游戏时长字体大小"] || 22);	
	DrillUp.g_SMa_realTime_enable = String(DrillUp.parameters["是否显示真实时间"] || "true") == "true";
	DrillUp.g_SMa_realTime_x = Number(DrillUp.parameters["平移-真实时间 X"] || 0);	
	DrillUp.g_SMa_realTime_y = Number(DrillUp.parameters["平移-真实时间 Y"] || 0);	
	DrillUp.g_SMa_realTime_format = String(DrillUp.parameters["真实时间的时间格式"] || "yyyy-MM-dd HH:mm:ss");	
	DrillUp.g_SMa_realTime_fontSize = Number(DrillUp.parameters["真实时间字体大小"] || 22);	
	DrillUp.g_SMa_gameWorldTime_enable = String(DrillUp.parameters["是否显示游戏世界时间"] || "true") == "true";
	DrillUp.g_SMa_gameWorldTime_x = Number(DrillUp.parameters["平移-游戏世界时间 X"] || 0);	
	DrillUp.g_SMa_gameWorldTime_y = Number(DrillUp.parameters["平移-游戏世界时间 Y"] || 0);	
	DrillUp.g_SMa_gameWorldTime_format = String(DrillUp.parameters["游戏世界时间的时间格式"] || "yyyy-MM-dd HH:mm:ss");	
	DrillUp.g_SMa_gameWorldTime_fontSize = Number(DrillUp.parameters["游戏世界时间字体大小"] || 22);	
	
	/*-----------------金钱显示------------------*/
	DrillUp.g_SMa_gold_mode = String(DrillUp.parameters["金钱显示模式"] || "参数数字模式");
	if( DrillUp.parameters["金钱窗口"] != undefined &&
		DrillUp.parameters["金钱窗口"] != "" ){
		var data = JSON.parse( DrillUp.parameters["金钱窗口"] );
		DrillUp.g_SMa_gold_window = DrillUp.drill_SMa_initGoldWindow( data );
	}else{
		DrillUp.g_SMa_gold_window = {};
	}
	if( DrillUp.parameters["金钱参数数字"] != undefined &&
		DrillUp.parameters["金钱参数数字"] != "" ){
		var data = JSON.parse( DrillUp.parameters["金钱参数数字"] );
		DrillUp.g_SMa_gold_number = DrillUp.drill_SMa_initGoldNumber( data );
	}else{
		DrillUp.g_SMa_gold_number = {};
	}
	
	/*-----------------菜单选项------------------*/
	DrillUp.g_SMa_command_mode = String(DrillUp.parameters["菜单选项模式"] || "按钮组模式");
	if( DrillUp.parameters["菜单选项窗口"] != undefined &&
		DrillUp.parameters["菜单选项窗口"] != "" ){
		var data = JSON.parse( DrillUp.parameters["菜单选项窗口"] );
		DrillUp.g_SMa_command_window = DrillUp.drill_SMa_initCommandWindow( data );
	}else{
		DrillUp.g_SMa_command_window = DrillUp.drill_SMa_initCommandWindow( {} );
	}
	if( DrillUp.parameters["菜单选项按钮组"] != undefined &&
		DrillUp.parameters["菜单选项按钮组"] != "" &&
		DrillUp.parameters["菜单选项按钮组"] != "{}" ){
		var data = JSON.parse( DrillUp.parameters["菜单选项按钮组"] );
		DrillUp.g_SMa_command_button = DrillUp.drill_SMa_initCommandButton( data );
	}else{
		if( DrillUp.g_SMa_command_mode == "按钮组模式" ){
			alert( "【Drill_SceneMain.js 面板 - 全自定义主菜单面板】\n" +
					"你未配置 菜单选项按钮组 参数，请及时配置。");
		}
		DrillUp.g_SMa_command_button = DrillUp.drill_SMa_initCommandButton( {} );
	}
	
	/*-----------------角色头像按钮------------------*/
	DrillUp.g_SMa_actorAvatar_skip = String(DrillUp.parameters["流程-只一个角色时是否跳过选头像"] || "false") == "true";
	DrillUp.g_SMa_actorAvatar_visibleNum = Number(DrillUp.parameters["可显示的角色头像数量"] || 4);	
	if( DrillUp.parameters["角色头像按钮组"] != undefined &&
		DrillUp.parameters["角色头像按钮组"] != "" &&
		DrillUp.parameters["角色头像按钮组"] != "{}" ){
		var data = JSON.parse( DrillUp.parameters["角色头像按钮组"] );
		DrillUp.g_SMa_actorAvatar_button = DrillUp.drill_SMa_initActorAvatarButton( data );
	}else{
		alert( "【Drill_SceneMain.js 面板 - 全自定义主菜单面板】\n" +
				"你未配置 角色头像按钮组 参数，请及时配置。");
		DrillUp.g_SMa_actorAvatar_button = {};
	}

	/*---------------角色固定框样式--------------*/
	DrillUp.g_SMa_styleList_length = 8;
	DrillUp.g_SMa_styleList = [];
	for( var i = 0; i < DrillUp.g_SMa_styleList_length; i++ ){
		if( DrillUp.parameters["角色固定框样式-" + String(i+1) ] != undefined &&
			DrillUp.parameters["角色固定框样式-" + String(i+1) ] != "" ){
			var data = JSON.parse(DrillUp.parameters["角色固定框样式-" + String(i+1) ]);
			DrillUp.g_SMa_styleList[i] = DrillUp.drill_SMa_initActorBoardStyle( data );
			//alert(JSON.stringify(DrillUp.g_SMa_styleList[i]));
		}else{
			DrillUp.g_SMa_styleList[i] = DrillUp.drill_SMa_initActorBoardStyle( {} );
		}
	}
	if( DrillUp.parameters["固定框组"] != undefined &&
		DrillUp.parameters["固定框组"] != "" ){
		DrillUp.g_SMa_actorArrange = JSON.parse(DrillUp.parameters["固定框组"]);
		DrillUp.g_SMa_actorArrange = DrillUp.drill_SMa_initActorBoardArrange( DrillUp.g_SMa_actorArrange );
	}else{
		DrillUp.g_SMa_actorArrange = {};
	}
	if( DrillUp.parameters["备用角色前视图列表"] != undefined &&
		DrillUp.parameters["备用角色前视图列表"] != "" ){
		DrillUp.g_SMa_actorPicBackupTank = JSON.parse( DrillUp.parameters["备用角色前视图列表"] || [] );
	}else{
		DrillUp.g_SMa_actorPicBackupTank = [];
	}
	
	/*----------------角色框设置---------------*/
	DrillUp.g_SMa_bind_length = 60;
	DrillUp.g_SMa_bind = [];
	for( var i = 0; i < DrillUp.g_SMa_bind_length; i++ ){
		if( DrillUp.parameters["角色框设置-" + String(i+1) ] != undefined &&
			DrillUp.parameters["角色框设置-" + String(i+1) ] != "" ){
			var data = JSON.parse(DrillUp.parameters["角色框设置-" + String(i+1) ]);
			DrillUp.g_SMa_bind[i] = DrillUp.drill_SMa_initActorBoardBind( data );
			DrillUp.g_SMa_bind[i]['actor_id'] = i+1 ;
			DrillUp.g_SMa_bind[i]['inited'] = true ;
		}else{
			DrillUp.g_SMa_bind[i] = DrillUp.drill_SMa_initActorBoardBind( {} );
			DrillUp.g_SMa_bind[i]['actor_id'] = i+1 ;
			DrillUp.g_SMa_bind[i]['inited'] = false ;
		}
	}
	
	
//=============================================================================
// ** 资源文件夹
//=============================================================================
ImageManager.load_MenuMain = function( filename ){
    return this.loadBitmap('img/Menu__main/', filename, 0, true);
};
ImageManager.load_MenuActorFace = function( filename ){
    return this.loadBitmap('img/Menu__actorFaces/', filename, 0, true);
};
//=============================================================================
// ** 插件指令
//=============================================================================
var _drill_SMa_pluginCommand = Game_Interpreter.prototype.pluginCommand
Game_Interpreter.prototype.pluginCommand = function(command, args) {
	_drill_SMa_pluginCommand.call(this, command, args);
	if(command === ">主菜单面板"){
		if( args.length == 2 ){
			var type = String(args[1]);
			if( type == "打开面板" ){			//打开菜单
				SceneManager.push(Scene_Menu);
			}
		}
		if( args.length == 4 ){
			var type = String(args[1]);
			var temp1 = String(args[3]);
			
			/*-----------------菜单选项按钮组------------------*/
			if( type == "菜单选项按钮组" ){
				if( temp1.indexOf("改变位置[") != -1 ){
					temp1 = temp1.replace("改变位置[","");
					temp1 = temp1.replace("]","");
					var temp_arr = temp1.split(/[,，]/);
					if( temp_arr.length >= 2 ){
						$gameSystem._drill_SMa_commandButton_x =  Number(temp_arr[0]);
						$gameSystem._drill_SMa_commandButton_y =  Number(temp_arr[1]);
					}
				}
				if( temp1.indexOf("改变样式[") != -1 ){
					temp1 = temp1.replace("改变样式[","");
					temp1 = temp1.replace("]","");
					temp1 = Number(temp1) - 1;
					$gameSystem._drill_SMa_commandButton_index = temp1;
				}
			}
			
			/*-----------------角色框设置------------------*/
			if( type.indexOf("角色框设置[") != -1 ){
				type = type.replace("角色框设置[","");
				type = type.replace("]","");
				var a_id = Number(type) - 1;
				if( temp1.indexOf("改变样式[") != -1 ){
					temp1 = temp1.replace("改变样式[","");
					temp1 = temp1.replace("]","");
					temp1 = Number(temp1) - 1;
					$gameSystem._drill_SMa_actorBindTank[ a_id ]['style_id'] = temp1;
				}
				if( temp1.indexOf("改变前视图[") != -1 ){
					temp1 = temp1.replace("改变前视图[","");
					temp1 = temp1.replace("]","");
					var temp_arr = temp1.split(/[,，]/);
					var temp_tank = [];
					for( var i=0; i < temp_arr.length; i++ ){
						temp_tank.push( DrillUp.g_SMa_actorPicBackupTank[ Number(temp_arr[i])-1 ] );
					}
					$gameSystem._drill_SMa_actorBindTank[ a_id ]['pic_src_commandSet'] = temp_tank;
				}
				if( temp1 == "还原默认前视图配置" ){
					$gameSystem._drill_SMa_actorBindTank[ a_id ]['pic_src_commandSet'] = [];
				}
			}
		}
		/*-----------------获取时间------------------*/
		if( args.length == 6 ){
			var type = String(args[1]);
			var temp1 = String(args[3]);
			var temp2 = String(args[5]);
			if( temp1 == "给予值" ){
				temp2 = temp2.replace("变量[","");
				temp2 = temp2.replace("]","");
				if( type == "累积游戏时长(秒)" || type == "累积游戏时长（秒）" ){
					var sec = $gameSystem.playtime() % 60;
					$gameVariables.setValue( Number(temp2), sec );
				}
				if( type == "累积游戏时长(分)" || type == "累积游戏时长（分）" ){
					var min = Math.floor($gameSystem.playtime() / 60) % 60;
					$gameVariables.setValue( Number(temp2), min );
				}
				if( type == "累积游戏时长(时)" || type == "累积游戏时长（时）" ){
					var hour = Math.floor($gameSystem.playtime() / 60 / 60);
					$gameVariables.setValue( Number(temp2), hour );
				}
				if( type == "累积游戏时长(总秒数)" || type == "累积游戏时长（总秒数）" ){
					$gameVariables.setValue( Number(temp2), $gameSystem.playtime() );
				}
				if( type == "真实时间(秒)" || type == "真实时间（秒）" ){
					var sec = new Date().getSeconds();
					$gameVariables.setValue( Number(temp2), sec );
				}
				if( type == "真实时间(分)" || type == "真实时间（分）" ){
					var min = new Date().getMinutes();
					$gameVariables.setValue( Number(temp2), min );
				}
				if( type == "真实时间(时)" || type == "真实时间（时）" ){
					var hour = new Date().getHours();
					$gameVariables.setValue( Number(temp2), hour );
				}
				if( type == "真实时间(日)" || type == "真实时间（日）" ){
					var d = new Date().getDate();
					$gameVariables.setValue( Number(temp2), d );
				}
				if( type == "真实时间(月)" || type == "真实时间（月）" ){
					var month = new Date().getMonth() + 1;
					$gameVariables.setValue( Number(temp2), month );
				}
				if( type == "真实时间(年)" || type == "真实时间（年）" ){
					var year = new Date().getFullYear();
					$gameVariables.setValue( Number(temp2), year );
				}
				if( type == "游戏世界时间(秒)" || type == "游戏世界时间（秒）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var sec = $gameSystem.second();
					$gameVariables.setValue( Number(temp2), sec );
				}
				if( type == "游戏世界时间(分)" || type == "游戏世界时间（分）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var min = $gameSystem.minute();
					$gameVariables.setValue( Number(temp2), min );
				}
				if( type == "游戏世界时间(时)" || type == "游戏世界时间（时）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var hour = $gameSystem.hour();
					$gameVariables.setValue( Number(temp2), hour );
				}
				if( type == "游戏世界时间(日)" || type == "游戏世界时间（日）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var d = $gameSystem.day();
					$gameVariables.setValue( Number(temp2), d );
				}
				if( type == "游戏世界时间(月)" || type == "游戏世界时间（月）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var month = $gameSystem.month();
					$gameVariables.setValue( Number(temp2), month );
				}
				if( type == "游戏世界时间(年)" || type == "游戏世界时间（年）" ){
					if( Imported.MOG_TimeSystem != true ){ $gameVariables.setValue( Number(temp2), -1 ); return; }
					var year = $gameSystem.year();
					$gameVariables.setValue( Number(temp2), year );
				}
			}
		}
	};
};

//=============================================================================
// ** 存储数据初始化
//=============================================================================
//==============================
// * 存储数据 - 初始化
//==============================
var _drill_SMa_sys_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {	
	_drill_SMa_sys_initialize.call(this);
	this._drill_SMa_commandButton_x = DrillUp.g_SMa_command_button['x'];				//菜单选项按钮组 - x
	this._drill_SMa_commandButton_y = DrillUp.g_SMa_command_button['y'];				//菜单选项按钮组 - y
	this._drill_SMa_commandButton_index = DrillUp.g_SMa_command_button['style_id']-1;	//菜单选项按钮组 - 样式
	this._drill_SMa_actorBindTank = JSON.parse(JSON.stringify( DrillUp.g_SMa_bind ));
};
//==============================
// * 存储数据 - 载入存档时检查
//==============================
var _drill_SMa_sys_extractSaveContents = DataManager.extractSaveContents;
DataManager.extractSaveContents = function( contents ){
	_drill_SMa_sys_extractSaveContents.call( this, contents );
	
	if( $gameSystem._drill_SMa_actorBindTank == undefined ){ return; }
	for(var i=0; i < $gameSystem._drill_SMa_actorBindTank.length; i++ ){	//（设置为空时，自动覆盖新的默认配置）
		if( DrillUp.g_SMa_bind[i] == undefined ){ continue; }
		if( $gameSystem._drill_SMa_actorBindTank[i]['inited'] != true ){
			$gameSystem._drill_SMa_actorBindTank[i] = JSON.parse(JSON.stringify( DrillUp.g_SMa_bind[i] ));
		}
	}
}


//=============================================================================
// ** 主菜单
//=============================================================================
//==============================
// * 主菜单 - 初始化
//==============================
var _drill_SMa_initialize = Scene_Menu.prototype.initialize;
Scene_Menu.prototype.initialize = function() {
	_drill_SMa_initialize.call(this);
	//暂无
};
//==============================
// * 主菜单 - 创建
//==============================
var _drill_SMa_create = Scene_Menu.prototype.create;
Scene_Menu.prototype.create = function() {
	_drill_SMa_create.call(this);
	this.drill_SMa_createLayer();					//层级
	this.drill_SMa_createLayout();					//整体布局
	this.drill_SMa_createActorBoard();				//角色固定框
	this.drill_SMa_createMapName();					//所在地图名
	this.drill_SMa_createPlayTime();				//累积游戏时长
	this.drill_SMa_createRealTime();				//真实时间
	this.drill_SMa_createGameWorldTime();			//游戏世界时间
	this.drill_SMa_createGoldNumber();				//金钱参数数字
	this.drill_SMa_createCommandButton();			//菜单选项按钮集
	this.drill_SMa_createActorAvatarButton();		//角色头像按钮集
}
//==============================
// * 主菜单 - 帧刷新（rmmv中没有此函数，不能覆写，覆写会少背景）
//==============================
var _drill_SMa_update = Scene_Menu.prototype.update;
Scene_Menu.prototype.update = function() {
    _drill_SMa_update.call(this);
	this.drill_SMa_updateOrgWindow();				//原装窗口控制
	this.drill_SMa_updatePlayTime();				//累积游戏时长
	this.drill_SMa_updateRealTime();				//真实时间
	this.drill_SMa_updateGoldNumber();				//金钱参数数字
	this.drill_SMa_updateCommandButton();			//菜单选项按钮集
	this.drill_SMa_updateActorAvatarButton();		//角色头像按钮集
}

//=============================================================================
// ** 创建
//=============================================================================
//==============================
// * 创建 - 原装菜单选项窗口
//==============================
var _drill_SMa_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
Scene_Menu.prototype.createCommandWindow = function() {
	_drill_SMa_createCommandWindow.call( this );
	if( DrillUp.g_SMa_command_mode == "窗口模式" ){
		this._commandWindow.drill_COWA_changeParamData( DrillUp.g_SMa_command_window );
		this._commandWindow.maxCols = function(){ return DrillUp.g_SMa_command_window['col']; }
		this._commandWindow.itemTextAlign = function(){
			if( DrillUp.g_SMa_command_window['align'] == "居中" ){ return "center"; }
			if( DrillUp.g_SMa_command_window['align'] == "右对齐" ){ return "right"; }
			return "left";
		}
		
		// > 兼容Drill_MenuCursor菜单指针插件
		if( Imported.Drill_MenuCursor == true && DrillUp.g_SMa_command_window['cursor'] != null ){
			this._commandWindow.drill_MCu_cursorEnabled = function(){
				return DrillUp.g_SMa_command_window['cursor']['MCu_enabled'];
			}
			this._commandWindow.drill_MCu_cursorStyleId = function(){
				if( DrillUp.g_SMa_command_window['cursor']['MCu_lock'] == true ){
					return DrillUp.g_SMa_command_window['cursor']['MCu_style'];
				}else{
					return $gameSystem._drill_MCu_style;
				}
			}
		}
		// > 兼容Drill_MenuCursorBorder菜单边框插件
		if( Imported.Drill_MenuCursorBorder == true && DrillUp.g_SMa_command_window['cursor'] != null ){
			this._commandWindow.drill_MCB_glimmerRectVisible = function() {
				return DrillUp.g_SMa_command_window['cursor']['MCB_rectEnabled'];
			}
			this._commandWindow.drill_MCB_borderEnabled = function() {
				return DrillUp.g_SMa_command_window['cursor']['MCB_enabled'];
			}
			this._commandWindow.drill_MCB_borderStyleId = function() {
				if( DrillUp.g_SMa_command_window['cursor']['MCB_lock'] == true ){
					return DrillUp.g_SMa_command_window['cursor']['MCB_style'];
				}else{
					return $gameSystem._drill_MCB_style;
				}
			}
		}
		// > 兼容Drill_MenuScrollBar菜单滚动条插件
		if( Imported.Drill_MenuScrollBar == true && DrillUp.g_SMa_command_window['cursor'] != null ){
			this._commandWindow.drill_MSB_scrollBarEnabled = function() {
				return DrillUp.g_SMa_command_window['cursor']['MSB_enabled'];
			}
			this._commandWindow.drill_MSB_scrollBarStyleId = function() {
				if( DrillUp.g_SMa_command_window['cursor']['MSB_lock'] == true ){
					return DrillUp.g_SMa_command_window['cursor']['MSB_style'];
				}else{
					return $gameSystem._drill_MSB_style;
				}
			}
		}
		
		this._commandWindow.refresh();
	}
}
//==============================
// * 创建 - 原装金钱窗口
//==============================
var _drill_SMa_createGoldWindow = Scene_Menu.prototype.createGoldWindow;
Scene_Menu.prototype.createGoldWindow = function() {
	_drill_SMa_createGoldWindow.call( this );
	if( DrillUp.g_SMa_gold_mode == "窗口模式" ){
		this._goldWindow.drill_COWA_changeParamData( DrillUp.g_SMa_gold_window );
		this._goldWindow.refresh();
	}
}
//==============================
// * 创建 - 原装状态窗口
//==============================
var _drill_SMa_createStatusWindow = Scene_Menu.prototype.createStatusWindow;
Scene_Menu.prototype.createStatusWindow = function() {
	_drill_SMa_createStatusWindow.call( this );
	
	this._statusWindow._list = [];	//强制加上_list给 按钮组核心识别
	this._statusWindow.refresh();
}
//==============================
// * 创建 - 层级
//==============================
Scene_Menu.prototype.drill_SMa_createLayer = function() {
	this._layer_context = new Sprite();		//内容层
	this.addChild( this._layer_context );
	this._layer_outer = new Sprite();		//外层
	this.addChild( this._layer_outer );
}
//==============================
// * 创建 - 整体布局
//==============================
Scene_Menu.prototype.drill_SMa_createLayout = function() {
	var temp_sprite = new Sprite( ImageManager.load_MenuMain( DrillUp.g_SMa_layout_src ) );
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_layoutSprite = temp_sprite;
}
//==============================
// * 创建 - 所在地图名
//==============================
Scene_Menu.prototype.drill_SMa_createMapName = function() {
	if( DrillUp.g_SMa_mapName_enable == false ){ return; }
	if( $gameMap == undefined ){ return; }
	if( $dataMap == undefined ){ return; }
	
	var temp_sprite = new Sprite();
	temp_sprite.x = DrillUp.g_SMa_mapName_x;
	temp_sprite.y = DrillUp.g_SMa_mapName_y;
	temp_sprite.bitmap = new Bitmap( 320, DrillUp.g_SMa_mapName_fontSize + 4 );
	temp_sprite.bitmap.fontSize = DrillUp.g_SMa_mapName_fontSize;
	var align = "center";
	if( DrillUp.g_SMa_mapName_align == "右对齐" ){ align = "right"; }
	if( DrillUp.g_SMa_mapName_align == "居中" ){ align = "center"; }
	if( DrillUp.g_SMa_mapName_align == "左对齐" ){ align = "left"; }
	temp_sprite.bitmap.drawText( $gameMap.displayName(),0,0, 320, DrillUp.g_SMa_mapName_fontSize + 4, align );
	
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_mapNameSprite = temp_sprite;
}
//==============================
// * 创建 - 累积游戏时长
//==============================
Scene_Menu.prototype.drill_SMa_createPlayTime = function() {
	if( DrillUp.g_SMa_playTime_enable == false ){ return; }
	
	var temp_sprite = new Sprite();
	temp_sprite.x = DrillUp.g_SMa_playTime_x;
	temp_sprite.y = DrillUp.g_SMa_playTime_y;
	temp_sprite.bitmap = new Bitmap(250,32);
	temp_sprite.bitmap.fontSize = DrillUp.g_SMa_playTime_fontSize;
	
	var temp_str = $gameSystem.drill_SMa_getPlaytimeTextByFormat( DrillUp.g_SMa_playTime_format );
	temp_sprite.bitmap.drawText( temp_str,0,0,250,32,"center" );
	//（固定居中，如果可设置对齐方式反而不自然）
	
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_playTimeSprite = temp_sprite;
	this._drill_SMa_playTime = $gameSystem.playtime() % 60;
}
//==============================
// * 创建 - 真实时间
//==============================
Scene_Menu.prototype.drill_SMa_createRealTime = function() {
	if( DrillUp.g_SMa_realTime_enable == false ){ return; }
	
	var temp_sprite = new Sprite();
	temp_sprite.x = DrillUp.g_SMa_realTime_x;
	temp_sprite.y = DrillUp.g_SMa_realTime_y;
	temp_sprite.bitmap = new Bitmap(250,32);
	temp_sprite.bitmap.fontSize = DrillUp.g_SMa_realTime_fontSize;
	
	var temp_str = new Date().drill_SMa_getDateTextByFormat( DrillUp.g_SMa_realTime_format );
	temp_sprite.bitmap.drawText( temp_str,0,0,250,32,"center" );
	
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_realTimeSprite = temp_sprite;
	this._drill_SMa_realTimeString = temp_str;
}
//==============================
// * 创建 - 游戏世界时间
//==============================
Scene_Menu.prototype.drill_SMa_createGameWorldTime = function() {
	if( DrillUp.g_SMa_gameWorldTime_enable == false ){ return; }
	if( Imported.MOG_TimeSystem == false ){ return; }
	
	var temp_sprite = new Sprite();
	temp_sprite.x = DrillUp.g_SMa_gameWorldTime_x;
	temp_sprite.y = DrillUp.g_SMa_gameWorldTime_y;
	temp_sprite.bitmap = new Bitmap(250,32);
	temp_sprite.bitmap.fontSize = DrillUp.g_SMa_gameWorldTime_fontSize;
	
	var temp_str = $gameSystem.drill_SMa_getGameWorldTimeTextByFormat( DrillUp.g_SMa_gameWorldTime_format );
	temp_sprite.bitmap.drawText( temp_str,0,0,250,32,"center" );
	
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_gameWorldTimeSprite = temp_sprite;
}
//==============================
// * 创建 - 金钱参数数字
//==============================
Scene_Menu.prototype.drill_SMa_createGoldNumber = function() {
	if( DrillUp.g_SMa_gold_mode != "参数数字模式" ){ return; }
	
	var temp_sprite = new Drill_COGN_NumberSprite( DrillUp.g_SMa_gold_number );
	this._layer_outer.addChild( temp_sprite );
	this._drill_SMa_goldNumberSprite = temp_sprite;
}
//==============================
// * 创建 - 菜单选项按钮集
//==============================
Scene_Menu.prototype.drill_SMa_createCommandButton = function() {
	if( DrillUp.g_SMa_command_mode != "按钮组模式" ){ return; }
	
	// > 参数监听
	var data_org = DrillUp.g_SMa_command_button;
	if( data_org['debug_search'] == true ){
		alert( "菜单选项按钮集：\n" + JSON.stringify( this._commandWindow._list ));
	}
	
	// > 准备按钮组参数
	var data_style = DrillUp.drill_COSB_getCopyedBtnData( $gameSystem._drill_SMa_commandButton_index );	//深拷贝数据
	var keys = Object.keys(data_org);
	for(var i = 0; i < keys.length; i++){	//（传入值）
		var key = keys[i];
		data_style[key] = data_org[key];
	}
	data_style['x'] = $gameSystem._drill_SMa_commandButton_x;
	data_style['y'] = $gameSystem._drill_SMa_commandButton_y;
	
	// > 建立按钮组层
	var temp_sprite = new Drill_COSB_LayerSprite( data_style, this._commandWindow );
	this._layer_context.addChild( temp_sprite );
	this._drill_SMa_commandButtonSprite = temp_sprite;
}
//==============================
// * 创建 - 角色头像按钮集
//==============================
Scene_Menu.prototype.drill_SMa_createActorAvatarButton = function() {
	
	// > 准备按钮组参数
	var data_org = DrillUp.g_SMa_actorAvatar_button;
	var data_style = DrillUp.drill_COSB_getCopyedBtnData( data_org['style_id']-1 );	//深拷贝数据
	var keys = Object.keys(data_org);
	for(var i = 0; i < keys.length; i++){	//（传入值）
		var key = keys[i];
		data_style[key] = data_org[key];
	}
	
	// > 建立按钮组层
	var temp_sprite = new Drill_COSB_LayerSprite( data_style, this._statusWindow );
	this._layer_context.addChild( temp_sprite );
	this._drill_SMa_actorAvatarButtonSprite = temp_sprite;
}
//==============================
// * 创建 - 角色固定框
//==============================
Scene_Menu.prototype.drill_SMa_createActorBoard = function() {
	var temp_data = DrillUp.g_SMa_actorArrange;
	
	// > 固定框组层级
	var temp_layer = new Sprite();
	temp_layer.x = temp_data['x'];		//固定框组整体位置
	temp_layer.y = temp_data['y'];		//
	this._layer_context.addChild( temp_layer );
	this._drill_SMa_actorLayerSprite = temp_layer;
	
	// > 角色固定框容器
	this._drill_SMa_actorSpriteTank = [];
	this._drill_SMa_actorPositionTank = [];
	var count = temp_data['visible_rowCount'];
	for( var i = 0; i < count; i++ ){
		
		// > 固定框初始化
		var actor = $gameParty.members()[i];
		var temp_sprite = new Drill_SMa_ActorSprite( actor, i );
		temp_sprite['_org_visible'] = true;
		if( temp_data['visible_force'] == false && i >= $gameParty.members().length ){
			temp_sprite['_org_visible'] = false;
		}
		
		// > 固定框排列
		var orgX = 0;
		var orgY = 0;
		if( temp_data['arrange_mode'] == "直线排列" ){
			var xx = temp_data['arrange_spacing'] * i;
			var yy = (i % 2) * temp_data['arrange_wSpacing'];
			var angle = temp_data['arrange_angle'] / 180.0 * Math.PI;
			if( count > 1 && 	//（限宽）
				temp_data['arrange_limitEnable'] == true &&	
				temp_data['arrange_spacing'] * (count - 1) > temp_data['arrange_limitLength'] ){
				xx = temp_data['arrange_limitLength'] / (count - 1) * i;
			}
			orgX = xx * Math.cos(angle) - yy * Math.sin(angle);
			orgY = xx * Math.sin(angle) + yy * Math.cos(angle);
		}
		if( temp_data['arrange_mode'] == "环形排列" ){
			if( Math.abs( temp_data['arrange_angleStart'] - temp_data['arrange_angleEnd'] ) % 360 == 0 ){
				var angle = 360 * i / count + temp_data['arrange_angleStart'];
				angle = angle / 180.0 * Math.PI;
				orgX = temp_data['arrange_radius'] * Math.cos(angle) ;
				orgY = temp_data['arrange_radius'] * Math.sin(angle) ;
			}else{
				var angle = (temp_data['arrange_angleEnd'] - temp_data['arrange_angleStart']) * i / (count-1) + temp_data['arrange_angleStart'];
				angle = angle / 180.0 * Math.PI;
				orgX = temp_data['arrange_radius'] * Math.cos(angle) ;
				orgY = temp_data['arrange_radius'] * Math.sin(angle) ;
			}
		}
		if( temp_data['arrange_mode'] == "矩阵排列" ){
			orgX = Math.floor(i % temp_data['arrange_col']) * temp_data['arrange_width'] ;
			orgY = Math.floor(i / temp_data['arrange_col']) * temp_data['arrange_height'] ;
		}
		if( temp_data['arrange_mode'] == "固定离散排列" ){
			if( temp_data['arrange_squeeze'][i] != undefined ){
				var str = String( temp_data['arrange_squeeze'][i] );
				str = str.replace("(","");
				str = str.replace(")","");
				var str_arr = str.split(/[,，]/);
				orgX = Number( str_arr[0] );
				orgY = Number( str_arr[1] );
			}
		}
		temp_sprite['_org_x'] = orgX;	//（建立固定框后，赋值初始位置）
		temp_sprite['_org_y'] = orgY;
		temp_sprite.x = orgX;
		temp_sprite.y = orgY;
		
		// > 按钮添加
		temp_layer.addChild( temp_sprite );
		this._drill_SMa_actorSpriteTank[i] = temp_sprite;
		var pos = { "x" : orgX, "y" : orgY };
		this._drill_SMa_actorPositionTank.push( pos );
		
		
		// > 移动动画参数 转 两点式弹道
		var data = {};
		data['movementMode'] = "两点式";
		data['movementTime'] = temp_data['board_slideAnim']['slideTime'];
		data['movementDelay']= temp_data['board_slideAnim']['slideDelay'] + i * temp_data['board_slideAnim']['slideOrderlyDelay'];		//间隔+依次间隔
		data['twoPointType'] = temp_data['board_slideAnim']['slideMoveType'];
		if( temp_data['board_slideAnim']['slidePosType'] == "各固定框的相对坐标" ){
			data['twoPointDifferenceX'] = temp_data['board_slideAnim']['slideX'];
			data['twoPointDifferenceY'] = temp_data['board_slideAnim']['slideY'];
		}else{
			data['twoPointDifferenceX'] = temp_data['board_slideAnim']['slideAbsoluteX'] - temp_sprite.x;
			data['twoPointDifferenceY'] = temp_data['board_slideAnim']['slideAbsoluteY'] - temp_sprite.y;
		}
		
		// > 弹道初始化
		$gameTemp.drill_COBa_setBallisticsMove( data );												//初始化
		$gameTemp.drill_COBa_preBallisticsMove( temp_sprite, i , temp_sprite.x, temp_sprite.y );	//推演赋值
		temp_sprite._drill_foldTime = 0;		//播放帧时间置零
		
	}
}

//=============================================================================
// ** 帧刷新
//=============================================================================
//==============================
// * 帧刷新 - 原装窗口控制
//==============================
Scene_Menu.prototype.drill_SMa_updateOrgWindow = function() {
	// > 菜单选项窗口
	if( DrillUp.g_SMa_command_mode == "按钮组模式" ){
		this._commandWindow.y = Graphics.boxHeight * 2;
	}
	if( DrillUp.g_SMa_command_mode == "窗口模式" ){
		this._commandWindow.drill_COWA_CPD_update();
	}
	// > 金钱窗口
	if( DrillUp.g_SMa_gold_mode == "参数数字模式" ){
		this._goldWindow.y = Graphics.boxHeight * 2;
	}
	if( DrillUp.g_SMa_gold_mode == "窗口模式" ){
		this._goldWindow.drill_COWA_CPD_update();
	}
	// > 角色控制窗口（直接屏蔽）
	this._statusWindow.y = Graphics.boxHeight * 2;
}
//==============================
// * 帧刷新 - 游戏时长
//==============================
Scene_Menu.prototype.drill_SMa_updatePlayTime = function() {
	if( DrillUp.g_SMa_playTime_enable == false ){ return; }
	
	var time = $gameSystem.playtime() % 60;
	if( this._drill_SMa_playTime == time ){ return; }
	this._drill_SMa_playTime = time;
	
	var temp_str = $gameSystem.drill_SMa_getPlaytimeTextByFormat( DrillUp.g_SMa_playTime_format );
	this._drill_SMa_playTimeSprite.bitmap.clear();
	this._drill_SMa_playTimeSprite.bitmap.drawText( temp_str,0,0,250,32,"center" );
}
//==============================
// * 帧刷新 - 真实时间
//==============================
Scene_Menu.prototype.drill_SMa_updateRealTime = function() {
	if( DrillUp.g_SMa_realTime_enable == false ){ return; }
	
	var temp_str = new Date().drill_SMa_getDateTextByFormat( DrillUp.g_SMa_realTime_format );
	if( this._drill_SMa_realTimeString == temp_str ){ return; }
	this._drill_SMa_realTimeString = temp_str;
	
	this._drill_SMa_realTimeSprite.bitmap.clear();
	this._drill_SMa_realTimeSprite.bitmap.drawText( temp_str,0,0,250,32,"center" );
}
//==============================
// * 帧刷新 - 金钱参数数字
//==============================
Scene_Menu.prototype.drill_SMa_updateGoldNumber = function() {
	if( DrillUp.g_SMa_gold_mode != "参数数字模式" ){ return; }
	
	this._drill_SMa_goldNumberSprite.drill_COGN_reflashValue( $gameParty.gold() );
}
//==============================
// * 帧刷新 - 菜单选项按钮集
//==============================
Scene_Menu.prototype.drill_SMa_updateCommandButton = function() {
	if( DrillUp.g_SMa_command_mode != "按钮组模式" ){ return; }
	
	// （暂无操作）（按钮组核心已经全部包揽）
}
//==============================
// * 帧刷新 - 角色头像按钮集
//==============================
Scene_Menu.prototype.drill_SMa_updateActorAvatarButton = function() {
	
	// （暂无操作）（按钮组核心已经全部包揽）
}



//=============================================================================
// ** 原装窗口
//=============================================================================
//==============================
// * 原装状态窗口 - 流程-只一个角色时跳过选头像
//==============================
var _drill_SMa_commandPersonal = Scene_Menu.prototype.commandPersonal;
Scene_Menu.prototype.commandPersonal = function() {
	if( DrillUp.g_SMa_actorAvatar_skip == true &&
		$gameParty.members().length == 1 ){			
		this._statusWindow.setFormationMode(false);
		this._statusWindow.selectLast();
		this.onPersonalOk();		//（直接Ok进入）
	}else{
		_drill_SMa_commandPersonal.call(this);
	}
};
//==============================
// * 原装状态窗口 - 刷新
//==============================
var _drill_SMa_statusWindowRefresh = Window_MenuStatus.prototype.refresh;
Window_MenuStatus.prototype.refresh = function() {

	// > 列表刷新
	this._list = [];						//名称列表（VisibleRows并不影响list数量）
	this._drill_COSB_indexList = [];		//交叉列表
	var actors = $gameParty.members();
	for( var i=0; i < actors.length; i++ ){
		var actor = actors[i];
		this._list.push( actor.name() );
		this._drill_COSB_indexList.push( actor.actorId() -1 );
	}
	
	// > 默认刷新
	_drill_SMa_statusWindowRefresh.call(this);
};
//==============================
// * 原装状态窗口 - 状态窗口显示按钮数量
//==============================
Window_MenuStatus.prototype.numVisibleRows = function() {
    return DrillUp.g_SMa_actorAvatar_visibleNum;
};


//=============================================================================
// ** 角色固定框
//=============================================================================
//==============================
// * 角色固定框 - 定义
//==============================
function Drill_SMa_ActorSprite() {
    this.initialize.apply(this, arguments);
}
Drill_SMa_ActorSprite.prototype = Object.create(Sprite_Base.prototype);
Drill_SMa_ActorSprite.prototype.constructor = Drill_SMa_ActorSprite;
//==============================
// * 角色固定框 - 初始化
//==============================
Drill_SMa_ActorSprite.prototype.initialize = function( actor, memberIndex ) {
    Sprite_Base.prototype.initialize.call(this);
	this._drill_actor = actor;		//角色可能为空
	this._drill_memberIndex = memberIndex;
	if( this._drill_actor ){
		this._drill_data_bind = JSON.parse(JSON.stringify( $gameSystem._drill_SMa_actorBindTank[ this._drill_actor.actorId()-1 ] ));	//深拷贝数据
		this._drill_data_style = JSON.parse(JSON.stringify( DrillUp.g_SMa_styleList[ this._drill_data_bind['style_id']-1 ] ));	//深拷贝数据
	}else{
		this._drill_data_bind = DrillUp.g_SMa_actorArrange['visible_emptyActor'];
		this._drill_data_style = JSON.parse(JSON.stringify( DrillUp.g_SMa_styleList[ this._drill_data_bind['style_id']-1 ] ));
	}
	
	this.drill_initData();				//初始化数据
	this.drill_initSprite();			//初始化对象
};
//==============================
// * 角色固定框 - 帧刷新
//==============================
Drill_SMa_ActorSprite.prototype.update = function() {
	Sprite_Base.prototype.update.call(this);
	
	this.drill_updateSprite();			//帧刷新对象
};
//==============================
// * 初始化 - 数据
//==============================
Drill_SMa_ActorSprite.prototype.drill_initData = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 私有对象初始化
	this._drill_time = 0;						//时间
	this._drill_foldTime = 0;					//消失/显现时间
	this._drill_forceDestroy = false;			//强制销毁
	this._drill_background_sprite = null;		//背景贴图
	this._drill_foreground_sprite = null;		//前景贴图
	
	this._drill_hp_meterSprite = null;			//生命参数条
	this._drill_mp_meterSprite = null;			//魔法参数条
	this._drill_tp_meterSprite = null;			//怒气参数条
	this._drill_exp_meterSprite = null;			//经验参数条
	
	this._drill_hp_numberSprite = null;			//生命参数数字
	this._drill_mp_numberSprite = null;			//魔法参数数字
	this._drill_tp_numberSprite = null;			//怒气参数数字
	this._drill_exp_numberSprite = null;		//经验参数数字
	this._drill_lv_numberSprite = null;			//等级参数数字
	
	this._drill_picture_sprite = null;										//头像贴图
	this._drill_name_sprite = null;											//姓名贴图
	this._drill_career_sprite = null;										//职业贴图
	this._drill_nickname_sprite = null;										//昵称贴图
	this._drill_states_systemIcon = ImageManager.loadSystem("IconSet");		//状态贴图
	
	this._drill_shake_cur_life = 0;				//震动效果 - 持续时间
	this._drill_shake_trigger = 0;				//震动效果 - 触发
	this._drill_shake_dir = 1;					//震动效果 - 方向
	this._drill_shake_diff = 0;					//震动效果 - 实际偏移
	
	// > 样式参数 转移到 实例参数
	if( data_b['hp_symbol_visible'] == undefined ){ data_b['hp_symbol_visible'] = data_s['hp_symbol_visible']; }	
	if( data_b['mp_symbol_visible'] == undefined ){ data_b['mp_symbol_visible'] = data_s['mp_symbol_visible']; }	
	if( data_b['tp_symbol_visible'] == undefined ){ data_b['tp_symbol_visible'] = data_s['tp_symbol_visible']; }		
	if( data_b['exp_symbol_visible'] == undefined ){ data_b['exp_symbol_visible'] = data_s['exp_symbol_visible']; }	
	if( data_b['lv_symbol_visible'] == undefined ){ data_b['lv_symbol_visible'] = data_s['lv_symbol_visible']; }
	
	//data_b['visible'] = true;
	//data_b['frame_x'] = 100 + 100*this._drill_memberIndex;
	//data_b['frame_y'] = 200;
	
	// > 主体属性
	this.opacity = 255;
	this.visible = true;		//创建了，就一定显示（ data_b['visible']控制的是出现/消失过程 ）
	//this.width = Graphics.boxWidth;
	//this.height = Graphics.boxHeight;
	
};
//==============================
// * 初始化 - 对象
//==============================
Drill_SMa_ActorSprite.prototype.drill_initSprite = function() {
	
	this.drill_createBackground();			//创建背景
	this.drill_createPictureImage();		//创建角色前视图
	this.drill_createHPMeter();				//创建生命参数条
	this.drill_createMPMeter();				//创建魔法参数条
	this.drill_createTPMeter();				//创建怒气参数条
	this.drill_createEXPMeter();			//创建经验参数条
	this.drill_createForeground();			//创建前景
	
	this.drill_createState();				//创建状态
	this.drill_createName();				//创建姓名
	this.drill_createCareer();				//创建职业
	this.drill_createNickname();			//创建昵称
	this.drill_createHPNumber();			//创建生命参数数字
	this.drill_createMPNumber();			//创建魔法参数数字
	this.drill_createTPNumber();			//创建怒气参数数字
	this.drill_createEXPNumber();			//创建经验参数数字
	this.drill_createLVNumber();			//创建等级参数数字
};
//==============================
// * 创建 - 背景
//==============================
Drill_SMa_ActorSprite.prototype.drill_createBackground = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	var temp_sprite = new Sprite();
	temp_sprite.bitmap = ImageManager.load_MenuMain( data_s['background_src'] );
	temp_sprite.x = data_s['background_x'];
	temp_sprite.y = data_s['background_y'];
	this.addChild(temp_sprite);
	this._drill_background_sprite = temp_sprite;
}
//==============================
// * 创建 - 前景
//==============================
Drill_SMa_ActorSprite.prototype.drill_createForeground = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	var temp_sprite = new Sprite();
	temp_sprite.bitmap = ImageManager.load_MenuMain( data_s['foreground_src']  );
	temp_sprite.x = data_s['foreground_x'];
	temp_sprite.y = data_s['foreground_y'];
	this.addChild(temp_sprite);
	this._drill_foreground_sprite = temp_sprite;
}
//==============================
// * 创建 - 生命条
//==============================
Drill_SMa_ActorSprite.prototype.drill_createHPMeter = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['hp_meter_enable'] != true ){ return }	//（不显示，则不创建）
	if( data_s['hp_meter_param'] == undefined ){ return }
	
	// > 生命条 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['hp_meter_param'] ));	//深拷贝数据
	if( this._drill_actor ){
		temp_data['level_max'] = this._drill_actor.param(0);	//生命上限
	}else{
		temp_data['level_max'] = 100;
	}
	
	// > 生命条 贴图初始化
	var temp_sprite = new Drill_COGM_MeterSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_hp_meterSprite = temp_sprite;
}
//==============================
// * 创建 - 魔法条
//==============================
Drill_SMa_ActorSprite.prototype.drill_createMPMeter = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['mp_meter_enable'] != true ){ return }	//（不显示，则不创建）
	if( data_s['mp_meter_param'] == undefined ){ return }
	
	// > 魔法条 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['mp_meter_param'] ));	//深拷贝数据
	if( this._drill_actor ){
		temp_data['level_max'] = this._drill_actor.param(1);	//魔法上限
	}else{
		temp_data['level_max'] = 100;
	}
	
	// > 魔法条 贴图初始化
	var temp_sprite = new Drill_COGM_MeterSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_mp_meterSprite = temp_sprite;
}
//==============================
// * 创建 - 怒气条
//==============================
Drill_SMa_ActorSprite.prototype.drill_createTPMeter = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['tp_meter_enable'] != true ){ return }	//（不显示，则不创建）
	if( data_s['tp_meter_param'] == undefined ){ return }
	
	// > 怒气条 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['tp_meter_param'] ));	//深拷贝数据
	if( this._drill_actor ){
		temp_data['level_max'] = this._drill_actor.maxTp();	//怒气上限
	}else{
		temp_data['level_max'] = 100;
	}
	
	// > 怒气条 贴图初始化
	var temp_sprite = new Drill_COGM_MeterSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_tp_meterSprite = temp_sprite;
}
//==============================
// * 创建 - 经验条
//==============================
Drill_SMa_ActorSprite.prototype.drill_createEXPMeter = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['exp_meter_enable'] != true ){ return }	//（不显示，则不创建）
	if( data_s['exp_meter_param'] == undefined ){ return }
	
	// > 经验条 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['exp_meter_param'] ));	//深拷贝数据
	if( this._drill_actor ){
		temp_data['level_max'] = this._drill_actor.nextLevelExp() - this._drill_actor.currentLevelExp();	//下一级经验
	}else{
		temp_data['level_max'] = 100;
	}
	
	// > 经验条 贴图初始化
	var temp_sprite = new Drill_COGM_MeterSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_exp_meterSprite = temp_sprite;
}
//==============================
// * 创建 - 角色前视图
//==============================
Drill_SMa_ActorSprite.prototype.drill_createPictureImage = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > gif贴图
	this._drill_picture_spriteTank = [];
	if( data_b['pic_src_commandSet'] != undefined && 
		data_b['pic_src_commandSet'].length > 0 ){
		for(var j = 0; j < data_b['pic_src_commandSet'].length ; j++){	//（插件指令设置）
			this._drill_picture_spriteTank.push(ImageManager.load_MenuActorFace( data_b['pic_src_commandSet'][j] ));
		}
	}else{
		for(var j = 0; j < data_b['pic_src'].length ; j++){	//（默认设置）
			this._drill_picture_spriteTank.push(ImageManager.load_MenuActorFace( data_b['pic_src'][j] ));
		}
	}
	
	// > 前视图
	var temp_sprite = new Sprite();
	temp_sprite.bitmap = this._drill_picture_spriteTank[0];
	temp_sprite.x = data_b['pic_x'];
	temp_sprite.y = data_b['pic_y'];
	temp_sprite.visible = data_b['pic_visible'];		//（不显示，也要创建）
	this.addChild(temp_sprite);
	this._drill_picture_sprite = temp_sprite;
}
//==============================
// * 创建 - 姓名
//==============================
Drill_SMa_ActorSprite.prototype.drill_createName = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 姓名初始化
	var temp_sprite = new Sprite();
	temp_sprite.x = data_s['name_x'];
	temp_sprite.y = data_s['name_y'];
	temp_sprite.visible = data_s['name_visible'];		//（不显示，也要创建）
	
	// > 绘制字符
	temp_sprite.bitmap = new Bitmap(320, data_s['name_fontsize'] + 4 );
	temp_sprite.bitmap.fontSize = data_s['name_fontsize'];
	temp_sprite.bitmap._align = "center";
	if( data_s['name_align'] == "右对齐" ){ temp_sprite.bitmap._align = "right"; }
	if( data_s['name_align'] == "居中" ){ temp_sprite.bitmap._align = "center"; }
	if( data_s['name_align'] == "左对齐" ){ temp_sprite.bitmap._align = "left"; }
	this.addChild(temp_sprite);
	this._drill_name_sprite = temp_sprite;
	this.drill_drawName();
}
//==============================
// * 姓名 - 绘制（继承接口）
//==============================
Drill_SMa_ActorSprite.prototype.drill_drawName = function() {
	if(!this._drill_actor ){ return; } 
	var text = this._drill_actor.name();
	var width = this._drill_name_sprite.bitmap.width;
	var height = this._drill_name_sprite.bitmap.height;
	var align = this._drill_name_sprite.bitmap._align;
	this._drill_name_sprite.bitmap.drawText( text, 0, 0, width, height, align );	
}
//==============================
// * 创建 - 职业
//==============================
Drill_SMa_ActorSprite.prototype.drill_createCareer = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 姓名初始化
	var temp_sprite = new Sprite();
	temp_sprite.x = data_s['career_x'];
	temp_sprite.y = data_s['career_y'];
	temp_sprite.visible = data_s['career_visible'];		//（不显示，也要创建）
	
	// > 绘制字符
	temp_sprite.bitmap = new Bitmap(320, data_s['career_fontsize'] + 4 );
	temp_sprite.bitmap.fontSize = data_s['career_fontsize'];
	temp_sprite.bitmap._align = "center";
	if( data_s['career_align'] == "右对齐" ){ temp_sprite.bitmap._align = "right"; }
	if( data_s['career_align'] == "居中" ){ temp_sprite.bitmap._align = "center"; }
	if( data_s['career_align'] == "左对齐" ){ temp_sprite.bitmap._align = "left"; }
	this.addChild(temp_sprite);
	this._drill_career_sprite = temp_sprite;
	this.drill_drawCareer();
}
//==============================
// * 职业 - 绘制（继承接口）
//==============================
Drill_SMa_ActorSprite.prototype.drill_drawCareer = function() {
	if(!this._drill_actor ){ return; } 
	var text = this._drill_actor.currentClass().name;
	var width = this._drill_career_sprite.bitmap.width;
	var height = this._drill_career_sprite.bitmap.height;
	var align = this._drill_career_sprite.bitmap._align;
	this._drill_career_sprite.bitmap.drawText( text, 0, 0, width, height, align );	
}
//==============================
// * 创建 - 昵称
//==============================
Drill_SMa_ActorSprite.prototype.drill_createNickname = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 昵称初始化
	var temp_sprite = new Sprite();
	temp_sprite.x = data_s['nickname_x'];
	temp_sprite.y = data_s['nickname_y'];
	temp_sprite.visible = data_s['nickname_visible'];		//（不显示，也要创建）
	
	// > 绘制字符
	temp_sprite.bitmap = new Bitmap(320, data_s['nickname_fontsize'] + 4 );
	temp_sprite.bitmap.fontSize = data_s['nickname_fontsize'];
	temp_sprite.bitmap._align = "center";
	if( data_s['nickname_align'] == "右对齐" ){ temp_sprite.bitmap._align = "right"; }
	if( data_s['nickname_align'] == "居中" ){ temp_sprite.bitmap._align = "center"; }
	if( data_s['nickname_align'] == "左对齐" ){ temp_sprite.bitmap._align = "left"; }
	this.addChild(temp_sprite);
	this._drill_nickname_sprite = temp_sprite;
	this.drill_drawNickname();
}
//==============================
// * 昵称 - 绘制（继承接口）
//==============================
Drill_SMa_ActorSprite.prototype.drill_drawNickname = function() {
	if(!this._drill_actor ){ return; } 
	var text = this._drill_actor.nickname();
	var width = this._drill_nickname_sprite.bitmap.width;
	var height = this._drill_nickname_sprite.bitmap.height;
	var align = this._drill_nickname_sprite.bitmap._align;
	this._drill_nickname_sprite.bitmap.drawText( text, 0, 0, width, height, align );	
}
//==============================
// * 创建 - 状态
//==============================
Drill_SMa_ActorSprite.prototype.drill_createState = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['state_enable'] != true ){ return }		//（不显示，则不创建）
	
	if( data_s['state_mode'] == "直线并排" ){
		
		// > 并排的状态贴图
		this._drill_state_sprite = new Sprite();
		this._drill_state_sprite_tank = [];
		this._drill_state_sprite.anchor.x = 0.5;
		this._drill_state_sprite.anchor.y = 0.5;
		this._drill_state_sprite.x = data_s['state_x'];
		this._drill_state_sprite.y = data_s['state_y'];
		
		// > 状态图标集
		for(var i=0; i < data_s['state_max']; i++){	
			var temp_sprite = new Sprite();
			temp_sprite.bitmap = this._drill_states_systemIcon;
			temp_sprite.anchor.x = 0.5;
			temp_sprite.anchor.y = 0.5;
			temp_sprite.setFrame(0,0,0,0);
			
			var iw = Window_Base._iconWidth;
			var ih = Window_Base._iconHeight;
			var space = data_s['state_spacing'];
			var align = data_s['state_align'];
			if( align == "右对齐" ){
				temp_sprite.x = -1 * i * (iw + space) ;
			}else if( align == "上对齐" ){
				temp_sprite.y = -1 * i * (ih + space) ;
			}else if( align == "下对齐" ){
				temp_sprite.y = 1 * i * (ih + space) ;
			}else{
				temp_sprite.x = 1 * i * (iw + space) ;
			}
			this._drill_state_sprite_tank.push(temp_sprite);
			this._drill_state_sprite.addChild(temp_sprite);
		}
		
	}else{
		// > 闪烁的状态贴图（直接用rmmv默认）
		this._drill_state_sprite = new Sprite_StateIcon();	
		this._drill_state_sprite.anchor.x = 0.5;
		this._drill_state_sprite.anchor.y = 0.5;
		this._drill_state_sprite.x = this._drill_data_style['state_x'];
		this._drill_state_sprite.y = this._drill_data_style['state_y'];
		if( this._drill_actor ){
			this._drill_state_sprite.setup(this._drill_actor);
		}
	}
	
	this.addChild(this._drill_state_sprite);
}

//==============================
// * 创建 - 生命参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_createHPNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['hp_symbol_param'] == undefined ){ return }
	
	// > 生命数字 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['hp_symbol_param'] ));	//深拷贝数据
	temp_data['visible'] = data_b['hp_symbol_visible'];							//（不显示，也要创建）
	if( this._drill_actor ){
		temp_data['specified_conditionNum'] = this._drill_actor.param(0);			//强制赋值额定数值
	}else{
		temp_data['specified_conditionNum'] = 100;
	}
	
	// > 生命数字 贴图初始化
	var temp_sprite = new Drill_COGN_NumberSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_hp_numberSprite = temp_sprite;
}
//==============================
// * 创建 - 魔法参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_createMPNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['mp_symbol_param'] == undefined ){ return }
	
	// > 魔法数字 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['mp_symbol_param'] ));	//深拷贝数据
	temp_data['visible'] = data_b['mp_symbol_visible'];							//（不显示，也要创建）
	if( this._drill_actor ){
		temp_data['specified_conditionNum'] = this._drill_actor.param(1);
	}else{
		temp_data['specified_conditionNum'] = 100;
	}

	// > 魔法数字 贴图初始化
	var temp_sprite = new Drill_COGN_NumberSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_mp_numberSprite = temp_sprite;
}
//==============================
// * 创建 - 怒气参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_createTPNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['tp_symbol_param'] == undefined ){ return }
	
	// > 怒气数字 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['tp_symbol_param'] ));	//深拷贝数据
	temp_data['visible'] = data_b['tp_symbol_visible'];							//（不显示，也要创建）
	if( this._drill_actor ){
		temp_data['specified_conditionNum'] = this._drill_actor.maxTp();
	}else{
		temp_data['specified_conditionNum'] = 100;
	}
	
	// > 怒气数字 贴图初始化
	var temp_sprite = new Drill_COGN_NumberSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_tp_numberSprite = temp_sprite;
}
//==============================
// * 创建 - 经验参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_createEXPNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['exp_symbol_param'] == undefined ){ return }
	
	// > 经验数字 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['exp_symbol_param'] ));	//深拷贝数据
	temp_data['visible'] = data_b['exp_symbol_visible'];						//（不显示，也要创建）
	if( this._drill_actor ){
		temp_data['specified_conditionNum'] = this._drill_actor.nextLevelExp() - this._drill_actor.currentLevelExp();
	}else{
		temp_data['specified_conditionNum'] = 100;
	}
	
	// > 经验数字 贴图初始化
	var temp_sprite = new Drill_COGN_NumberSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_exp_numberSprite = temp_sprite;
}
//==============================
// * 创建 - 等级参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_createLVNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['lv_symbol_param'] == undefined ){ return }
	
	// > 等级数字 数据初始化
	var temp_data = JSON.parse(JSON.stringify( data_s['lv_symbol_param'] ));	//深拷贝数据
	temp_data['visible'] = data_b['lv_symbol_visible'];							//（不显示，也要创建）
	if( this._drill_actor ){
		temp_data['specified_conditionNum'] = this._drill_actor.maxLevel();
	}else{
		temp_data['specified_conditionNum'] = 100;
	}
	
	// > 等级数字 贴图初始化
	var temp_sprite = new Drill_COGN_NumberSprite( temp_data );
	this.addChild( temp_sprite );
	this._drill_lv_numberSprite = temp_sprite;
}

//==============================
// * 帧刷新对象
//==============================
Drill_SMa_ActorSprite.prototype.drill_updateSprite = function() {
	this._drill_time += 1;
	
	this.drill_updateMeter();				//参数条
	this.drill_updateNumber();				//参数数字
	this.drill_updatePosition();			//位移+透明度
	this.drill_updateStates();				//状态绘制
	this.drill_updatePictureImage();		//角色前视图gif播放
}
//==============================
// * 帧刷新 - 参数条
//==============================
Drill_SMa_ActorSprite.prototype.drill_updateMeter = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// >参数条 - 值刷新
	if(!this._drill_actor){ return; }
	if(this._drill_hp_meterSprite){ this._drill_hp_meterSprite.drill_COGM_reflashValue(this._drill_actor._hp); }
	if(this._drill_mp_meterSprite){ this._drill_mp_meterSprite.drill_COGM_reflashValue(this._drill_actor._mp); }
	if(this._drill_tp_meterSprite){ this._drill_tp_meterSprite.drill_COGM_reflashValue(this._drill_actor._tp); }
	if(this._drill_exp_meterSprite){ this._drill_exp_meterSprite.drill_COGM_reflashValue(this._drill_actor.currentExp() - this._drill_actor.currentLevelExp()); }
}
//==============================
// * 帧刷新 - 参数数字
//==============================
Drill_SMa_ActorSprite.prototype.drill_updateNumber = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// >参数数字 - 值刷新
	if(!this._drill_actor){ return; }
	if(this._drill_hp_numberSprite){ this._drill_hp_numberSprite.drill_COGN_reflashValue(this._drill_actor._hp); }
	if(this._drill_mp_numberSprite){ this._drill_mp_numberSprite.drill_COGN_reflashValue(this._drill_actor._mp); }
	if(this._drill_tp_numberSprite){ this._drill_tp_numberSprite.drill_COGN_reflashValue(this._drill_actor._tp); }
	if(this._drill_exp_numberSprite){ this._drill_exp_numberSprite.drill_COGN_reflashValue(this._drill_actor.currentExp() - this._drill_actor.currentLevelExp()); }
	if(this._drill_lv_numberSprite){ this._drill_lv_numberSprite.drill_COGN_reflashValue(this._drill_actor._level); }
}
//==============================
// * 帧刷新 - 位移+透明度
//==============================
Drill_SMa_ActorSprite.prototype.drill_updatePosition = function() {
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 出现/消失控制
	var end_index = this['_drill_COBa_x'].length - 1;
	
	if( this['_org_visible'] == false ){				//隐藏 消失
		this._drill_foldTime -= 1;
	}else if( this._drill_forceDestroy == true ){	//销毁 消失
		this._drill_foldTime -= 1;
	}else{
		this._drill_foldTime += 1;
	}
	if( this._drill_foldTime > end_index ){ this._drill_foldTime = end_index; }
	if( this._drill_foldTime < 0 ){ this._drill_foldTime = 0; }
	
	// > 出现/消失控制
	var time = this._drill_foldTime;
	var xx = this['_org_x'] + this['_drill_COBa_x'][ end_index ] - this['_drill_COBa_x'][ time ];
	var yy = this['_org_y'] + this['_drill_COBa_y'][ end_index ] - this['_drill_COBa_y'][ time ];
	
	if( end_index <= 0 ){	//（移动时长为1时，直接显示透明度）
		this.opacity = 255;
	}else{
		this.opacity = 255 * time / end_index;
	}
	this.x = Math.floor(xx);
	this.y = Math.floor(yy);
}
//==============================
// * 帧刷新 - 状态绘制
//==============================
Drill_SMa_ActorSprite.prototype.drill_updateStates = function(){
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	if( data_s['state_enable'] != true ){ return }
	if( !this._drill_states_systemIcon.isReady() ){ return }
	
	// > 直线并排
	if( data_s['state_mode'] == "直线并排" && this._drill_actor ){
		var icons = this._drill_actor.allIcons();
		for(var i=0; i<this._drill_state_sprite_tank.length; i++){	
			var temp_sprite = this._drill_state_sprite_tank[i];
			var id = Number(icons[i]);
			if( id ){
				var iw = Window_Base._iconWidth;
				var ih = Window_Base._iconHeight;
				var ix = id % 16 * iw;
				var iy = Math.floor( id / 16) * ih;
				temp_sprite.setFrame(ix, iy, iw, ih);
			}else{
				temp_sprite.setFrame(0,0,0,0) ;
			}
		}
	}
	// > 单一闪烁
	//	（不需要帧刷新，对象自己会变）
}
//==============================
// * 帧刷新 - 角色前视图gif播放
//==============================
Drill_SMa_ActorSprite.prototype.drill_updatePictureImage = function(){
	var data_b = this._drill_data_bind;
	var data_s = this._drill_data_style;
	
	// > 播放gif
	var src_tank = this._drill_picture_spriteTank;
	var inter = this._drill_time ;
	inter = inter / data_b['pic_interval'];
	inter = inter % src_tank.length;
	if( data_b['pic_back_run'] ){
		inter = src_tank.length - 1 - inter;
	}
	inter = Math.floor(inter);
	this._drill_picture_sprite.bitmap = src_tank[ inter ];
	
}





//=============================================================================
// ** 队形界面
//=============================================================================
//==============================
// * 队形界面 - 定义
//==============================
function Scene_Drill_SMa_Formation() {
    this.initialize.apply(this, arguments);
}
Scene_Drill_SMa_Formation.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Drill_SMa_Formation.prototype.constructor = Scene_Drill_SMa_Formation;
//==============================
// * 队形界面 - 初始化
//==============================
Scene_Drill_SMa_Formation.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
};
//==============================
// * 队形界面 - 创建
//==============================
Scene_Drill_SMa_Formation.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
	this.drill_createStatusWindow();	//状态窗口
};
//==============================
// * 队形界面 - 帧刷新
//==============================
Scene_Drill_SMa_Formation.prototype.update = function() {
	Scene_MenuBase.prototype.update.call(this);
};
//==============================
// * 队形界面 - 覆写主菜单指令
//==============================
Scene_Menu.prototype.commandFormation = function() {
	SceneManager.push(Scene_Drill_SMa_Formation);
};

//==============================
// * 创建 - 状态窗口
//==============================
Scene_Drill_SMa_Formation.prototype.drill_createStatusWindow = function() {
	this._drill_statusWindow = new Window_Drill_SMa_Formation(0, 0);
	this._drill_statusWindow.selectLast();
	this._drill_statusWindow.activate();
	this._drill_statusWindow.setHandler('ok',     this.drill_formationOk.bind(this));
	this._drill_statusWindow.setHandler('cancel', this.drill_formationCancel.bind(this));
	this.addWindow(this._drill_statusWindow);
};
//==============================
// * 窗口 - 事件确认
//==============================
Scene_Drill_SMa_Formation.prototype.drill_formationOk = function() {
	var index = this._drill_statusWindow.index();
	var actor = $gameParty.members()[index];
	var pendingIndex = this._drill_statusWindow.pendingIndex();
	if( pendingIndex >= 0 ){
		// > 待选索引 选中了角色时
		$gameParty.swapOrder(index, pendingIndex);
		this._drill_statusWindow.setPendingIndex(-1);
		this._drill_statusWindow.redrawItem(index);
	}else{
		// > 待选索引为空时
		this._drill_statusWindow.setPendingIndex(index);
	}
	this._drill_statusWindow.activate();
};
//==============================
// * 窗口 - 事件取消
//==============================
Scene_Drill_SMa_Formation.prototype.drill_formationCancel = function() {
    if( this._drill_statusWindow.pendingIndex() >= 0 ){
		this._drill_statusWindow.setPendingIndex(-1);
		this._drill_statusWindow.activate();
    }else{
		SceneManager.pop()
    }
};
//=============================================================================
// ** 队形窗口
//=============================================================================
//==============================
// * 队形窗口 - 定义
//==============================
function Window_Drill_SMa_Formation() {
	this.initialize.apply(this, arguments);
}
Window_Drill_SMa_Formation.prototype = Object.create(Window_Selectable.prototype);
Window_Drill_SMa_Formation.prototype.constructor = Window_Drill_SMa_Formation;
//==============================
// * 队形窗口 - 初始化
//==============================
Window_Drill_SMa_Formation.prototype.initialize = function(x, y) {
	var width = this.windowWidth();
	var height = this.windowHeight();
	Window_Selectable.prototype.initialize.call(this, x, y, width, height);
	
	// > 私有变量初始化
	this._drill_pendingIndex = -1;		//待选索引
	
	// > 初始化操作
	this.drill_loadImages();
	this.refresh();
	this.select(0);
};
//==============================
// * 队形窗口 - 基本属性
//==============================
Window_Drill_SMa_Formation.prototype.windowWidth = function() {
    return Graphics.boxWidth;
};
Window_Drill_SMa_Formation.prototype.windowHeight = function() {
    return Graphics.boxHeight;
};
Window_Drill_SMa_Formation.prototype.maxItems = function() {
    return $gameParty.size();
};
Window_Drill_SMa_Formation.prototype.numVisibleRows = function() {
    return 4;
};
//==============================
// * 队形窗口 - 选项高度
//==============================
Window_Drill_SMa_Formation.prototype.itemHeight = function() {
    var clientHeight = this.height - this.padding * 2;
    return Math.floor(clientHeight / this.numVisibleRows());
};
//==============================
// * 队形窗口 - 读取头像
//==============================
Window_Drill_SMa_Formation.prototype.drill_loadImages = function() {
    $gameParty.members().forEach(function(actor) {
        ImageManager.loadFace(actor.faceName());
    }, this);
};
//==============================
// * 队形窗口 - 选项绘制
//==============================
Window_Drill_SMa_Formation.prototype.drawItem = function( index ){
    this.contents.fontSize = 20;
	this.drill_drawItemBackground(index);
    this.drill_drawItemImage(index);
    this.drill_drawItemStatus(index);
};
//==============================
// * 选项绘制 - 绘制背景
//==============================
Window_Drill_SMa_Formation.prototype.drill_drawItemBackground = function( index ){
    if (index === this._drill_pendingIndex) {
        var rect = this.itemRect(index);
        var color = this.pendingColor();
        this.changePaintOpacity(false);
        this.contents.fillRect(rect.x, rect.y, rect.width, rect.height, color);
        this.changePaintOpacity(true);
    };
};
//==============================
// * 选项绘制 - 绘制头像
//==============================
Window_Drill_SMa_Formation.prototype.drill_drawItemImage = function( index ){
    var actor = $gameParty.members()[index];
    var rect = this.itemRect(index);
    this.changePaintOpacity(actor.isBattleMember());
    this.drawActorFace(actor, rect.x + 1, rect.y + 1, 144, rect.height - 2);
    this.changePaintOpacity(true);
};
//==============================
// * 选项绘制 - 绘制属性文本
//==============================
Window_Drill_SMa_Formation.prototype.drill_drawItemStatus = function( index ){
    var actor = $gameParty.members()[index];
    var rect = this.itemRect(index);
    var x = rect.x + 162;
    var y = rect.y + rect.height / 2 - this.lineHeight() * 1.5;
    var width = rect.width - x - this.textPadding();
	
	// > 属性名
	this.changeTextColor(this.systemColor());
	this.drawText( "LV",  x,       y + 28 * 1, 64 ,"left");
	this.drawText( "HP",  x,       y + 28 * 2, 64 ,"left");
	this.drawText( "MP",  x,       y + 28 * 3, 80 ,"left");
	this.drawText( "Atk", x + 130, y + 28 * 1, 64 ,"left");
	this.drawText( "Def", x + 130, y + 28 * 2, 64 ,"left");
	this.drawText( "Mat", x + 130, y + 28 * 3, 80 ,"left");
	this.drawText( "Mdf", x + 260, y + 28 * 1, 64 ,"left");
	this.drawText( "Agi", x + 260, y + 28 * 2, 64 ,"left");
	this.drawText( "Luk", x + 260, y + 28 * 3, 80 ,"left");
	
	// > 属性值
	this.changeTextColor(this.normalColor());
	this.drawText( actor.name(), x,       y );
	this.drawText( actor.level,  x,       y + 28 * 1, 80, "right");
	this.drawText( actor.mhp,    x,       y + 28 * 2, 80, "right");
	this.drawText( actor.mmp,    x,       y + 28 * 3, 80, "right");
	this.drawText( actor.atk,    x + 130, y + 28 * 1, 80, "right");
	this.drawText( actor.def,    x + 130, y + 28 * 2, 80, "right");
	this.drawText( actor.mat,    x + 130, y + 28 * 3, 80, "right");
	this.drawText( actor.mdf,    x + 260, y + 28 * 1, 80, "right");
	this.drawText( actor.agi,    x + 260, y + 28 * 2, 80, "right");
	this.drawText( actor.luk,    x + 260, y + 28 * 3, 80, "right");
};
//==============================
// * 队形窗口 - 事件确认
//==============================
Window_Drill_SMa_Formation.prototype.processOk = function() {
	Window_Selectable.prototype.processOk.call(this);
	$gameParty.setMenuActor($gameParty.members()[this.index()]);
};
//==============================
// * 队形窗口 - 选中最后一个
//==============================
Window_Drill_SMa_Formation.prototype.selectLast = function() {
	this.select(0);
};
//==============================
// * 队形窗口 - 获取待选索引
//==============================
Window_Drill_SMa_Formation.prototype.pendingIndex = function() {
	return this._drill_pendingIndex;
};
//==============================
// * 队形窗口 - 设置待选索引
//==============================
Window_Drill_SMa_Formation.prototype.setPendingIndex = function(index) {
	var lastPendingIndex = this._drill_pendingIndex;
	this._drill_pendingIndex = index;
	this.redrawItem(this._drill_pendingIndex);		//两个选项变换后重绘
	this.redrawItem(lastPendingIndex);
};



//=============================================================================
// ** 日期/时间 格式化
//=============================================================================
//==============================
// * 累积游戏时长 - 格式化
//==============================
Game_System.prototype.drill_SMa_getPlaytimeTextByFormat = function( fmt ) {
    var hour = Math.floor(this.playtime() / 60 / 60);
    var min = Math.floor(this.playtime() / 60) % 60;
    var sec = this.playtime() % 60;
	fmt = fmt.replace( "HH", hour.padZero(2) );
	fmt = fmt.replace( "mm", min.padZero(2) );
	fmt = fmt.replace( "ss", sec.padZero(2) );
    return fmt;
};
//==============================
// * 真实时间 - 格式化
//==============================
Date.prototype.drill_SMa_getDateTextByFormat = function( fmt ){
	var o = {
		"M+": this.getMonth() + 1,						//月份 
		"d+": this.getDate(),							//日 
		"H+": this.getHours(),							//小时 
		"m+": this.getMinutes(),						//分 
		"s+": this.getSeconds(),						//秒 
		"q+": Math.floor((this.getMonth() + 3) / 3),	//季度 
		"S":  this.getMilliseconds()					//毫秒 
	};
	if( /(y+)/.test(fmt) ){
		fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	}
	for( var k in o ){
		if( new RegExp("(" + k + ")").test(fmt) ){
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		}
	}
	return fmt;
}
//==============================
// * 累积游戏时长 - 格式化
//==============================
Game_System.prototype.drill_SMa_getGameWorldTimeTextByFormat = function( fmt ) {
	if( Imported.MOG_TimeSystem != true ){ return; }
	
	var o = {
		"M+": this.month(),								//月份 
		"d+": this.day(),								//日 
		"H+": this.hour(),								//小时 
		"m+": this.minute(),							//分 
		"s+": this.second(),							//秒 
		"q+": Math.floor((this.month() + 2) / 3),		//季度 
	};
	if( /(y+)/.test(fmt) ){
		fmt = fmt.replace(RegExp.$1, (this.year() + "").substr(4 - RegExp.$1.length));
	}
	for( var k in o ){
		if( new RegExp("(" + k + ")").test(fmt) ){
			fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		}
	}
	return fmt;
};


//=============================================================================
// ** mog插件兼容
//=============================================================================
if( Imported.MOG_TimeSystem ){
	//==============================
	// * create Time Status
	//==============================
	Scene_Menu.prototype.createTimeStatus = function() {
		$gameSystem._refresh_window_time = false;	
	};
}




//=============================================================================
// * <<<<基于插件检测<<<<
//=============================================================================
}else{
		Imported.Drill_SceneMain = false;
		alert(
			"【Drill_SceneMain.js 面板 - 全自定义主菜单面板】\n缺少基础插件，去看看下列插件是不是 未添加 / 被关闭 / 顺序不对："+
			"\n- Drill_CoreOfWindowAuxiliary  系统-窗口辅助核心"+
			"\n- Drill_CoreOfGaugeMeter       系统-参数条核心"+
			"\n- Drill_CoreOfGaugeNumber      系统-参数数字核心"+
			"\n- Drill_CoreOfSelectableButton 系统-按钮组核心"
		);
}

