//=============================================================================
// Drill_TroopName.js
//=============================================================================

/*:
 * @plugindesc [v1.1]        单位 - 敌人命名
 * @author Drill_up
 * 
 * @help  
 * =============================================================================
 * +++ Drill_TroopName +++
 * 作者：Drill_up
 * 如果你有兴趣，也可以来看看更多我写的drill插件哦ヽ(*。>Д<)o゜
 * https://rpg.blue/thread-409713-1-1.html
 * =============================================================================
 * 如果战斗中出现重复敌人，你可以在这里设置其后缀。
 * 
 * -----------------------------------------------------------------------------
 * ----设定注意事项
 * 1.插件的作用域：战斗界面。
 *   只作用于战斗中重复的敌人。
 * 2.rmmv国际化做得不是很好，目前系统全默认按照半字节来设定。
 *   原先半字节和全字节是为了中文和英文的适应性而设置的，可以把它们设成一样的。
 *
 * -----------------------------------------------------------------------------
 * ----插件性能
 * 测试仪器：   4G 内存，Intel Core i5-2520M CPU 2.5GHz 处理器
 *              Intel(R) HD Graphics 3000 集显 的垃圾笔记本
 *              (笔记本的3dmark综合分：571，鲁大师综合分：48456)
 * 总时段：     20000.00ms左右
 * 对照表：     0.00ms  - 40.00ms （几乎无消耗）
 *              40.00ms - 80.00ms （低消耗）
 *              80.00ms - 120.00ms（中消耗）
 *              120.00ms以上      （高消耗）
 * 工作类型：   单次执行
 * 时间复杂度： o(1)
 * 测试方法：   进入战斗界面进行测试。
 * 测试结果：   战斗界面中，消耗为：【5ms以下】
 * 
 * 1.插件只在自己作用域下工作消耗性能，在其它作用域下是不工作的。
 *   测试结果并不是精确值，范围在给定值的10ms范围内波动。
 *   更多性能介绍，去看看 "0.性能测试报告 > 关于插件性能.docx"。
 * 2.该插件只修改一个参数，性能消耗几乎没有。
 *
 * -----------------------------------------------------------------------------
 * ----更新日志
 * [v1.0]
 * 完成插件ヽ(*。>Д<)o゜
 * [v1.1]
 * 修改了插件分类。
 * 
 * 
 * @param 重复敌人后缀名-半字节
 * @type text[]
 * @desc 重复敌人的后缀名命名。
 * @default [" A"," B"," C"," D"," E"," F"," G"," H"," I"," J"," K"," L"," M"," N"," O"," P"," Q"," R"," S"," T"," U"," V"," W"," X"," Y"," Z"]
 * 
 * @param 重复敌人后缀名-全字节
 * @type text[]
 * @desc 重复敌人的后缀名命名。
 * @default ["Ａ","Ｂ","Ｃ","Ｄ","Ｅ","Ｆ","Ｇ","Ｈ","Ｉ","Ｊ","Ｋ","Ｌ","Ｍ","Ｎ","Ｏ","Ｐ","Ｑ","Ｒ","Ｓ","Ｔ","Ｕ","Ｖ","Ｗ","Ｘ","Ｙ","Ｚ"]
 */
 
//<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
//		插件简称		TN（Troop_Name）
//		临时全局变量	DrillUp.g_TN_xxx
//		临时局部变量	无
//		存储数据变量	无
//		全局存储变量	无
//		覆盖重写方法	无
//
//		工作类型		单次执行
//		时间复杂度		o(1)
//		性能测试因素	无
//		性能测试消耗	无（没有测试的必要）
//		最坏情况		无
//		备注			无
//
//插件记录：
//		无
//

//=============================================================================
// ** 变量获取
//=============================================================================
　　var Imported = Imported || {};
　　Imported.Drill_TroopName = true;
　　var DrillUp = DrillUp || {}; 

    DrillUp.parameters = PluginManager.parameters('Drill_TroopName');
	if(DrillUp.parameters['重复敌人后缀名-半字节'] != "" ){
		DrillUp.g_TN_half = JSON.parse(DrillUp.parameters['重复敌人后缀名-半字节']);
	}else{
		DrillUp.g_TN_half = [
			' A',' B',' C',' D',' E',' F',' G',' H',' I',' J',' K',' L',' M',
			' N',' O',' P',' Q',' R',' S',' T',' U',' V',' W',' X',' Y',' Z'
		];
	}
	if(DrillUp.parameters['重复敌人后缀名-全字节'] != "" ){
		DrillUp.g_TN_full = JSON.parse(DrillUp.parameters['重复敌人后缀名-全字节']);
	}else{
		DrillUp.g_TN_full = [
			'Ａ','Ｂ','Ｃ','Ｄ','Ｅ','Ｆ','Ｇ','Ｈ','Ｉ','Ｊ','Ｋ','Ｌ','Ｍ',
			'Ｎ','Ｏ','Ｐ','Ｑ','Ｒ','Ｓ','Ｔ','Ｕ','Ｖ','Ｗ','Ｘ','Ｙ','Ｚ'
		];
	}

//=============================================================================
// ** 复写函数
//=============================================================================

Game_Troop.LETTER_TABLE_HALF = DrillUp.g_TN_half;
Game_Troop.LETTER_TABLE_FULL = DrillUp.g_TN_full;

