/*:
 * @plugindesc Synthetise v1.1
 * @author Qiu Jiu
 *
 * @param List
 * @text 配方
 * @desc 所有可合成物品的总数据。
 * @type struct<listdata>[]
 * @default
 *
 * @param menu
 * @text 是否将合成页面添加到菜单栏
 * @desc 是否将合成页面添加到菜单栏
 * @type Boolean
 * @default true
 *
 * @param Text1
 * @text 待执行文字
 * @desc 处在L4时所显示的文字
 * @default 请放入原料以后点击合成。
 *
 * @param Text2
 * @text 待选择文字
 * @desc 处在L3时所显示的文字
 * @default 请选择一个区域放置原料。
 *
 * @param Text3
 * @text 合成失败文字
 * @desc 处在L4且在无法合成或者合成失败时所显示的文字
 * @default 此配方未解锁或者配方无效。
 *
 * @param Text4
 * @text 批量合成页面文字
 * @desc 图鉴中批量合成页面的文字。
 * @default 您要批量合成此物品
 *
 * @param Text5
 * @text 批量合成页面文字后面的量词
 * @desc 图鉴中批量合成页面的文字最后的量词。
 * @default 个
 *
 * @param Sound1
 * @text 成功音效
 * @desc 成功合成音效
 * @default
 * @require 1
 * @dir audio/se/
 * @type file
 * 
 * @param Sound2
 * @text 失败音效
 * @desc 失败合成音效
 * @default
 * @require 1
 * @dir audio/se/
 * @type file
 *
 * @param Sound3
 * @text 选择音效
 * @desc 选择后音效
 * @default
 * @require 1
 * @dir audio/se/
 * @type file
 *
 * @param img1
 * @text 主窗口合成图标
 * @desc 放在九格合成栏与产物之间的指向标，大小推荐100*60。
 * @default 合成图标
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img2
 * @text 主窗口内层图片
 * @desc 主菜单里边的背景图，大小推荐816*624。
 * @default 主页面内层图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img7
 * @text 主窗口特殊图片
 * @desc 主菜单中九格所在窗口的背景，其在窗口外面，图标下面，主窗口表层图片下面。
 * @default 主窗口特殊图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img3
 * @text 主窗口表层图片
 * @desc 主菜单里遮盖所有的图片，没有需求就用默认的透明图片，大小推荐816*624。
 * @default 主页面表层图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img4
 * @text 图鉴窗口内层图片
 * @desc 图鉴窗口里边的背景图，大小推荐816*624。
 * @default 图鉴内层图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img5
 * @text 图鉴窗口表层图片
 * @desc 图鉴窗口里遮盖所有的图片，没有需求就用默认的透明图片，大小推荐816*624。
 * @default 图鉴表层图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img8
 * @text 图鉴窗口特殊图片
 * @desc 图鉴窗口，其在窗口外面，图标下面，图鉴窗口表层图片下面。
 * @default 图鉴窗口特殊图片
 * @require 1
 * @dir img/system/
 * @type file
 *
 * @param img6
 * @text 图鉴窗口合成结构
 * @desc 图鉴窗口里的小结构图，大小推荐247*230。
 * @default 图鉴单个合成结构
 * @require 1
 * @dir img/system/
 * @type file
 *
 *
 *
 * @help
 * 合成系统。
 * V1.1 
 *    修复了退出时游戏也退出的情况
 *    增设了结构可移动的判定方法————只要各个原料的相对位置相同，那么就能合成对应产物。
 *    不必与参数中的设置一一对应。
 *
 *
 * 1.首先在参数列表的第一行设置配方，每一个配方的9种原料在合成页面的位置分别为：
 * 材料1  材料2  材料3
 * 材料4  材料5  材料6
 * 材料7  材料8  材料9
 * 每一个配方在合成一次以后，便会出现在合成图鉴中，在合成图鉴中玩家可以进行批量合成，
 * 若是不想让玩家进行批量合成，那么要在"是否"可批量合成这里选择off，这样的话合成过
 * 一次的配方仍然会进入图鉴，但是玩家在图鉴中不能批量合成。
 * 若是想让玩家在获得A技能以后才能合成（使2号配方有效），那么需要在对应的配方的"是否
 * 限制合成"那里选择off，然后在A技能的备注栏里填入<syn:[2]>,批量添加时可用,分隔开。
 * 例如：<syn:[2,3,4,5,6]>
 * V1.2
 * 添加了大量图片设定。
 *
 *
 * 2.参数第二行是设置是否在菜单栏中出现，若是出现则选true。
 * 可以在游戏中用 脚本指令 
 * SceneManager.goto(Scene_Synthetise);
 * 召唤出合成页面。
 *
 * 3.音效与文字。
 *
 *
 *
 * 注意！请确认将manual.png 与 Synthetise.png文件放在了img/system文件夹内。
 * 您可以通过修改这两个图片来修改页面。
 *
 *
*/
/*~struct~listdata:
 * @param name
 * @text 配方名字
 * @desc 只有作者能看到，只是方便作者的统计。
 * @default
 *
 * @param batch
 * @text 是否可批量合成
 * @desc 决定此物品玩家能否批量合成，即在合成一次，解锁配方以后，能否在配方页面进行批量合成。
 * @type Boolean
 * @default true
 * 
 * @param item0
 * @text 产物
 * @desc 物品、武器、装备中只能选择一个设置，多设置时最前面的那个生效。且一次只能合成单个产物。
 * @type struct<Item>
 * @default
 * 
 * @param item1
 * @text 材料1
 * @desc (1,1)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item2
 * @text 材料2
 * @desc (2,1)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item3
 * @text 材料3
 * @desc (3,1)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item4
 * @text 材料4
 * @desc (1,2)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item5
 * @text 材料5
 * @desc (2,2)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item6
 * @text 材料6
 * @desc (3,2)同样只能设置一个。
 * @type struct<Item>
 * @default
 * 
 * @param item7
 * @text 材料7
 * @desc (1,3)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item8
 * @text 材料8
 * @desc (2,3)同样只能设置一个。
 * @type struct<Item>
 * @default
 *
 * @param item9
 * @text 材料9
 * @desc (3,3)同样只能设置一个。
 * @type struct<Item>
 * @default
 * 
 * @param skill
 * @text 是否进行限制
 * @desc 此选项为off时，此配方无法使用。当队列中的角色拥有某个技能以后才可以。
 * @type Boolean
 * @default true
 *
 *
 *
 *
*/
/*~struct~Item:
 * @param item
 * @text 物品
 * @type item
 * @parent Object Selectors
 *
 * @param weapon
 * @text 武器
 * @type weapon
 * @parent Object Selectors
 *
 * @param armor
 * @text 装备
 * @type armor
 * @parent Object Selectors
 * 
*/
//-----------------------------------------------------
//信息载入
//-----------------------------------------------------
var Imported = Imported || {};
Imported.HG_Synthetise = true;
var HG = HG || {};
HG.Synthetise = HG.Synthetise || {};
HG.Synthetise.Data = HG.Synthetise.Data || {};
HG.Synthetise.Parameters = PluginManager.parameters('HG-Syn');
HG.Synthetise.Data.Text1 = String(HG.Synthetise.Parameters['Text1']);
HG.Synthetise.Data.Text2 = String(HG.Synthetise.Parameters['Text2']);
HG.Synthetise.Data.Text3 = String(HG.Synthetise.Parameters['Text3']);
HG.Synthetise.Data.Text4 = String(HG.Synthetise.Parameters['Text4']);
HG.Synthetise.Data.Text5 = String(HG.Synthetise.Parameters['Text5']);
HG.Synthetise.Data.Sound1 = String(HG.Synthetise.Parameters['Sound1']);
HG.Synthetise.Data.Sound2 = String(HG.Synthetise.Parameters['Sound2']);
HG.Synthetise.Data.Sound3 = String(HG.Synthetise.Parameters['Sound3']);
HG.Synthetise.Data.List = eval(HG.Synthetise.Parameters['List']) || [];
HG.Synthetise.Data.Img1 = String(HG.Synthetise.Parameters['img1']);
HG.Synthetise.Data.Img2 = String(HG.Synthetise.Parameters['img2']);
HG.Synthetise.Data.Img3 = String(HG.Synthetise.Parameters['img3']);
HG.Synthetise.Data.Img4 = String(HG.Synthetise.Parameters['img4']);
HG.Synthetise.Data.Img5 = String(HG.Synthetise.Parameters['img5']);
HG.Synthetise.Data.Img6 = String(HG.Synthetise.Parameters['img6']);
HG.Synthetise.Data.Img7 = String(HG.Synthetise.Parameters['img7']);
HG.Synthetise.Data.Img8 = String(HG.Synthetise.Parameters['img8']);
HG.Synthetise.List = [];
HG.Synthetise.mList = [[],[],[]];
HG.Synthetise.LoadData = DataManager.loadDatabase;
HG.Synthetise.menu = Boolean(HG.Synthetise.Parameters['menu']);
DataManager.loadDatabase = function() {
    HG.Synthetise.LoadData.call(this);
    this.loadSynthetiseData();
};
DataManager.loadSynthetiseData = function(){
    for(var i=0;i<HG.Synthetise.Data.List.length;i++){
        var list = JSON.parse(HG.Synthetise.Data.List[i]); 
        var data = [],deal;
        for (var j=0;j<10;j++) {
            deal=list["item"+j]
            if (deal!="") {
                deal=JSON.parse(deal);
                if (deal.item!="") {
                    deal=["item",Number(deal.item)];
                    if (!HG.Synthetise.mList[0].includes(deal[1])) HG.Synthetise.mList[0].push(deal[1]);
                }
                else if (deal.weapon!="") {
                    deal=["weapon",Number(deal.weapon)];
                    if (!HG.Synthetise.mList[1].includes(deal[1])) HG.Synthetise.mList[1].push(deal[1]);
                }
                else if (deal.armor!="") {
                    deal=["armor",Number(deal.armor)];
                    if (!HG.Synthetise.mList[2].includes(deal[1])) HG.Synthetise.mList[2].push(deal[1]);
                }
            } else deal=[0,0];
            data[j]=deal;
        }
        deal=JSON.parse(list["batch"]);
        data[10]=deal;
        deal=JSON.parse(list["skill"]);
        data[11]=deal;
        HG.Synthetise.List.push(data);
    }
};
//-----------------------------------------------------
//合成场景
//-----------------------------------------------------
function Scene_Synthetise() {
    this.initialize.apply(this, arguments);
}
Scene_Synthetise.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Synthetise.prototype.constructor = Scene_Synthetise;
Scene_Synthetise.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
    this._data = [0,0,0,0,0,0,0,0,0,0];
    this._sound1 = {"name":HG.Synthetise.Data.Sound1,"pan":0,"pitch":100,"volume":100};
    this._sound2 = {"name":HG.Synthetise.Data.Sound2,"pan":0,"pitch":100,"volume":100};
    this._sound3 = {"name":HG.Synthetise.Data.Sound3,"pan":0,"pitch":100,"volume":100};
    this._position = 0;
};
Scene_Synthetise.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this.createImg();
    this.createL1();
    this.createL2();
    this.createL3();
    this.createL4();
    this._L4.activate();
    this._L4.select(0);
    this._L1.setText(String(HG.Synthetise.Data.Text1));
};
Scene_Synthetise.prototype.createBackground = function() {
    this._img2 = new Sprite();
    this._img2.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img2);
    this.addChild(this._img2);
};
Scene_Synthetise.prototype.start = function() {
    Scene_MenuBase.prototype.start.call(this);
};
Scene_Synthetise.prototype.createImg = function() {
    this._img1 = new Sprite();
    this._img1.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img1);
    this._img1.x=594;
    this._img1.y=302;
    this.addChild(this._img1);
    this._img3 = new Sprite();
    this._img3.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img3);
    this.addChild(this._img3);
};
Scene_Synthetise.prototype.createL1 = function() {
    this._L1 = new Window_Help(2);
    this.addWindow(this._L1);
};
Scene_Synthetise.prototype.createL2 = function() {
    var x = 0;
    var y = this._L1.y + this._L1.height;
    var width = 270;
    var height = 444;
    this._L2 = new Window_SynthetiseItem(x, y, width, height);
    this._L2.setHandler('ok',     this.selects.bind(this));
    this._L2.setHandler('cancel', this.selectf.bind(this));
    this.addWindow(this._L2);
    this._L2.setHelpWindow(this._L1);
};
Scene_Synthetise.prototype.selects = function(){
    var item = this._L2.item();
    if(item){
        $gameParty.loseItem(item, 1);
    }
    var lastItem = this._data[this._position];
    if(lastItem){
        $gameParty.gainItem(lastItem, 1);
    }
    if (item!=null) this._data[this._position] = item;
    else this._data[this._position]=0;
    this._L2.refresh();
    this._L2.deactivate();
    this._L2.deselect();
    this._L3.activate();
    this._L3.setData(this._data);
    this._L3.select(this._position);
    this._L3.refresh();
    this._L3.updateHelp();
    AudioManager.playSe(this._sound3);
};
Scene_Synthetise.prototype.selectf = function() {
    this._L2.deactivate();
    this._L2.deselect();
    this._L3.activate();
    this._L3.select(this._position);
};
Scene_Synthetise.prototype.createL3 = function() {
    var x = 270;
    var y = this._L1.y + this._L1.height;
    var width = Graphics.boxWidth - x;
    var height = 444;
    this._L3 = new Window_SynthetiseBox(x, y, width, height);
    this._L3.setHandler('ok',     this.boxselects.bind(this));
    this._L3.setHandler('cancel', this.boxselectf.bind(this));
    this.addWindow(this._L3);
    this._L3.setData(this._data);
    this._L3.setHelpWindow(this._L1);
};
Scene_Synthetise.prototype.boxselects = function() {
    this._position = this._L3.Position();
    this._L2.activate();
    this._L2.select(0);
    this._L3.deactivate();
    this._L3.deselect();
    AudioManager.playSe(this._sound3);
};
Scene_Synthetise.prototype.boxselectf = function() {
    this._L4.activate();
    this._L4.select(0);
    this._L3.deactivate();
    this._L3.deselect();
    this._L1.setText(String(HG.Synthetise.Data.Text1));
};
Scene_Synthetise.prototype.createL4 = function() {
    var x = 0;
    var y = 552;
    var width = Graphics.boxWidth;
    var height = 72;
    this._L4 = new Window_SynthetiseOption(x, y, width, height);
    this._L4.setHandler('manual',     this.manual.bind(this));
    this._L4.setHandler('select',     this.opselect.bind(this));
    this._L4.setHandler('syn',     this.opsyn.bind(this));
    this._L4.setHandler('cancel', this.opcancel.bind(this));
    this._L4.setHelpWindow(this._L1);
    this.addWindow(this._L4);
};
Scene_Synthetise.prototype.manual = function() {
	for(var i = 0; i < 9; i++){
        var item = this._data[i];
        $gameParty.gainItem(item, 1);
    }
    SoundManager.playOk();
    SceneManager.push(Scene_Synthetise);
    SceneManager.goto(Scene_Manual);
};
Scene_Synthetise.prototype.opselect = function() {
    SoundManager.playOk();
    this._L3.activate();
    this._L3.select(0);
    this._L4.deactivate();
    this._L4.deselect();
    this._L1.setText(String(HG.Synthetise.Data.Text2));
};
Scene_Synthetise.prototype.opsyn = function() {
    var consult=$gameMap.judgeSyn(this._data,true);
    if (consult!=0 && $gameParty.numItems(consult)<$gameParty.maxItems(consult)) {
        this._data=[0,0,0,0,0,0,0,0,0,0];
        this._L3.setData(this._data);
        this._L3.refresh();
        $gameParty.gainItem(consult, 1);
        this._L2.refresh();
        AudioManager.playSe(this._sound1);
    } else {
        AudioManager.playSe(this._sound2);
        this._L4._fail=true;
    }
    this._L4.select(2);
    this._L4.activate();
};
Scene_Synthetise.prototype.opcancel = function() {
    for(var i = 0; i < 9; i++){
        var item = this._data[i];
        $gameParty.gainItem(item, 1);
    }
    if (SceneManager._stack.length > 0) this.popScene();
    else SceneManager.goto(Scene_Map);
};
//-----------------------------------------------------
//选择指令窗口
//-----------------------------------------------------
function Window_SynthetiseOption() {
    this.initialize.apply(this, arguments);
};
Window_SynthetiseOption.prototype = Object.create(Window_HorzCommand.prototype);
Window_SynthetiseOption.prototype.constructor = Window_SynthetiseOption;
Window_SynthetiseOption.prototype.initialize = function(x, y, width, height) {
    this._fail=false;
    this.clearCommandList();
    this.makeCommandList();
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this.refresh();
};
Window_SynthetiseOption.prototype.makeCommandList = function() {
    this.addCommand("配方快速合成", 'manual');
    this.addCommand("放入材料", 'select');
    this.addCommand("合成", 'syn');
    this.addCommand("取消", 'cancel');
};
Window_SynthetiseOption.prototype.maxCols = function() {
    return 4;
};
Window_SynthetiseOption.prototype.itemWidth = function() {
    return 183;
};
Window_SynthetiseOption.prototype.updateHelp = function() {
    if (this._fail) {this._helpWindow.setText(String(HG.Synthetise.Data.Text3));this._fail=false;}
    else this._helpWindow.setText(String(HG.Synthetise.Data.Text1));
};
Window_SynthetiseOption.prototype.playOkSound = function() {
    
};
//-----------------------------------------------------
//选择合成窗口
//-----------------------------------------------------
function Window_SynthetiseBox() {
    this.initialize.apply(this, arguments);
};
Window_SynthetiseBox.prototype = Object.create(Window_Selectable.prototype);
Window_SynthetiseBox.prototype.constructor = Window_SynthetiseBox;
Window_SynthetiseBox.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._data = [];
    this.refresh();
};
Window_SynthetiseBox.prototype.maxCols = function() {
    return 3;
};
Window_SynthetiseBox.prototype.maxItems = function() {
    return 9;
};
Window_SynthetiseBox.prototype.maxPageRows = function() {
    return 3;
};
Window_SynthetiseBox.prototype.setData = function(data) {
    this._data = data;
    return ;
};
Window_SynthetiseBox.prototype.itemHeight = function() {
    return 84;
};
Window_SynthetiseBox.prototype.itemWidth = function() {
    return 84;
};
Window_SynthetiseBox.prototype.itemRect = function(index) {
    var rect = new Rectangle();
    var maxCols = this.maxCols();
    rect.width = 84;
    rect.height = 84;
    rect.x = index%3*100+16;
    rect.y = Math.floor(index/3)*100+62;
    return rect;
};
Window_SynthetiseBox.prototype.Position = function() {
    return this._index;
};
Window_SynthetiseBox.prototype.updateHelp = function() {
    if (this._data[this.index()]==0) this._helpWindow.setText(String(HG.Synthetise.Data.Text2));
    else this.setHelpWindowItem(this._data[this.index()]);
};
Window_SynthetiseBox.prototype.processCursorMove = function() {
    if (this.isCursorMovable()) {
        var lastIndex = this.index();
        if (Input.isRepeated('down')) {
            this.cursorDown(Input.isTriggered('down'));
        }
        if (Input.isRepeated('up')) {
            this.cursorUp(Input.isTriggered('up'));
        }
        if (Input.isRepeated('right')) {
            this.cursorRight(Input.isTriggered('right'));
        }
        if (Input.isRepeated('left')) {
            this.cursorLeft(Input.isTriggered('left'));
        }
        if (!this.isHandled('pagedown') && Input.isTriggered('pagedown')) {
            this.cursorPagedown();
        }
        if (!this.isHandled('pageup') && Input.isTriggered('pageup')) {
            this.cursorPageup();
        }
        if (this.index() !== lastIndex) {
            AudioManager.playSe({"name":HG.Synthetise.Data.Sound3,"pan":0,"pitch":100,"volume":90});
        }
    }
};
Window_SynthetiseBox.prototype.drawItem = function(index) {
    var item = this._data[index];
    var rect = this.itemRect(index);
    if(item){
        var iconBoxWidth = Window_Base._iconWidth + 4;
        var ystart = (rect.height - Window_Base._iconHeight - this.lineHeight()) / 2;
        var y1 = rect.y + ystart + 6;
        var y2 = y1 + Window_Base._iconHeight;
        var x1 = rect.x + (rect.width - iconBoxWidth) / 2
        this.resetTextColor();
        this.drawIcon(item.iconIndex,rect.x+(rect.width-iconBoxWidth)/2, y1);
        this.contents.fontSize = 16;
        this.drawText(item.name, rect.x, y2, rect.width, 'center');
    }
};
Window_SynthetiseBox.prototype.playOkSound = function() {
    
};
SynthetiseBox = Window_SynthetiseBox.prototype.refresh;
Window_SynthetiseBox.prototype.refresh = function() {
    this._img7 = new Sprite();
    this._img7.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img7);
    this._img7.x=-270;
    this._img7.y=-108;
    this.addChildToBack(this._img7);
    SynthetiseBox.call(this);
    var consult=$gameMap.judgeSyn(this._data,false);
    if (consult!=0) {
        var iconBoxWidth = Window_Base._iconWidth + 4;
        var item=consult;
        var ystart = (816 - Window_Base._iconHeight - this.lineHeight()) / 2;
        this.resetTextColor();
        this.drawIcon(item.iconIndex,440, 174);
        this.drawText(item.name,416,208,84, 'center');
    }
};
ManualRemember = Game_Map.prototype.initialize;
Game_Map.prototype.initialize = function() {
    ManualRemember.call(this);
    this._manual = [];
    this._allSyn = false;
};
Game_Map.prototype.judgeSyn = function(data,value) {
    if (data[0]==undefined) return 0;
    var list=data;
    var jl=Array(9);
    for (var i=0;i<9;i++) {
        if ($dataWeapons.contains(list[i])) jl[i]=['weapon',list[i].id];
        if ($dataArmors.contains(list[i])) jl[i]=['armor',list[i].id];
        if ($dataItems.contains(list[i])) jl[i]=['item',list[i].id];
        if (list[i]==0) jl[i]=[0,0];
    }
    var skilllist=[];
    var member=$gameParty.allMembers();
    var skill,syn;
    for (var i=0;i<member.length;i++) {$gameParty.allMembers()[0].skills()
        skill=member[i].skills();
        for (var j=0;j<skill.length;j++) {
            syn=eval(skill[j].meta.syn);
            if (skill[j].meta.syn) {
                for (var l=0;l<syn.length;l++) {
                    if (!skilllist.includes(syn[l]-1)) skilllist.push(syn[l]-1);
                }
            }
        }
    }
    var alldata=HG.Synthetise.List;
    for (var i=0;i<alldata.length;i++) {
        if (alldata[i][11]==false) {
            if (!skilllist.includes(i)) alldata[i]=0;
        }
    }

    var bo=-2;
    for (var i=0;i<alldata.length;i++) {
        if (alldata[i]!=0) {bo=-1;break;}
    }
    if (bo==-2) return 0;
    for (var j=0;jl[0][0]==0&&jl[1][0]==0&&jl[2][0]==0;j++) {
        if (j==2) break;
        jl=[jl[3],jl[4],jl[5],jl[6],jl[7],jl[8],[0,0],[0,0],[0,0]];
    }
    for (var j=0;jl[0][0]==0&&jl[3][0]==0&&jl[6][0]==0;j++) {
        if (j==2) break;
        jl=[jl[1],jl[2],[0,0],jl[4],jl[5],[0,0],jl[7],jl[8],[0,0]];
    }
    for (var i=0;i<alldata.length;i++) {
        if (alldata[i]==0) continue;
        var ad=JsonEx.makeDeepCopy(alldata[i]);
        ad=[ad[1],ad[2],ad[3],ad[4],ad[5],ad[6],ad[7],ad[8],ad[9]]
        for (var j=0;ad[0][0]==0&&ad[1][0]==0&&ad[2][0]==0;j++) {
            if (j==2) break;
            ad=[ad[3],ad[4],ad[5],ad[6],ad[7],ad[8],[0,0],[0,0],[0,0]];
        }
        for (var j=0;ad[0][0]==0&&ad[3][0]==0&&ad[6][0]==0;j++) {
            if (j==2) break;
            ad=[ad[1],ad[2],[0,0],ad[4],ad[5],[0,0],ad[7],ad[8],[0,0]];
        }
        bo=-2;
        for (var j=0;j<9;j++) {
            if (ad[j][0]==0 && jl[j][0]==0) continue;
            if (!(ad[j][0]==jl[j][0] && ad[j][1]==jl[j][1])) {bo=-1;break;}
        }
        if (bo==-2) {bo=i;break;}
    }
    if (bo<0)  return 0;
    if (value==true) this._manual[i]=true;
    if (alldata[bo][0][0]=='weapon') return $dataWeapons[alldata[bo][0][1]];
    if (alldata[bo][0][0]=='armor') return $dataArmors[alldata[bo][0][1]];
    if (alldata[bo][0][0]=='item') return $dataItems[alldata[bo][0][1]];
};

//-----------------------------------------------------
//选择物品窗口
//-----------------------------------------------------
function Window_SynthetiseItem() {
    this.initialize.apply(this, arguments);
};
Window_SynthetiseItem.prototype = Object.create(Window_Selectable.prototype);
Window_SynthetiseItem.prototype.constructor = Window_SynthetiseItem;
Window_SynthetiseItem.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._data = [];
    this.refresh();
};
Window_SynthetiseItem.prototype.maxCols = function() {
    return 1;
};
Window_SynthetiseItem.prototype.standardPadding = function() {
    return 9;
};
Window_SynthetiseItem.prototype.makeItemList = function() {
    this._candata = HG.Synthetise.mList;
    this._data = $gameParty.allItems().filter(function(item) {
        if (!item) {
            return false;
        } else if (DataManager.isItem(item)) {
            return this._candata[0].includes(item.id);
        } else if (DataManager.isWeapon(item)) {
            return this._candata[1].includes(item.id);
        } else if (DataManager.isArmor(item)) {
            return this._candata[2].includes(item.id);
        } else {
            return false;
        }
    }, this);
    if (this._data) this._data.push(null);
    //if (this.includes(null)) this._data.push(null);
};
Window_SynthetiseItem.prototype.maxItems = function() {
    return this._data ? this._data.length : 1;
};
Window_SynthetiseItem.prototype.item = function() {
    var index = this.index();
    return this._data && index >= 0 ? this._data[index] : null;
};
Window_SynthetiseItem.prototype.selectLast = function() {
    var index = this._data.indexOf($gameParty.lastItem());
    this.select(index >= 0 ? index : 0);
};
Window_SynthetiseItem.prototype.drawItem = function(index) {
    var item = this._data[index];
    if (item) {
        var numberWidth = this.numberWidth();
        var rect = this.itemRect(index);
        rect.width -= this.textPadding();
        this.changePaintOpacity(true);
        this.drawItemName(item, rect.x, rect.y, rect.width - numberWidth);
        this.drawItemNumber(item, rect.x, rect.y, rect.width);
        this.changePaintOpacity(1);
    }
};
Window_SynthetiseItem.prototype.numberWidth = function() {
    return this.textWidth('000');
};
Window_SynthetiseItem.prototype.drawItemNumber = function(item, x, y, width) {
    this.drawText(':', x, y, width - this.textWidth('00'), 'right');
    this.drawText($gameParty.numItems(item), x, y, width, 'right');
};
Window_SynthetiseItem.prototype.refresh = function() {
    this.makeItemList();
    this.createContents();
    this.drawAllItems();
};
Window_SynthetiseItem.prototype.updateHelp = function() {
    this.setHelpWindowItem(this.item());
};
Window_SynthetiseItem.prototype.playOkSound = function() {
    
};
Window_SynthetiseItem.prototype.processCursorMove = function() {
    if (this.isCursorMovable()) {
        var lastIndex = this.index();
        if (Input.isRepeated('down')) {
            this.cursorDown(Input.isTriggered('down'));
        }
        if (Input.isRepeated('up')) {
            this.cursorUp(Input.isTriggered('up'));
        }
        if (Input.isRepeated('right')) {
            this.cursorRight(Input.isTriggered('right'));
        }
        if (Input.isRepeated('left')) {
            this.cursorLeft(Input.isTriggered('left'));
        }
        if (!this.isHandled('pagedown') && Input.isTriggered('pagedown')) {
            this.cursorPagedown();
        }
        if (!this.isHandled('pageup') && Input.isTriggered('pageup')) {
            this.cursorPageup();
        }
        if (this.index() !== lastIndex) {
            AudioManager.playSe({"name":HG.Synthetise.Data.Sound3,"pan":0,"pitch":100,"volume":90});
        }
    }
};
//-----------------------------------------------------
//图鉴
//-----------------------------------------------------
function Scene_Manual() {
    this.initialize.apply(this, arguments);
}
Scene_Manual.prototype = Object.create(Scene_MenuBase.prototype);
Scene_Manual.prototype.constructor = Scene_Manual;
Scene_Manual.prototype.initialize = function() {
    Scene_MenuBase.prototype.initialize.call(this);
    this._data=[];
    this._position=0; 
};
Scene_Manual.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this.createL1();
    this.createL2();
    this.createL3();
    this._L3.hide();
    this._L2.activate();
    this._L2.select(this._position);
};
Scene_Manual.prototype.createBackground = function() {
    this._img4 = new Sprite();
    this._img4.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img4);
    this.addChild(this._img4);
};
Scene_Manual.prototype.start = function() {
    Scene_MenuBase.prototype.start.call(this);
};
Scene_Manual.prototype.createL1 = function() {
    this._L1 = new Window_Help(2);
    this.addWindow(this._L1);
};
Scene_Manual.prototype.createL2 = function() {
    var x = 0;
    var y = 108;
    var width = 816;
    var height = 516;
    this._L2 = new Window_Manual(x, y, width, height);
    this._L2.setHandler('ok',     this.selects.bind(this));
    this._L2.setHandler('cancel', this.selectf.bind(this));
    this.addWindow(this._L2);
    this._L2.setHelpWindow(this._L1);
};
Scene_Manual.prototype.selects = function(){
    this._data=this._L2.item();
    this._position=this._L2.getPosition();
    if (this._data[10]==true) {
        this._L2.deactivate();
        this._L2.hide();
        this._L3.activate();
        this._L3.setData(this._data);
        this._L3.show();
        this._L3.refresh();
    }else{
        this._L2.activate();
        this._L2.select(this._position);
    }
};
Scene_Manual.prototype.selectf = function() {
    SceneManager.pop();
};
Scene_Manual.prototype.createL3 = function() {
    this._L3 = new Window_ManualNumber(0,108,816,516);
    this._L3.setHandler('ok',     this.L3Ok.bind(this));
    this._L3.setHandler('cancel', this.L3Cancel.bind(this));
    this.addWindow(this._L3);
};
Scene_Manual.prototype.L3Ok = function() {
	this._L3.activate();
    this.doSyn(this._L3.number());
};
Scene_Manual.prototype.L3Cancel = function() {
    this._L3.hide();
    this._L3.deactivate();
    this._L2.show();
    this._L2.activate();
    this._L2.select(this._position);
};
Scene_Manual.prototype.doSyn = function(number) {
    var x=[];
    var bo=true;
    for (var i=0;i<10;i++) {
        if (this._data[i][0]=='weapon') x[i]=$dataWeapons[this._data[i][1]];
        else if (this._data[i][0]=='armor') x[i]=$dataArmors[this._data[i][1]];
        else if (this._data[i][0]=='item') x[i]=$dataItems[this._data[i][1]];
        else x[i]=0;
    }
    for (var i=1;i<=9;i++) {
        if ($gameParty.numItems(x[i])<number && x[i]!=0) {bo=false;this._L3._fail=true;break;}
    }
    if ($gameParty.numItems(x[0])+number>$gameParty.maxItems(x[0])) {
    	bo=false;
    	this._L3._fail=true;
    }
    if (bo==true) {
        $gameParty.gainItem(x[0], number);
        for (var j=1;j<=9;j++) {
            if (x[i]==0) continue;
            $gameParty.loseItem(x[j], number);
        }
        SoundManager.playOk();
        this._L3.refresh();
    } else {
    	SoundManager.playBuzzer();
    }
};
//-----------------------------------------------------
//图鉴窗口
//-----------------------------------------------------
function Window_Manual() {
    this.initialize.apply(this, arguments);
};
Window_Manual.prototype = Object.create(Window_Selectable.prototype);
Window_Manual.prototype.constructor = Window_Manual;
Window_Manual.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._data = [];
    this._candata = [];
    this.refresh();
};
Window_Manual.prototype.maxCols = function() {
    return 3;
};
Window_Manual.prototype.standardPadding = function() {
    return 25;
};
Window_Manual.prototype.lineHeight = function() {
    return 230;
};
Window_Manual.prototype.makeItemList = function() {
    this._candata = [];
    this._data = HG.Synthetise.List;
    if ($gameMap._allSyn==true) {
        this._candata=this._data;
        return;
    }
    for (var i=0;i<this._data.length;i++) {
        if ($gameMap._manual[i]==true) this._candata.push(this._data[i]);
    }
};
Window_Manual.prototype.maxItems = function() {
    return this._candata ? this._candata.length : 1;
};
Window_Manual.prototype.item = function() {
    var index = this.index();
    return this._candata && index >= 0 ? this._candata[index] : null;
};
Window_Manual.prototype.isCurrentItemEnabled = function() {
    if (this._candata[this.index()]) return this._candata[this.index()][10];
    else return false;
};
Window_Manual.prototype.selectLast = function() {
    var index = this._candata.indexOf($gameParty.lastItem());
    this.select(index >= 0 ? index : 0);
};
Window_Manual.prototype.getPosition = function() {
    return this.index();
};
Window_Manual.prototype.drawItem = function(index) {
    var item = this._candata[index];
    if (item) {
        var rect = this.itemRect(index);
        this.contents.fontSize = 14;
        this._backgroundSprite = new Sprite();
        this._backgroundSprite.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img6);
        this._backgroundSprite.x=rect.x+25;
        this._backgroundSprite.y=rect.y+25;
        this.addChildToBack(this._backgroundSprite);
        this.contents.paintOpacity = 100;
        if (item[10]==true) this.contents.paintOpacity = 255;
        var num=[[rect.x+190,rect.y+100]];
        num=num.concat([[rect.x+15,rect.y+35],[rect.x+70,rect.y+35],[rect.x+125,rect.y+35]]);
        num=num.concat([[rect.x+15,rect.y+100],[rect.x+70,rect.y+100],[rect.x+125,rect.y+100]]);
        num=num.concat([[rect.x+15,rect.y+155],[rect.x+70,rect.y+155],[rect.x+125,rect.y+155]]);
        for (var i=0;i<10;i++) {
            if (item[i][0]==0) continue;
            if (item[i][0]=='weapon') {
                iconIndex=$dataWeapons[item[i][1]].iconIndex;
                name=$dataWeapons[item[i][1]].name;
            }
            if (item[i][0]=='armor') {
                iconIndex=$dataArmors[item[i][1]].iconIndex;
                name=$dataArmors[item[i][1]].name;
            }
            if (item[i][0]=='item') {
                iconIndex=$dataItems[item[i][1]].iconIndex;
                name=$dataItems[item[i][1]].name;
            }
            this.drawIcon(iconIndex,num[i][0],num[i][1]);
            this.drawText(name,num[i][0]-6,num[i][1]-70,40, 'center');
        }
    }
};
Window_Manual.prototype.refresh = function() {
    this.makeItemList();
    this.createContents();
    this.drawAllItems();
};
Window_Manual.prototype.updateHelp = function() {
    if (this.item()==null) return;
    var list=this.item()[0];
    if (list[0]=='weapon') list=$dataWeapons[list[1]];
    if (list[0]=='armor') list=$dataArmors[list[1]];
    if (list[0]=='item') list=$dataItems[list[1]];
    this.setHelpWindowItem(list);
};
//-----------------------------------------------------
//批量合成窗口
//-----------------------------------------------------
function Window_ManualNumber() {
    this.initialize.apply(this, arguments);
}
Window_ManualNumber.prototype = Object.create(Window_Selectable.prototype);
Window_ManualNumber.prototype.constructor = Window_ManualNumber;
Window_ManualNumber.prototype.initialize = function(x, y, width, height) {
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this._data=[];
    this._number=1;
    this.refresh();
    this._fail=false;
};
Window_ManualNumber.prototype.refresh = function() {
    this.contents.clear();
    this._img8 = new Sprite();
    this._img8.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img8);
    this._img8.x=0;
    this._img8.y=-108;
    this.addChildToBack(this._img8);
    this.drawData();
    this.drawNumber();
    this._img5 = new Sprite();
    this._img5.bitmap = ImageManager.loadSystem(HG.Synthetise.Data.Img5);
    this._img5.x=0;
    this._img5.y=-108;
    this.addChild(this._img5);
};
Window_ManualNumber.prototype.setData = function(value) {
    var x=[];
    this._data=value;
    if (this._data.length==0) return;
    for (var i=0;i<10;i++) {
        if (this._data[i][0]=='weapon') x[i]=$dataWeapons[this._data[i][1]];
        else if (this._data[i][0]=='armor') x[i]=$dataArmors[this._data[i][1]];
        else if (this._data[i][0]=='item') x[i]=$dataItems[this._data[i][1]];
        else x[i]=0;
    }
    this._data=x;
};
Window_ManualNumber.prototype.isCurrentItemEnabled = function() {
    for (var i=1;i<=9;i++) {
        if ($gameParty.numItems(this._data[i])<this._number && this._data[i]!=0) return false;
    }
    return true;
};
Window_ManualNumber.prototype.drawData = function() {
    if (this._data.length!=0) {
        var num=[[370,180],[30,80],[130,80],[230,80],[30,180],[130,180],[230,180],[30,280],[130,280],[230,280]];
        for (var i=0;i<10;i++) {
            if (this._data[i]==0) continue;
            this.drawIcon(this._data[i].iconIndex,num[i][0]+27,num[i][1]+6);
            this.contents.fontSize = 18;
            this.drawText(this._data[i].name,num[i][0]+3,num[i][1]+36,84, 'center');
            if (i!=0) this.drawText("余量："+$gameParty.numItems(this._data[i]), num[i][0]+3, num[i][1]+58, 84, 'center');
        }
    }
};
Window_ManualNumber.prototype.number = function() {
    return this._number;
};
Window_ManualNumber.prototype.update = function() {
    Window_Selectable.prototype.update.call(this);
    this.processNumberChange();
};
Window_ManualNumber.prototype.processNumberChange = function() {
    if (this.isOpenAndActive()) {
        if (Input.isRepeated('right')) {
            this.changeNumber(1);
        }
        if (Input.isRepeated('left')) {
            this.changeNumber(-1);
        }
        if (Input.isRepeated('up')) {
            this.changeNumber(10);
        }
        if (Input.isRepeated('down')) {
            this.changeNumber(-10);
        }
    }
};
Window_ManualNumber.prototype.changeNumber = function(amount) {
    var lastNumber = this._number;
    this._number = (this._number + amount).clamp(1, 99);
    if (this._number !== lastNumber) {
        SoundManager.playCursor();
        this.refresh();
    }
};
Window_ManualNumber.prototype.drawNumber = function() {
    this.resetTextColor();
    this.contents.fontSize = 36;
    this.drawText(HG.Synthetise.Data.Text4, 480, 205, 220, 'right');
    this.drawText(this._number, 645, 205, 90, 'right');
    this.drawText(HG.Synthetise.Data.Text5, 690, 205, 90, 'right');
};
Window_ManualNumber.prototype.playOkSound = function() {
    if (this._fail==true) {
    	this._fail=false;
    	SoundManager.playBuzzer();
    }
};
//-----------------------------------------------------
//菜单重设
//-----------------------------------------------------
Synthtise = Scene_Menu.prototype.createCommandWindow;
Scene_Menu.prototype.createCommandWindow = function() {
    Synthtise.call(this);
    this._commandWindow.setHandler('syn',       this.commandSyn.bind(this));
};
Scene_Menu.prototype.commandSyn = function() {
    SceneManager.push(Scene_Synthetise);
};
Synthtise_add = Window_MenuCommand.prototype.makeCommandList;
Window_MenuCommand.prototype.makeCommandList = function() {
    Synthtise_add.call(this);
    if (HG.Synthetise.menu) this.addCommand("制造", 'syn', true);
};
//-----------------------------------------------------
//菜单重设
//-----------------------------------------------------