//=============================================================================
// RPG Maker MV
//=============================================================================
/*:
 * @plugindesc 弹幕插件[V4.3]
 * @author Qiu Jiu
 *
 *
 * @help
 * ===============================================================================
 * ================================================================
 * 一.插件说明
 * ================================================================
 * 1.您需要在img/bullets下存放子弹/弹幕文件。
 * 2.考虑性能，最好将事件的默认刚体形状定为矩形而非圆形。且尽量减少一颗子弹的存在时间。
 *      也就是均衡“一定时间内子弹的存在量”。
 * 3.系统加载图片时需要几帧的时间来加载图片，所以一个子弹发射时，若其子弹图片是第一次使用，那么
 *      子弹的图像会延迟几帧才加载出来，对于部分存在和淡出总时长在大概20帧以上的子弹来说此问题
 *      影响甚微。但是对于一些只出现几帧的子弹来说影响很大，所以加入了“预载图片”的功能。
 *      只要在预载栏里把对应的文件名写上，那么系统就会对其进行预载，在第一次使用该图片作为子弹
 *      时不需要延迟加载。 
 *
 *
 *
 * ===============================================================================
 * ================================================================
 * 二.脚本指令与范例
 * ================================================================
 * 1.基础子弹发射：系统预设了一个最基础的子弹的数据，您可以通过下方的这种设置方式来修改
 *   这些默认的数据来发射一个子弹。默认的数据在下方可以查询。
 *
 *   QJ.BL.Shoot({
 *    新属性名:新属性的对应值,
 *    新属性名:新属性的对应值,
 *    新属性名:新属性的对应值
 *   });
 *
 *   例如在默认的基础上修改Action和Anim：
 *
 *   QJ.BL.Shoot({
 *    Action:["SS[A,true]"],
 *    Anim:1
 *   });
 *
 *   其他：
 *
 *   QJ.BL.Shoot({
 *    
 *   });
 *
 * ===============================================
 *      initialRotation:默认为"PD[]"。子弹的朝向，0-360度。0度时朝上，90度朝右，180度朝下，以此类推。
 *          除此之外还可以写转义字符，包含转义字符时需加英文引号:
 *          "M[]"朝向鼠标。
 *          "PD[]"朝向玩家所在方向。玩家朝右时90度，朝左时270度，以此类推。
 *          "D[数字]"朝向指定事件所朝方向，此事件的朝向为右时为90度，为下时为180度，以此类推。
 *              写0代表本事件。
 *              若数字写0且在公共事件里执行，则该发射子弹的指令无效。
 *          "P[]"对准玩家位置发射。
 *          "E[事件id]"对准事件位置发射。例如"E[5]"即发射时自动对准事件5。
 *          "EV[变量id]"对准由变量指定的事件的位置发射。
 *          "X[数字]Y[数字]"对准某画面XY位置发射，此处是发射时刻的屏幕坐标。例如"X[100]Y[100]"。
 *          "XM[数字]YM[数字]"对准某地图XY位置，此处是发射时刻的地图坐标。
 *          "G[事件集合编号]"对准某个事件集合中距离此子弹发射位置最近的事件发射。
 *          "N[特殊编号]"让此子弹朝向备注中含有[特殊编号]的事件中离发射点最近的事件。
 * ===============================================
 *      x/y:默认为"P[]"。发射时的X位置和Y位置，此处是发射时刻的屏幕坐标，填整数。
 *          "M[]"代表鼠标的X/Y位置。
 *          "P[]"代表玩家的X/Y位置。
 *          "E[0]"代表本事件。
 *          "E[事件id]"代表指定id的事件。
 * ===============================================
 *      z:默认为"C[]"。子弹的Z值,可以填:
 *           "T[]"让子弹显示在地图下，玩家与事件之下，图片之下。
 *           "M[]"让子弹显示在地图上，玩家与事件之下，图片之下。
 *           "C[]"让子弹显示在地图上，玩家与事件之上，图片之下。
 *           "P[]"让子弹显示在地图上，玩家与事件之上，图片之上。
 * ===============================================
 *      scaleX:默认为100。子弹图像的横向（宽度）放大率，单位为%。
 *          可以写类似"0|100~10|200~20|300"的格式用来设计动态放大缩小的效果。
 *          即在初始时放大率为100，第10帧时变为200，第20帧时变为300。长度可变。
 * ===============================================
 *      scaleY:默认为100。子弹图像的纵向（高度）放大率，单位为%。
 *          可以写类似"0|100~10|200~20|300"的格式用来设计动态放大缩小的效果。
 *          即在初始时放大率为100，第10帧时变为200，第20帧时变为300。长度可变。
 * ===============================================
 *      MoveType:默认为"S[]"。子弹的移动类型，代表不同的移动方式。
 *           "S[]"发射后角度不变,直直地向前走（Straight）。0
 *           "TP[最小转角]"发射后追踪玩家（Trace Player）。1
 *           "TE[最小转角,事件id]"发射后追踪指定id的事件（Trace Event）。2
 *           "TEV[最小转角,变量id]"发射后追踪数字所指定的id的事件（Trace Event Base On Variable）。3
 *           "TG[最小转角,事件集合编号]"追踪某个事件集合中距离此子弹最近的事件（Trace Group）。4
 *           "TN[最小转角,特殊编号]"对备注中含有[特殊编号]的事件中离发射点最近的事件进行追踪（Trace Nobi）。7
 *           "QP[一倍宽度,发射角度,一倍时间,次数]"让此子弹的轨迹为抛物线（Quadratic parabola）。6
 *                  此选项需要考虑的因素比较多，所以若想使用，请使用预设QJ.BL.Shooter_HandGrenade.
 *           "B[指定id,朝下x偏移,朝下y偏移,朝左x偏移,朝左y偏移,朝右x偏移,朝右y偏移,朝上x偏移,朝上y偏移]"
 *                  发射后让此子弹粘附在某事件上，不会移动。速度大于0时也不会移动。        5
 *                  指定id:-1玩家 0当前事件 其他数字代表指定事件。基础项为为"B[-1,0,0,0,0,0,0,0,0]"
 *           "F[函数]"使用函数来定义路径，具体输入可参考Particles下的moveType。（function）
 *                  例如直线为："F[-8*t;0]"或"F[-8*t|0]"。       8
 *                  注意！使用此轨迹后，ReBound参数将无效，也就是使用此移动类型的子弹无法反弹！
 *                  注意！使用此轨迹后，与速度有关的参数（包括speed）也将无效！
 * ===============================================
 *      rTRotation:默认为""。特殊的旋转角度附加。
 *          可以写类似"10|30~50|15~100|-20"的格式来指定在某时刻突变的角度。
 *          即在第10帧时突然顺时针旋转30度，第50帧时突然顺时针旋转15度，第100帧时突然逆时针旋转20度。
 * ===============================================
 *      Regions:默认为[]。子弹消失的区域id列表，当子弹与列表中包含的区域相碰撞时子弹消失。
 *              注意，只能写以下数字（即只能使用以下区域）：1 2 3 4 5 6 7 8。
 *              例如写[1,5]时子弹在碰到区域1或5时消失。
 * ===============================================
 *      Terrains:默认为[]。子弹消失的地形id列表，当子弹与列表中包含的地形相碰撞时子弹消失。
 *              注意，只能写以下数字：1 2 3 4 5 6 7。
 *              例如写[1,5]时子弹在碰到地形1或5时消失。
 * ===============================================
 *      Target:默认为[]。此子弹可以打中的事件的列表，可以在[]中写下面的语句，不同的语句间用，隔开。
 *          "E[事件id]"让此子弹可以打中某id的事件，除非此事件被执行了“暂时消除事件”的指令，否则
 *              子弹一直能打到该事件。
 *          "G[事件列表的id]"我们可以在一个事件的某个事件页的第一行中写<Group:"事件列表的id">。
 *              当该事件的当前事件页为该事件页时，该事件就能被target中有"G[事件列表的id]"的子弹打到。
 *              例如<Group:"enemy">和"G[enemy]",可查看范例来进一步理解。
 *          "EV[数字]"让此子弹能够攻击当前地图上由变量指定的某id的事件。
 *          "P[]"让此子弹能够攻击玩家。
 *          "Nobi[T]"我们可以在某个事件的备注中写[特殊编号],那么此子弹就能攻击到该事件。
 *              例如在某些事件的备注中写[T],而这里写["Nobi[T]"],那么子弹将能够攻击到这些事件。
 * ===============================================
 *      Pierce:默认为0。子弹的穿透能力，写数字代表穿透次数，只能写大于等于0的整数。
 *          使用此功能可以做穿透弹。穿透只能穿透事件，无法穿透设为墙壁的区域和地形。
 *          写0:此子弹在第一次与别的事件相接触后就消失。
 *          写其他正整数 :此子弹可以穿透几次。
 * ===============================================
 *      Img:默认为"bullet0"。图片文件名。此处图片放在游戏目录的img/bullets下。
 *          可以在电脑/手机本地的图片文件名的后边写[帧数,速度]。也就是[frames,speed]。
 *          例如写flash1[4,5]时，整个图片被纵向切成四竖列，然后由左到右循环播放，每两竖列间等待5帧。
 *          
 *          除了直接写文字(整体加上英文引号)来设置子弹的插件外，也可以直接复制此刻某个事件/玩家此刻的行走
 *          图来制作残影，需要写数组(整体不加引号)：
 *          [0,目标id]
 *          0是固定的数字，不能修改，以便以后扩展其他功能。使用此功能时，下方的AnchorY将默认为1而非0。
 *          目标id写-1时复制此刻玩家的行走图，0为本事件的行走图，大于0的数为指定id的行走图。
 *          例如写[0,-1]可以将当前玩家的行走图作为子弹的外形。
 *          
 *          当然也可以直接将文字作为弹幕发射出去：
 *          [1,文字内容,文字颜色,文字字号,文字排列方式,文本子弹最大宽度,文本子弹最大高度,描边颜色,描边粗细]
 *          文字颜色/描边颜色:十六进制颜色或者渐变["0|初始文字颜色~1|终止文字颜色",角度]
 *          文字排列方式:0竖排  1横排
 *
 *          当然可以直接用图标。
 *          [2,图标编号]
 * ===============================================
 *      Anim:默认为0。子弹消失后播放的动画id。写0时不播放动画。
 * ===============================================
 *      DeadCount:默认为0。子弹在要消失的时候，变透明（淡出）所需的时间，单位为帧数。
 *          注意！子弹接触到可以触碰的事件的时候，首先执行Action，然后播放动画，播放动画的同时进行淡出。
 *          当子弹动画播放完且淡出成功（不透明度已经是0了）的时候子弹完全消失（被清除）。
 * ===============================================
 *      Speed:默认为12。子弹运动的速度，写正整数，单位是像素/每帧。一般来说，这里的速度写6-28比较好。
 *          除了写数字外，也可以写例如"0|6~4|12~8|18"格式的字符串。这个字符串的意思是在子弹运行的第
 *          0帧时移速变为6，在4帧时移速变为12，在8帧时移速变为18。
 *          基础格式为"0|初始速度~第一次移速改变的帧数|第一次移速改变为多少~第二次帧数|第二次移速~……"。
 *          每个改变的时刻与速度中间用|分割，然后再用~分割不同的变化次序。
 *          又例如，"0|0~60|12~120|24"代表发射后一秒内不动，接下来一秒以12的速度运动，再接下来的
 *          一秒以24的速度运动。
 *          （写负数将产生无法预知的bug，要想让子弹拐弯请使用rTRotation参数来指定。）
 * ===============================================
 *      Max:默认为120。子弹能够移动的帧数。
 *          也就是说，这里的Speed是速度，Max是时间，Speed乘Max就是移动的最大像素数（路程）。
 * ===============================================
 *      RotationAuto:默认为-1。旋转速度，写下面指定的数字。子弹图片一般是朝上的，也就是说一般图片的上方是子弹的头，
 *          整个子弹图片会进行旋转，方向与运动轨迹相切，以表现某些追踪弹“拐弯”的效果。但是有些可回旋的武器不需要“方
 *          向与运动轨迹相切”，“运动的转角”与“图片本身的转角”并不需要同步，例如圆形的飞镖。
 *          写-1:“运动的转角”与“图片本身的转角”同步，一般的时候写-1即可。
 *          写0:角度不变。
 *          写1-360的正整数:固定旋转角度。
 *          写361-1080的正整数:“运动的转角”与“图片本身的转角”不同步。且 此数字减720 代表旋转速度(减720后可为负时逆时针，减720后可
 *              为正时顺时针)，单位为度/帧。
 * ===============================================
 *      Action:默认为[]。触发后执行的指令的列表。
 *          "C[公共事件id]"执行公共事件。
 *          "S[id,value]"将某开关打开或者关闭。此处value只能填true或者false。例如"S[1,true]"代表打开1号开关。
 *          "SS[id,value]"将被攻击到的事件的某独立开关打开或者关闭，例如"SS[A,true]"
 *          "E"对被攻击到的事件执行“暂时消除指令”，这个指令在事件指令的第二页的“人物”那一栏的最后一行。
 *          "C[公共事件id,要传入的参数1,要传入的参数2……]":执行公共事件，且传入参数。
 *              (1)可以在公共事件中访问传入的参数，例如this.BP[1]代表要传入的参数1。（Bullet Param）
 *              (2)可以在公共事件中用this.EID访问此时子弹击中的事件的id。
 *              this.EID等于-1时说明打到了玩家，this.EID等于0时说明没有打到玩家或事件，this.EID等于其他数字时说明打到了
 *              某id的事件。
 *              (3)可以直接在公共事件的各指令中使用this.EID或者this.BP[参数编号]。
 *              (4)例如:此处写"C[5,10]"，假设此子弹碰撞到id为3的事件，那么this.BP[1]就是10，this.EID就是3。
 *              (5)可以用this.bullet.x和this.bullet.y获得子弹消失时的位置。
 *              (6)可以使用this.bullet.x和this.bullet.y来获得此时此子弹的坐标。
 *                 可以使用这个值来制作更丰富的子弹。
 *          "CP[id]":直接额外执行“被攻击到的事件”的某一个事件页，此处即指Rpg Maker 2000/Rpg Maker 2003中的那个
 *              “事件呼叫”中呼叫特定事件的某个事件页的功能。
 *              此功能也可以直接用QJ.BL.CallEvent(事件id,事件页id)来执行（相当于本脚本的额外功能，主要
 *              目的是方便做“事件与脚本混合”的那种ARPG）。
 *          "T[语句]"执行脚本。
 *              脚本中bulletX/bulletY可获得子弹/触发行动点的坐标，bullet获得子弹数据，tarCharacter获得
 *              对象数据。此项配合eval(QJ.BL.QuickText(预设编号))或者QJ.BL.Quick(预设编号,{})指令会
 *              很方便。
 * ===============================================
 *      CollisionBox:默认为"R[4,4]。"子弹的碰撞体积，我们设计一个图形用来代表此子弹的碰撞体积，此设定与事件的碰撞体积相同。
 *          "C[半径]"（Circle）以子弹图片的正中心为原点，画一个圆代表此子弹的碰撞体积。
 *          "R[宽,高]"（Rectangle）以一个长方形为碰撞形状。
 * ===============================================
 *      Tone:默认为[0,0,0,0]。色调，格式为[红,绿,蓝,灰度]，这里的“红,绿,蓝,灰度”与事件指令“更改画面色调”中的
 *          色调是一个意思，正常情况下是[0,0,0,0],纯红是[255,-255,-255,0]，纯黑是[0,0,0,255]。
 * ===============================================
 *      Opacity:不透明度，范围是0-255。 正常情况下写0即可。
 *          可以写类似"0|100~10|200~20|300"的格式用来设计动态变化的效果。
 * ===============================================
 *      AfterImage:默认为[]（即不显示残影）。残影的相关设置。要设置残影需要写一个数组:
 *          [颜色,不透明度,存在时间,消失时间,宽度,高度]  例如["#FF0000",150,10,60,0,0]
 *          颜色:十六进制的颜色表示方式，例如"#FF0000"。
 *              这里的颜色也可以动态指定（极大消耗资源），指定方式与speed的指定方式类似，这里只举一个例子。
 *              ["0|#0000FF~60|#00FF00~120|#FF0000",100,10,50,0,0]
 *              子弹会在运行的第0-60帧内有蓝色（#0000FF）的拖尾效果。
 *              子弹会在运行的第60-120帧内有绿色（#00FF00）的拖尾效果。
 *              子弹会在运行的第120-结束帧内有红色（#FF0000）的拖尾效果。
 *              这三种拖尾效果的初始不透明度均为100，均持续10帧后淡出，均花费50帧进行淡出。
 *          不透明度:残影出现时的不透明度，在消失时将逐渐变成0。
 *          存在时间:残影存在的时间，指出现到准备淡出的时间。
 *          消失时间:淡出的时间。
 *          宽度和高度:指残影的大小，写0时自动加载默认值。
 * ===============================================
 *      Light:默认为[]（即不显示光效）。在子弹附近显示光效。在同时装有TerraxLighting.js的前提下此
 *          选项才能起效，在子弹附近显示光效。
 *          "L[颜色,大小]"显示圆形的光效，目前只能指定颜色和大小。
 *          !!!此数据已暂时废弃，目前无法使用此效果!!!
 * ===============================================
 *      Particles:默认为[]（即不启用粒子效果）。
 *          在子弹附近显示粒子效果,注意，此项较为复杂，所以若想制作简单的效果，请使用预设。
 *          []中可以写粒子数据，粒子数据{}中可以写的参数有：
 *          img:"gas"或者"gas[5,5]"之类的。
 *          offsetX:粒子发射点相对子弹中心的偏移。
 *          offsetY:粒子发射点相对子弹中心的偏移。
 *          dir:发射方向，此方向是相对子弹方向的方向。注意此处单位为弧度而非角度。
 *          dirOffset:发射方向的最大偏移范围，写0则不偏移。注意此处单位为弧度而非角度。
 *          speed:速度。
 *          max:最大存在时间。
 *          deadCount:淡出时间。
 *          opacityMin:初始最小不透明度。注意此处的范围为0-1而非0-255。
 *          opacityMax:初始最大不透明度。注意此处的范围为0-1而非0-255。
 *          scaleMin:最小放大率。注意此处的范围为0-1而非0-100。
 *          scaleMax:最大放大率。注意此处的范围为0-1而非0-100。
 *          moveType:移动方式，此处写过零点且在移动范围内连续(否则效果会很奇怪或者无效)的参数函数。
 *              默认为"-8*t;0",8;符号分割x和y。以粒子所朝方向为x轴正半轴，以此轴顺时针方向旋
 *              转90度为y轴建系的话，粒子存活t帧时，粒子的相对坐标就为(-8*t,0),即x=-8*t,y=0,也就是粒子将匀速后退。
 *              此处函数不过零点或者函数过于复杂将导致无法预知的问题，若想简单使用请使用
 *              预设，若想做复杂的效果请联系我。
 *              可能可以用到的值:
 *              ***默认后退"-8*t;0".
 *              ***正弦抖动(其中24和3为可调值)"-8*t;24*Math.sin(t/3)"粒子会朝左右摆动.
 *              ***螺线旋转(其中2为可调值)"t/2*Math.cos(t/2);t/2*Math.sin(t/2)"粒子会以生成点为
 *                  圆心进行旋转半径逐渐增大的圆周运动，也就是绕螺线运动.
 *              为了有更好的效果，此处也支持极坐标方程，使用极坐标方程时应用|分割。
 *              若一个极坐标方程为ρ=sin(θ)，则此时应该写"Math.sin(t)|t",以t代替θ进行动态选变化。
 *              |前的式子中t代表时间，总会变化。t后的数字代表t与θ的关系，故实际上是"ρ(t)|θ(t)".
 *              ***默认后退"-8*t|0".
 *              ***三叶玫瑰线"144*Math.sin(3*t/180)|t/180"
 *          wait:两次发射粒子的间隔。
 *          num:一次发射的粒子数量。
 *              默认参数的粒子为:
 *              {
 *              img:null,
 *              offsetX:0,
 *              offsetY:0,
 *              dir:Math.PI,
 *              dirOffset:Math.PI/6,
 *              max:30,
 *              deadCount:60,
 *              opacityMin:0.5,
 *              opacityMax:1,
 *              scaleMin:0.5,
 *              scaleMax:1.5,
 *              moveType:"0",
 *              wait:2,
 *              num:1
 *              }
 * ===============================================
 *      AtkRange:默认为0。攻击范围，写数字。
 *          若此处写0，则子弹在碰到指定敌人事件后便执行一次Action，然后消失。若碰到上方指定的
 *          区域或者地形，或者到达最大持续时间，那么直接消失（ReBound是true则是反弹）。
 *          若此处写大于0的数字，则子弹在碰到指定敌人事件后，不针对该敌人进行一次Action，而是
 *          以子弹消失位置为中心创建一个临时的圆形碰撞体，这里的数字就代表圆的半径，然后对检测
 *          到的敌人均执行一次Action。在碰到上方指定的区域或者地形，或者到达最大持续时间时，直
 *          接消失（DeadAction是true时也进行一次范围检测）。
 * ===============================================
 *      WaitBaseOnSpeed:默认为-2。此项可填以下数字：
 *          -2无效果。
 *          -1该子弹无法攻击敌人。但是可以通过打开DeadAction或NoCollisionAction
 *          （不包括PierceAction）且使AtkRange>0来使该子弹在碰到墙壁或要消失时进行一次范围攻击。此功能的
 *          主要目的是用来做倒计时炸药，在抛射的中途不会攻击，而是在撞到墙或者要消失（计时快结束）时才进行
 *          攻击。
 *          0该子弹的速度为0时才能攻击敌人和碰撞墙壁。此功能主要是用来做触发试地雷，在地雷被抛射（地雷枪）或放置时
 *          （此时作为地雷的子弹速度不是0）无法攻击敌人，在放置完成（不再移动，速度为0）时才可以攻击敌人。
 *          大于0的整数：只有当子弹的速度为此值时子弹才能攻击敌人。
 * ===============================================
 *      DeadAction:默认为false。当子弹没有击中敌人，而是碰到上方指定的区域或者地形时，
 *          是否执行一次范围检测，此项只在上方的AtkRange非0时起效。
 * ===============================================
 *      PierceAction:默认为false。穿透时是否执行Action。
 *          当此项为true且上方指定的Pierce的值大于0时，子弹在穿透敌人时也会对敌人造成伤害。
 *          且上方指定的AtkRange大于0时，在穿透处进行范围检测。
 * ===============================================
 *      NoCollisionAction:默认为false。子弹到达最大存在时间时还未触碰到墙壁或事件时，若AtkRange>0
 *          则是否在消失处进行一次范围检测。
 *          注意，此项能执行说明子弹没有直接攻击到敌人，那么AtkRange要大于0，否则会出bug。
 * ===============================================
 *      DeadAnim:默认为true。子弹到触碰到墙壁或事件时，是否显示动画。
 * ===============================================
 *      PierceAnim:默认为false。子弹进行穿透时，是否显示动画。
 *          子弹进行穿透时，也在进行移动。所以在看到动画播放时，子弹可能已经走远了。
 * ===============================================
 *      NoCollisionAnim:默认为false。子弹到达最大存在时间时还未触碰到墙壁或事件时，是否显示动画。
 *          注意，此项能执行说明子弹没有直接攻击到敌人，那么AtkRange要大于0，否则会出bug。
 * ===============================================
 *      ReBound:默认为false。子弹是否可以反弹，这个选项为true时，子弹可以在碰到指定的地形或者
 *           区域时进行反弹，反弹与穿透（Pierce）无关，且无法在碰到事件时反弹。
 * ===============================================
 *      AnchorX:默认为0.5。子弹图片的中心横向描点，范围为0-1。
 * ===============================================
 *      AnchorY:默认为0。子弹图片的中心纵向描点，范围为0-1。
 * ===============================================
 *      LMD:默认为true（即Leave Map Disappear）。
 *          若此选项为true则当子弹移动到地图（不是屏幕）外围时子弹直接消失。此功能可以用来直接删掉
 *          一些已经无用的超过地图的子弹。
 *          若为false时则不这么做。
 * ===============================================
 *      Update:默认为""。（需JavaScript基础）在此将脚本写成字符串或函数，那么子弹的每一帧都会执行此
 *          脚本/函数，若为函数则可使用arguments[0]或者第一个参数名来获得子弹的“this”对象指针。
 * ===============================================
 *      Bit:默认为false。打开此开关后子弹将不会进行碰撞检测。
 * ===============================================
 *      DeadT:默认为""。在执行Action前必定执行的额外脚本（字符串或完整的函数）。(需要JS基础)
 * ===============================================
 *      Name:为弹幕指定一个名字，然后可以使用QJ.BL.deleteBullet(Name);来直接删除指定名字的弹幕。
 * ================================================================
 * 2.以玩家或者某事件所在朝向为基础，精细化设定发射点，在一定角度的范围内发射一定数量的子弹。
 *   QJ.BL.Shooter_CharacterAtk(character,{},[ox2,oy2,ox4,oy4,ox6,oy6,ox8,oy8],[r1,r2,num,l]);或
 *   QJ.BL.Shooter_CharacterAtk(character,{},[ox2,oy2,ox4,oy4,ox6,oy6,ox8,oy8]);
 *
 *   character:写数字，-1为玩家，0为本事件，大于0为指定id的事件。
 *
 *   [ox2,oy2,ox4,oy4,ox6,oy6,ox8,oy8]:为各朝向的具体xy偏移。
 *
 *   [r1,r2,num,l]:
 *   r1和r2为附加的角度，r1为附加的起始角度，r2为附加的终止角度。
 *   num为在这个范围内发射的子弹数。
 *   l为角度波动数。子弹在某范围内一般是均匀分布，l等于0时无效果，l大于0时
 *   会使角度在l度内波动。
 *
 *   而{}是要发射的子弹的额外数据，与1中的设置相同，此函数的每一个子弹都会
 *   被赋予这些数据。额外数据很明显不包括initialRotation。
 *
 *   也可以用QJ.BL.Shooter_ArcRange(initialRotation,{},[r1,r2,num,l])
 *   来直接在指定角度内发射子弹。
 * ================================================================
 * 3.调用预设：
 *   直接调用插件参数中“预设指令”中的指令,然后在此基础上进行修改。
 *   QJ.BL.Quick(预设编号,{})
 *   直接调用插件参数中“文字预设指令”中的指令。
 *   eval(QJ.BL.QuickText(预设编号))
 * ================================================================
 * 4.执行当前地图某事件的事件页中的指令（额外功能，用于某些ARPG的制作，不用可以忽略）
 *   QJ.BL.CallEvent(事件id,事件页id)
 * ================================================================
 * 5.清除所有子弹
 *   QJ.BL.ClearAll()
 * ================================================================
 * 6.打开或者禁用鼠标/手指点击移动。
 *   如果点击能同时让玩家移动，又能让玩家发射子弹，那会让情况变得……很怪异。
 *   QJ.BL.SetMove(true)允许原本的点击移动
 *   QJ.BL.SetMove(false)禁用原本的点击移动
 * ================================================================
 * 7.在指定地方构造碰撞体，对与此碰撞体碰撞到的目标执行action。
 *   碰撞体进行一次检测后便直接消失。相当于一个闪现的子弹。
 *   QJ.BL.DirectAction(X,Y,CollisionBox,Action,Target);
 *   各个数据与1中的数据相同。
 * ================================================================
 * 8.获得此时子弹的数量
 *   $gameMap.bulletsNumber()
 * ================================================================
 * 9.角色残影
 *   QJ.BL.Shadow(id,{})
 *   id是指谁产生残影，-1是玩家0是本事件，大于0的整数是别的事件。
 *   {}中写可调的参数。
 * ================================================================
 * 10.
 *
 * 旧调用方法1：
 * QJ.BL.ShootOld(initialRotation,x,y,z,MoveType,Regions,Terrains,Target,Pierce,Img,Anim,
 *   DeadCount,Speed,Max,RotationAuto,Action,CollisionBox,Tone,Opacity,AfterImage,
 *   AtkRange,Light,DeadAction,PierceAction,NoCollisionAction,DeadAnim,PierceAnim,NoCollisionAnim,
 *   ReBound,AnchorX,AnchorY,rTRotation,WaitBaseOnSpeed,scaleX,scaleY,LMD,Update,Bit,DeadT,Particles);
 *
 * 旧调用方法默认值1：
 * QJ.BL.ShootOld("PD[]","P[]","P[]","C[]","S[]",[],[],[],0,"bullet0",0,
 *   0,12,120,-1,[],"R[4,4]",[0,0,0,0],255,[],
 *   0,[],false,false,false,true,false,false,
 *   false,0.5,0,"",-2,100,100,true,"",false,"",[]);
 *  （注意，Particles那一项及以后的项可以不写，不写则使用默认值）
 *
 * 旧调用方法2：
 * QJ.BL.Shoot(initialRotation,x,y,x,MoveType,Regions,Terrains,Target,Pierce,Img,Anim,
 *   DeadCount,Speed,Max,RotationAuto,Action,CollisionBox,Tone,Opacity,Effect,AtkRange);
 * 注意，旧调用方法2中的 Effect 选项已废弃，无论填什么都没有具体效果。旧调用方法2的函数名（QJ.BL.Shoot）与
 * 新使用方法（QJ.BL.Shoot({})）相同，但不会影响具体使用。
 *
 * 旧调用方法2默认值：
 * QJ.BL.Shoot("PD[]","P[]","P[]","C[]","S[]",[],[],[],0,"bullet0",0,
 *   0,12,120,-1,[],"R[4,4]",[0,0,0,0],255,"",0);
 *
 * ================================================================
 * 11.以玩家角色为中心投掷投掷物。
 * QJ.BL.Shooter_HandGrenade({},oneLength,oneTime,maxReBound);
 * ***注意，此指令使用的是moveType中的"QP[一倍宽度,发射角度,一倍时间,次数]",并进行一些
 *  系统性的数值调整以做出抛射效果。在此情况下{}中不要设定Speed和MoveType参数。***
 * ***若投掷物在弹跳结束前提早消失，那么原因是{}中Max的值小于oneTime*maxReBound，
 *  导致弹跳前就达到最大存在时间。此处Max的值最好大于oneTime*maxReBound。***
 * ***此指令预设了AtkRange的值为96，以便范围攻击。
 *
 *
 *  oneLength:单次弹跳距离
 *  oneTime:单次弹跳时间
 *  maxReBound:最大弹跳次数
 *  
 * 默认值：
 * QJ.BL.Shooter_HandGrenade({Img:"xzd"},56,30,3);
 *
 *
 * ================================================================
 * 12.以角色或事件为中心发射文字永远朝下的文字弹幕。
 * QJ.BL.Text(text,color,fontsize,linecolor,linewidth,character,{});
 * text:文字内容
 * color:文字颜色
 * fontsize:文字大小
 * linecolor:文字描边颜色
 * linewidth:文字描边大小
 * character:角色，-1时指玩家，0指本事件，大于0指指定事件。
 *
 * ***注意，此指令在指定了character后，{}内不能再写x/y/initialRotation等参数***
 *
 * ================================================================
 * 13.朝一个方向发射多个子弹，多个子弹在发射点附近排布为圆形，整体朝一个方向发射。
 * QJ.BL.Shooter_C({},r,speed,roSpeed,number,initRotation,x,y) 
 * {}:每一个子弹的公共数据
 * r:排布为圆形的半径
 * speed:所有子弹整体移动的速度
 * roSpeed:每个子弹在移动时沿着圆形旋转的(角)速度，写0.05-1之间的数据比较合适。
 * number:子弹的数量
 * initRotation:所有子弹整体移动的方向
 * x/y:坐标
 *
 * 例如：
 * QJ.BL.Shooter_C({},48,4,0.25,8,"M[]","P[]","P[]") 
 *
 * ***注意，此指令中默认的子弹图像Img为"dart"。若想修改请在{}中添加Img参数。
 *
 * ================================================================
 * 14.朝一个方向发射多个子弹，多个子弹在发射点附近排布为正多边形，整体朝一个方向发射。
 * QJ.BL.Shooter_P({},r,speed,roSpeed,number,initRotation,x,y,edgeNum) 
 * {}:每一个子弹的公共数据
 * r:正多边形的半径(多边形中心与多边形上任意一顶点的连线)
 * speed:所有子弹整体移动的速度
 * roSpeed:每个子弹在移动时沿着圆形旋转的(角)速度，写0.05-1之间的数据比较合适
 * number:多边形每条边上的子弹数(包括顶点)，此值应大于等于2，且尽量写成奇数，写偶数效果可能不佳
 * initRotation:所有子弹整体移动的方向
 * x/y:坐标
 * edgeNum:多边形的边数，注意，边数应为大于等于2的正整数
 *
 * 例如：
 * 正三角形：QJ.BL.Shooter_P({},48,4,0.25,3,"M[]","P[]","P[]",3) 
 * 正方形形：QJ.BL.Shooter_P({},48,4,0.25,3,"M[]","P[]","P[]",4) 
 * 正五边形：QJ.BL.Shooter_P({},48,4,0.25,3,"M[]","P[]","P[]",5) 
 * ***注意，此指令中默认的子弹图像Img也为"dart"。若想修改请在{}中添加Img参数。
 *
 * ================================================================
 * 15.朝一个方向发射激光，激光会反弹，对接触到的敌人造成伤害。
 *
 * QJ.BL.Laser({})
 * {}中可以写的数据有：
 * name：默认为""。此值会被记录，可以使用QJ.BL.deleteLaser(name);来删除指令激光。
 * initialRotation：默认为"M[]"。发射角度，会自动进行变化。
 *      注意，此项内PD[]和D[]不能同时出现，只能用一个（不过这两个几乎不可能合起来用吧ORZ）。
 * x/y：默认为"P[]"。发射坐标，会自动进行变化。
 * z：默认为"C[]"。
 * Action：默认为[]。与其他指令中的Action一样。
 * Regions：默认为[]。与其他指令中的Regions一样。
 * Terrains：默认为[]。与其他指令中的Terrains一样。
 * Target：默认为[]。与其他指令中的Target一样。
 * Img：默认为"laser1[2,5]"。
 * DeadCount：默认为10。消失时所需时间
 * Tone：默认为[0,0,0,0]。与其他指令中的Tone一样。
 * Opacity：默认为255。与其他指令中的Opacity一样。
 * Width：默认为12。激光判定宽度
 * AtkWait：默认为30。每两次攻击的间隔
 * ReBound：默认为10。最大反弹次数
 * Max:默认为120。最大存在时间。
 *
 * 例如（可直接使用）：QJ.BL.Laser({});
 * 
 * 若想手动消除激光可以使用：
 * QJ.BL.deleteLaser(name);
 * 来消除某个事件/玩家身上绑定的激光。
 *
 * ================================================================
 * 16.向四周发射物品，玩家触碰物品后即可获得此物品。
 * 此指令发射一个可以被当做“可捡取物品”的子弹。
 * ***注意！此指令适配MOG_TreasurePopup.js插件***
 * QJ.BL.Shooter_Gain({},type,id,num)
 * {}附加参数
 * type：获得物品的类型，写0或"item"是物品，写1或"weapon"是武器，写2或"armor"是护甲，写3时是金钱
 * id：当type是0或1或2时此数值写获得的物品/武器/护甲的id编号，此时Img主动变为该物品的图标。
 *     当type是3时，玩家获得的是金钱，id指金钱的图标，用于指定Img
 * num：获得个数
 *
 * 例如：
 * 发射获得5个id为2的物品的弹幕QJ.BL.Shooter_Gain({},0,2,5)
 * 发射获得6个id为6的武器的弹幕QJ.BL.Shooter_Gain({},1,6,6)
 * 发射获得2个id为7的护甲的弹幕QJ.BL.Shooter_Gain({},2,7,2)
 * 发射获得100金钱，且图像为5号图标的弹幕QJ.BL.Shooter_Gain({},4,5,100)
 *
 * ================================================================
 * ===============================================================================
 * ================================================================
 * 三.事件页第一行的注释中可以写:
 * ================================================================
 *   <Group:"该事件所属的事件集合的编号">
 *   这样可以将事件归类。若某事件的被触发事件页第一行没有注释，但别的未被触发的事件页的第一行有此注释，此
 *   事件同样不会被攻击到。这样可以配合着做“敌人被击败后不会再被攻击到”的效果。
 *   例如地图上有一些事件：这些事件的第一个事件页的第一行为注释，且注释中写着<Group:"enemy">
 *   且玩家发射的子弹的Target中写["G[enemy]"],那么此子弹只能攻击到上方所说的写着<Group:"enemy">的事件。
 *   若InitialRotation写成"G[enemy]"那么此子弹发射时自动对准写着<Group:"enemy">的那些事件中距离此子弹
 *   发射点最近的事件。
 * ================================================================
 * ===============================================================================
 *
 * @param ======杂项======
 * @default
 *
 * @param forBidDestination
 * @type boolean
 * @text 取消掉点击移动
 * @desc 初始时是否取消掉点击移动，注意，取消掉后也无法再直接与事件进行互动，但可以用指令恢复。
 * @default true
 * @parent ======杂项======
 *
 * @param showWarn
 * @type boolean
 * @text 是否显示警告信息
 * @desc 是否显示警告信息,调试的时候请打开
 * @default true
 * @parent ======杂项======
 *
 * @param precision
 * @type number
 * @min 1
 * @max 16
 * @text 判定精度
 * @desc 子弹判定精度范围是1-16，这个数值越小判定越精确，消耗资源越多。
 * @default 8
 * @parent ======杂项======
 *
 * @param maxbullet
 * @type number
 * @min 1
 * @text 最大子弹数
 * @desc 场上存在的子弹越多，越容易卡。
 * @default 100
 * @parent ======杂项======
 *
 * @param ======预载预设======
 * @default
 *
 * @param reserveImg
 * @type []
 * @text 预载子弹名称
 * @desc 预载子弹的图片名，同类型多个时可在一行内用|分隔。
 * @default []
 * @parent ======预载预设======
 *
 * @param preset
 * @type struct<persetdata>[]
 * @text 预设指令
 * @desc 可以使用QJ.BL.Quick(预设编号,{})来直接调用
 * @default []
 * @parent ======预载预设======
 *
 * @param presetText
 * @type struct<persetdataType>[]
 * @text 文字预设指令
 * @desc 可以使用QJ.BL.QuickText(预设编号)来直接调用，内容1/2/3将直接连起来执行。
 * @default []
 * @parent ======预载预设======
 *
*/
/*~struct~persetdataType:
 *
 * @param name
 * @type text
 * @text 此预设的编号
 * @desc 此预设的编号
 * @default 1
 *
 * @param content1
 * @type note
 * @text 内容1
 * @desc 内容1
 * @default 
 *
 * @param content2
 * @type note
 * @text 内容2
 * @desc 内容2
 * @default 
 *
 * @param content3
 * @type note
 * @text 内容3
 * @desc 内容3
 * @default 
 *
*/
/*~struct~persetdata:
 *
 * @param name
 * @type text
 * @text 此预设的编号
 * @desc 此预设的编号
 * @default 1
 *
 * @param initialRotation
 * @type combo
 * @text 初始朝向
 * @desc 初始朝向
 * @default PD[]
 * @option PD[]
 * @option M[]
 * @option D[]
 * @option P[]
 * @option E[事件id]
 * @option EV[变量id]
 * @option X[数字]Y[数字]
 * @option XM[数字]YM[数字]
 * @option G[事件集合编号]
 * @option N[特殊编号]
 *
 * @param x
 * @type combo
 * @text x
 * @desc x
 * @default P[]
 * @option P[]
 * @option E[0]
 * @option E[事件id]
 *
 * @param y
 * @type combo
 * @text y
 * @desc y
 * @default P[]
 * @option P[]
 * @option E[0]
 * @option E[事件id]
 *
 * @param z
 * @type combo
 * @text z
 * @desc z
 * @default C[]
 * @option T[]
 * @option M[]
 * @option C[]
 * @option P[]
 *
 * @param scaleX
 * @type text
 * @text x放大率
 * @desc x放大率
 * @default 100
 *
 * @param scaleY
 * @type text
 * @text y放大率
 * @desc y放大率
 * @default 100
 *
 * @param MoveType
 * @type combo
 * @text 移动类型
 * @desc 移动类型
 * @default S[]
 * @option TP[最小转角]
 * @option TE[最小转角,事件id]
 * @option TEV[最小转角,变量id]
 * @option TG[最小转角,事件集合编号]
 * @option TN[最小转角,特殊编号]
 * @option QP[一倍宽度,发射角度,一倍时间,次数]
 * @option B[指定id,朝下x偏移,朝下y偏移,朝左x偏移,朝左y偏移,朝右x偏移,朝右y偏移,朝上x偏移,朝上y偏移]
 * @option F[函数]
 *
 * @param rTRotation
 * @type text
 * @text 特殊的旋转角度附加
 * @desc 特殊的旋转角度附加
 * @default 
 *
 * @param Regions
 * @type text
 * @text 消失区域id的列表
 * @desc 消失区域id的列表
 * @default []
 *
 * @param Terrains
 * @type text
 * @text 消失地形id的列表
 * @desc 消失地形id的列表
 * @default []
 *
 * @param Target
 * @type text
 * @text 目标列表
 * @desc 目标列表"E[事件id]" "G[事件列表的id]" "EV[数字]" "P[]" "Nobi[T]"
 * @default []
 *
 * @param Pierce
 * @type number
 * @text 穿透次数
 * @desc 穿透次数
 * @default 0
 *
 * @param Img
 * @type file
 * @dir img/bullets
 * @text 图片文件名
 * @desc 图片文件名
 * @default 
 *
 * @param Anim
 * @type animation
 * @text 动画id
 * @desc 动画id
 * @default 0
 *
 * @param DeadCount
 * @type number
 * @text 淡出时间
 * @desc 淡出时间
 * @default 0
 *
 * @param Speed
 * @type text
 * @text 速度
 * @desc 速度
 * @default 12
 *
 * @param Max
 * @type number
 * @text 最大存在时间
 * @desc 最大存在时间
 * @default 120
 *
 * @param RotationAuto
 * @type text
 * @text 图像旋转速度
 * @desc 图像旋转速度
 * @default -1
 *
 * @param Action
 * @type text
 * @text 行动列表
 * @desc 行动列表"S[id,value]" "SS[id,value]" "E[]" "C[公共事件id,传参1,传参2……]"  "CP[id]" "T[语句]"
 * @default []
 *
 * @param CollisionBox
 * @type text
 * @text 碰撞体积
 * @desc 碰撞体积
 * @default R[4,4]
 *
 * @param Tone
 * @type text
 * @text 色调
 * @desc 色调
 * @default [0,0,0,0]
 *
 * @param Opacity
 * @type text
 * @text 不透明度
 * @desc 不透明度
 * @default 255
 *
 * @param AfterImage
 * @type text
 * @text 残影
 * @desc 残影 [颜色,不透明度,存在时间,消失时间,宽度,高度]
 * @default []
 *
 * @param Light
 * @type text
 * @text 光效
 * @desc 光效 [颜色,大小]
 * @default []
 *
 * @param Particles
 * @type struct<particles>[]
 * @text 粒子效果
 * @desc 粒子效果
 * @default []
 *
 * @param AtkRange
 * @type number
 * @text 攻击范围
 * @desc 攻击范围
 * @default 0
 *
 * @param WaitBaseOnSpeed
 * @type text
 * @text 特殊数值
 * @desc 特殊数值
 * @default -2
 *
 * @param DeadAction
 * @type boolean
 * @text 死亡行动
 * @desc 死亡行动
 * @default false
 *
 * @param PierceAction
 * @type boolean
 * @text 穿透行动
 * @desc 穿透行动
 * @default false
 *
 * @param NoCollisionAction
 * @type boolean
 * @text 消失行动
 * @desc 消失行动
 * @default false
 *
 * @param DeadAnim
 * @type boolean
 * @text 死亡动画
 * @desc 死亡动画
 * @default true
 *
 * @param PierceAnim
 * @type boolean
 * @text 穿透动画
 * @desc 穿透动画
 * @default false
 *
 * @param NoCollisionAnim
 * @type boolean
 * @text 消失动画
 * @desc 消失动画
 * @default false
 *
 * @param ReBound
 * @type boolean
 * @text 反弹
 * @desc 反弹
 * @default false
 *
 * @param AnchorX
 * @type text
 * @text x描点
 * @desc x描点
 * @default 0.5
 *
 * @param AnchorY
 * @type text
 * @text y描点
 * @desc y描点
 * @default 0
 *
 * @param LMD
 * @type boolean
 * @text 自动消除
 * @desc 自动消除
 * @default true
 *
 * @param Update
 * @type note
 * @text 帧刷新脚本
 * @desc 帧刷新脚本
 * @default 
 *
 * @param Bit
 * @type boolean
 * @text 是否禁止碰撞检测
 * @desc 是否禁止碰撞检测
 * @default false
 *
 * @param DeadT
 * @type note
 * @text 额外脚本
 * @desc 执行Action前的额外脚本
 * @default 
 *
*/
/*~struct~particles:
 * @param img
 * @type text
 * @text 图像
 * @desc 图像
 * @default 
 *
 * @param offsetX
 * @type number
 * @text 偏移
 * @desc 偏移
 * @default 0
 *
 * @param offsetY
 * @type text
 * @text number
 * @desc 偏移
 * @default 0
 *
 * @param dir
 * @type text
 * @text 方向
 * @desc 方向
 * @default Math.PI
 *
 * @param dirOffset
 * @type text
 * @text 方向偏移
 * @desc 方向偏移
 * @default Math.PI/6
 *
 * @param max
 * @type number
 * @text 最大存在时间
 * @desc 最大存在时间
 * @default 120
 *
 * @param deadCount
 * @type number
 * @text 淡出时间
 * @desc 淡出时间
 * @default 10
 *
 * @param opacityMin
 * @type text
 * @text 最小不透明度
 * @desc 最小不透明度
 * @default 0.5
 *
 * @param opacityMax
 * @type text
 * @text 最大不透明度
 * @desc 最大不透明度
 * @default 1
 *
 * @param scaleMin
 * @type text
 * @text 最小放大率
 * @desc 最小放大率
 * @default 0.5
 *
 * @param scaleMax
 * @type text
 * @text 最大放大率
 * @desc 最大放大率
 * @default 1.5
 *
 * @param moveType
 * @type text
 * @text 移动类型函数
 * @desc 移动类型函数
 * @default -8*t;0
 *
 * @param wait
 * @type number
 * @text 发射间隔
 * @desc 发射间隔
 * @default 2
 *
*/
//=============================================================================
//
//=============================================================================
/*!
 * pixi-particles - v4.3.0
 * License MIT
 */
this.PIXI=this.PIXI||{},function(t,i){"use strict";var e,s=function(){function i(i,e,s){this.value=i,this.time=e,this.next=null,this.isStepped=!1,this.ease=s?"function"==typeof s?s:t.ParticleUtils.generateEase(s):null}return i.createList=function(e){if("list"in e){var s=e.list,r=void 0,n=s[0],a=n.value,h=n.time,o=r=new i("string"==typeof a?t.ParticleUtils.hexToRGB(a):a,h,e.ease);if(s.length>2||2===s.length&&s[1].value!==a)for(var l=1;l<s.length;++l){var p=s[l],d=p.value,c=p.time;r.next=new i("string"==typeof d?t.ParticleUtils.hexToRGB(d):d,c),r=r.next}return o.isStepped=!!e.isStepped,o}var u=new i("string"==typeof e.start?t.ParticleUtils.hexToRGB(e.start):e.start,0);return e.end!==e.start&&(u.next=new i("string"==typeof e.end?t.ParticleUtils.hexToRGB(e.end):e.end,1)),u},i}(),r=i;function n(t){return e(t)}e=parseInt(/^(\d+)\./.exec(i.VERSION)[1],10)<5?r.Texture.fromImage:r.Texture.from,function(t){t.verbose=!1,t.DEG_TO_RADS=Math.PI/180,t.rotatePoint=function(i,e){if(i){i*=t.DEG_TO_RADS;var s=Math.sin(i),r=Math.cos(i),n=e.x*r-e.y*s,a=e.x*s+e.y*r;e.x=n,e.y=a}},t.combineRGBComponents=function(t,i,e){return t<<16|i<<8|e},t.normalize=function(i){var e=1/t.length(i);i.x*=e,i.y*=e},t.scaleBy=function(t,i){t.x*=i,t.y*=i},t.length=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},t.hexToRGB=function(t,i){var e;return i||(i={}),"#"===t.charAt(0)?t=t.substr(1):0===t.indexOf("0x")&&(t=t.substr(2)),8===t.length&&(e=t.substr(0,2),t=t.substr(2)),i.r=parseInt(t.substr(0,2),16),i.g=parseInt(t.substr(2,2),16),i.b=parseInt(t.substr(4,2),16),e&&(i.a=parseInt(e,16)),i},t.generateEase=function(t){var i=t.length,e=1/i;return function(s){var r=i*s|0,n=(s-r*e)*i,a=t[r]||t[i-1];return a.s+n*(2*(1-n)*(a.cp-a.s)+n*(a.e-a.s))}},t.getBlendMode=function(t){if(!t)return i.BLEND_MODES.NORMAL;for(t=t.toUpperCase();t.indexOf(" ")>=0;)t=t.replace(" ","_");return i.BLEND_MODES[t]||i.BLEND_MODES.NORMAL},t.createSteppedGradient=function(i,e){void 0===e&&(e=10),("number"!=typeof e||e<=0)&&(e=10);var r=new s(t.hexToRGB(i[0].value),i[0].time);r.isStepped=!0;for(var n=r,a=i[0],h=1,o=i[h],l=1;l<e;++l){for(var p=l/e;p>o.time;)a=o,o=i[++h];p=(p-a.time)/(o.time-a.time);var d=t.hexToRGB(a.value),c=t.hexToRGB(o.value),u={r:(c.r-d.r)*p+d.r,g:(c.g-d.g)*p+d.g,b:(c.b-d.b)*p+d.b};n.next=new s(u,l/e),n=n.next}return r}}(t.ParticleUtils||(t.ParticleUtils={}));var a=function(t,i){return(a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)i.hasOwnProperty(e)&&(t[e]=i[e])})(t,i)};function h(t,i){function e(){this.constructor=t}a(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}function o(t){return this.ease&&(t=this.ease(t)),(this.next.value-this.current.value)*t+this.current.value}function l(i){this.ease&&(i=this.ease(i));var e=this.current.value,s=this.next.value,r=(s.r-e.r)*i+e.r,n=(s.g-e.g)*i+e.g,a=(s.b-e.b)*i+e.b;return t.ParticleUtils.combineRGBComponents(r,n,a)}function p(t){for(this.ease&&(t=this.ease(t));t>this.next.time;)this.current=this.next,this.next=this.next.next;return t=(t-this.current.time)/(this.next.time-this.current.time),(this.next.value-this.current.value)*t+this.current.value}function d(i){for(this.ease&&(i=this.ease(i));i>this.next.time;)this.current=this.next,this.next=this.next.next;i=(i-this.current.time)/(this.next.time-this.current.time);var e=this.current.value,s=this.next.value,r=(s.r-e.r)*i+e.r,n=(s.g-e.g)*i+e.g,a=(s.b-e.b)*i+e.b;return t.ParticleUtils.combineRGBComponents(r,n,a)}function c(t){for(this.ease&&(t=this.ease(t));this.next&&t>this.next.time;)this.current=this.next,this.next=this.next.next;return this.current.value}function u(i){for(this.ease&&(i=this.ease(i));this.next&&i>this.next.time;)this.current=this.next,this.next=this.next.next;var e=this.current.value;return t.ParticleUtils.combineRGBComponents(e.r,e.g,e.b)}var m,f=function(){function t(t){void 0===t&&(t=!1),this.current=null,this.next=null,this.isColor=!!t,this.interpolate=null,this.ease=null}return t.prototype.reset=function(t){this.current=t,this.next=t.next,this.next&&this.next.time>=1?this.interpolate=this.isColor?l:o:t.isStepped?this.interpolate=this.isColor?u:c:this.interpolate=this.isColor?d:p,this.ease=this.current.ease},t}(),_=function(e){function s(t){var r=e.call(this)||this;return r.prevChild=r.nextChild=null,r.emitter=t,r.anchor.x=r.anchor.y=.5,r.velocity=new i.Point,r.rotationSpeed=0,r.rotationAcceleration=0,r.maxLife=0,r.age=0,r.ease=null,r.extraData=null,r.alphaList=new f,r.speedList=new f,r.speedMultiplier=1,r.acceleration=new i.Point,r.maxSpeed=NaN,r.scaleList=new f,r.scaleMultiplier=1,r.colorList=new f(!0),r._doAlpha=!1,r._doScale=!1,r._doSpeed=!1,r._doAcceleration=!1,r._doColor=!1,r._doNormalMovement=!1,r._oneOverLife=0,r.next=null,r.prev=null,r.init=r.init,r.Particle_init=s.prototype.init,r.update=r.update,r.Particle_update=s.prototype.update,r.Sprite_destroy=e.prototype.destroy,r.Particle_destroy=s.prototype.destroy,r.applyArt=r.applyArt,r.kill=r.kill,r}return h(s,e),s.prototype.init=function(){this.age=0,this.velocity.x=this.speedList.current.value*this.speedMultiplier,this.velocity.y=0,t.ParticleUtils.rotatePoint(this.rotation,this.velocity),this.noRotation?this.rotation=0:this.rotation*=t.ParticleUtils.DEG_TO_RADS,this.rotationSpeed*=t.ParticleUtils.DEG_TO_RADS,this.rotationAcceleration*=t.ParticleUtils.DEG_TO_RADS,this.alpha=this.alphaList.current.value,this.scale.x=this.scale.y=this.scaleList.current.value,this._doAlpha=!!this.alphaList.current.next,this._doSpeed=!!this.speedList.current.next,this._doScale=!!this.scaleList.current.next,this._doColor=!!this.colorList.current.next,this._doAcceleration=0!==this.acceleration.x||0!==this.acceleration.y,this._doNormalMovement=this._doSpeed||0!==this.speedList.current.value||this._doAcceleration,this._oneOverLife=1/this.maxLife;var i=this.colorList.current.value;this.tint=t.ParticleUtils.combineRGBComponents(i.r,i.g,i.b),this.visible=!0},s.prototype.applyArt=function(t){this.texture=t||i.Texture.EMPTY},s.prototype.update=function(i){if(this.age+=i,this.age>=this.maxLife||this.age<0)return this.kill(),-1;var e=this.age*this._oneOverLife;if(this.ease&&(e=4===this.ease.length?this.ease(e,0,1,1):this.ease(e)),this._doAlpha&&(this.alpha=this.alphaList.interpolate(e)),this._doScale){var s=this.scaleList.interpolate(e)*this.scaleMultiplier;this.scale.x=this.scale.y=s}if(this._doNormalMovement){var r=void 0,n=void 0;if(this._doSpeed){var a=this.speedList.interpolate(e)*this.speedMultiplier;t.ParticleUtils.normalize(this.velocity),t.ParticleUtils.scaleBy(this.velocity,a),r=this.velocity.x*i,n=this.velocity.y*i}else if(this._doAcceleration){var h=this.velocity.x,o=this.velocity.y;if(this.velocity.x+=this.acceleration.x*i,this.velocity.y+=this.acceleration.y*i,this.maxSpeed){var l=t.ParticleUtils.length(this.velocity);l>this.maxSpeed&&t.ParticleUtils.scaleBy(this.velocity,this.maxSpeed/l)}r=(h+this.velocity.x)/2*i,n=(o+this.velocity.y)/2*i}else r=this.velocity.x*i,n=this.velocity.y*i;this.position.x+=r,this.position.y+=n}if(this._doColor&&(this.tint=this.colorList.interpolate(e)),0!==this.rotationAcceleration){var p=this.rotationSpeed+this.rotationAcceleration*i;this.rotation+=(this.rotationSpeed+p)/2*i,this.rotationSpeed=p}else 0!==this.rotationSpeed?this.rotation+=this.rotationSpeed*i:this.acceleration&&!this.noRotation&&(this.rotation=Math.atan2(this.velocity.y,this.velocity.x));return e},s.prototype.kill=function(){this.emitter.recycle(this)},s.prototype.destroy=function(){this.parent&&this.parent.removeChild(this),this.Sprite_destroy(),this.emitter=this.velocity=this.colorList=this.scaleList=this.alphaList=this.speedList=this.ease=this.next=this.prev=null},s.parseArt=function(i){var e;for(e=i.length;e>=0;--e)"string"==typeof i[e]&&(i[e]=n(i[e]));if(t.ParticleUtils.verbose)for(e=i.length-1;e>0;--e)if(i[e].baseTexture!==i[e-1].baseTexture){window.console&&console.warn("PixiParticles: using particle textures from different images may hinder performance in WebGL");break}return i},s.parseData=function(t){return t},s}(i.Sprite),C=function(){function t(t){this.segments=[],this.countingLengths=[],this.totalLength=0,this.init(t)}return t.prototype.init=function(t){if(t&&t.length)if(Array.isArray(t[0]))for(var i=0;i<t.length;++i)for(var e=t[i],s=e[0],r=1;r<e.length;++r){var n=e[r];this.segments.push({p1:s,p2:n,l:0}),s=n}else for(s=t[0],i=1;i<t.length;++i){n=t[i];this.segments.push({p1:s,p2:n,l:0}),s=n}else this.segments.push({p1:{x:0,y:0},p2:{x:0,y:0},l:0});for(i=0;i<this.segments.length;++i){var a=this.segments[i],h=a.p1,o=a.p2,l=Math.sqrt((o.x-h.x)*(o.x-h.x)+(o.y-h.y)*(o.y-h.y));this.segments[i].l=l,this.totalLength+=l,this.countingLengths.push(this.totalLength)}},t.prototype.getRandomPoint=function(t){var i,e,s=Math.random()*this.totalLength;if(1===this.segments.length)i=this.segments[0],e=s;else for(var r=0;r<this.countingLengths.length;++r)if(s<this.countingLengths[r]){i=this.segments[r],e=0===r?s:s-this.countingLengths[r-1];break}e/=i.l||1;var n=i.p1,a=i.p2;t.x=n.x+e*(a.x-n.x),t.y=n.y+e*(a.y-n.y)},t}(),v=i;m=parseInt(/^(\d+)\./.exec(i.VERSION)[1],10)<5?v.ticker.shared:v.Ticker.shared;var x=new i.Point,y=function(){function e(t,i,e){this._currentImageIndex=-1,this._particleConstructor=_,this.particleImages=null,this.startAlpha=null,this.startSpeed=null,this.minimumSpeedMultiplier=1,this.acceleration=null,this.maxSpeed=NaN,this.startScale=null,this.minimumScaleMultiplier=1,this.startColor=null,this.minLifetime=0,this.maxLifetime=0,this.minStartRotation=0,this.maxStartRotation=0,this.noRotation=!1,this.minRotationSpeed=0,this.maxRotationSpeed=0,this.particleBlendMode=0,this.customEase=null,this.extraData=null,this._frequency=1,this.spawnChance=1,this.maxParticles=1e3,this.emitterLifetime=-1,this.spawnPos=null,this.spawnType=null,this._spawnFunc=null,this.spawnRect=null,this.spawnCircle=null,this.spawnPolygonalChain=null,this.particlesPerWave=1,this.particleSpacing=0,this.angleStart=0,this.rotation=0,this.ownerPos=null,this._prevEmitterPos=null,this._prevPosIsValid=!1,this._posChanged=!1,this._parent=null,this.addAtBack=!1,this.particleCount=0,this._emit=!1,this._spawnTimer=0,this._emitterLife=-1,this._activeParticlesFirst=null,this._activeParticlesLast=null,this._poolFirst=null,this._origConfig=null,this._origArt=null,this._autoUpdate=!1,this._currentImageIndex=-1,this._destroyWhenComplete=!1,this._completeCallback=null,this.parent=t,i&&e&&this.init(i,e),this.recycle=this.recycle,this.update=this.update,this.rotate=this.rotate,this.updateSpawnPos=this.updateSpawnPos,this.updateOwnerPos=this.updateOwnerPos}return Object.defineProperty(e.prototype,"orderedArt",{get:function(){return-1!==this._currentImageIndex},set:function(t){this._currentImageIndex=t?0:-1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"frequency",{get:function(){return this._frequency},set:function(t){this._frequency="number"==typeof t&&t>0?t:1},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"particleConstructor",{get:function(){return this._particleConstructor},set:function(t){if(t!==this._particleConstructor){this._particleConstructor=t,this.cleanup();for(var i=this._poolFirst;i;i=i.next)i.destroy();this._poolFirst=null,this._origConfig&&this._origArt&&this.init(this._origArt,this._origConfig)}},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"parent",{get:function(){return this._parent},set:function(t){this.cleanup(),this._parent=t},enumerable:!0,configurable:!0}),e.prototype.init=function(e,r){if(e&&r){this.cleanup(),this._origConfig=r,this._origArt=e,e=Array.isArray(e)?e.slice():[e];var n=this._particleConstructor;this.particleImages=n.parseArt?n.parseArt(e):e,r.alpha?this.startAlpha=s.createList(r.alpha):this.startAlpha=new s(1,0),r.speed?(this.startSpeed=s.createList(r.speed),this.minimumSpeedMultiplier=("minimumSpeedMultiplier"in r?r.minimumSpeedMultiplier:r.speed.minimumSpeedMultiplier)||1):(this.minimumSpeedMultiplier=1,this.startSpeed=new s(0,0));var a=r.acceleration;a&&(a.x||a.y)?(this.startSpeed.next=null,this.acceleration=new i.Point(a.x,a.y),this.maxSpeed=r.maxSpeed||NaN):this.acceleration=new i.Point,r.scale?(this.startScale=s.createList(r.scale),this.minimumScaleMultiplier=("minimumScaleMultiplier"in r?r.minimumScaleMultiplier:r.scale.minimumScaleMultiplier)||1):(this.startScale=new s(1,0),this.minimumScaleMultiplier=1),r.color?this.startColor=s.createList(r.color):this.startColor=new s({r:255,g:255,b:255},0),r.startRotation?(this.minStartRotation=r.startRotation.min,this.maxStartRotation=r.startRotation.max):this.minStartRotation=this.maxStartRotation=0,r.noRotation&&(this.minStartRotation||this.maxStartRotation)?this.noRotation=!!r.noRotation:this.noRotation=!1,r.rotationSpeed?(this.minRotationSpeed=r.rotationSpeed.min,this.maxRotationSpeed=r.rotationSpeed.max):this.minRotationSpeed=this.maxRotationSpeed=0,this.rotationAcceleration=r.rotationAcceleration||0,this.minLifetime=r.lifetime.min,this.maxLifetime=r.lifetime.max,this.particleBlendMode=t.ParticleUtils.getBlendMode(r.blendMode),r.ease?this.customEase="function"==typeof r.ease?r.ease:t.ParticleUtils.generateEase(r.ease):this.customEase=null,n.parseData?this.extraData=n.parseData(r.extraData):this.extraData=r.extraData||null,this.spawnRect=this.spawnCircle=null,this.particlesPerWave=1,r.particlesPerWave&&r.particlesPerWave>1&&(this.particlesPerWave=r.particlesPerWave),this.particleSpacing=0,this.angleStart=0,this.parseSpawnType(r),this.frequency=r.frequency,this.spawnChance="number"==typeof r.spawnChance&&r.spawnChance>0?r.spawnChance:1,this.emitterLifetime=r.emitterLifetime||-1,this.maxParticles=r.maxParticles>0?r.maxParticles:1e3,this.addAtBack=!!r.addAtBack,this.rotation=0,this.ownerPos=new i.Point,this.spawnPos=new i.Point(r.pos.x,r.pos.y),this.initAdditional(e,r),this._prevEmitterPos=this.spawnPos.clone(),this._prevPosIsValid=!1,this._spawnTimer=0,this.emit=void 0===r.emit||!!r.emit,this.autoUpdate=!!r.autoUpdate,this.orderedArt=!!r.orderedArt}},e.prototype.initAdditional=function(t,i){},e.prototype.parseSpawnType=function(t){var e;switch(t.spawnType){case"rect":this.spawnType="rect",this._spawnFunc=this._spawnRect;var s=t.spawnRect;this.spawnRect=new i.Rectangle(s.x,s.y,s.w,s.h);break;case"circle":this.spawnType="circle",this._spawnFunc=this._spawnCircle,e=t.spawnCircle,this.spawnCircle=new i.Circle(e.x,e.y,e.r);break;case"ring":this.spawnType="ring",this._spawnFunc=this._spawnRing,e=t.spawnCircle,this.spawnCircle=new i.Circle(e.x,e.y,e.r),this.spawnCircle.minRadius=e.minR;break;case"burst":this.spawnType="burst",this._spawnFunc=this._spawnBurst,this.particleSpacing=t.particleSpacing,this.angleStart=t.angleStart?t.angleStart:0;break;case"point":this.spawnType="point",this._spawnFunc=this._spawnPoint;break;case"polygonalChain":this.spawnType="polygonalChain",this._spawnFunc=this._spawnPolygonalChain,this.spawnPolygonalChain=new C(t.spawnPolygon);break;default:this.spawnType="point",this._spawnFunc=this._spawnPoint}},e.prototype.recycle=function(t){t.next&&(t.next.prev=t.prev),t.prev&&(t.prev.next=t.next),t===this._activeParticlesLast&&(this._activeParticlesLast=t.prev),t===this._activeParticlesFirst&&(this._activeParticlesFirst=t.next),t.prev=null,t.next=this._poolFirst,this._poolFirst=t,t.parent&&t.parent.removeChild(t),--this.particleCount},e.prototype.rotate=function(i){if(this.rotation!==i){var e=i-this.rotation;this.rotation=i,t.ParticleUtils.rotatePoint(e,this.spawnPos),this._posChanged=!0}},e.prototype.updateSpawnPos=function(t,i){this._posChanged=!0,this.spawnPos.x=t,this.spawnPos.y=i},e.prototype.updateOwnerPos=function(t,i){this._posChanged=!0,this.ownerPos.x=t,this.ownerPos.y=i},e.prototype.resetPositionTracking=function(){this._prevPosIsValid=!1},Object.defineProperty(e.prototype,"emit",{get:function(){return this._emit},set:function(t){this._emit=!!t,this._emitterLife=this.emitterLifetime},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"autoUpdate",{get:function(){return this._autoUpdate},set:function(t){this._autoUpdate&&!t?m.remove(this.update,this):!this._autoUpdate&&t&&m.add(this.update,this),this._autoUpdate=!!t},enumerable:!0,configurable:!0}),e.prototype.playOnceAndDestroy=function(t){this.autoUpdate=!0,this.emit=!0,this._destroyWhenComplete=!0,this._completeCallback=t},e.prototype.playOnce=function(t){this.emit=!0,this._completeCallback=t},e.prototype.update=function(t){if(this._autoUpdate&&(t=t/i.settings.TARGET_FPMS/1e3),this._parent){var e,s,r,n,a;for(s=this._activeParticlesFirst;s;s=r)r=s.next,s.update(t);this._prevPosIsValid&&(n=this._prevEmitterPos.x,a=this._prevEmitterPos.y);var h=this.ownerPos.x+this.spawnPos.x,o=this.ownerPos.y+this.spawnPos.y;if(this._emit)for(this._spawnTimer-=t<0?0:t;this._spawnTimer<=0;){if(this._emitterLife>=0&&(this._emitterLife-=this._frequency,this._emitterLife<=0)){this._spawnTimer=0,this._emitterLife=0,this.emit=!1;break}if(this.particleCount>=this.maxParticles)this._spawnTimer+=this._frequency;else{var l=void 0;if(l=this.minLifetime===this.maxLifetime?this.minLifetime:Math.random()*(this.maxLifetime-this.minLifetime)+this.minLifetime,-this._spawnTimer<l){var p=void 0,d=void 0;if(this._prevPosIsValid&&this._posChanged){var c=1+this._spawnTimer/t;p=(h-n)*c+n,d=(o-a)*c+a}else p=h,d=o;e=0;for(var u=Math.min(this.particlesPerWave,this.maxParticles-this.particleCount);e<u;++e)if(!(this.spawnChance<1&&Math.random()>=this.spawnChance)){var m=void 0;this._poolFirst?(m=this._poolFirst,this._poolFirst=this._poolFirst.next,m.next=null):m=new this.particleConstructor(this),this.particleImages.length>1?-1!==this._currentImageIndex?(m.applyArt(this.particleImages[this._currentImageIndex++]),(this._currentImageIndex<0||this._currentImageIndex>=this.particleImages.length)&&(this._currentImageIndex=0)):m.applyArt(this.particleImages[Math.floor(Math.random()*this.particleImages.length)]):m.applyArt(this.particleImages[0]),m.alphaList.reset(this.startAlpha),1!==this.minimumSpeedMultiplier&&(m.speedMultiplier=Math.random()*(1-this.minimumSpeedMultiplier)+this.minimumSpeedMultiplier),m.speedList.reset(this.startSpeed),m.acceleration.x=this.acceleration.x,m.acceleration.y=this.acceleration.y,m.maxSpeed=this.maxSpeed,1!==this.minimumScaleMultiplier&&(m.scaleMultiplier=Math.random()*(1-this.minimumScaleMultiplier)+this.minimumScaleMultiplier),m.scaleList.reset(this.startScale),m.colorList.reset(this.startColor),this.minRotationSpeed===this.maxRotationSpeed?m.rotationSpeed=this.minRotationSpeed:m.rotationSpeed=Math.random()*(this.maxRotationSpeed-this.minRotationSpeed)+this.minRotationSpeed,m.rotationAcceleration=this.rotationAcceleration,m.noRotation=this.noRotation,m.maxLife=l,m.blendMode=this.particleBlendMode,m.ease=this.customEase,m.extraData=this.extraData,this.applyAdditionalProperties(m),this._spawnFunc(m,p,d,e),m.init(),this.addAtBack?this._parent.addChildAt(m,0):this._parent.addChild(m),this._activeParticlesLast?(this._activeParticlesLast.next=m,m.prev=this._activeParticlesLast,this._activeParticlesLast=m):this._activeParticlesLast=this._activeParticlesFirst=m,++this.particleCount,m.update(-this._spawnTimer)}}this._spawnTimer+=this._frequency}}if(this._posChanged&&(this._prevEmitterPos.x=h,this._prevEmitterPos.y=o,this._prevPosIsValid=!0,this._posChanged=!1),!this._emit&&!this._activeParticlesFirst){if(this._completeCallback){var f=this._completeCallback;this._completeCallback=null,f()}this._destroyWhenComplete&&this.destroy()}}},e.prototype.applyAdditionalProperties=function(t){},e.prototype._spawnPoint=function(t,i,e){this.minStartRotation===this.maxStartRotation?t.rotation=this.minStartRotation+this.rotation:t.rotation=Math.random()*(this.maxStartRotation-this.minStartRotation)+this.minStartRotation+this.rotation,t.position.x=i,t.position.y=e},e.prototype._spawnRect=function(i,e,s){this.minStartRotation===this.maxStartRotation?i.rotation=this.minStartRotation+this.rotation:i.rotation=Math.random()*(this.maxStartRotation-this.minStartRotation)+this.minStartRotation+this.rotation,x.x=Math.random()*this.spawnRect.width+this.spawnRect.x,x.y=Math.random()*this.spawnRect.height+this.spawnRect.y,0!==this.rotation&&t.ParticleUtils.rotatePoint(this.rotation,x),i.position.x=e+x.x,i.position.y=s+x.y},e.prototype._spawnCircle=function(i,e,s){this.minStartRotation===this.maxStartRotation?i.rotation=this.minStartRotation+this.rotation:i.rotation=Math.random()*(this.maxStartRotation-this.minStartRotation)+this.minStartRotation+this.rotation,x.x=Math.random()*this.spawnCircle.radius,x.y=0,t.ParticleUtils.rotatePoint(360*Math.random(),x),x.x+=this.spawnCircle.x,x.y+=this.spawnCircle.y,0!==this.rotation&&t.ParticleUtils.rotatePoint(this.rotation,x),i.position.x=e+x.x,i.position.y=s+x.y},e.prototype._spawnRing=function(i,e,s){var r=this.spawnCircle;this.minStartRotation===this.maxStartRotation?i.rotation=this.minStartRotation+this.rotation:i.rotation=Math.random()*(this.maxStartRotation-this.minStartRotation)+this.minStartRotation+this.rotation,r.minRadius!==r.radius?x.x=Math.random()*(r.radius-r.minRadius)+r.minRadius:x.x=r.radius,x.y=0;var n=360*Math.random();i.rotation+=n,t.ParticleUtils.rotatePoint(n,x),x.x+=this.spawnCircle.x,x.y+=this.spawnCircle.y,0!==this.rotation&&t.ParticleUtils.rotatePoint(this.rotation,x),i.position.x=e+x.x,i.position.y=s+x.y},e.prototype._spawnPolygonalChain=function(i,e,s){this.minStartRotation===this.maxStartRotation?i.rotation=this.minStartRotation+this.rotation:i.rotation=Math.random()*(this.maxStartRotation-this.minStartRotation)+this.minStartRotation+this.rotation,this.spawnPolygonalChain.getRandomPoint(x),0!==this.rotation&&t.ParticleUtils.rotatePoint(this.rotation,x),i.position.x=e+x.x,i.position.y=s+x.y},e.prototype._spawnBurst=function(t,i,e,s){0===this.particleSpacing?t.rotation=360*Math.random():t.rotation=this.angleStart+this.particleSpacing*s+this.rotation,t.position.x=i,t.position.y=e},e.prototype.cleanup=function(){var t,i;for(t=this._activeParticlesFirst;t;t=i)i=t.next,this.recycle(t),t.parent&&t.parent.removeChild(t);this._activeParticlesFirst=this._activeParticlesLast=null,this.particleCount=0},e.prototype.destroy=function(){var t;this.autoUpdate=!1,this.cleanup();for(var i=this._poolFirst;i;i=t)t=i.next,i.destroy();this._poolFirst=this._parent=this.particleImages=this.spawnPos=this.ownerPos=this.startColor=this.startScale=this.startAlpha=this.startSpeed=this.customEase=this._completeCallback=null},e}(),g=new i.Point,P=["pow","sqrt","abs","floor","round","ceil","E","PI","sin","cos","tan","asin","acos","atan","atan2","log"],w=new RegExp(["[01234567890\\.\\*\\-\\+\\/\\(\\)x ,]"].concat(P).join("|"),"g");var b=function(e){function s(t){var s=e.call(this,t)||this;return s.path=null,s.initialRotation=0,s.initialPosition=new i.Point,s.movement=0,s}return h(s,e),s.prototype.init=function(){this.initialRotation=this.rotation,this.Particle_init(),this.path=this.extraData.path,this._doNormalMovement=!this.path,this.movement=0,this.initialPosition.x=this.position.x,this.initialPosition.y=this.position.y},s.prototype.update=function(i){var e=this.Particle_update(i);if(e>=0&&this.path){if(this._doSpeed){var s=this.speedList.interpolate(e)*this.speedMultiplier;this.movement+=s*i}else{s=this.speedList.current.value*this.speedMultiplier;this.movement+=s*i}g.x=this.movement,g.y=this.path(this.movement),t.ParticleUtils.rotatePoint(this.initialRotation,g),this.position.x=this.initialPosition.x+g.x,this.position.y=this.initialPosition.y+g.y}return e},s.prototype.destroy=function(){this.Particle_destroy(),this.path=this.initialPosition=null},s.parseArt=function(t){return _.parseArt(t)},s.parseData=function(i){var e={};if(i&&i.path)try{e.path=function(t){for(var i=t.match(w),e=i.length-1;e>=0;--e)P.indexOf(i[e])>=0&&(i[e]="Math."+i[e]);return t=i.join(""),new Function("x","return "+t+";")}(i.path)}catch(i){t.ParticleUtils.verbose&&console.error("PathParticle: error in parsing path expression"),e.path=null}else t.ParticleUtils.verbose&&console.error("PathParticle requires a path string in extraData!"),e.path=null;return e},s}(_),S=function(t){function e(i){var e=t.call(this,i)||this;return e.textures=null,e.duration=0,e.framerate=0,e.elapsed=0,e.loop=!1,e}return h(e,t),e.prototype.init=function(){this.Particle_init(),this.elapsed=0,this.framerate<0&&(this.duration=this.maxLife,this.framerate=this.textures.length/this.duration)},e.prototype.applyArt=function(t){this.textures=t.textures,this.framerate=t.framerate,this.duration=t.duration,this.loop=t.loop},e.prototype.update=function(t){var e=this.Particle_update(t);if(e>=0){this.elapsed+=t,this.elapsed>this.duration&&(this.loop?this.elapsed=this.elapsed%this.duration:this.elapsed=this.duration-1e-6);var s=this.elapsed*this.framerate+1e-7|0;this.texture=this.textures[s]||i.Texture.EMPTY}return e},e.prototype.destroy=function(){this.Particle_destroy(),this.textures=null},e.parseArt=function(t){for(var e=[],s=0;s<t.length;++s){for(var r=t[s],a=e[s]={},h=a.textures=[],o=r.textures,l=0;l<o.length;++l){var p=o[l];if("string"==typeof p)h.push(n(p));else if(p instanceof i.Texture)h.push(p);else{var d=p.count||1;for(p="string"==typeof p.texture?n(p.texture):p.texture;d>0;--d)h.push(p)}}"matchLife"===r.framerate?(a.framerate=-1,a.duration=0,a.loop=!1):(a.loop=!!r.loop,a.framerate=r.framerate>0?r.framerate:60,a.duration=h.length/a.framerate)}return e},e}(_),R=function(t){function e(){var i=null!==t&&t.apply(this,arguments)||this;return i._firstChild=null,i._lastChild=null,i._childCount=0,i}return h(e,t),Object.defineProperty(e.prototype,"firstChild",{get:function(){return this._firstChild},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"lastChild",{get:function(){return this._lastChild},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"childCount",{get:function(){return this._childCount},enumerable:!0,configurable:!0}),e.prototype.addChild=function(){for(var t=[],i=0;i<arguments.length;i++)t[i]=arguments[i];if(t.length>1)for(var e=0;e<t.length;e++)this.addChild(t[e]);else{var s=t[0];s.parent&&s.parent.removeChild(s),s.parent=this,this.sortDirty=!0,s.transform._parentID=-1,this._lastChild?(this._lastChild.nextChild=s,s.prevChild=this._lastChild,this._lastChild=s):this._firstChild=this._lastChild=s,++this._childCount,this._boundsID++,this.onChildrenChange(),this.emit("childAdded",s,this,this._childCount),s.emit("added",this)}return t[0]},e.prototype.addChildAt=function(t,i){if(i<0||i>this._childCount)throw new Error("addChildAt: The index "+i+" supplied is out of bounds "+this._childCount);t.parent&&t.parent.removeChild(t),t.parent=this,this.sortDirty=!0,t.transform._parentID=-1;var e=t;if(this._firstChild)if(0===i)this._firstChild.prevChild=e,e.nextChild=this._firstChild,this._firstChild=e;else if(i===this._childCount)this._lastChild.nextChild=e,e.prevChild=this._lastChild,this._lastChild=e;else{for(var s=0,r=this._firstChild;s<i;)r=r.nextChild,++s;r.prevChild.nextChild=e,e.prevChild=r.prevChild,e.nextChild=r,r.prevChild=e}else this._firstChild=this._lastChild=e;return++this._childCount,this._boundsID++,this.onChildrenChange(i),t.emit("added",this),this.emit("childAdded",t,this,i),t},e.prototype.addChildBelow=function(t,i){if(i.parent!==this)throw new Error("addChildBelow: The relative target must be a child of this parent");return t.parent&&t.parent.removeChild(t),t.parent=this,this.sortDirty=!0,t.transform._parentID=-1,i.prevChild.nextChild=t,t.prevChild=i.prevChild,t.nextChild=i,i.prevChild=t,this._firstChild===i&&(this._firstChild=t),++this._childCount,this._boundsID++,this.onChildrenChange(),this.emit("childAdded",t,this,this._childCount),t.emit("added",this),t},e.prototype.addChildAbove=function(t,i){if(i.parent!==this)throw new Error("addChildBelow: The relative target must be a child of this parent");return t.parent&&t.parent.removeChild(t),t.parent=this,this.sortDirty=!0,t.transform._parentID=-1,i.nextChild.prevChild=t,t.nextChild=i.nextChild,t.prevChild=i,i.nextChild=t,this._lastChild===i&&(this._lastChild=t),++this._childCount,this._boundsID++,this.onChildrenChange(),this.emit("childAdded",t,this,this._childCount),t.emit("added",this),t},e.prototype.swapChildren=function(t,i){if(t!==i&&t.parent===this&&i.parent===this){var e=t,s=e.prevChild,r=e.nextChild;t.prevChild=i.prevChild,t.nextChild=i.nextChild,i.prevChild=s,i.nextChild=r,this._firstChild===t?this._firstChild=i:this._firstChild===i&&(this._firstChild=t),this._lastChild===t?this._lastChild=i:this._lastChild===i&&(this._lastChild=t),this.onChildrenChange()}},e.prototype.getChildIndex=function(t){for(var i=0,e=this._firstChild;e&&e!==t;)e=e.nextChild,++i;if(!e)throw new Error("The supplied DisplayObject must be a child of the caller");return i},e.prototype.setChildIndex=function(t,i){if(i<0||i>=this._childCount)throw new Error("The index "+i+" supplied is out of bounds "+this._childCount);if(t.parent!==this)throw new Error("The supplied DisplayObject must be a child of the caller");if(t.nextChild&&(t.nextChild.prevChild=t.prevChild),t.prevChild&&(t.prevChild.nextChild=t.nextChild),this._firstChild===t&&(this._firstChild=t.nextChild),this._lastChild===t&&(this._lastChild=t.prevChild),t.nextChild=null,t.prevChild=null,this._firstChild)if(0===i)this._firstChild.prevChild=t,t.nextChild=this._firstChild,this._firstChild=t;else if(i===this._childCount)this._lastChild.nextChild=t,t.prevChild=this._lastChild,this._lastChild=t;else{for(var e=0,s=this._firstChild;e<i;)s=s.nextChild,++e;s.prevChild.nextChild=t,t.prevChild=s.prevChild,t.nextChild=s,s.prevChild=t}else this._firstChild=this._lastChild=t;this.onChildrenChange(i)},e.prototype.removeChild=function(){for(var t=[],i=0;i<arguments.length;i++)t[i]=arguments[i];if(t.length>1)for(var e=0;e<t.length;e++)this.removeChild(t[e]);else{var s=t[0];if(s.parent!==this)return null;s.parent=null,s.transform._parentID=-1,s.nextChild&&(s.nextChild.prevChild=s.prevChild),s.prevChild&&(s.prevChild.nextChild=s.nextChild),this._firstChild===s&&(this._firstChild=s.nextChild),this._lastChild===s&&(this._lastChild=s.prevChild),s.nextChild=null,s.prevChild=null,--this._childCount,this._boundsID++,this.onChildrenChange(),s.emit("removed",this),this.emit("childRemoved",s,this)}return t[0]},e.prototype.getChildAt=function(t){if(t<0||t>=this._childCount)throw new Error("getChildAt: Index ("+t+") does not exist.");if(0===t)return this._firstChild;if(t===this._childCount)return this._lastChild;for(var i=0,e=this._firstChild;i<t;)e=e.nextChild,++i;return e},e.prototype.removeChildAt=function(t){var i=this.getChildAt(t);return i.parent=null,i.transform._parentID=-1,i.nextChild&&(i.nextChild.prevChild=i.prevChild),i.prevChild&&(i.prevChild.nextChild=i.nextChild),this._firstChild===i&&(this._firstChild=i.nextChild),this._lastChild===i&&(this._lastChild=i.prevChild),i.nextChild=null,i.prevChild=null,--this._childCount,this._boundsID++,this.onChildrenChange(t),i.emit("removed",this),this.emit("childRemoved",i,this,t),i},e.prototype.removeChildren=function(t,i){void 0===t&&(t=0),void 0===i&&(i=this._childCount);var e=t,s=i,r=s-e;if(r>0&&r<=s){for(var n=[],a=this._firstChild,h=0;h<=s&&a;++h,a=a.nextChild)h>=e&&n.push(a);var o=n[0].prevChild,l=n[n.length-1].nextChild;l?l.prevChild=o:this._lastChild=o,o?o.nextChild=l:this._firstChild=l;for(h=0;h<n.length;++h)n[h].parent=null,n[h].transform&&(n[h].transform._parentID=-1),n[h].nextChild=null,n[h].prevChild=null;this._boundsID++,this.onChildrenChange(t);for(h=0;h<n.length;++h)n[h].emit("removed",this),this.emit("childRemoved",n[h],this,h);return n}if(0===r&&0===this._childCount)return[];throw new RangeError("removeChildren: numeric values are outside the acceptable range.")},e.prototype.updateTransform=function(){var t,i;for(this._boundsID++,this.transform.updateTransform(this.parent.transform),this.worldAlpha=this.alpha*this.parent.worldAlpha,t=this._firstChild;t;t=i)i=t.nextChild,t.visible&&t.updateTransform()},e.prototype.calculateBounds=function(){var t,i;for(this._bounds.clear(),this._calculateBounds(),t=this._firstChild;t;t=i)if(i=t.nextChild,t.visible&&t.renderable)if(t.calculateBounds(),t._mask){var e=t._mask.maskObject||t._mask;e.calculateBounds(),this._bounds.addBoundsMask(t._bounds,e._bounds)}else t.filterArea?this._bounds.addBoundsArea(t._bounds,t.filterArea):this._bounds.addBounds(t._bounds);this._bounds.updateID=this._boundsID},e.prototype.getLocalBounds=function(t,e){void 0===e&&(e=!1);var s=i.DisplayObject.prototype.getLocalBounds.call(this,t);if(!e){var r=void 0,n=void 0;for(r=this._firstChild;r;r=n)n=r.nextChild,r.visible&&r.updateTransform()}return s},e.prototype.render=function(t){if(this.visible&&!(this.worldAlpha<=0)&&this.renderable)if(this._mask||this.filters&&this.filters.length)this.renderAdvanced(t);else{this._render(t);var i=void 0,e=void 0;for(i=this._firstChild;i;i=e)e=i.nextChild,i.render(t)}},e.prototype.renderAdvanced=function(t){t.batch.flush();var i,e,s=this.filters,r=this._mask;if(s){this._enabledFilters||(this._enabledFilters=[]),this._enabledFilters.length=0;for(var n=0;n<s.length;n++)s[n].enabled&&this._enabledFilters.push(s[n]);this._enabledFilters.length&&t.filter.push(this,this._enabledFilters)}for(r&&t.mask.push(this,this._mask),this._render(t),i=this._firstChild;i;i=e)e=i.nextChild,i.render(t);t.batch.flush(),r&&t.mask.pop(this),s&&this._enabledFilters&&this._enabledFilters.length&&t.filter.pop()},e.prototype.renderWebGL=function(t){if(this.visible&&!(this.worldAlpha<=0)&&this.renderable)if(this._mask||this.filters&&this.filters.length)this.renderAdvancedWebGL(t);else{this._renderWebGL(t);var i=void 0,e=void 0;for(i=this._firstChild;i;i=e)e=i.nextChild,i.renderWebGL(t)}},e.prototype.renderAdvancedWebGL=function(t){t.flush();var i,e,s=this._filters,r=this._mask;if(s){this._enabledFilters||(this._enabledFilters=[]),this._enabledFilters.length=0;for(var n=0;n<s.length;n++)s[n].enabled&&this._enabledFilters.push(s[n]);this._enabledFilters.length&&t.filterManager.pushFilter(this,this._enabledFilters)}for(r&&t.maskManager.pushMask(this,this._mask),this._renderWebGL(t),i=this._firstChild;i;i=e)e=i.nextChild,i.renderWebGL(t);t.flush(),r&&t.maskManager.popMask(this,this._mask),s&&this._enabledFilters&&this._enabledFilters.length&&t.filterManager.popFilter()},e.prototype.renderCanvas=function(t){if(this.visible&&!(this.worldAlpha<=0)&&this.renderable){var i,e;for(this._mask&&t.maskManager.pushMask(this._mask),this._renderCanvas(t),i=this._firstChild;i;i=e)e=i.nextChild,i.renderCanvas(t);this._mask&&t.maskManager.popMask(t)}},e}(i.Container);t.AnimatedParticle=S,t.Emitter=y,t.GetTextureFromString=n,t.LinkedListContainer=R,t.Particle=_,t.PathParticle=b,t.PolygonalChain=C,t.PropertyList=f,t.PropertyNode=s}(this.PIXI.particles=this.PIXI.particles||{},PIXI);
//=============================================================================
var QJ = QJ || {};
QJ.BL = QJ.BL || {};
var Imported = Imported || {};
Imported.QJBullet = true;
var numberQJY = 0;
(() => {
//=============================================================================
//
//=============================================================================
const pluginName = "QJ-Bullet";
const parameters = PluginManager.parameters(pluginName);
const preset=eval(parameters['preset']) || [];
const presetText=eval(parameters['presetText']) || [];
const precision=Number(parameters['precision']) || 8;
const maxbullet=Number(parameters['maxbullet']) || 50;
const showWarn=eval(parameters['showWarn']) || true;
const reserveImg=eval(parameters['reserveImg']);
const PresetText = (()=>{
    let list = {};
    for (let i=0;i<presetText.length;i++) {
        let detial=JsonEx.parse(presetText[i]);
        list[String(detial.name)] = eval(detial.content1+detial.content2+detial.content3);
    }
    //console.log(list);
    return list;
})();
const Preset = (()=>{
    let list = {};
    for (let i=0;i<preset.length;i++) {
        let detial=JsonEx.parse(preset[i]);
        list[String(detial.name)] = {
            initialRotation:detial.initialRotation,
            x:(isNaN(Number(detial.x))?detial.x:Number(detial.x)),
            y:(isNaN(Number(detial.y))?detial.y:Number(detial.y)),
            z:detial.z,
            scaleX:(isNaN(Number(detial.scaleX))?detial.scaleX:Number(detial.scaleX)),
            scaleY:(isNaN(Number(detial.scaleY))?detial.scaleY:Number(detial.scaleY)),
            //======================================
            MoveType:detial.MoveType,
            Regions:eval(detial.Regions),
            Terrains:eval(detial.Terrains),
            Target:eval(detial.Target),
            Pierce:Number(detial.Pierce),
            //======================================
            Img:((Img)=>{
                let newImg;
                try{newImg=eval(Img);} catch(e) {newImg=Img;}
                return newImg;
            })(detial.Img),
            Anim:Number(detial.Anim),
            DeadCount:Number(detial.DeadCount),
            Speed:(isNaN(Number(detial.Speed))?detial.Speed:Number(detial.Speed)),
            Max:Number(detial.Max),
            RotationAuto:Number(detial.RotationAuto),
            //======================================
            Action:eval(detial.Action),
            CollisionBox:detial.CollisionBox,
            //======================================
            Tone:eval(detial.Tone),
            Opacity:(isNaN(Number(detial.Opacity))?detial.Opacity:Number(detial.Opacity)),
            AfterImage:eval(detial.AfterImage),
            Light:eval(detial.Light),
            Particles:eval(detial.Particles),
            AtkRange:Number(detial.AtkRange),
            DeadAction:eval(detial.DeadAction),
            PierceAction:eval(detial.PierceAction),
            NoCollisionAction:eval(detial.NoCollisionAction),
            DeadAnim:eval(detial.DeadAnim),
            PierceAnim:eval(detial.PierceAnim),
            NoCollisionAnim:eval(detial.NoCollisionAnim),
            ReBound:eval(detial.ReBound),
            AnchorX:Number(detial.AnchorX),
            AnchorY:Number(detial.AnchorY),
            rTRotation:detial.rTRotation,
            WaitBaseOnSpeed:(isNaN(Number(detial.WaitBaseOnSpeed))?detial.WaitBaseOnSpeed:Number(detial.WaitBaseOnSpeed)),
            LMD:eval(detial.LMD),
            Update:detial.Update,
            Bit:eval(detial.Bit),
            DeadT:detial.DeadT
        }
    }
    //console.log(list);
    return list;
})();
const tileSize=48;
let QJBInter=null;
let forBidDestination=eval(parameters['forBidDestination']) || false;
let textureSave = {};
//=============================================================================
//
//=============================================================================
const QJB_Game_Temp_setDestination = Game_Temp.prototype.setDestination
Game_Temp.prototype.setDestination = function(x, y) {
    if (forBidDestination) return;
    QJB_Game_Temp_setDestination.call(this,x,y);
};
QJ.BL.SetMove = function(bo) {
    forBidDestination = !(!!bo);
}
QJ.BL.ClearAll = function() {
    if (!SceneManager._scene) return;
    if (!SceneManager._scene._spriteset) return;
    QJ.Matter.bulletClear();
    SceneManager._scene._spriteset.clearAllButtle();
    textureSave = {};
}
//=============================================================================
//
//=============================================================================
QJ.Matter.BulletBox = Matter.Composite.create();
QJ.Matter.bulletAdd = (content)=>{return QJ.Matter.Composite.add(QJ.Matter.BulletBox,content);};
QJ.Matter.bulletRemove = (content)=>{return QJ.Matter.Composite.remove(QJ.Matter.BulletBox,content);};
QJ.Matter.bulletAllBodies = ()=>{return QJ.Matter.Composite.allBodies(QJ.Matter.BulletBox);};
QJ.Matter.bulletClear = ()=>{return Matter.Composite.clear(QJ.Matter.BulletBox);};
QJ.Matter.makeBulletBodyBox = (target) =>{
    let option = {
        frictionAir:0,
        friction:0,
        restitution:target.ReBound?1:0,
        inertia:Infinity,
        frictionStatic:0
    }
    let m=null;
    for (let i of target.regions) {
        if (m) m = m|QJ.Matter.cl.region[i];
        else m = QJ.Matter.cl.region[i];
    }
    for (let i of target.terrains) {
        if (m) m = m|QJ.Matter.cl.terrain[i];
        else m = QJ.Matter.cl.terrain[i];
    }
    if (m&&!target.Bit) option.collisionFilter = {mask:m,group:-1};
    else option.collisionFilter = {mask:QJ.Matter.cl.nullBox,group:-1};
    //=======================================
    if (target.boxType[0]==0) {
        if (target.QJBody) return;//QJ.Matter.bulletRemove(target.QJBody);
        target.QJBody = QJ.Matter.circle(target.orginX(),target.orginY(),target.boxType[1],option);
        target.QJBodyForJudge = QJ.Matter.circle(target.orginX(),target.orginY(),target.boxType[1],option);
        if (target.regularWorld()) QJ.Matter.bulletAdd(target.QJBody);
    } else if (target.boxType[0]==1) {
        if (target.QJBody) return;//QJ.Matter.bulletRemove(target.QJBody);
        target.QJBody = QJ.Matter.rectangle(target.orginX(),target.orginY(),target.boxType[1],target.boxType[2],option);
        target.QJBodyForJudge = QJ.Matter.rectangle(target.orginX(),target.orginY(),target.boxType[1],target.boxType[2],option);
        if (target.regularWorld()) QJ.Matter.bulletAdd(target.QJBody);
    }
    target.QJBody.render.fillStyle = "#000000";
    target.QJBody.parentTarget = target;
    target.QJBodyForJudge.parentTarget = target;
    target.QJBody.isBullet = true;
    target.QJBodyForJudge.isBullet = true;
    //=======================================
}
//==============================================================
QJ.BL.engine = Matter.Engine.create({
    gravity: {x: 0,y: 0,scale: 0}
})
QJ.BL.world = QJ.BL.engine.world;
QJ.Matter.Composite.add(QJ.BL.world,QJ.Matter.BulletBox);
QJ.Matter.Composite.add(QJ.BL.world,QJ.Matter.RegionBox);
QJ.Matter.Composite.add(QJ.BL.world,QJ.Matter.TerrainBox);
QJ.BL.sCF=(collisionList)=>{
    for (let i of collisionList.pairs) {
        if (i.bodyA.isBullet&&i.bodyA.parentTarget) {
            i.bodyA.parentTarget.updateCollidePre(i);
        } else if (i.bodyB.isBullet&&i.bodyB.parentTarget) {
            i.bodyB.parentTarget.updateCollidePre(i);
        }
    }
};
QJ.BL.aCF=(collisionList)=>{
    for (let i of collisionList.pairs) {
        if (i.bodyA.isBullet&&i.bodyA.parentTarget) {
            i.bodyA.parentTarget.updateCollideIng(i);
        } else if (i.bodyB.isBullet&&i.bodyB.parentTarget) {
            i.bodyB.parentTarget.updateCollideIng(i);
        }
    }
}
QJ.BL.eCF=(collisionList)=>{
    for (let i of collisionList.pairs) {
        if (i.bodyA.isBullet&&i.bodyA.parentTarget) {
            i.bodyA.parentTarget.updateCollide(i);
        } else if (i.bodyB.isBullet&&i.bodyB.parentTarget) {
            i.bodyB.parentTarget.updateCollide(i);
        }
    }
}
Matter.Events.on(QJ.BL.engine,"collisionStart",(collisionList)=>QJ.BL.sCF(collisionList));
Matter.Events.on(QJ.BL.engine,"collisionActive",(collisionList)=>QJ.BL.aCF(collisionList));
Matter.Events.on(QJ.BL.engine,"collisionEnd",(collisionList)=>QJ.BL.eCF(collisionList));
//==============================================================
const QJB_Game_Map_update = Game_Map.prototype.update;
Game_Map.prototype.update = function(sceneActive) {
    //====================================
    if (sceneActive) Matter.Engine.update(QJ.BL.engine);
    //====================================
    QJB_Game_Map_update.call(this,sceneActive);
    //====================================
    for (let i=0,l=this._forceInterpreterQB.length;i<l;i++) {
        if (!this._forceInterpreterQB[i]) continue;
        if (!this._forceInterpreterQB[i].isRunning()) {
            this._forceInterpreterQB[i].setup(
                $dataCommonEvents[this._forceInterpreterQB[i].commonEventId].list,
                this._forceInterpreterQB[i].EID>0?this._forceInterpreterQB[i].EID:0);
        }
        this._forceInterpreterQB[i].update();
    }
    //====================================
    $gameMap._aliveBullet=0;
    this._mapBullets.forEach(function(bullet) {
        if (bullet) {
            $gameMap._aliveBullet++;
            bullet.update();
        }
    });
    //====================================
}
//=============================================================================
//loadBullet
//=============================================================================
ImageManager.loadBullet = function(filename) {
    return this.loadBitmap('img/bullets/', filename, 0, false);
};
ImageManager.reserveBullet = function(filename) {
    return this.reserveBitmap('img/bullets/', filename, 0, false, null);
};
const QJB_Scene_Boot_loadSystemImages = Scene_Boot.loadSystemImages;
Scene_Boot.loadSystemImages = function() {
    QJB_Scene_Boot_loadSystemImages.call(this);
    for (let i of reserveImg) {
        if (i.includes("|")) {
            let detail = i.split("|");
            for (let j of detail) {
                ImageManager.reserveBullet(j);
            }
        } else ImageManager.reserveBullet(i);
    }
};
QJ.BL.ColorGrad = function(bitmap,content,x,y,w,h,ro) {
    if (!content.includes("|")) return content;
    const list=content.split("~");
    const colorNum = list.length;
    const grad = bitmap._context.createLinearGradient(x,y+h,x+w*Math.sin(ro),y-h*Math.cos(ro));
    for(let i=0; i<colorNum; i++) {
        let detail = list[i].split("|");
        grad.addColorStop(detail[0],detail[1]);
    }
    return grad;
}
Bitmap.prototype.drawTextChangeRotation = function(text, x, y, maxWidth, lineHeight, align ,rotation) {
    if (text !== undefined) {
        var tx = x;
        var ty = y + lineHeight - (lineHeight - this.fontSize * 0.7) / 2;
        var context = this._context;
        var alpha = context.globalAlpha;
        maxWidth = maxWidth || 0xffffffff;
        if (align === 'center') {
            tx += maxWidth / 2;
        }
        if (align === 'right') {
            tx += maxWidth;
        }
        context.save();
        context.translate(0,0);
        context.rotate(rotation);
        context.translate(0,-lineHeight+4);
        context.font = this._makeFontNameText();
        context.textAlign = align;
        context.textBaseline = 'alphabetic';
        context.globalAlpha = 1;
        this._drawTextOutline(text, tx, ty, maxWidth);
        context.globalAlpha = alpha;
        this._drawTextBody(text, tx, ty, maxWidth);
        context.restore();
        this._setDirty();
    }
};
Bitmap.prototype.drawTextVerticalRow = function(text, x, y, maxWidth, lineHeight, align) {
    if (text !== undefined) {
        var tx = x + lineHeight / 2;
        var ty = y + lineHeight;
        var context = this._context;
        var alpha = context.globalAlpha;
        maxWidth = maxWidth || 0xffffffff;
        context.save();
        context.font = this._makeFontNameText();
        context.textAlign = align;
        context.textBaseline = 'alphabetic';
        for (let i=0;i<text.length;i++) {
            context.globalAlpha = 1;
            this._drawTextOutline(text[i], tx, ty+i*lineHeight, maxWidth);
            context.globalAlpha = alpha;
            this._drawTextBody(text[i], tx, ty+i*lineHeight, maxWidth);
        }
        context.restore();
        this._setDirty();
    }
};
QJ.BL.randomColor = function(start,length) {
    return QJ.BL.rgbToHex({
        r:start+Math.floor(Math.random()*length),
        g:start+Math.floor(Math.random()*length),
        b:start+Math.floor(Math.random()*length)});
}
//=============================================================================
//
//=============================================================================
QJ.BL.Shooter_FlameThrower = function(data,minScale,maxScale,offsetDir,num) {
    let bullet = {
        Img:"fire[11,5]",
        Max:80,
        DeadCount:40,
        AnchorX:0.5,
        AnchorY:0.5
    };
    for (let i in data) bullet[i] = data[i];
    for (let i=0;i<num;i++) {
        let size = minScale+Math.random()*(maxScale-minScale);
        bullet.initialRotation=(data.initialRotation!=undefined?data.initialRotation:"PD[]")+"+"+(Math.random()*offsetDir*2-offsetDir);
        bullet.Speed=1.5+Math.random()*1.5;
        bullet.CollisionBox="R["+size+","+size+"]";
        bullet.scaleX=size;
        bullet.scaleY=size;
        QJ.BL.Shoot(bullet);
    }
}
QJ.BL.Shooter_Gain = function(data,type,id,num) {
    data.x = "E[0]";
    data.y = "E[0]";
    data.Target = ["P[]"];
    data.Max = 90+60*60*60;
    data.initialRotation = 60*Math.random()-30+(Math.random()>0.5?90:270);
    data.RotationAuto = 0;
    data.CollisionBox = "R[32,32]";
    let item;
    if (type==3||type=="gold") {
        data.Img=[2,id];
        if (Imported.MOG_TreasurePopup&&((Moghunter.trpopup_GoldVisible) === "true"&&$gameSystem._trspupVisible)) {
            if (num>0||(num<0&&Moghunter.trpopup_LostItemVisible)) 
                data.Action = ["T[$gameParty.gainGold("+num+");"+
                "$gameSystem._trspupData.push(["+null+","+num+",bullet.screenShowX(),bullet.screenShowY()]);]"];
        } else data.Action = ["T[$gameParty.gainGold("+num+");]"];
    } else {
        if (type==0||type=="item") item="$dataItems["+id+"]";
        else if (type==1||type=="weapon") item="$dataWeapons["+id+"]";
        else if (type==2||type=="armor") item="$dataArmors["+id+"]";
        else {
            console.log("投射物品的指令参数错误。");
            return;
        }
        data.Img=[2,eval(item).iconIndex];
        if (Imported.MOG_TreasurePopup&&$gameSystem._trspupVisible) {
            if (num>0||(num<0&&Moghunter.trpopup_LostItemVisible)) 
                data.Action = ["T[$gameParty.gainItem("+item+","+num+");"+
                "$gameSystem._trspupData.push(["+item+","+num+",bullet.screenShowX(),bullet.screenShowY()]);]"];
        } else data.Action = ["T[$gameParty.gainItem("+item+","+num+");]"];
    }
    data.Update=(bullet)=>{
        if (bullet.moveType[4]==0&&bullet.QJBody) {
            if (bullet.itemOffset==undefined) bullet.itemOffset = 30;
            bullet.itemOffset--;
            if (bullet.itemOffset>=15) bullet.anchorY+=0.1/15;
            else bullet.anchorY-=0.1/15;
            if (bullet.itemOffset==0) bullet.itemOffset=30;
        }
    }
    QJ.BL.Shooter_HandGrenade(data,16,5,5);
}
QJ.BL.Shooter_CharacterAtk = function(character,data,of,arc) {
    //[ox2,oy2,ox4,oy4,ox6,oy6,ox8,oy8],[r1,r2,num,l]
    //====================================
    let tar = character==-1?$gamePlayer:
        (character==0?QJ.BL.getEvent():$gameMap.event(character));
    if (!tar) return;
    //====================================
    let orginRotation = QJ.BL.calculateAngleByDirection(tar.direction())*180/Math.PI;
    let ofx=of[tar.direction()-2],ofy=of[tar.direction()-1];
    //====================================
    if (arc) {
        let delta = (arc[1] - arc[0]) / arc[2];
        for (let i=arc[0];i<arc[1];i+=delta) {
            let bullet = {
                initialRotation:orginRotation+i+(Math.random()-0.5)*arc[3],
                x:tar.boxScreenSubX()+ofx,
                y:tar.boxScreenSubY()+ofy
            };
            for (let i in data) bullet[i] = data[i];
            QJ.BL.Shoot(bullet);
        }
    } else {
        let bullet = {
            initialRotation:orginRotation,
            x:tar.boxScreenSubX()+ofx,
            y:tar.boxScreenSubY()+ofy
        };
        for (let i in data) bullet[i] = data[i];
        QJ.BL.Shoot(bullet);
    }
    //====================================
}
QJ.BL.Shooter_P = function(data,r,speed,roSpeed,number,rotation,x,y,edgeNum) {
    if (edgeNum<2) {
        QJ.BL.error(" edgeNum "+edgeNum+" ");
        return;
    }
    if (number<2) {
        QJ.BL.error(" edgeNum "+number+" ");
        return;
    }
    //====================================
    let calRo=(a,b,c)=>{
        return Math.asin(a*Math.sin(c)/Math.sqrt(a*a+b*b-2*a*b*Math.cos(c)));
    };
    let calLo=(a,b,c)=>{
        return Math.sqrt(a*a+b*b-2*a*b*Math.cos(c));
    }
    //====================================
    for (let i=0,il=number-1,ilm=Math.max(Math.sqrt(2-2*Math.cos(2*Math.PI/edgeNum))*r/(number-1),1),
        c=Math.PI*(0.5-1/edgeNum),fan=false,halfil=(il+1)/2;i<il;i++) {
        if (i>halfil) fan=true;
        QJ.BL.Shooter_C(data,calLo(i*ilm,r,c),speed,roSpeed,edgeNum,rotation,x,y,
            fan?(-calRo((il-i)*ilm,r,c)):calRo(i*ilm,r,c));
    }
    //====================================
}
QJ.BL.Shooter_C = function(data,r,speed,roSpeed,number,rotation,x,y,extraRo) {
    //====================================
    let makeText=(r,rs,n,m,s)=>{
        return "F[-"+s+"*t+"+
        r+"*Math.sin(t/"+
        rs+"+2*Math.PI*"+
        n+"/"+m+"+"+extraRo+");0+"+
        r+"*Math.cos(t/"+
        rs+"+2*Math.PI*"+
        n+"/"+m+"+"+extraRo+")]";
    };
    //====================================
    let event=QJ.BL.getEvent();
    let ro = QJ.BL.dealInitialRotation(rotation,event,QJ.BL.dealX(x,event,false),QJ.BL.dealY(y,event,false));
    roSpeed=30/roSpeed/Math.PI;
    extraRo=extraRo||0;
    //====================================
    let bullet = {
        initialRotation:ro*180/Math.PI,
        Max:120,
        RotationAuto:0,
        Img:"dart",
        Regions:[1],
        x:x,
        y:y,
        MoveType:"S[]"
    }
    for (let i in data) bullet[i] = data[i];
    for (let i=0;i<number;i++) {
        bullet.MoveType=makeText(r,roSpeed,i,number,speed);
        QJ.BL.Shoot(JSON.parse(JSON.stringify(bullet)));
    }
    //====================================
}
QJ.BL.Shooter_ArcRange = function(initialRotation,data,arc) {
    //====================================
    let delta = (arc[1] - arc[0]) / arc[2];
    for (let i=arc[0];i<arc[1];i+=delta) {
        data["initialRotation"] = initialRotation+i+(Math.random()-0.5)*arc[3];
        QJ.BL.Shoot(data);
    }
    //====================================
}
QJ.BL.Shooter_HandGrenade = function(data,oneLength,oneTime,maxReBound) {
    //====================================
    //一倍宽度,发射角度,一倍时间,次数
    let bullet = {
        MoveType:"QP["+oneLength+","+Math.PI/3+","+oneTime+","+maxReBound+"]",
        Max:oneTime*(maxReBound+1)*maxReBound/2,
        NoCollisionAction:false,
        NoCollisionAnim:true,
        DeadAction:true,
        DeadAnim:true,
        Speed:18,
        ReBound:true,
        AnchorY:0.5,
        AtkRange:96
    };
    for (let i in data) bullet[i] = data[i];
    QJ.BL.Shoot(bullet);
    //====================================
}
QJ.BL.Shadow = function(character,data) {
    //====================================
    let tar = character==-1?$gamePlayer:
        (character==0?QJ.BL.getEvent():$gameMap.event(character));
    if (!tar) return;
    //====================================
    let bullet = {
        initialRotation:0,
        x:tar.boxScreenSubX(),
        y:tar.boxScreenSubY()+24,
        Speed:0,
        Img:[0,character],
        Bit:true
    };
    for (let i in data) bullet[i] = data[i];
    QJ.BL.Shoot(bullet);
    //====================================
}
QJ.BL.Text = function(text,color,fontsize,linecolor,linewidth,character,data) {
    //====================================
    let tar = character==-1?$gamePlayer:
        (character==0?QJ.BL.getEvent():$gameMap.event(character));
    if (!tar) return;
    let d=tar.direction(),box="R["+(fontsize-8)/72*96+","+text.length*(fontsize-4)/72*96+"]";
    //====================================
    let bullet = {
        Pierce:100,
        Speed:2,
        x:tar.boxScreenSubX()+(d==4?-text.length*(fontsize-4)/72*96/2:(d==6?text.length*(fontsize-4)/72*96/2:0)),
        y:tar.boxScreenSubY()+(d==8?-text.length*(fontsize-4)/72*96/2:(d==2?text.length*(fontsize-4)/72*96/2:0)),
        Img:[1,text,color,fontsize,(d==2||d==8?1:0),text.length*(fontsize-4)/72*96,(fontsize-4)/72*96,linecolor,linewidth],
        CollisionBox:box,
        AnchorX:0.5,
        AnchorY:0.5,
        PierceAction:true,
        RotationAuto:0,
        initialRotation:(d==2?180:(d==4?270:(d==6?90:0))),
    };
    for (let i in data) bullet[i] = data[i];
    QJ.BL.Shoot(bullet);
    //====================================
}
QJ.BL.Shoot = function(data,bo) {
    if (arguments[2]!=undefined) {
        data = {
            initialRotation:arguments[0],
            x:arguments[1],
            y:arguments[2],
            z:arguments[3],
            MoveType:arguments[4],
            Regions:arguments[5],
            Terrains:arguments[6],
            Target:arguments[7],
            Pierce:arguments[8],
            Img:arguments[9],
            Anim:arguments[10],
            DeadCount:arguments[11],
            Speed:arguments[12],
            Max:arguments[13],
            RotationAuto:arguments[14],
            Action:arguments[15],
            CollisionBox:arguments[16],
            Tone:arguments[17]?arguments[17]:[0,0,0,0],
            Opacity:arguments[18]?arguments[18]:255,
            AtkRange:arguments[20]?arguments[20]:0
        };
        bo = false;
    }
    //======================================
    let bullet = {
        //======================================
        initialRotation:"PD[]",
        x:"P[]",
        y:"P[]",
        z:"C[]",
        scaleX:100,
        scaleY:100,
        //======================================
        MoveType:"S[]",
        Regions:[],
        Terrains:[],
        Target:[],
        Pierce:0,
        //======================================
        Img:"bullet0",
        Anim:0,
        DeadCount:0,
        Speed:12,
        Max:120,
        RotationAuto:-1,
        //======================================
        Action:[],
        CollisionBox:"R[4,4]",
        //======================================
        Tone:[0,0,0,0],
        Opacity:255,
        AfterImage:[],
        Light:[],
        Particles:[],
        AtkRange:0,
        DeadAction:false,
        PierceAction:false,
        NoCollisionAction:false,
        DeadAnim:true,
        PierceAnim:false,
        NoCollisionAnim:false,
        ReBound:false,
        AnchorX:0.5,
        AnchorY:0,
        rTRotation:"",
        WaitBaseOnSpeed:-2,
        LMD:true,
        Update:"",
        Bit:false,
        DeadT:""
        //======================================
    };
    //======================================
    if (!bo) {
        for (let i in data) bullet[i] = data[i];
    } else bullet=data;
    //======================================
    let event=QJ.BL.getEvent();
    let isObject=false;
    if (typeof Img == "object") {
        if (Img[0]==0) isObject=true;
    }
    //======================================
    bullet["x"] = QJ.BL.dealX(bullet["x"],event,isObject);
    bullet["y"] = QJ.BL.dealY(bullet["y"],event,isObject);
    bullet["z"] = QJ.BL.dealZ(bullet["z"],event,isObject);
    bullet["initialRotation"] = 
        QJ.BL.dealInitialRotation(bullet["initialRotation"],event,bullet["x"],bullet["y"]);
    bullet["MoveType"] = QJ.BL.dealMoveType(bullet["MoveType"],event);
    bullet["CollisionBox"] = QJ.Matter.dealCollisionBox(bullet["CollisionBox"]);
    if (typeof bullet["Img"] == "object"&&bullet["Img"][0]==0&&bullet["Img"][1]==0) 
        bullet["Img"][1] = QJ.BL.getEvent()._eventId;
    //======================================
    //console.log(bullet);
    if (QJ.BL.findNull(bullet)) return null;
    return $gameMap.addBullet(bullet);
    //======================================
}
QJ.BL.ShootOld = function(initialRotation,x,y,z,MoveType,Regions,Terrains,Target,Pierce,Img,Anim,
    DeadCount,Speed,Max,RotationAuto,Action,CollisionBox,Tone,Opacity,AfterImage,
    AtkRange,Light,DeadAction,PierceAction,NoCollisionAction,DeadAnim,PierceAnim,NoCollisionAnim,
    ReBound,AnchorX,AnchorY,rTRotation,WaitBaseOnSpeed,scaleX,scaleY,LMD,Update,Bit,DeadT,Particles) {
    let bullet = {
        //======================================
        initialRotation:initialRotation,
        x:x,
        y:y,
        z:z,
        scaleX:scaleX,
        scaleY:scaleY,
        //======================================
        MoveType:MoveType,
        Regions:Regions,
        Terrains:Terrains,
        Target:Target,
        Pierce:Pierce,
        //======================================
        Img:Img,
        Anim:Anim,
        DeadCount:DeadCount,
        Speed:Speed,
        Max:Max,
        RotationAuto:RotationAuto,
        //======================================
        Action:Action,
        CollisionBox:CollisionBox,
        //======================================
        Tone:Tone,
        Opacity:Opacity,
        AfterImage:AfterImage,
        Light:Light,
        AtkRange:AtkRange,
        DeadAction:DeadAction,
        PierceAction:PierceAction,
        NoCollisionAction:NoCollisionAction,
        DeadAnim:DeadAnim,
        PierceAnim:PierceAnim,
        NoCollisionAnim:NoCollisionAnim,
        ReBound:ReBound,
        AnchorX:AnchorX,
        AnchorY:AnchorY,
        rTRotation:rTRotation,
        WaitBaseOnSpeed:WaitBaseOnSpeed,
        LMD:LMD,
        Update:Update,
        Bit:Bit,
        DeadT:DeadT,
        Particles:Particles?Particles:[]
        //======================================
    };
    QJ.BL.Shoot(bullet,true);
}
QJ.BL.deleteBullet = function(name) {
    for (let i of $gameMap._mapBullets) {
        if (!i) continue;
        if (i.bulletMode!=0||!i.data.Name) continue;
        if (i.data.Name==name) {
            i.setDirectDead();
        }
    }
}
QJ.BL.Quick = function(id,data) {
    if (!Preset[String(id)]) {
        console.log("id为"+id+"的预设不存在。");
        return;
    }
    let bullet = JsonEx.makeDeepCopy(Preset[String(id)]);
    for (let i in data) bullet[i] = data[i];
    QJ.BL.Shoot(bullet,true);
}
QJ.BL.QuickText = function(id) {
    if (!PresetText[String(id)]) {
        console.log("id为"+id+"的预设不存在。");
        return;
    }
    return JsonEx.makeDeepCopy(PresetText[String(id)]);
}
//=======================================LASER=======================================LASER
QJ.BL.Laser = function(data) {
    //======================================
    let bullet={
        name:-1,
        initialRotation:"M[]",
        x:"P[]",
        y:"P[]",
        z:"C[]",
        Action:[],
        Regions:[],
        Terrains:[],
        Target:[],
        Img:"laser1[2,5]",
        DeadCount:0,
        Tone:[0,0,0,0],
        Opacity:255,
        Width:12,
        AtkWait:30,
        ReBound:10,
        Max:120
    }
    //======================================
    for (let i in data) bullet[i] = data[i];
    //======================================
    let event=QJ.BL.getEvent();
    bullet.z = QJ.BL.dealZ(bullet.z,QJ.BL.getEvent(),false);
    if (event) {
        if (typeof bullet.x == "string") bullet.x=bullet.x.replace(/E\[0\]/ig,"E["+event._eventId+"]");
        if (typeof bullet.y == "string") bullet.y=bullet.y.replace(/E\[0\]/ig,"E["+event._eventId+"]");
        if (typeof bullet.initialRotation == "string") 
            bullet.initialRotation=bullet.initialRotation.replace(/D\[0\]/ig,"D["+event._eventId+"]");
    }
    //======================================
    if (QJ.BL.findNull(bullet)) return null;
    return $gameMap.addBullet(bullet,1);
    //======================================
}
QJ.BL.deleteLaser = function(name) {
    for (let i of $gameMap._mapBullets) {
        if (!i) continue;
        if (i.bulletMode!=1) continue;
        if (i.data.name==name) {
            i.setDead();
        }
    }
}
QJ.BL.dealCharacter = function(data) {
    if (typeof data == "number") {
        if (data==-1) return $gamePlayer;
        else if (data==0) return QJ.BL.getEvent()?QJ.BL.getEvent():null;
        else return $gameMap.event(data)?$gameMap.event(data):null;
    } else return data;
}
//=============================================================================
//
//=============================================================================
QJ.BL.hexToRgb = function (hex) {
    let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return {r: parseInt(result[1],16),g: parseInt(result[2], 16),b: parseInt(result[3], 16)};
}
QJ.BL.rgbToHex = function (rgb) {
    let r=rgb.r.toString(16),g=rgb.g.toString(16),b=rgb.b.toString(16);
    return "#"+(r.length==1?("0"+r):r)+(g.length==1?("0"+g):g)+(b.length==1?("0"+b):b);
}
QJ.BL.calculateAngleByTwoPoint=function(x,y,ex,ey){
    let ro;
    if (ex>x&&ey<y)  ro=(-Math.atan((x-ex)/(y-ey)));
    if (ex>x&&ey>y)  ro=(Math.PI-Math.atan((x-ex)/(y-ey)));
    if (ex<x&&ey>y)  ro=(Math.PI-Math.atan((x-ex)/(y-ey)));
    if (ex<x&&ey<y)  ro=(2*Math.PI-Math.atan((x-ex)/(y-ey)));
    if (ex==x&&ey>y) ro=Math.PI;
    if (ex==x&&ey<y) ro=0;
    if (ex>x&&ey==y) ro=Math.PI/2;
    if (ex<x&&ey==y) ro=Math.PI*3/2;
    if (ex==x&&ey==y)ro=null;//说明在同一点
    return ro;
};
QJ.BL.calculateAngleByDirection=function(direction){
    if (direction==1) return Math.PI*5/4;//左下
    if (direction==2) return Math.PI;
    if (direction==3) return Math.PI*3/4;//右下
    if (direction==4) return Math.PI*3/2;
    if (direction==6) return Math.PI/2;
    if (direction==7) return Math.PI*7/4;//左上
    if (direction==8) return 0;
    if (direction==9) return Math.PI/4;//右上
    return 0;
};
QJ.BL.getAnnotation = function(event) {
    let page=null,content="";
    try{
        page=event.page();
    } catch(e) {
        page=null;
    }
    if (page) {
        if (page.list[0].code === 108) {
            let i=0;
            while (page.list[i].code === 408 || page.list[i].code === 108) {
                content=content + page.list[i].parameters[0];
                i++;
            }
        }
    }
    return content;
};
QJ.BL.getGroup = function(name) {
    let basedata=$gameMap.events(),eventList=new Array();
    for (let i in basedata) {
        let content=QJ.BL.getAnnotation(basedata[i]);
        let detail = content.match(/<Group:[^>]*>/i);
        if (detail) {
            detail=detail[0].substr(8,detail[0].length-10);
            if (detail==name) {
                eventList.push(basedata[i]);
            }
        }
    }
    return eventList;
};
QJ.BL.getGroupId = function(name) {
    let basedata=$gameMap.events(),eventIdList=new Array();
    for (let i in basedata) {
        let content=QJ.BL.getAnnotation(basedata[i]);
        let detail = content.match(/<Group:[^>]*>/i);
        if (detail) {
            detail=detail[0].substr(8,detail[0].length-10);
            if (detail==name) {
                eventIdList.push(basedata[i]._eventId);
            }
        }
    }
    return eventIdList;
};
QJ.BL.getMinEventId = function(x,y,group) {
    let basedata=null,min=9999999,id=0;
    if (group) {
        basedata=QJ.BL.getGroup(group);
    } else {
        basedata=$gameMap.events();
    }
    for (let i in basedata) {
        let length=(basedata[i].boxScreenX()-x)*(basedata[i].boxScreenX()-x)+
                   (basedata[i].boxScreenY()-y)*(basedata[i].boxScreenY()-y);
        if (length<min) {
            id=basedata[i]._eventId;
            min=length;
        }
    }
    return id;
};
QJ.BL.getMinEventIdNobi = function(x,y,nobi) {
    let basedata=null,min=9999999,id=0;
    if (nobi) {
        basedata=QJ.BL.getComment(nobi);
    } else {
        basedata=$gameMap.events();
    }
    for (let i in basedata) {
        let length=(basedata[i].boxScreenX()-x)*(basedata[i].boxScreenX()-x)+
                   (basedata[i].boxScreenY()-y)*(basedata[i].boxScreenY()-y);
        if (length<min) {
            id=basedata[i]._eventId;
            min=length;
        }
    }
    return id;
};
QJ.BL.getCommentId = function(name) {
    let basedata=$gameMap.events(),eventIdList=new Array();
    for (let i in basedata) {
        if (basedata[i].event().note.includes(name)) {
            if (basedata[i]._pageIndex>=0) {
                eventIdList.push(basedata[i]._eventId);
            }
        }
    }
    return eventIdList;
};
QJ.BL.getComment = function(name) {
    let basedata=$gameMap.events(),eventIdList=new Array();
    for (let i in basedata) {
        if (basedata[i].event().note.includes(name)) {
            if (basedata[i]._pageIndex>=0) {
                eventIdList.push(basedata[i]);
            }
        }
    }
    return eventIdList;
};
QJ.BL.error=function(content){
    if (!showWarn) return;
    throw new Error("子弹数据中的"+content+"书写错误。");
};
QJ.BL.findNull=function(bullet){
    for (var i in bullet) {
        if (bullet[i]==null) {
            if (!showWarn) return true;
            console.error("参数录入有误，某子弹未成功创建。错误点："+i);
            return true;
        } 
    }
    return false;
};
Game_Map.prototype.xyQJLight = function(x,y,r,c,t) {
    if (!Imported.TerraxLighting) {
        console.warn("没有TerraxLighting插件，无法启动光效插件。");
        return;
    }
    var x1 = x;
    var y1 = y;
    var radius = r;
    var color = c;
    var time =t;
    var def = radius+","+color+","+time;
    Terrax_ABS_blast_x.push(x1);
    Terrax_ABS_blast_y.push(y1);
    Terrax_ABS_blast.push(def);
    Terrax_ABS_blast_duration.push(-1);
    Terrax_ABS_blast_fade.push(-1);
    Terrax_ABS_blast_grow.push(-1);
    Terrax_ABS_blast_mapid.push($gameMap.mapId());
};
const QJB_Game_Interpreter_executeCommand = Game_Interpreter.prototype.executeCommand;
Game_Interpreter.prototype.executeCommand = function() {
    QJBInter=this;
    return QJB_Game_Interpreter_executeCommand.call(this);
};
QJ.BL.callCE = function (id,bullet) {
    QJ.BL.callCommonEvent(id,0,[],{x:bullet.screenShowX(),y:bullet.screenShowY()});
}
//=============================================================================
//
//=============================================================================
QJ.BL.getEvent=()=>{return (typeof QJBInter == "number")?$gameMap.event(QJBInter):$gameMap.event(QJBInter._eventId);};
QJ.BL.dealInitialRotation=function(data,event,x,y){
    //======================================
    if (!isNaN(Number(data))) return data*Math.PI/180;
    //======================================
    if (data[0]=="S") {
        data=data.substr(2,data.length-3);
        try{
            data=eval(data);
            if (isNaN(Number(data))) return null;
            return Number(data);
        } catch(e) {
            return null;
        }
    }
    //======================================
    try{
    //======================================
    data=data.replace(/PD(\[\])*/ig,(d)=>{
        return QJ.BL.calculateAngleByDirection($gamePlayer.direction())*180/Math.PI;
    });
    data=data.replace(/EV\[([^\],]*)\]/ig,(d,s1)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            $gameMap.event($gameVariables.value(Number(s1))).boxScreenSubX(),
            $gameMap.event($gameVariables.value(Number(s1))).boxScreenSubY())*180/Math.PI;
    });
    data=data.replace(/XM\[([^\],]*)\]YM\[([^\],]*)\]/ig,(d,s1,s2)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            Number(s1)*tileSize+24 + $gameMap.displayX(),
            Number(s2)*tileSize+24 + $gameMap.displayY())*180/Math.PI;
    });
    //======================================
    data=data.replace(/P(\[\])+/ig,(d)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            $gamePlayer.boxScreenSubX(),$gamePlayer.boxScreenSubY())*180/Math.PI;
    });
    data=data.replace(/M(\[\])+/ig,(d)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            TouchInput.x + $gameMap.displayX(),TouchInput.y + $gameMap.displayY())*180/Math.PI;
    });
    data=data.replace(/D\[([^\],]+)\]/ig,(d,s1)=>{
        return QJ.BL.calculateAngleByDirection(
            s1==0?event.direction():$gameMap.event(Number(s1)).direction())*180/Math.PI;
    });
    data=data.replace(/E\[([^\],]+)\]/ig,(d,s1)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            $gameMap.event(Number(s1)).boxScreenSubX(),
            $gameMap.event(Number(s1)).boxScreenSubY())*180/Math.PI;
    });
    data=data.replace(/G\[([^\],]+)\]/ig,(d,s1)=>{
        let eventData = $gameMap.event(QJ.BL.getMinEventId(x+$gameMap.displayX()*48,y+$gameMap.displayY()*48,s1));
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            eventData.boxScreenSubX(),eventData.boxScreenSubY())*180/Math.PI;
    });
    data=data.replace(/N\[([^\],]+)\]/ig,(d,s1)=>{
        let eventData = $gameMap.event(QJ.BL.getMinEventIdNobi(x+$gameMap.displayX()*48,y+$gameMap.displayY()*48,s1));
        return QJ.BL.calculateAngleByTwoPoint(x,y,
            eventData.boxScreenSubX(),eventData.boxScreenSubY())*180/Math.PI;
    });
    data=data.replace(/X\[([^\],]+)\]Y\[([^\],]+)\]/ig,(d,s1,s2)=>{
        return QJ.BL.calculateAngleByTwoPoint(x,y,Number(s1),Number(s2))*180/Math.PI;
    });
    //======================================
    data=eval(data);
    if (isNaN(Number(data))) return null;
    return Number(data)*Math.PI/180;
    //======================================
    } catch(e) {return null;}
    //======================================
};
QJ.BL.dealX=function(data,event,ifSpecial){
    //======================================
    if (!isNaN(Number(data))) return data;
    //======================================
    if (data[0]=="S") {
        data=data.substr(2,data.length-3);
        try{
            data=eval(data);
            if (isNaN(Number(data))) return null;
            return Number(data);
        } catch(e) {
            return null;
        }
    }
    //======================================
    try{
    //======================================
    data=data.replace(/P(\[\])+/ig,(d)=>{
        return ifSpecial?$gamePlayer.screenX():$gamePlayer.boxScreenSubX();
    });
    data=data.replace(/M(\[\])+/ig,(d)=>{
        return TouchInput.x;
    });
    data=data.replace(/E\[([^\],]+)\]/ig,(d,s1)=>{
        let tar = Number(s1)==0?event:$gameMap.event(Number(s1));
        return ifSpecial?tar.screenX():tar.boxScreenSubX();
    });
    //======================================
    data=eval(data);
    if (isNaN(Number(data))) return null;
    return Number(data);
    //======================================
    } catch(e) {return null;}
    //======================================
};
QJ.BL.dealY=function(data,event,ifSpecial){
    //======================================
    if (!isNaN(Number(data))) return data;
    //======================================
    if (data[0]=="S") {
        data=data.substr(2,data.length-3);
        try{
            data=eval(data);
            if (isNaN(Number(data))) return null;
            return Number(data);
        } catch(e) {
            return null;
        }
    }
    //======================================
    try{
    //======================================
    data=data.replace(/P(\[\])+/ig,(d)=>{
        return ifSpecial?$gamePlayer.screenY():$gamePlayer.boxScreenSubY();
    });
    data=data.replace(/M(\[\])+/ig,(d)=>{
        return TouchInput.y;
    });
    data=data.replace(/E\[([^\],]+)\]/ig,(d,s1)=>{
        let tar = Number(s1)==0?event:$gameMap.event(Number(s1));
        return ifSpecial?tar.screenY():tar.boxScreenSubY();
    });
    //======================================
    data=eval(data);
    if (isNaN(Number(data))) return null;
    return Number(data);
    //======================================
    } catch(e) {return null;}
    //======================================
};
QJ.BL.dealZ=function(data,event,ifSpecial){
    if (typeof data === "number") return "C";
    else if (data[0]=="T") return "T";
    else if (data[0]=="M") return "M";
    else if (data[0]=="C") return "C";
    else if (data[0]=="P") return "P";
    else return null;
};
QJ.BL.dealMoveType = function(movetype,event) {
    if (movetype[0]=="S") return [0];
    //======================================
    try{
    if (movetype[0]=="F") {
        let data=movetype.substr(2,movetype.length-3);
        if (data.includes(";")) {
            data=data.split(";");
            if (data.length!=2) return null;
            return [8,0,data[0],data[1]];
        } else {
            data=data.split("|");
            if (data.length!=2) return null;
            return [8,1,data[0],data[1]];
        }
    }
    if (movetype[0]=="B") {
        let data=(movetype.substr(2,movetype.length-3)).split(",");
        if (Number(data[0])==0) data[0] = event._eventId;
        else data[0] = Number(data[0]);
        if (!data) return null;
        return [5,data[0],Number(data[1]),Number(data[2]),Number(data[3]),Number(data[4])
                         ,Number(data[5]),Number(data[6]),Number(data[7]),Number(data[8])];
    }
    if (movetype[0]=="Q"&&movetype[1]=="P") {
        let data=(movetype.substr(3,movetype.length-4)).split(",");
        if (!data) return null;
        return [6,Number(eval(data[0])),Number(eval(data[1])),
                  Number(eval(data[2])),Number(eval(data[3]))];
    }
    if (movetype[0]!="T") return null;
    //======================================
    if (movetype[1]=="E"&&movetype[2]=="V") {
        let data=movetype.match(/\[[^\]]*\]/i);
        if (!data) return null;
        let detail=eval(data[0]);
        return [3,Number(detail[0]),$gameVariables.value(Number(detail[1]))];
    }
    if (movetype[1]=="E") {
        let data=movetype.match(/\[[^\]]*\]/i);
        if (!data) return null;
        let detail=eval(data[0]);
        return [2,Number(detail[0]),Number(detail[1])];
    }
    if (movetype[1]=="P") {
        let data=movetype.match(/\[[^\]]*\]/i);
        if (!data) return null;
        let detail=eval(data[0]);
        return [1,Number(detail[0])];
    }
    if (movetype[1]=="G") {
        let data=(movetype.substr(3,movetype.length-4)).split(",");
        if (!data) return null;
        return [4,Number(data[0]),String(data[1])];
    }
    if (movetype[1]=="N") {
        let data=(movetype.substr(3,movetype.length-4)).split(",");
        if (!data) return null;
        return [7,Number(data[0]),String(data[1])];
    }
    return null;
    //======================================
    } catch(e) {return null;}
    //======================================
};
QJ.BL.dealTarget = function(data) {
    let tarList=new Array();
    //======================================
    try{
    //======================================
    for (let i of data) {
        if (i[0]=="E"&&i[1]=="V") {
            let detail=eval(i.match(/\[[^\]]*\]/i)[0]);
            if (!detail||isNaN(Number(detail[0]))) continue;
            tarList.push($gameVariables.value(Number(detail[0])));
        } else if (i[0]=="E") {
            let detail=eval(i.match(/\[[^\]]*\]/i)[0]);
            if (!detail||isNaN(Number(detail[0]))) continue;
            tarList.push(Number(detail[0]));
        } else if (i[0]=="P") {
            tarList.push(-1);
        } else if (i[0]=="G") {
            let detail=i.substr(2,i.length-3);
            if (!detail) continue;
            tarList=tarList.concat(QJ.BL.getGroupId(detail));
        } else if (i.includes("Nobi")) {
            let detail=i.substr(5,i.length-6);
            if (!detail) continue;
            tarList=tarList.concat(QJ.BL.getCommentId("["+detail+"]"));
        }
    }
    return tarList;
    //======================================
    } catch(e) {return null;}
    //======================================
};
QJ.BL.startAction=function(bullet,tarCharacter){
    let dataList=bullet.action,eid=0;
    if (tarCharacter) {
        if (tarCharacter==$gamePlayer) eid=-1;
        else if (tarCharacter._eventId>0) eid=tarCharacter._eventId;
    }
    let bulletX = bullet.screenShowX(),bulletY = bullet.screenShowY();
    if (typeof dataList === "string") dataList=[dataList];
    for (let data of dataList) {
    if (data[0]=="C"&&data[1]=="P"&&eid!=0) {
        let detail=eval(data.match(/\[[^\]]*\]/i)[0]);
        if (!detail) return;
        if (isNaN(Number(detail[0]))) return;
        if (Number(detail[0])<=0||!Number.isInteger(detail[0])) return;
        QJ.BL.CallEvent(eid,Number(detail[0]));
    } else if (data[0]=="C") {
        let detail=eval(data.match(/\[[^\]]*\]/i)[0]);
        if (!detail) return;
        if (isNaN(Number(detail[0]))) return;
        if (Number(detail[0])<=0||!Number.isInteger(detail[0])) return;
        QJ.BL.callCommonEvent(Number(detail[0]),eid,detail,{
            x:bulletX,
            y:bulletY,
        });
    } else if (data[0]=="S"&&data[1]=="S"&&eid!=0) {
        let detail=data.substr(3,data.length-4).split(",");
        let key = [$gameMap.mapId(),eid,detail[0]];
        let result=detail[1]=="true"?true:false;
        $gameSelfSwitches.setValue(key,result);
    } else if (data[0]=="S") {
        let detail=eval(data.match(/\[[^\]]*\]/i)[0]);
        if (!detail) return;
        if (isNaN(Number(detail[0]))) return;
        if (Number(detail[0])<=0||!Number.isInteger(detail[0])) return;
        $gameSwitches.setValue(Number(detail[0]),detail[1]);
    } else if (data[0]=="E") {
        if (tarCharacter._eventId>0) tarCharacter.erase();
    } else if (data[0]=="T") {
        let detail=data.substr(2,data.length-3);
        eval(detail);
    }
    }
};
QJ.BL.DirectAction = function(x,y,box,action,target,lastAtkEvent) {
    //==========================================
    let boxData = QJ.Matter.dealCollisionBox(box),body;
    let event=QJ.BL.getEvent();
    let xo = QJ.BL.dealX(x,event,false);
    let yo = QJ.BL.dealY(y,event,false);
    x = xo+$gameMap.displayX()*tileSize;
    y = yo+$gameMap.displayY()*tileSize;
    //==========================================
    if (boxData[0]==0) body=QJ.Matter.circle(x,y,boxData[1]);
    else if (boxData[0]==1) body=QJ.Matter.rectangle(x,y,boxData[1],boxData[2]);
    if (!body) return [];
    //==========================================
    target = QJ.BL.dealTarget(target);
    let hasAtkEvent = [];
    lastAtkEvent = lastAtkEvent||[];
    //==========================================
    for (let i=0,l=target.length;i<l;i++) {
        let character=null;
        character=QJ.BL.dealCharacter(target[i]);
        if (!character) continue;
        if (lastAtkEvent.includes(character)) continue;
        if (QJ.Matter.judge(body,character.QJBody).collided) {
            hasAtkEvent.push(character);
            QJ.BL.startAction({
                action:action,
                screenShowX:()=>{return xo;},
                screenShowY:()=>{return yo;}
            },character);
        }
    }
    return hasAtkEvent;
}
QJ.BL.dealParticles = function(data){
    if (typeof data !== "object"||data.length==null||data.length==undefined) return [];
    for (let i in data) {
        if (typeof data[i] == "string") {
            try{data[i] = JsonEx.parse(data[i]);}catch(e){data[i] = null;}
        } else if (typeof data[i] !== "object") data[i] = null;
        if (!data[i]) continue;
        let list = {
            img:null,
            offsetX:0,
            offsetY:0,
            dir:Math.PI,
            dirOffset:Math.PI/6,
            max:30,
            deadCount:60,
            opacityMin:0.5,
            opacityMax:1,
            scaleMin:0.5,
            scaleMax:1.5,
            moveType:"-8*t;0",
            wait:2,
            num:1
        };
        for (let j in data[i]) list[j] = data[i][j];
        list.count = list.wait;
        data[i] = list;
    };
    return data;
};
//=============================================================================
//Call Page
//=============================================================================
QJ.BL.CallEvent = function(value,listvalue){
    if ($gameMap.event(value)) 
    $gameMap.event(value).steupTarPageQB(listvalue);
};
const QB_Game_Event_initialize = Game_Event.prototype.initialize;
Game_Event.prototype.initialize = function(mapId, eventId) {
    this._forceInterpreterQB = new Array();
    QB_Game_Event_initialize.call(this,mapId, eventId);
};
Game_Event.prototype.steupTarPageQB = function(value) {
    if (!!this.event().pages[value-1])
    this._forceInterpreterQB.push(new Game_InterpreterForceQBEvent(value-1));
};
const QB_Game_Event_updateParallel = Game_Event.prototype.updateParallel;
Game_Event.prototype.updateParallel = function() {
    QB_Game_Event_updateParallel.call(this);
    for (let i=0,l=this._forceInterpreterQB.length;i<l;i++) {
        if (!this._forceInterpreterQB[i]) continue;
        if (!this._forceInterpreterQB[i].isRunning()) {
            this._forceInterpreterQB[i].setup(
                this.event().pages[this._forceInterpreterQB[i].pageIndex].list,
                this._eventId);
        }
        this._forceInterpreterQB[i].update();
    }
};
function Game_InterpreterForceQBEvent() {
    this.initialize.apply(this, arguments);
};
Game_InterpreterForceQBEvent.prototype = Object.create(Game_Interpreter.prototype);
Game_InterpreterForceQBEvent.prototype.constructor = Game_InterpreterForceQBEvent;
Game_InterpreterForceQBEvent.prototype.initialize = function(pageIndex) {
    Game_Interpreter.prototype.initialize.call(this,0);
    this.pageIndex=pageIndex;
};
Game_InterpreterForceQBEvent.prototype.terminate = function() {
    $gameMap.event(this.eventId())._forceInterpreterQB.splice(
        $gameMap.event(this.eventId())._forceInterpreterQB.indexOf(this),1);
    Game_Interpreter.prototype.terminate.call(this);
};
//=============================================================================
//Common Event
//=============================================================================
QJ.BL.callCommonEvent = function(listvalue,eid,bp,bulletCanUseData){
    $gameMap.steupTarPageQB(listvalue,eid,bp,bulletCanUseData);
};
const QB_Game_Map_initialize = Game_Map.prototype.initialize;
Game_Map.prototype.initialize = function() {
    QB_Game_Map_initialize.call(this);
    this._forceInterpreterQB = new Array();
};
Game_Map.prototype.steupTarPageQB = function(value,eid,bp,bulletCanUseData) {
    if (!!$dataCommonEvents[value])
    this._forceInterpreterQB.push(new Game_InterpreterForceQBCommonEvent(value,eid,bp,bulletCanUseData));
};
//Game_Map.prototype.update
function Game_InterpreterForceQBCommonEvent() {
    this.initialize.apply(this, arguments);
};
Game_InterpreterForceQBCommonEvent.prototype = Object.create(Game_Interpreter.prototype);
Game_InterpreterForceQBCommonEvent.prototype.constructor = Game_InterpreterForceQBCommonEvent;
Game_InterpreterForceQBCommonEvent.prototype.initialize = function(id,eid,bp,bulletCanUseData) {
    Game_Interpreter.prototype.initialize.call(this,0);
    this.commonEventId=id;
    this.EID=eid;
    this.BP=bp;
    this.bullet = bulletCanUseData;
};
Game_InterpreterForceQBCommonEvent.prototype.terminate = function() {
    $gameMap._forceInterpreterQB.splice($gameMap._forceInterpreterQB.indexOf(this),1);
    Game_Interpreter.prototype.terminate.call(this);
};
//=============================================================================
//Game_Map
//=============================================================================
const QJB_Game_Map_setup = Game_Map.prototype.setup;
Game_Map.prototype.setup = function(mapId) {
    this._mapBullets = [];
    this._forceInterpreterQB = new Array();
    QJ.Matter.bulletClear();
    QJB_Game_Map_setup.call(this,mapId);
};
Game_Map.prototype.bulletsNumber = function() {
    return $gameMap._aliveBullet;
};
Game_Map.prototype.addBullet = function(bullet,type) {
    if (showWarn) {
        if ($gameMap._aliveBullet>=maxbullet) {
            console.warn("The number of bullets has reached the limit."+
                "And the number is"+$gameMap._aliveBullet+".");
            return null;
        }
    }
    let bulletsTarget;
    if (!type) bulletsTarget=new Game_QJBullet(bullet,this._mapBullets.length);
    else if (type==1) bulletsTarget=new Game_QJLaser(bullet,this._mapBullets.length);
    this._mapBullets.push(bulletsTarget);
    if (!this._mapBullets[this._mapBullets.length-1].dead)
       SceneManager._scene._spriteset.createBullet(this._mapBullets.length-1,type);
    return bulletsTarget;
};
Game_Map.prototype.removeBullet = function(index) {
    let data=this._mapBullets[index];
    if (data) {
        //=====================remove sprite=====================

        if (data.sprite) {
            if (data.sprite.parent) data.sprite.parent.removeChild(data.sprite);
            data.sprite.destroy();
        }
        //====================remove matter body=================
        if (data.QJBody) {
            QJ.Matter.bulletRemove(data.QJBody);
            data.QJBody.parentTarget = null;
            data.QJBody = null;
            data.QJBodyForJudge = null;
        }
        //=====================remove data=======================
        data.destroy();
        this._mapBullets[index] = null;
        //=======================================================
    }
};
Game_Map.prototype.bullet = function(index) {
    return this._mapBullets[index];
};
//Game_Map.prototype.update;
//=============================================================================
//Spriteset_Map
//=============================================================================
Spriteset_Map.prototype.clearAllButtle = function() {
    this._upperBulletContainer.removeChildren();
    this._lowerBulletContainer.removeChildren();
    this._parallaxBulletContainer.removeChildren();
    this._mapBulletContainer.removeChildren();
    $gameMap._mapBullets = [];
    QJ.Matter.bulletClear();
};
const QJB_Spriteset_Map_createParallax = Spriteset_Map.prototype.createParallax;
Spriteset_Map.prototype.createParallax = function() {
    QJB_Spriteset_Map_createParallax.call(this);
    this._parallaxBulletContainer = new Sprite_QJContainer();
    this._parallaxBulletContainerParticle = new Sprite_QJContainer();
    this._baseSprite.addChild(this._parallaxBulletContainerParticle);
    this._baseSprite.addChild(this._parallaxBulletContainer);
};
const QJB_Spriteset_creatBullets = Spriteset_Map.prototype.createCharacters;
Spriteset_Map.prototype.createCharacters = function() {
    this._mapBulletContainer = new Sprite_QJContainer();
    this._mapBulletContainerParticle = new Sprite_QJContainer();
    this._mapBulletContainer.z = 0;
    this._mapBulletContainerParticle.z = 0;
    this._tilemap.addChild(this._mapBulletContainerParticle);
    this._tilemap.addChild(this._mapBulletContainer);
    QJB_Spriteset_creatBullets.call(this);
    this._upperBulletContainer = new Sprite_QJContainer();
    this._upperBulletContainerParticle = new Sprite_QJContainer();
    this._lowerBulletContainer = new Sprite_QJContainer();
    this._lowerBulletContainerParticle = new Sprite_QJContainer();
    //The upper container will be added later.
    //To ensure it will be added above picture.
    this.addChild(this._lowerBulletContainerParticle);
    this.addChild(this._lowerBulletContainer);
    if (!$gameMap._mapBullets) return;
    if ($gameMap._mapBullets.length==0) return;
    for (let i=0;i<$gameMap._mapBullets.length;i++) {
        if ($gameMap._mapBullets[i]) this.createBullet(i,$gameMap._mapBullets[i].bulletMode);
    }
};
const QJB_Spriteset_Base_createTimer = Spriteset_Base.prototype.createTimer;
Spriteset_Base.prototype.createTimer = function() {
    QJB_Spriteset_Base_createTimer.call(this);
    this.addChild(this._upperBulletContainerParticle);
    this.addChild(this._upperBulletContainer);
};
Spriteset_Map.prototype.createBullet = function(index,type) {
    let data=$gameMap._mapBullets[index],spriteData;
    if (data.sprite) {
        if (data.sprite.parent) data.sprite.parent.removeChild(data.sprite);
        data.sprite.destroy();
    }
    if (!type) spriteData=new Sprite_QJBullet(index);
    else if (type==1) spriteData=new Sprite_QJLaser(index);
    if (data.data.z=="T") {
        this._parallaxBulletContainer.addChild(spriteData);
        spriteData.particleParent = this._parallaxBulletContainerParticle;
    } else if (data.data.z=="M") {
        this._mapBulletContainer.addChild(spriteData);
        spriteData.particleParent = this._mapBulletContainerParticle;
    } else if (data.data.z=="P") {
        this._upperBulletContainer.addChild(spriteData);
        spriteData.particleParent = this._upperBulletContainerParticle;
    } else {
        this._lowerBulletContainer.addChild(spriteData);
        spriteData.particleParent = this._lowerBulletContainerParticle;
    }
    data.sprite=spriteData;
};
//=============================================================================
//Sprite_QJContainer
//=============================================================================
function Sprite_QJContainer() {
    this.initialize.apply(this, arguments);
};
Sprite_QJContainer.prototype = Object.create(PIXI.Container.prototype);
Sprite_QJContainer.prototype.constructor = Sprite_QJContainer;
Sprite_QJContainer.prototype.initialize = function() {
    PIXI.Container.call(this);
    this.list={};
}
Sprite_QJContainer.prototype.addChildrenAtId = function(bulletSprite) {
    let bulletSpriteId=bulletSprite.QJParentid;
    if (this.list[bulletSpriteId]) {
        this.list[bulletSpriteId].addChild(bulletSprite);
    } else{
        let newContainer=new Sprite_QJPContainer(bulletSpriteId);
        this.addChild(newContainer);
        newContainer.addChild(bulletSprite);
        this.list[bulletSpriteId]=newContainer;
    }
};
Sprite_QJContainer.prototype.update = function() {
    this.children.forEach(function(child) {
        if (child.update) {
            child.update();
        }
    });
};
//=============================================================================
//Sprite_QJPContainer
//=============================================================================
function Sprite_QJPContainer() {
    this.initialize.apply(this, arguments);
};
Sprite_QJPContainer.prototype = Object.create(PIXI.particles.ParticleContainer.prototype);
Sprite_QJPContainer.prototype.constructor = Sprite_QJPContainer;
Sprite_QJPContainer.prototype.initialize = function(id) {
    PIXI.particles.ParticleContainer.call(this,10000,{
        rotation:true,
        scale:true,
        alpha:true,
        uvs:true}
    );
    this.QJParentid=id;
};
Sprite_QJPContainer.prototype.update = function() {
    this.children.forEach(function(child) {
        if (child.update) {
            child.update();
        }
    });
};
//=============================================================================
//Sprite_QJY
//=============================================================================
function Sprite_QJY() {
    this.initialize.apply(this, arguments);
};
Sprite_QJY.prototype = Object.create(PIXI.Sprite.prototype);
Sprite_QJY.prototype.constructor = Sprite_QJY;
Sprite_QJY.prototype.initialize = function(parent,data,buttle) {
    if (data[0]==1) this.QJParentid="qjy1"+Math.floor(data[5])+Math.floor(data[6])+data[7];
    else if (data[0]==2) this.QJParentid="qjy2"+data[1].img;
    this.baseTexture = textureSave[this.QJParentid]?
        textureSave[this.QJParentid]:this.createTexture(data);
    this.textureData = this.baseTexture?(new PIXI.Texture(this.baseTexture,new PIXI.Rectangle(0,0,0,0))):null;
    PIXI.Sprite.call(this,this.textureData);
    this.bitType = data[0];
    if (this.bitType==1) {
        if (buttle.moveType[0]==6) this.rotation = buttle.rM6S[2];
        else if (buttle.moveType[0]==5||buttle.moveType[0]==8) this.rotation = buttle.rotationMove;
        else this.rotation = parent.rotation;
        this._x=parent.x+$gameMap.displayX()*48;
        this._y=parent.y+$gameMap.displayY()*48;
        //=======================================
        this.opacity = data[4];
        this.perFade=Math.max(this.opacity/data[3],1);
        this.time=data[2];
        this.setFrame(0,0,data[5],data[6]);
    } else if (this.bitType==2) {
        this.data = data[1];
        this._x=parent.x+
            eval(this.data.offsetX)*Math.cos(parent.rotation)-
            eval(this.data.offsetY)*Math.sin(parent.rotation)+
            $gameMap.displayX()*48;
        this._y=parent.y+
            eval(this.data.offsetY)*Math.cos(parent.rotation)-
            eval(this.data.offsetX)*Math.sin(parent.rotation)+
            $gameMap.displayY()*48;
        this.rotation = parent.rotation + this.data.dir + Math.random()*this.data.dirOffset*2 - this.data.dirOffset;
        //=======================================
        this.opacity = ((this.data.opacityMax-this.data.opacityMin)*Math.random()+this.data.opacityMin)*255;
        this.perFade=Math.max(this.opacity/this.data.deadCount,1);
        this.time=this.data.max;
        this.sizeManager = [0,10,((this.data.scaleMax-this.data.scaleMin)*Math.random()+this.data.scaleMin)/10];
        this.setScale(this.sizeManager[0]*this.sizeManager[2]);
        let frameImage=this.data.img.match(/\[[^\]]*\]/i);
        if (frameImage){
            let data=eval(frameImage[0]);
            this.dymaticBitmap=[0,Number(data[0]),this.baseTexture.width/Number(data[0]),0,Number(data[1]),this.baseTexture.height];
            this.setFrame(this.dymaticBitmap[0]*this.dymaticBitmap[2],0,this.dymaticBitmap[2],this.dymaticBitmap[5]);
        } else this.setFrame(0,0,this.baseTexture.width,this.baseTexture.height);
        if (this.data.moveType.includes(";")) {
            this.mTFT=0;
            this.moveType=this.data.moveType.split(";");
        } else {
            this.mTFT=1;
            this.moveType=this.data.moveType.split("|");
        }
        if (this.moveType.length!=2) {
            this.moveTypeWrong();
            this.data.moveType=[0,0];
        }
    } 
    this.anchor.set(0.5,0.5);
    this.updateBaseData();
    numberQJY++;
};
Sprite_QJY.prototype.moveTypeWrong = function() {
    if (showWarn) console.warn("The moveType "+this.data.moveType+" of particle is wrong.");
}
Sprite_QJY.prototype.update = function() {
    this.updateBaseData();
    if (this.time<=0) {
        this.opacity-=this.perFade;
        if (this.opacity<=0) {
            this.parent.removeChild(this);
            numberQJY--;
            this.destroy();
            return;
        }
    }
    this.time--;
};
Sprite_QJY.prototype.setFrame = function(x,y,w,h) {
    this.textureData.frame = new PIXI.Rectangle(
        Math.floor(x),Math.floor(y),Math.floor(w),Math.floor(h));
};
Sprite_QJY.prototype.setScale = function(size) {
    this.scale = new PIXI.ObservablePoint(null,null,size,size);
};
Sprite_QJY.prototype.updateBaseData = function() {
    if (this.bitType==1) {
        this.alpha = this.opacity/255;
        this.x=this._x-$gameMap.displayX()*48;
        this.y=this._y-$gameMap.displayY()*48;
    } else if (this.bitType==2) {
        //=============================================
        if (this.sizeManager[0]<this.sizeManager[1]) {
            this.sizeManager[0]++;
            this.setScale(this.sizeManager[0]*this.sizeManager[2]);
        }
        //=============================================
        this.alpha = this.opacity/255;
        //=============================================
        let r=this.rotation,m=this.moveType,t=this.data.max-this.time,xL=0,yL=0;
        try{
            if (this.mTFT==0) {
                xL=-1*Number(eval(m[0]));yL=Number(eval(m[1]));
            } else {
                let length = -1*Number(eval(m[0])),rota=Number(eval(m[1]));
                xL=length*Math.cos(rota);
                yL=length*Math.sin(rota);
            }
        } catch(e) {
            this.moveTypeWrong();
            xL=0;
            yL=0;
        }
        if (!xL&&xL!=0) {xL=0;this.moveTypeWrong();}
        if (!yL&&yL!=0) {yL=0;this.moveTypeWrong();}
        this.x=xL*Math.sin(r)+ yL*Math.sin(r+Math.PI/2)+this._x-$gameMap.displayX()*48;
        this.y=-xL*Math.cos(r)-yL*Math.cos(r+Math.PI/2)+this._y-$gameMap.displayY()*48;
        //=============================================
        if (this.dymaticBitmap) {
            this.dymaticBitmap[3]++;
            if (this.dymaticBitmap[3]==this.dymaticBitmap[4]) {
                this.dymaticBitmap[3]=0;
                this.dymaticBitmap[0]++;
                if (this.dymaticBitmap[0]==this.dymaticBitmap[1]) this.dymaticBitmap[0]=0;
                this.setFrame(this.dymaticBitmap[0]*this.dymaticBitmap[2],0,this.dymaticBitmap[2],this.dymaticBitmap[5]);
            }
        }
        //=============================================
    }
};
Sprite_QJY.prototype.createTexture = function(data) {
    let lsCanvas = document.createElement('canvas');
    let lscontext = lsCanvas.getContext('2d');
    let lsBaseTexture = null;
    if (data[0]==1) {
        lsCanvas.width = data[5];
        lsCanvas.height = data[6];
        lsBaseTexture = new PIXI.BaseTexture(lsCanvas);
        lsBaseTexture.scaleMode = PIXI.SCALE_MODES.NEAREST;
        lsBaseTexture.width = data[5];
        lsBaseTexture.height = data[6];
        lscontext.save();
        lscontext.fillStyle = data[7];
        lscontext.fillRect(0,0,data[5],data[6]);
        lscontext.restore();
    } else if (data[0]==2) {
        let bitmap = ImageManager.loadBullet(data[1].img),w=bitmap.width,h=bitmap.height;
        lsCanvas.width = w;
        lsCanvas.height = h;
        lsBaseTexture = new PIXI.BaseTexture(lsCanvas);
        lsBaseTexture.scaleMode = PIXI.SCALE_MODES.NEAREST;
        lsBaseTexture.width = w;
        lsBaseTexture.height = h;
        lscontext.globalCompositeOperation = 'source-over';
        lscontext.drawImage(bitmap._canvas,0,0,w,h,0,0,w,h);
    }
    lsBaseTexture.update();
    textureSave[this.QJParentid] = lsBaseTexture;
    return lsBaseTexture;
};
//=============================================================================
//Sprite_QJBullet
//=============================================================================
function Sprite_QJBullet() {
    this.initialize.apply(this, arguments);
};
Sprite_QJBullet.prototype = Object.create(Sprite_Base.prototype);
Sprite_QJBullet.prototype.constructor = Sprite_QJBullet;
Sprite_QJBullet.prototype.initialize = function(index) {
    Sprite_Base.prototype.initialize.call(this);
    this.o=$gameMap.bullet(index);
    this.opacity=this.o.opacity;
    this.setColorTone(this.o.tone);
    if (typeof this.o.bitmap == "string") {
        let frameImage=this.o.bitmap.match(/\[[^\]]*\]/i);
        if (frameImage){
            let data=eval(frameImage[0]);
            ImageManager.loadBullet(this.o.bitmap).addLoadListener((bit)=>{
                this.bitmap=bit;
                this.dymaticBitmap=[0,Number(data[0]),this.bitmap.width/Number(data[0]),0,Number(data[1])];
                this.setFrame(this.dymaticBitmap[0]*this.dymaticBitmap[2],0,this.dymaticBitmap[2],this.bitmap.height);
            });
        } else ImageManager.loadBullet(this.o.bitmap).addLoadListener((bit)=>this.bitmap=bit);
    } else if (typeof this.o.bitmap == "object") {
        let data=this.o.bitmap;
        if (data[0]==0) {
            this.bitmap=data[2];
            this.setFrame(data[3],data[4],data[5],data[6]);
        }
        if (data[0]==1) {
            //[1,文字内容,文字颜色,文字字号,4文字排列方式,文本子弹最大宽度,文本子弹最大高度,7描边颜色,8描边粗细]
            let mw = Math.min(data[5],Math.ceil(data[3]*data[1].length/72*96));
            let mh = Math.min(data[6],Math.ceil(data[3]/72*96));
            if (data[4]==0) this.bitmap=new Bitmap(mw,mh);
            else this.bitmap=new Bitmap(mh,mw);
            this.bitmap.fontSize = Number(data[3]);
            if (typeof data[2] === "object") {
                this.bitmap.textColor = QJ.BL.ColorGrad(this.bitmap,data[2][0],0,0,mw,mh,data[2][1]*Math.PI/180);
            } else this.bitmap.textColor = data[2];
            this.bitmap.fontItalic = false;
            if (typeof data[2] === "object") {
                this.bitmap.outlineColor = QJ.BL.ColorGrad(this.bitmap,data[7][0],0,0,mw,mh,data[7][1]*Math.PI/180);
            } else this.bitmap.outlineColor = data[7];
            this.bitmap.outlineWidth = data[8];
            if (data[4]==0) this.bitmap.drawText(data[1],0,0,mw,mh,"center");
            else if (data[4]==1) this.bitmap.drawTextVerticalRow(data[1],0,0,mw,mh,"center");
            //else if (data[4]==1) this.bitmap.drawTextChangeRotation(data[1],0,0,mw,mh,"center",90*Math.PI/180);
        }
        if (data[0]==2) {
            this.bitmap=ImageManager.loadSystem('IconSet');
            this.setIconIndexFrame(data[1]);
        }
    }
    this.QJParentid=""+this.o.bitmap;
    this.updateBaseData();
};
Sprite_QJBullet.prototype.setIconIndexFrame = function(index) {
    var pw = 32;
    var ph = 32;
    var sx = index % 16 * pw;
    var sy = Math.floor(index / 16) * ph;
    this.setFrame(sx, sy, pw, ph);
}
Sprite_QJBullet.prototype.refresDymaticBitmap = function() {
    this.dymaticBitmap[3]++;
    if (this.dymaticBitmap[3]==this.dymaticBitmap[4]) {
        this.dymaticBitmap[3]=0;
        this.dymaticBitmap[0]++;
        if (this.dymaticBitmap[0]==this.dymaticBitmap[1]) this.dymaticBitmap[0]=0;
        this.setFrame(this.dymaticBitmap[0]*this.dymaticBitmap[2],0,this.dymaticBitmap[2],this.bitmap.height);
    }
}
Sprite_QJBullet.prototype.update = function() {
    Sprite_Base.prototype.update.call(this);
    if (!this.bitmap) return;
    //========================================
    this.updateBaseData();
    //========================================
    if (this.dymaticBitmap) this.refresDymaticBitmap();
    //========================================
};
Sprite_QJBullet.prototype.updateBaseData = function() {
    this.x=this.o.screenShowX();
    this.y=this.o.screenShowY();
    this.rotation=this.o.rotation;
    this.scale.x = this.o.scaleX;
    this.scale.y = this.o.scaleY;
    this.anchor.x=this.o.anchorX;
    this.anchor.y=this.o.anchorY;
    this.opacity=this.o.opacity;
};
//=============================================================================
//Game_QJBullet
//=============================================================================
function Game_QJBullet() {
    this.initialize.apply(this, arguments);
}
Game_QJBullet.prototype.initialize = function(data,index) {
    this.data=data;
    this.index=index;
    this.setBase();
    this.setOthers();
};
Game_QJBullet.prototype.setBase = function() {
    //===============================================
    this.bulletMode = 0;
    this.rotationAuto=this.data.RotationAuto>=0?this.data.RotationAuto*Math.PI/180:-1;
    this.max=this.data.Max;
    this.time = this.max;
    this.ReBound=this.data.ReBound;
    this.Bit = this.data.Bit;
    //===============================================
    this.z=this.data.z;
    this._x=this.data.x+$gameMap.displayX()*48;//初始绝对位置
    this._y=this.data.y+$gameMap.displayY()*48;//初始绝对位置
    this.anchorX = this.data.AnchorX;
    this.anchorY = this.data.AnchorY;
    //===============================================
    this.bitmap = this.data.Img;
    //===============================================
    this.moveType = this.data.MoveType;
    //specail value
    if (this.data.MoveType[0]==6) {
        this.rM6S = [0,0,0];
    }
    if (this.data.MoveType[0]==8) {
        this.ReBound = false;
    }
    //===============================================
    this.opacity = this.data.Opacity;
    if (typeof this.data.Opacity === "string") {
        this.opacityManager={};
        let opacityData = this.data.Opacity.split("~");
        let lastopacity = [0,100];
        for (let j of opacityData) {
            let detail=j.split("|");
            let time = Number(detail[0]);
            for (let i=lastopacity[0];i<=time;i++) {
                if (time==i) {
                    this.opacityManager[this.max-time]=Number(detail[1]);
                    break;
                }
                this.opacityManager[this.max-i]=
                    (Number(detail[1])-lastopacity[1])*(i-lastopacity[0])/(time-lastopacity[0])+lastopacity[1];
            }
            lastopacity = [time,Number(detail[1])];
        }
        this.opacity = 255;
        this.updateOpacity();
    } else this.opacity = this.data.Opacity;
    this.tone = this.data.Tone;
    this.animation=this.data.Anim;
    //===============================================
    this.dead=false;//此子弹开始死亡，死亡后播放完动画且淡出后才真正消失。
    this.rememberEvent=[];//穿透时一个敌人只攻击一次，移出后才删除
    //===============================================
    this.target=QJ.BL.dealTarget(this.data.Target);
    this.regions=this.data.Regions;
    this.terrains=this.data.Terrains;
    this.pierce=this.data.Pierce;
    this.deadCount=this.data.DeadCount;
    if (typeof this.data.Speed  == "string") {
        this.speedManager={};
        let datas=this.data.Speed.split("~");
        for (let i=0,l=datas.length;i<l;i++) {
            let data=datas[i].split("|");
            this.speedManager[this.max-Number(data[0])]=Number(data[1]);
        }
    };
    if (typeof this.data.rTRotation == "string"&&this.data.rTRotation.length>0) {
        this.rTRotationManager={};
        let datas=this.data.rTRotation.split("~");
        for (let i=0,l=datas.length;i<l;i++) {
            let data=datas[i].split("|");
            this.rTRotationManager[this.max-Number(data[0])]=Number(data[1])*Math.PI/180;
        }
    }
    //===============================================
    this.action=this.data.Action;
    this.boxType=this.data.CollisionBox;
    this.refreshBodyBox();
    //===============================================
    this.afterImage=this.data.AfterImage;
    if (this.afterImage.length>0&&this.afterImage[0].length>7) {
        this.afterImageManager={};
        let datas=this.afterImage[0].split("~");
        let lastAfterImage = [0,{r:0,g:0,b:0}];
        for (let j of datas) {
            let detail=j.split("|");
            let time = Number(detail[0]);
            detail[1] = QJ.BL.hexToRgb(detail[1]);
            for (let i=lastAfterImage[0];i<=time;i++) {
                if (time==i) {
                    this.afterImageManager[this.max-time]=QJ.BL.rgbToHex(detail[1]);
                    break;
                }
                this.afterImageManager[this.max-i]=QJ.BL.rgbToHex({
                    r:Math.floor(lastAfterImage[1].r+ (detail[1].r-lastAfterImage[1].r)*(i-lastAfterImage[0])/(time-lastAfterImage[0])),
                    g:Math.floor(lastAfterImage[1].g+ (detail[1].g-lastAfterImage[1].g)*(i-lastAfterImage[0])/(time-lastAfterImage[0])),
                    b:Math.floor(lastAfterImage[1].b+ (detail[1].b-lastAfterImage[1].b)*(i-lastAfterImage[0])/(time-lastAfterImage[0]))
                });
            }
            lastAfterImage = [time,detail[1]];
        }
        this.updateafterImage();
    }
    //===============================================
    this.light=this.data.Light;
    this.Particles=QJ.BL.dealParticles(this.data.Particles);
    //===============================================
    this.atkRange=this.data.AtkRange;
    this.DeadAction=this.data.DeadAction;
    this.PierceAction=this.data.PierceAction;
    this.NoCollisionAction=this.data.NoCollisionAction;
    this.DeadAnim=this.data.DeadAnim;
    this.PierceAnim=this.data.PierceAnim;
    this.NoCollisionAnim=this.data.NoCollisionAnim;
    if (typeof this.data.WaitBaseOnSpeed  == "string") {
        this.WaitBaseOnSpeedManager={};
        let datas=this.data.WaitBaseOnSpeed.split("~");
        for (let i=0,l=datas.length;i<l;i++) {
            let data=datas[i].split("|");
            this.WaitBaseOnSpeedManager[this.max-Number(data[0])]=Number(data[1]);
        }
        this.WaitBaseOnSpeed=-2;
        this.updateWaitBaseOnSpeed();
    } else this.WaitBaseOnSpeed=this.data.WaitBaseOnSpeed;
    this.LMD=this.data.LMD;
    this.UpdateScript=[];
    if (typeof this.data.Update === "string"&&this.data.Update[0]=="\""&&this.data.Update[this.data.Update.length-1]=="\"") {
        this.data.Update=eval(this.data.Update);
    }
    if (typeof this.data.Update === "string") {
        if (this.data.Update.length>0) this.UpdateScript=[0,this.data.Update];
    } else if (typeof this.data.Update === "function") {
        this.UpdateScript=[1,this.data.Update];
    }
    this.DeadT = this.data.DeadT;
    if (typeof this.data.scaleX === "string") {
        this.scaleXManager={};
        let scaleXData = this.data.scaleX.split("~");
        let lastScaleX = [0,100];
        for (let j of scaleXData) {
            let detail=j.split("|");
            let time = Number(detail[0]);
            for (let i=lastScaleX[0];i<=time;i++) {
                if (time==i) {
                    this.scaleXManager[this.max-time]=Number(detail[1]);
                    break;
                }
                this.scaleXManager[this.max-i]=
                    (Number(detail[1])-lastScaleX[1])*(i-lastScaleX[0])/(time-lastScaleX[0])+lastScaleX[1];
            }
            lastScaleX = [time,Number(detail[1])];
        }
        this.scaleX = 1;
        this.updateScaleX();
    } else this.scaleX = this.data.scaleX/100;
    if (typeof this.data.scaleY === "string") {
        this.scaleYManager={};
        let scaleYData = this.data.scaleY.split("~");
        let lastScaleY = [0,100];
        for (let j of scaleYData) {
            let detail=j.split("|");
            let time = Number(detail[0]);
            for (let i=lastScaleY[0];i<=time;i++) {
                if (time==i) {
                    this.scaleYManager[this.max-time]=Number(detail[1]);
                    break;
                }
                this.scaleYManager[this.max-i]=
                    (Number(detail[1])-lastScaleY[1])*(i-lastScaleY[0])/(time-lastScaleY[0])+lastScaleY[1];
            }
            lastScaleY = [time,Number(detail[1])];
        }
        this.scaleY = 1;
        this.updateScaleY();
    } else this.scaleY = this.data.scaleY/100;
    //===============================================
    this.rotation=0;
    this.updateImgRotation();
    //===============================================
    this.xyRem=[[this.x,this.y]];
    this.collidedCount=0;
    //===============================================
};
Game_QJBullet.prototype.refreshBodyBox = function() {
    QJ.Matter.makeBulletBodyBox(this);
};
Game_QJBullet.prototype.regularWorld = function() {
    return true;
};
Game_QJBullet.prototype.destroy = function() {

};
Game_QJBullet.prototype.setOthers = function() {
    //===============================================
    if (typeof this.bitmap == "object") {
        let data=this.bitmap;
        if (data[0]==0) {
            let tar=(data[1]==-1)?$gamePlayer:$gameMap.event(data[1]),sp=null;
            if (!tar) {this.setDirectDead();return;}
            for (let i of SceneManager._scene._spriteset._characterSprites) {
                if (i._character==tar) {sp=i;break;}
            }
            if (!sp) {this.setDirectDead();return;}
            this.bitmap=data.concat([sp.bitmap,sp._frame.x,sp._frame.y,sp._frame.width,sp._frame.height]);
            if (tar.isObjectCharacter()) {
                this.y-=6;
                this._y-=6;
            }
            if (this.anchorY==0) this.anchorY=1;
        } else if (data[0]==1) {
            //文字显示，不需要预处理
        } else $gameMap.removeBullet(this.index);
    }
    //===============================================
    if ([1,2,3,4,7].includes(this.moveType[0])) this.maxRotation = this.moveType[1]*Math.PI/180;
    //===============================================
    //载入刚体数据
    //===============================================
    if (this.speedManager) this.updateSpeed();
    else this.setSpeed(this.data.Speed,this.data.initialRotation);
    this.updateRTRotation();
    //===============================================
};
//========================================================================
//========================================================================
//========================================================================
Object.defineProperty(Game_QJBullet.prototype, 'x', {
    get: function() {
        return this.QJBody.position.x;
    },
    set: function(value) {
        console.error("illegal set");
    },
    configurable: true
});
Object.defineProperty(Game_QJBullet.prototype, 'y', {
    get: function() {
        return this.QJBody.position.y;
    },
    set: function(value) {
        console.error("illegal set");
    },
    configurable: true
});
Object.defineProperty(Game_QJBullet.prototype, 'rotationMove', {
    get: function() {
        if (this.moveType[0]==8&&this.xyRem) {
            let r=this.xyRem,l=r.length;
            if (r.length==1) return this.data.initialRotation;
            else return QJ.BL.calculateAngleByTwoPoint(r[l-2][0],r[l-2][1],r[l-1][0],r[l-1][1]);
        }
        let s = this.QJBody.velocity;
        return QJ.BL.calculateAngleByTwoPoint(0,0,s.x,s.y);
    },
    set: function(value) {
        console.error("illegal set");
    },
    configurable: true
});
Object.defineProperty(Game_QJBullet.prototype, 'speed', {
    get: function() {
        if (this.moveType[0]==6) {
            return Math.sqrt(this.rM6S[0]*this.rM6S[0]+this.rM6S[1]*this.rM6S[1]);
        }
        if (this.moveType[0]==8) {
            let r=this.xyRem,l=r.length;
            if (r.length==1) return 0;
            else return Math.sqrt((r[l-1][0]-r[l-2][0])*(r[l-1][0]-r[l-2][0])+
                (r[l-1][1]-r[l-2][1])*(r[l-1][1]-r[l-2][1]));
        }
        return this.QJBody.speed;
    },
    set: function(value) {
        console.error("illegal set");
    },
    configurable: true
});
Object.defineProperty(Game_QJBullet.prototype, 'scaleX', {
    get: function() {
        if (!this._scaleX) this._scaleX = 1;
        return this._scaleX;
    },
    set: function(value) {
        this.setScale(this.scaleX,this.scaleY,value,this.scaleY);
        this._scaleX = value;
    },
    configurable: true
});
Object.defineProperty(Game_QJBullet.prototype, 'scaleY', {
    get: function() {
        if (!this._scaleY) this._scaleY = 1;
        return this._scaleY;
    },
    set: function(value) {
        this.setScale(this.scaleX,this.scaleY,this.scaleX,value);
        this._scaleY = value;
    },
    configurable: true
});
Game_QJBullet.prototype.screenShowX = function() {
    return this.x - $gameMap.displayX()*48;
}
Game_QJBullet.prototype.screenShowY = function() {
    return this.y - $gameMap.displayY()*48;
}
Game_QJBullet.prototype.xs = function() {
    return this.boxScreenX();
}
Game_QJBullet.prototype.ys = function() {
    return this.boxScreenY();
}
Game_QJBullet.prototype.boxScreenX = function() {
    return this.x;
}
Game_QJBullet.prototype.boxScreenY = function() {
    return this.y;
}
Game_QJBullet.prototype.orginX = function() {
    return this._x;
}
Game_QJBullet.prototype.orginY = function() {
    return this._y;
}
Game_QJBullet.prototype.getSpecialTargetXy = function () {
    let character=null;
    if (this.moveType[0]==1) 
        character=$gamePlayer;
    if (this.moveType[0]==2||this.moveType[0]==3) 
        character=$gameMap.event(this.moveType[2]);
    if (this.moveType[0]==4) 
        character=$gameMap.event(QJ.BL.getMinEventId(this.xs(),this.ys(),this.moveType[2]));
    if (this.moveType[0]==7) 
        character=$gameMap.event(QJ.BL.getMinEventIdNobi(this.xs(),this.ys(),this.moveType[2]));
    if (character) {
        return [character.boxScreenX(),character.boxScreenY()];
    } else {
        return [null,null];
    }
}
//========================================================================
//========================================================================
//========================================================================
Game_QJBullet.prototype.setSpeed = function(speed,rotationMove) {
    if (this.moveType[0]!=5) {
        if (this.moveType[0]==8) speed=0;
        rotationMove=(typeof rotationMove == "number")?rotationMove:this.QJBody.angle;
        QJ.Matter.Body.setVelocity(this.QJBody,{
            x:speed*Math.sin(rotationMove),
            y:-speed*Math.cos(rotationMove)});
    }
    QJ.Matter.Body.setAngle(this.QJBody,rotationMove);
};
Game_QJBullet.prototype.setScale = function(oldX,oldY,newX,newY) {
    QJ.Matter.Body.setAngle(this.QJBody,0);
    QJ.Matter.Body.scale(this.QJBody,1/oldX,1/oldY);
    QJ.Matter.Body.scale(this.QJBody,newX,newY);
    QJ.Matter.Body.setAngle(this.QJBody,this.rotationMove);
};
Game_QJBullet.prototype.rotate = function(value,sign) {
    this.setSpeed(this.speed,(sign?0:this.QJBody.angle)+value);
};
Game_QJBullet.prototype.updateSpeed = function() {
    if (this.speedManager) {
        let data=this.speedManager[this.time];
        if (typeof data == "number") {
            if (this.time==this.max) this.setSpeed(data,this.data.initialRotation);
            else this.setSpeed(data);
        }
    }
};
Game_QJBullet.prototype.updateWaitBaseOnSpeed = function() {
    if (this.WaitBaseOnSpeedManager) {
        let data=this.WaitBaseOnSpeedManager[this.time];
        if (typeof data == "number") this.WaitBaseOnSpeed=data;
    }
};
Game_QJBullet.prototype.updateRTRotation = function() {
    if (this.rTRotationManager) {
        let data=this.rTRotationManager[this.time];
        if (typeof data == "number") {
            this.rotate(data);
        }
    }
};
Game_QJBullet.prototype.updateScaleX = function() {
    if (this.scaleXManager) {
        let data=this.scaleXManager[this.time];
        if (typeof data == "number") this.scaleX=Math.abs(data/100)<0.01?(data==0?0.01:0.01*data/data):data/100;
    }
};
Game_QJBullet.prototype.updateScaleY = function() {
    if (this.scaleYManager) {
        let data=this.scaleYManager[this.time];
        if (typeof data == "number") this.scaleY=Math.abs(data/100)<0.01?(data==0?0.01:0.01*data/data):data/100;
    }
};
Game_QJBullet.prototype.updateOpacity = function() {
    if (this.opacityManager) {
        let data=this.opacityManager[this.time];
        if (typeof data == "number") this.opacity=data;
    }
};
Game_QJBullet.prototype.updateImgRotation = function () {
    if (this.rotationAuto==-1) {
        if (this.moveType[0]==6) this.rotation=this.rM6S[2];
        else this.rotation=this.QJBody.angle;
    } else if (this.rotationAuto>=0) {
        if (this.rotationAuto<=Math.PI*2) {
            this.rotation=this.rotationAuto;
        } else {
            this.rotation+=this.rotationAuto-Math.PI*4;
            if (this.rotation<0) this.rotation+=2*Math.PI;
            else if (this.rotation>2*Math.PI) this.rotation-=2*Math.PI;
        }
    }
}
//========================================================================
//========================================================================
Game_QJBullet.prototype.updateCollideIng = function (partData) {
    this.collidedCount++;
    if (this.collidedCount>2) {
        this.collidedCount=0;
        this.setSpeed(0);
        //this.setDead();
        return;
    }
}
Game_QJBullet.prototype.updateCollidePre = function (partData) {
    this.speedPre = this.speed;
    this.collidedCount = 0;
    if (this.ReBound) {
        if (this.moveType[0]==6) {
            this.moveType[6]=1;
            this.RB6S=!this.RB6S;
            QJ.Matter.Body.setPosition(this.QJBody,{
                x:this.xyRem[this.xyRem.length-2][0],
                y:this.xyRem[this.xyRem.length-2][1]
            });
        }
    } else {
        this.setDead();
    }
}
Game_QJBullet.prototype.updateCollide = function (partData) {
    //console.log(this.QJBody);
    this.collidedCount = 0;
    QJ.Matter.Body.setAngularVelocity(this.QJBody,0);
    if (this.ReBound) {
        if (this.moveType[0]==6) {
            this.setSpeed(0);
        } else this.setSpeed(this.speedPre);
    } else {
        this.setDead();
    }
}
//========================================================================
Game_QJBullet.prototype.update = function () {
    //console.time("bulletUpdate");
    //=======================
    if (this.dead) {
        if (this.deadMode==3) {
            $gameMap.removeBullet(this.index);
            return;
        }
        if (this.perFade==undefined) {
            if (this.deadCount<=0) this.opacity=0;
            else this.perFade=Math.max(this.opacity/this.deadCount,1);
        } else this.opacity-=this.perFade;
        if (this.opacity<=5) {
            if (this.sprite) {
                if (!this.sprite.isAnimationPlaying()&&this.sprite.children.length<=0) {
                    $gameMap.removeBullet(this.index);
                }
            } else $gameMap.removeBullet(this.index);
        }
        return;
    }
    //=======================
    if (this.time>0) this.time-=1;
    else {
        this.setDeadDisappear();
        return;
    }
    //===============================================================
    if (this.LMD) {
        if (this.x>$gameMap.maxScreenWidth||this.x<0||this.y<0||this.y>$gameMap.maxScreenHeight) {
            this.setDirectDead();
            return;
        }
    }
    //=======================
    this.updateWaitBaseOnSpeed();
    this.updateSpeed();
    this.updateScaleX();
    this.updateScaleY();
    this.updateOpacity();
    this.updateRTRotation();
    //updateRotation includes special movetype
    this.updateRotation();
    this.updateafterImage();
    this.updateParticles();
    if (this.dead) return;
    //=======================
    if (!this.Bit) this.updateCollision();
    //=======================
    this.updateImgRotation();
    //=======================
    if (this.UpdateScript.length>0) {
        if (this.UpdateScript[0]==0) eval(this.UpdateScript[1]);
        else this.UpdateScript[1].call(this,this);
    }
    //=======================
    this.xyRem.push([this.x,this.y]);
    //=======================
    //console.timeEnd("bulletUpdate");
}
Game_QJBullet.prototype.updateafterImage = function() {
    if (this.afterImage.length>0) {
        if (this.afterImageManager) {
            let data=this.afterImageManager[this.time+1];//+1是为了补偿
            if (data) this.afterImage[0]=data;
        }
        if (this.afterImage[0]&&this.speed>0&&(this.max-this.time)>2) {
            let w=0,h=0;
            if (this.moveType[0]==6) {
                h=this.afterImage[4]==0?this.sprite.width:this.afterImage[4];
                w=(this.afterImage[5]==0?(this.speed):this.afterImage[5])+1;
            } else {
                w=this.afterImage[4]==0?this.sprite.width:this.afterImage[4];
                h=(this.afterImage[5]==0?(this.speed):this.afterImage[5])+1;
            }
            this.sprite.particleParent.addChildrenAtId(new Sprite_QJY(this.sprite,
                [1,null,this.afterImage[2],this.afterImage[3],
                Math.min(this.afterImage[1],this.opacity),
                w,h,this.afterImage[0]]
                ,this));
        }
    }
}
Game_QJBullet.prototype.updateParticles = function() {
    for (let i of this.Particles) {
        if (!i) continue;
        if (i.count==0) {
            let bitmap = ImageManager.loadBullet(i.img);
            if (!bitmap.isReady()) continue;
            for (let j=i.num;j>0;j--) {
                this.sprite.particleParent.addChildrenAtId(new Sprite_QJY(this.sprite,[2,i],this));
            }
            i.count = i.wait;
        } else i.count--;
    }
}
Game_QJBullet.prototype.updateRotation = function () {
    //===============================================
    if (this.speed>0) {
        if ([1,2,3,4,7].includes(this.moveType[0])) {
        //===============================================
        let xy=this.getSpecialTargetXy();
        if (xy[0]==null) return;
        //===============================================
        let x=this.xs(),y=this.ys(),ex=xy[0],ey=xy[1],ro=QJ.BL.calculateAngleByTwoPoint(x,y,ex,ey);
        let rod=Math.abs(ro-this.rotationMove);
        rod=rod>Math.PI?(Math.PI*2-rod):rod;
        if (rod<=this.maxRotation) this.rotate(ro,true);
        else {
            let rodp=Math.abs(ro-this.rotationMove-this.maxRotation);
            let rodm=Math.abs(ro-this.rotationMove+this.maxRotation);
            rodp=rodp>Math.PI?(Math.PI*2-rodp):rodp;
            rodm=rodm>Math.PI?(Math.PI*2-rodm):rodm;
            if (rodp>rodm) this.rotate(-this.maxRotation);
            else this.rotate(this.maxRotation);
        }
        //===============================================
        }
    }
    //===============================================
    if (this.moveType[0]==5) {
        let character=null;
        if (this.moveType[1]==-1) character = $gamePlayer;
        else character = $gameMap.event(this.moveType[1]);
        if (!character) {this.setDirectDead();return;}
        let d = character.direction();
        QJ.Matter.Body.setPosition(this.QJBody,
            {x:character.boxScreenRealX() + this.moveType[d],
            y:character.boxScreenRealY() + this.moveType[d+1]});
    }
    //===============================================
    if (this.moveType[0]==6&&!this.dead) {
        if (this.moveType[4]==0) return;
        let data = this.moveType;
        if (data.length<6) {
            this.setSpeed(0);
            data[5]=this.data.initialRotation;
            if (data[5]>=Math.PI) data[2]=Math.PI*2-data[2];
            this.updateMoveType6(data);
        }
        data[6]--;
        let hor=data[14]*data[6]*(data[7]-data[6]),re=this.RB6S?-1:1;
        let addx=re*data[13]*Math.cos(data[2]);
        let addy=-re*(data[13]*Math.sin(data[2])-data[14]*(data[7]-data[6]));
        QJ.Matter.Body.setPosition(this.QJBody,{x:this.x+addx,y:this.y+addy});
        this.rM6S = [addx,addy,QJ.BL.calculateAngleByTwoPoint(0,0,addx,addy)];
        if (data[6]<=0) {
            data[4]--;
            if (data[4]==0) return;
            this.updateMoveType6(data);
        }
    }
    //===============================================
    if (this.moveType[0]==8&&!this.dead) {
        let r=this.data.initialRotation,m=this.moveType,t=this.max-this.time,xL=0,yL=0,x=0,y=0;
        try{
            if (m[1]==0) {
                xL=-1*Number(eval(m[2]));yL=Number(eval(m[3]));
            } else {
                let length = -1*Number(eval(m[2])),rota=Number(eval(m[3]));
                xL=length*Math.cos(rota);
                yL=length*Math.sin(rota);
            }
        } catch(e) {
            if (showWarn) console.warn("The moveType is wrong.");
            xL=0;
            yL=0;
        }
        if (!xL&&xL!=0) {xL=0;if (showWarn) console.warn("The moveType is wrong.");}
        if (!yL&&yL!=0) {yL=0;if (showWarn) console.warn("The moveType is wrong.");}
        x=xL*Math.sin(r)+ yL*Math.sin(r+Math.PI/2)+this._x;
        y=-xL*Math.cos(r)-yL*Math.cos(r+Math.PI/2)+this._y;
        QJ.Matter.Body.setPosition(this.QJBody,{x:x,y:y});
    }
    //===============================================
    //===============================================
    //===============================================
}
Game_QJBullet.prototype.updateMoveType6 = function(data) {
    //1一倍宽度,2发射角度,3一倍时间,4次数
    data[6]=data[3]*data[4];//时间
    data[7]=data[6];
    data[8]=data[1]*data[4];//宽度
    data[9]=this.x+data[8]*Math.sin(data[5]);
    data[10]=this.y-data[8]*Math.cos(data[5]);
    data[11]=data[8]*Math.sin(data[5])/data[7];
    data[12]=-data[8]*Math.cos(data[5])/data[7];
    data[13]=data[8]*Math.sin(data[5])/data[7]/Math.cos(data[2]);//v
    data[14]=2/(data[7]*data[7]) *(data[13]*Math.sin(data[2])*data[7]-data[8]*Math.cos(data[5]));//g
    data[15]=this.x;
    data[16]=this.y;
};
Game_QJBullet.prototype.updateCollision = function () {
    //===============================================================
    if (this.WaitBaseOnSpeed==-1) return;
    if (this.WaitBaseOnSpeed>=0&&this.speed!=this.WaitBaseOnSpeed) return;
    this.target=QJ.BL.dealTarget(this.data.Target);
    //===============================================================
    if (this.target.length==0) return;
    //===============================================================
    let oldP = this.QJBody.positionPrev,p = this.QJBody.position,scaleY=1,scaleX=this.scaleX,jb = this.QJBodyForJudge;
    if (this.max!=this.time+1) scaleY = this.speed/(this.boxType[0]==0?(this.boxType[1]*2):(this.boxType[2]))+1;
    scaleY*=this.scaleY;
    QJ.Matter.Body.setPosition(jb,{x:(oldP.x+p.x)/2,y:(oldP.y+p.y)/2});
    QJ.Matter.Body.scale(jb,scaleX,scaleY);
    QJ.Matter.Body.setAngle(jb,this.rotationMove);
    //===============================================================
    for (let i=0,l=this.target.length;i<l;i++) {
        let character=QJ.BL.dealCharacter(this.target[i]);
        if (!character) continue;
        if (QJ.Matter.judge(jb,character.QJBody).collided) {
            this.actionAndDead(character);
            if (this.dead) break;
            continue;
        }
        let index=this.rememberEvent.indexOf(character);
        if (index!=-1) this.rememberEvent.splice(index,1);
    }
    //===============================================================
    //QJ.Matter.sprite.aBody(jb);//For showing collision box.
    QJ.Matter.Body.setAngle(jb,0);
    QJ.Matter.Body.scale(jb,1/scaleX,1/scaleY);
    //===============================================================
}
//===============================================================
//===============================================================
//===============================================================
Game_QJBullet.prototype.actionAndDead = function (character) {
    if (this.dead) return;
    //打击到敌人后消失
    if (this.rememberEvent.indexOf(character)!=-1) return;
    this.pierce-=1;
    this.rememberEvent.push(character);
    if (this.PierceAction||this.pierce<0) this.setAction(character);
    if (this.PierceAnim||this.pierce<0) this.requestAnimationQJB();
    if (this.pierce<0) {
        this.dead=true;
        this.deadMode = 0;
        this.startDeadT(this.DeadT,this.deadMode);
        Matter.Sleeping.set(this.QJBody,true);
    }
}
Game_QJBullet.prototype.setDead = function () {
    if (this.dead) return;
    //碰到障碍后消失
    this.dead=true;
    this.deadMode = 1;
    this.startDeadT(this.DeadT,this.deadMode);
    Matter.Sleeping.set(this.QJBody,true);
    if (this.DeadAction) this.setAction();
    if (this.DeadAnim) this.requestAnimationQJB();
}
Game_QJBullet.prototype.setDeadDisappear = function () {
    if (this.dead) return;
    //到时间后消失
    this.dead=true;
    this.deadMode = 2;
    this.startDeadT(this.DeadT,this.deadMode);
    Matter.Sleeping.set(this.QJBody,true);
    if (this.NoCollisionAction) this.setAction();
    if (this.NoCollisionAnim) this.requestAnimationQJB();
}
Game_QJBullet.prototype.setDirectDead = function () {
    if (this.dead) return;
    //直接中断子弹
    this.dead=true;
    this.deadMode = 3;
    Matter.Sleeping.set(this.QJBody,true);
}
//===============================================================
//===============================================================
//===============================================================
Game_QJBullet.prototype.setAction = function (character) {
    if (this.atkRange>0) this.atkRangeTarget(character);
    else QJ.BL.startAction(this,character);
}
Game_QJBullet.prototype.requestAnimationQJB = function () {
    if (this.sprite) {
        this.sprite.startAnimation($dataAnimations[Number(this.animation)], false, 0);
    }
}
Game_QJBullet.prototype.atkRangeTarget = function (character) {
    let index=this.target.indexOf(character),xs=this.xs(),ys=this.ys(),atkPow=Math.pow(this.atkRange,2);
    if (index!=-1) this.target.splice(index,1);
    for (let i=0;i<this.target.length;i++) {
        let tar=this.target[i]==0?$gamePlayer:$gameMap.event(this.target[i]);
        if (!tar) continue;
        if (Math.pow(xs-tar.boxScreenX(),2)+Math.pow(ys-tar.boxScreenY(),2)<=atkPow) {
            QJ.BL.startAction(this,tar);
        }
    }
}
Game_QJBullet.prototype.startDeadT = function (data,mode) {
    if (typeof data === "string"&&data.length>0&&data[0]=="\""&&data[data.length-1]=="\"") {
        data=eval(data);
    }
    if (typeof data === "string") {
        if (data.length>0) eval(data);
    } else if (typeof data === "function") {
        data.call(this,this);
    }
}
//=============================================================================
//Sprite_QJLaser
//=============================================================================
function Sprite_QJLaser() {
    this.initialize.apply(this, arguments);
};
Sprite_QJLaser.prototype = Object.create(Sprite_Base.prototype);
Sprite_QJLaser.prototype.constructor = Sprite_QJLaser;
Sprite_QJLaser.prototype.initialize = function(index) {
    Sprite_Base.prototype.initialize.call(this);
    this.o=$gameMap.bullet(index);
    this.anchor.x=0;
    this.anchor.y=0;
    this.opacity=this.o.opacity;
    this.setColorTone(this.o.tone);
    this.bitmap = new Bitmap(Graphics.width,Graphics.height);
    if (typeof this.o.bitmap == "string") {
        let frameImage=this.o.bitmap.match(/\[[^\]]*\]/i);
        if (frameImage){
            let data=eval(frameImage[0]);
            ImageManager.loadBullet(this.o.bitmap).addLoadListener((bit)=>{
                this.bitmapOrgin=bit;
                this.dymaticBitmap=[0,Number(data[0]),bit.width/Number(data[0]),0,Number(data[1])];
                this.drawRectangle=[0,0,0,0];
                this.refresDymaticBitmap();
            });
        } else ImageManager.loadBullet(this.o.bitmap).addLoadListener((bit)=>{
            this.bitmapOrgin=bit;
            this.drawRectangle=[0,0,bit.width,bit.height];
        });
    }
};
Sprite_QJLaser.prototype.refresDymaticBitmap = function() {
    this.dymaticBitmap[3]++;
    if (this.dymaticBitmap[3]==this.dymaticBitmap[4]) {
        this.dymaticBitmap[3]=0;
        this.dymaticBitmap[0]++;
        if (this.dymaticBitmap[0]==this.dymaticBitmap[1]) this.dymaticBitmap[0]=0;
        this.drawRectangle=[this.dymaticBitmap[0]*this.dymaticBitmap[2],0,
            this.dymaticBitmap[2],this.bitmapOrgin.height];
    }
}
Sprite_QJLaser.prototype.update = function() {
    Sprite_Base.prototype.update.call(this);
    if (this.o.dead) {
        this.x=this.o.displayXY[0]-$gameMap.displayX()*48;
        this.y=this.o.displayXY[1]-$gameMap.displayY()*48;
        return;
    }
    if (!this.bitmapOrgin) return;
    //========================================
    if (this.dymaticBitmap) this.refresDymaticBitmap();
    this.bitmap.clear();
    this.bitmap.drawImgByTwoPoint(this.o.lineList,this);
    //========================================
    this.opacity=this.o.opacity;
    //========================================
};
Bitmap.prototype.drawLineByTwoPoint = function(x1,y1,x2,y2,color) {
    var context = this._context;
    context.save();
    context.beginPath();
    context.moveTo(x1,y1);
    context.lineTo(x2,y2);
    context.strokeStyle=color;
    context.stroke();
    context.restore();
    this._setDirty();
};
Bitmap.prototype.drawImgByTwoPoint = function(ll,data) {
    let context = this._context;
    context.globalCompositeOperation = 'source-over';
    for (let i=0;i<ll.length-1;i++) {
        context.save();
        let x1=ll[i][0],y1=ll[i][1],x2=ll[i+1][0],y2=ll[i+1][1];
        let ro = QJ.BL.calculateAngleByTwoPoint(x1,y1,x2,y2);
        let len = Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
        context.translate(x1,y1);
        context.rotate(ro);
        for (let k=1,kl=Math.ceil(len/data.bitmapOrgin.height);k<=kl;k++) {
            context.drawImage(data.bitmapOrgin.canvas,data.drawRectangle[0],data.drawRectangle[1],
                data.drawRectangle[2],data.drawRectangle[3],
                -data.drawRectangle[2]/2,-k*data.drawRectangle[3],
                data.drawRectangle[2],data.drawRectangle[3]);
        }
        context.restore();
    }
    this._setDirty();
};
//=============================================================================
//Game_QJLaser
//=============================================================================
function Game_QJLaser() {
    this.initialize.apply(this, arguments);
}
Game_QJLaser.prototype.initialize = function(data,index) {
    this.data=data;
    this.index=index;
    this.setBase();
};
Game_QJLaser.prototype.orginX = function() {
    return this.x+$gameMap.displayX()*48;
};
Game_QJLaser.prototype.orginY = function() {
    return this.y+$gameMap.displayY()*48;
};
Game_QJLaser.prototype.setBase = function() {
    //===============================================
    this.bulletMode = 1;
    this.z=this.data.z;
    this.bitmap = this.data.Img;
    //===============================================
    this.opacity = this.data.Opacity;
    if (typeof this.data.Opacity === "string") {
        this.opacityManager={};
        let opacityData = this.data.Opacity.split("~");
        let lastopacity = [0,100];
        for (let j of opacityData) {
            let detail=j.split("|");
            let time = Number(detail[0]);
            for (let i=lastopacity[0];i<=time;i++) {
                if (time==i) {
                    this.opacityManager[this.max-time]=Number(detail[1]);
                    break;
                }
                this.opacityManager[this.max-i]=
                    (Number(detail[1])-lastopacity[1])*(i-lastopacity[0])/(time-lastopacity[0])+lastopacity[1];
            }
            lastopacity = [time,Number(detail[1])];
        }
        this.opacity = 255;
        this.updateOpacity();
    } else this.opacity = this.data.Opacity;
    this.tone = this.data.Tone;
    this.dead=false;//此子弹开始死亡，死亡后播放完动画且淡出后才真正消失。
    this.rememberEvent=[];//穿透时一个敌人只攻击一次，移出后才删除
    this.target=null;
    this.regions=this.data.Regions;
    this.terrains=this.data.Terrains;
    this.deadCount=this.data.DeadCount;
    this.action=this.data.Action;
    //===============================================
    this.rotation=this.data.initialRotation;
    this.lineList = [];
    //===============================================
    this.name=this.data.name;
    this.updateWait = [this.data.AtkWait,this.data.AtkWait];
    this.atkWidth = this.data.Width;
    this.ReBound=this.data.ReBound;
    this.judgeBody = QJ.Matter.Bodies.rectangle(0,0,this.atkWidth,100);
    this.max = this.data.Max;
    this.time = this.data.Max;
    this.perFade=Math.max(this.opacity/this.deadCount,1);
    this.updateXYR();
};
Game_QJLaser.prototype.updateOpacity = function() {
    if (this.opacityManager) {
        let data=this.opacityManager[this.time];
        if (typeof data == "number") this.opacity=data;
    }
};
Game_QJLaser.prototype.updateXYR = function() {
    try{
        this.x = QJ.BL.dealX(this.data.x,null,false);
        this.y = QJ.BL.dealY(this.data.y,null,false);
        this.rotation = QJ.BL.dealInitialRotation(
            this.data.initialRotation,null,this.x,this.y);
    } catch(e) {
        this.setDead();
        return;
    }
    this.lineList=[[this.x,this.y,this.rotation]];
    for (let i=0,il=this.lineList,j=1,rbnum=0;rbnum<this.ReBound;j++) {
        let w=1*Math.sin(il[i][2]),h=-1*Math.cos(il[i][2]);
        if (j>=960) {
            this.lineList.push([il[i][0]+j*w,il[i][1]+j*h,0]);
            break;
        }
        let x=Math.floor((il[i][0]+j*w+$gameMap.displayX()*48)/48);
        let y=Math.floor((il[i][1]+j*h+$gameMap.displayY()*48)/48);
        if (!(this.regions.includes($gameMap.regionId(x,y))||
            this.terrains.includes($gameMap.terrainTag(x,y)))) continue;
        x=Math.floor((il[i][0]+j*w)/48)*48+24;
        y=Math.floor((il[i][1]+j*h)/48)*48+24;
        let k=Math.tan(il[i][2]-Math.PI/2),b=il[i][1]-k*il[i][0];
        let judgeLsit;
        if (x<il[i][0]) {
            if (y<il[i][1]) judgeLsit=[6,2];
            else if (y>il[i][1]) judgeLsit=[6,8];
            else judgeLsit=[6];
        } else {
            if (y<il[i][1]) judgeLsit=[4,2];
            else if (y>il[i][1]) judgeLsit=[4,8];
            else judgeLsit=[4];
        }
        let tx=-1,ty=-1,ro;
        for (let d=0;d<judgeLsit.length;d++) {
            if (judgeLsit[d]==2) {
                ty=y+24;
                tx=(ty-b)/k;
                ro=Math.PI-il[i][2];
                if (Math.abs(tx-x)<=24) break;
            } else if (judgeLsit[d]==4) {
                tx=x-24;
                ty=k*tx+b;
                ro=2*Math.PI-il[i][2];
                if (Math.abs(ty-y)<=24) break;
            } else if (judgeLsit[d]==6) {
                tx=x+24;
                ty=k*tx+b;
                ro=2*Math.PI-il[i][2];
                if (Math.abs(ty-y)<=24) break;
            } else if (judgeLsit[d]==8) {
                ty=y-24;
                tx=(ty-b)/k;
                ro=Math.PI-il[i][2];
                if (Math.abs(tx-x)<=24) break;
            }
        }
        if (tx==-1&&ty==-1) {
            throw new Error("出错");
        }
        this.lineList.push([tx,ty,ro]);
        i++;
        j=1;
        rbnum++;
    }
};
Game_QJLaser.prototype.update = function () {
    //console.time("bulletUpdate");
    //=======================
    if (this.dead) {
        if (this.deadCount==0) {
            $gameMap.removeBullet(this.index);
        } else {
            this.opacity-=this.perFade;
            if (this.opacity<=5) $gameMap.removeBullet(this.index);
        }
        return;
    }
    if (this.time==0) {
        this.setDead();
        return;
    } else this.time--;
    //=======================
    this.updateOpacity();
    this.updateXYR();
    if (this.updateWait[0]==0) {
        this.updateAtk();
        this.updateWait[0]=this.updateWait[1];
    } else this.updateWait[0]--;
    //=======================
    //console.timeEnd("bulletUpdate");
}
Game_QJLaser.prototype.updateAtk = function() {
    this.target=QJ.BL.dealTarget(this.data.Target);
    for (let ll=this.lineList,i=0,il=ll.length-1;i<il;i++) {
        let len=Math.sqrt((ll[i][0]-ll[i+1][0])*(ll[i][0]-ll[i+1][0])+
            (ll[i][1]-ll[i+1][1])*(ll[i][1]-ll[i+1][1]));
        if (len<=2) continue; 
        QJ.Matter.Body.setPosition(this.judgeBody,{
            x:(ll[i][0]+ll[i+1][0])/2+$gameMap.displayX()*48,
            y:(ll[i][1]+ll[i+1][1])/2+$gameMap.displayY()*48});
        QJ.Matter.Body.scale(this.judgeBody,1,len/100);
        QJ.Matter.Body.setAngle(this.judgeBody,QJ.BL.calculateAngleByTwoPoint(
            ll[i][0],ll[i][1],ll[i+1][0],ll[i+1][1]));
        //=============================
        for (let i=0,l=this.target.length;i<l;i++) {
            let character=QJ.BL.dealCharacter(this.target[i]);
            if (!character||!character.QJBody) continue;
            if (QJ.Matter.judge(this.judgeBody,character.QJBody).collided) {
                QJ.BL.startAction(this,character);
                continue;
            }
            let index=this.rememberEvent.indexOf(character);
            if (index!=-1) this.rememberEvent.splice(index,1);
        }
        //QJ.Matter.sprite.aBody(this.judgeBody);
        //=============================
        QJ.Matter.Body.setAngle(this.judgeBody,0);
        QJ.Matter.Body.scale(this.judgeBody,1,100/len);
    }
};
Game_QJLaser.prototype.destroy = function() {
    this.judgeBody = null;
};
Game_QJLaser.prototype.setDead = function() {
    this.dead = true;
    if (!this.displayXY) this.displayXY=[$gameMap.displayX()*48,$gameMap.displayY()*48];
};
Game_QJLaser.prototype.xs = function() {
    return 0;
};
Game_QJLaser.prototype.ys = function() {
    return 0;
};
Game_QJLaser.prototype.screenShowX = function() {
    return this.x - $gameMap.displayX()*48;
}
Game_QJLaser.prototype.screenShowY = function() {
    return this.y - $gameMap.displayY()*48;
}
//=============================================================================
//
//=============================================================================
})();
//=============================================================================
//
//=============================================================================