//=============================================================================
// RPG Maker MV
//=============================================================================
/*:
 * @plugindesc pixel move[V1.0]
 * @author Qiu Jiu
 * @help
 *
 * *********更新日志*********
 * ================================================================
 *    注意事项：
 *    1.本插件需要核心插件QJ-Collision.js。
 *    2.本插件不支持载具，即使将载具放到地图上也无法使用载具。
 *    3.最好将事件的“移动频率”设置为 5：最高，否则角色移动时会很慢。
 *    4.辅助移动指的是：当玩家撞墙时，自动进行偏移移动的功能。
 *      精度越小，最大距离越大，所耗费的资源越多。
 * ================================================================
 *
 *
 *
 *
 *
 * @param ======辅助移动======
 * @default
 *
 * @param autoMove
 * @type boolean
 * @text 辅助移动
 * @desc 是否开启辅助移动
 * @default true
 * @parent ======辅助移动======
 *
 * @param autoMoveDegree
 * @type number
 * @text 辅助移动精度
 * @desc 辅助移动精度
 * @default 1
 * @parent ======辅助移动======
 *
 * @param autoMoveLength
 * @type number
 * @text 辅助移动最大距离
 * @desc 辅助移动最大距离
 * @default 96
 * @parent ======辅助移动======
 *
 * @param ======行走图动画======
 * @default
 *
 * @param animSpeed
 * @type number
 * @max 500
 * @min 10
 * @text 行走图动画
 * @desc 行走图动画速度，这个数字越大，行走图动画越快
 * @default 50
 * @parent ======行走图动画======
 *
*/
//=============================================================================
//
//=============================================================================
var QJ = QJ || {};
QJ.PM = QJ.PM || {};
var Imported = Imported || {};
Imported.QJPixelMove = true;
(() => {
//=============================================================================
//
//=============================================================================
const pluginName = "QJ-PixelMove";
const parameters = PluginManager.parameters(pluginName);
const autoMove = eval(parameters["autoMove"]);
const autoMoveDegree = Number(parameters["autoMoveDegree"]) || 1;
const autoMoveLength = Number(parameters["autoMoveLength"]) || 96;
const animSpeed = Number(parameters["animSpeed"]) || 100;
//=============================================================================
//
//=============================================================================
const tileSize = 48;
//=============================================================================
//deal x and y
//=============================================================================
Game_Map.prototype.xWithDirection = function(x,d,distance) {
    return x + (d === 6 ? distance : d === 4 ? -distance : 0);
};
Game_Map.prototype.yWithDirection = function(y,d,distance) {
    return y + (d === 2 ? distance : d === 8 ? -distance : 0);
};
Game_Map.prototype.roundXWithDirection = function(x,d,distance) {
    return this.roundX(x + (d === 6 ? distance : d === 4 ? -distance : 0));
};
Game_Map.prototype.roundYWithDirection = function(y,d,distance) {
    return this.roundY(y + (d === 2 ? distance : d === 8 ? -distance : 0));
};
//=============================================================================
//canPass
//=============================================================================
Game_CharacterBase.prototype.canPassByPixel = function(x,y,distanceX,distanceY) {
    //=====================================
    distanceX=distanceX||0;
    distanceY=distanceY||0;
    let x2 = x+distanceX,y2 = y+distanceY;
    this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
    //=====================================
    if (!$gameMap.isValid(x2,y2)) return false;
    if (this.isThrough() || this.isDebugThrough()) return true;
    if (!this.isMapPassable(x2,y2)) return false;
    if (this.isCollidedWithCharacters(x2,y2)) return false;
    return true;
    //=====================================
};
Game_CharacterBase.prototype.canPass = function(x,y,d,distanceX,distanceY) {
    //=====================================
    distanceX=distanceX||0;
    distanceY=distanceY||0;
    let x2 = $gameMap.roundXWithDirection(x,d,distanceX);
    let y2 = $gameMap.roundYWithDirection(y,d,distanceY);
    this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
    //=====================================
    if (!$gameMap.isValid(x2,y2)) return false;
    if (this.isThrough() || this.isDebugThrough()) return true;
    if (!this.isMapPassable(x2,y2)) return false;
    if (this.isCollidedWithCharacters(x2,y2)) return false;
    return true;
    //=====================================
};
Game_CharacterBase.prototype.canPassDiagonally = function(x,y,horz,vert,distanceX,distanceY) {
    //=====================================
    distanceX=distanceX||0;
    distanceY=distanceY||0;
    let x2 = $gameMap.roundXWithDirection(x,horz,distanceX);
    let y2 = $gameMap.roundYWithDirection(y,vert,distanceY);
    this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
    //=====================================
    if (!$gameMap.isValid(x2,y2)) return false;
    if (this.isThrough() || this.isDebugThrough()) return true;
    if (!this.isMapPassable(x2,y2)) return false;
    if (this.isCollidedWithCharacters(x2,y2)) return false;
    return true;
    //=====================================
};
Game_CharacterBase.prototype.isMapPassable = function(x,y,d) {
    //=====================================
    if ($gameMap.judgeColliedWithTile(this.QJBodyForJudge,10)) return false;
    if ($gameMap.judgeColliedWithTile(this.QJBodyForJudge,2)) return false;
    if ($gameMap.judgeColliedWithTile(this.QJBodyForJudge,4)) return false;
    if ($gameMap.judgeColliedWithTile(this.QJBodyForJudge,6)) return false;
    if ($gameMap.judgeColliedWithTile(this.QJBodyForJudge,8)) return false;
    return true;
    //=====================================
};
Game_CharacterBase.prototype.isCollidedWithEvents = function(x, y) {
    for (let i of $gameMap.events()) {
        if (i==this||i.isThrough()||!i.QJBody) continue;
        if (QJ.Matter.judge(this.QJBodyForJudge,i.QJBody).collided) {
            if (i.isNormalPriority()) return true;
        }
    }
    return false;
};
Game_CharacterBase.prototype.isCollidedWithSpecialCharacter = function(character,d,distance) {
    distance=distance?distance:this.distancePerFrame();
    let x2 = $gameMap.roundXWithDirection(this._x,d,distance);
    let y2 = $gameMap.roundYWithDirection(this._y,d,distance);
    this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
    if (character==this||character.isThrough()||!character.QJBody) return true;
    if (QJ.Matter.judge(this.QJBodyForJudge,character.QJBody).collided) {
        if (character.isNormalPriority()) return true;
    }
    return false;
};
Game_CharacterBase.prototype.isCollidedWithVehicles = function(x, y) {
    let boat = $gameMap.boat(),ship = $gameMap.ship();
    if (!boat.QJBody||!ship.QJBody) return true;
    if (QJ.Matter.judge(this.QJBodyForJudge,boat.QJBody).collided&&!boat.isThrough()) return true;
    if (QJ.Matter.judge(this.QJBodyForJudge,ship.QJBody).collided&&!ship.isThrough()) return true;
    return false;
};
//========================================
Game_Event.prototype.isCollidedWithEvents = function(x, y) {
    return Game_CharacterBase.prototype.isCollidedWithEvents.call(this,x,y);
};
Game_Event.prototype.isCollidedWithPlayerCharacters = function(x, y) {
    return this.isNormalPriority() && $gamePlayer.isCollided(x,y,this);
};
Game_Player.prototype.isCollided = function(x,y,event) {
    if (!event||this.isThrough()||!this.QJBody) return false;
    return QJ.Matter.judge(event.QJBodyForJudge,this.QJBody).collided ||
            this._followers.isSomeoneCollided(x,y,event);
};
Game_Followers.prototype.isSomeoneCollided = function(x,y,event) {
    return this.visibleFollowers().some(function(follower) {
        return follower.isCollided(x,y,event);
    }, this);
};
Game_Follower.prototype.isCollided = function(x,y,event) {
    if (!event||this.isThrough()||!this.QJBody) return false;
    return QJ.Matter.judge(event.QJBodyForJudge,this.QJBody).collided;
};
//=============================================================================
//move
//=============================================================================
Game_CharacterBase.prototype.judgeCanPassMaxDistanceX = function(d,distanceX) {
    for (let i=1,il=distanceX+1;i<=il;i++) {
        if (!this.canPass(this._x,this._y,d,i/48,0)) {
            distanceX = i-1;
            break;
        }
    }
    return distanceX/48;
}
Game_CharacterBase.prototype.judgeCanPassMaxDistanceY = function(d,distanceY) {
    for (let i=1,il=distanceY+1;i<=il;i++) {
        if (!this.canPass(this._x,this._y,d,0,i/48)) {
            distanceY = i-1;
            break;
        }
    }
    return distanceY/48;
}
Game_CharacterBase.prototype.judgeCanPassMaxDistanceD = function(h,v,distance) {
    for (let i=1,il=distance+1;i<=il;i++) {
        if (!this.canPassDiagonally(this._x,this._y,h,v,i/48,i/48)) {
            distance = i-1;
            break;
        }
    }
    return distance/48;
}
Game_CharacterBase.prototype.judgeAutoMoveDirection = function(direction,maxOffset,minDistance) {
    for (let i=0;i<maxOffset;i++) {
        if (direction==2||direction==8) {
            if (this.canPass(this._x+i*minDistance,this._y,direction,0,minDistance)) {
                if (this.canPass(this._x,this._y,6,i*minDistance,0))
                return [6,i];
            }
            if (this.canPass(this._x-i*minDistance,this._y,direction,0,minDistance)) {
                if (this.canPass(this._x,this._y,4,i*minDistance,0))
                return [4,i];
            } 
        }
        if (direction==4||direction==6) {
            if (this.canPass(this._x,this._y+i*minDistance,direction,minDistance,0)) {
                if (this.canPass(this._x,this._y,2,0,i*minDistance))
                return [2,i];
            }
            if (this.canPass(this._x,this._y-i*minDistance,direction,minDistance,0)) {
                if (this.canPass(this._x,this._y,8,0,i*minDistance))
                return [8,i];
            } 
        }
    }
    return [0,0];
}
//============================================
Game_CharacterBase.prototype.autoMoveOffset = function(d) {
    let minDistance = this.distancePerFrame() * autoMoveDegree;
    let judgeData = this.judgeAutoMoveDirection(d,autoMoveLength,minDistance);
    if (judgeData[0]!=0) {
        let remFixDirection = this.isDirectionFixed();
        this.setDirectionFix(true);
        console.log(judgeData[0]);
        this.moveStraight(judgeData[0],null,false);
        this.setDirectionFix(remFixDirection);
    }
};
Game_CharacterBase.prototype.moveStraight = function(d,distance,ifAutoMove) {
    if (ifAutoMove==undefined) ifAutoMove=false;
    distance=this.dealDistance(distance);
    let distanceX=0,distanceY=0;
    if (d==4||d==6) distanceX=this.judgeCanPassMaxDistanceX(d,distance);
    if (d==2||d==8) distanceY=this.judgeCanPassMaxDistanceY(d,distance);
    this.setMovementSuccess(distanceX!=0||distanceY!=0);
    this.setDirection(d);
    if (this.isMovementSucceeded()) {
        this._realX = this._x;
        this._realY = this._y;
        this._x = $gameMap.roundXWithDirection(this._x,d,distanceX);
        this._y = $gameMap.roundYWithDirection(this._y,d,distanceY);
        this.increaseSteps();
        this.setBodyPosition();
    } else {
        this.checkEventTriggerTouchFront(d,distanceX,distanceY);
        if (ifAutoMove) this.autoMoveOffset(d);
    }
};
Game_Player.prototype.moveStraight = function(d,distance,ifAutoMove) {
    this._followers.updateMove();
    Game_CharacterBase.prototype.moveStraight.call(this,d,distance,ifAutoMove==false?false:autoMove);
};
//============================================
Game_CharacterBase.prototype.moveDiagonally = function(horz,vert,distance) {
    distance=this.dealDistance(distance);
    let distanceD=this.judgeCanPassMaxDistanceD(horz,vert,Math.floor(distance*0.7));
    let distanceX=0,distanceY=0;
    if (distanceD==0) {
        distanceX=this.judgeCanPassMaxDistanceX(horz,distance);
        if (distanceX==0) distanceY=this.judgeCanPassMaxDistanceY(vert,distance);
    } else {distanceX=distanceD;distanceY=distanceD;}
    this.setMovementSuccess(distanceX!=0||distanceY!=0);
    if (this._direction === this.reverseDir(horz)) this.setDirection(horz);
    if (this._direction === this.reverseDir(vert)) this.setDirection(vert);
    if (this.isMovementSucceeded()) {
        this._realX = this._x;
        this._realY = this._y;
        this._x = $gameMap.roundXWithDirection(this._x,horz,distanceX);
        this._y = $gameMap.roundYWithDirection(this._y,vert,distanceY);
        this.increaseSteps();
        this.setBodyPosition();
    } else {
        this.checkEventTriggerTouchFront(horz,distanceX,distanceY);
        this.checkEventTriggerTouchFront(vert,distanceX,distanceY);
    }
};
Game_Player.prototype.moveDiagonally = function(horz, vert,distance) {
    this._followers.updateMove();
    Game_Character.prototype.moveDiagonally.call(this, horz, vert,distance);
};
//============================================
Game_CharacterBase.prototype.moveToFarAway = function(rotation,distance) {
    for (let i=0;i<distance;i++) {
        let ofx = i*Math.sin(rotation)/48,ofy = -i*Math.cos(rotation)/48;
        if (!this.canPassByPixel(this._x,this._y,ofx,ofy)) {
            distance = i==0?0:(i-1);
            break;
        }
    }
    this._x += distance*Math.sin(rotation)/48;
    this._y += -distance*Math.cos(rotation)/48;
    this._realX = this._x;
    this._realY = this._y;
    this.setBodyPosition();
    return distance;
};
//============================================
Game_CharacterBase.prototype.dealDistance = function(distance) {//Pixel
    return Math.max(distance?distance:1,Math.ceil(this.distancePerFrame()*48*2));
};
Game_CharacterBase.prototype.padTheDeltaX = function(tarX) {
    return Math.abs(this.deltaXFrom(tarX))<=this.dealDistance()/48;
};
Game_CharacterBase.prototype.padTheDeltaY = function(tarY) {
    return Math.abs(this.deltaYFrom(tarY))<=this.dealDistance()/48;
};
//=============================================================================
//Movement
//=============================================================================
Game_Character.prototype.moveRandom = function() {
    this.moveStraight(2 + Math.randomInt(4) * 2);
};
Game_Character.prototype.moveTowardCharacter = function(character) {
    let xCan = true,yCan = true;
    if (this.padTheDeltaX(character.x)) xCan = false;
    if (this.padTheDeltaY(character.y)) yCan = false;
    let sx = this.deltaXFrom(character.x);
    let sy = this.deltaYFrom(character.y);
    if (xCan&&yCan&&Math.abs((Math.abs(sx) - Math.abs(sy)))<=this.dealDistance()/48) {
        this.moveDiagonally(sx > 0 ? 4 : 6,sy > 0 ? 8 : 2);
    } else if (Math.abs(sx) > Math.abs(sy)) {
        if (xCan) {
            this.moveTowardCharacterPartx(sx);
            if (!this.isMovementSucceeded() && sy !== 0 && yCan) 
                this.moveTowardCharacterParty(sy);
        } else if (yCan) this.moveTowardCharacterParty(sy);
    } else if (sy !== 0) {
        if (yCan) {
            this.moveTowardCharacterParty(sy);
            if (!this.isMovementSucceeded() && sx !== 0 && xCan) 
                this.moveTowardCharacterPartx(sx);
        } else if (xCan) this.moveTowardCharacterParty(sx);
    }
};
Game_Character.prototype.moveTowardCharacterPartx = function(sx) {
    let d = sx > 0 ? 4 : 6;
    this.moveStraight(d);
}
Game_Character.prototype.moveTowardCharacterParty = function(sy) {
    let d = sy > 0 ? 8 : 2;
    this.moveStraight(d);
}
Game_Character.prototype.moveAwayFromCharacter = function(character) {
    var sx = this.deltaXFrom(character.x);
    var sy = this.deltaYFrom(character.y);
    if (Math.abs(sx) > Math.abs(sy)) {
        this.moveStraight(sx > 0 ? 6 : 4);
        if (!this.isMovementSucceeded() && sy !== 0) {
            this.moveStraight(sy > 0 ? 2 : 8);
        }
    } else if (sy !== 0) {
        this.moveStraight(sy > 0 ? 2 : 8);
        if (!this.isMovementSucceeded() && sx !== 0) {
            this.moveStraight(sx > 0 ? 6 : 4);
        }
    }
};
Game_Event.prototype.moveTypeTowardPlayer = function() {
    if (this.isNearThePlayer()) this.moveTowardPlayer();
    else this.moveRandom();
};
Game_CharacterBase.prototype.moveToNearestGrid = function() {
    let remT = this.isThrough();
    this.setThrough(true);
    let tarX = Math.floor(this._x + 0.5);
    let tarY = Math.floor(this._y + 0.5);
    this.moveDirectToPoint(tarX,tarY,true,true,this.realMoveSpeed());
    this.setThrough(remT);
};
//=============================================================================
//Game_Player
//=============================================================================
Game_Player.prototype.getInputDirection = function() {
    return Input.dir8;//输入时读取8位
};
Game_Player.prototype.getMainInputDirection = function() {
    return Input.dir4;//8位时，读取主要的玩家朝向
};
Game_Player.prototype.executeMove = function(direction) {
    if (direction%2==0) this.moveStraight(direction);
    else if (direction==1) this.moveDiagonally(4, 2);
    else if (direction==3) this.moveDiagonally(6, 2);
    else if (direction==7) this.moveDiagonally(4, 8);
    else if (direction==9) this.moveDiagonally(6, 8);
};
//=============================================================================
//complex deal
//=============================================================================
const Game_Map_isLadder = Game_Map.prototype.isLadder;
Game_Map.prototype.isLadder = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_isLadder.call(this,x,y);
};
const Game_Map_isBush = Game_Map.prototype.isBush;
Game_Map.prototype.isBush = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_isBush.call(this,x,y);
};
const Game_Map_isCounter = Game_Map.prototype.isCounter;
Game_Map.prototype.isCounter = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_isCounter.call(this,x,y);
};
const Game_Map_isDamageFloor = Game_Map.prototype.isDamageFloor;
Game_Map.prototype.isDamageFloor = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_isDamageFloor.call(this,x,y);
};
const Game_Map_terrainTag = Game_Map.prototype.terrainTag;
Game_Map.prototype.terrainTag = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_terrainTag.call(this,x,y);
};
const Game_Map_regionId = Game_Map.prototype.regionId;
Game_Map.prototype.regionId = function(x, y) {
    x = Math.floor(x);
    y = Math.floor(y);
    return Game_Map_regionId.call(this,x,y);
};
Game_CharacterBase.prototype.pos = function(x, y) {
    return Math.floor(this._x) === Math.floor(x) && Math.floor(this._y) === Math.floor(y);
};
//=============================================================================
//event
//=============================================================================
const PM_Game_Player_initMembers = Game_Player.prototype.initMembers;
Game_Player.prototype.initMembers = function() {
    PM_Game_Player_initMembers.call(this);
    this._escapeAndStart = [];
};
const PM_Game_Player_update = Game_Player.prototype.update;
Game_Player.prototype.update = function(sceneActive) {
    PM_Game_Player_update.call(this,sceneActive);
    this.deleteEscapeEvent();
};
Game_Player.prototype.deleteEscapeEvent = function() {
    let dee = this._escapeAndStart,result;
    if (dee.length==0) return;
    for (let i=0,l=dee.length;i<l;i++) {
        result = dee[i]?!QJ.Matter.judge(this.QJBody,dee[i].QJBody).collided:true;
        if (result) dee.splice(i,1);
    }
};
Game_Player.prototype.checkEventTriggerThere = function(triggers,distance) {
    if (this.canStartLocalEvents()) {
        distance=this.dealDistance(distance)/48;
        let direction = this.direction();
        let x2 = $gameMap.roundXWithDirection(this._x, direction,distance);
        let y2 = $gameMap.roundYWithDirection(this._y, direction,distance);
        this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
        this.startMapEvent(x2, y2, triggers, true);
        if (!$gameMap.isAnyEventStarting() && $gameMap.isCounter(x2, y2)) {
            var x3 = $gameMap.roundXWithDirection(x2, direction);
            var y3 = $gameMap.roundYWithDirection(y2, direction);
            this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
            this.startMapEvent(x3, y3, triggers, true);
        }
    }
};
Game_Player.prototype.checkEventTriggerHere = function(triggers) {
    if (this.canStartLocalEvents()) {
        this.setBodyForJudgePosition(this.boxScreenTarX(this._x),this.boxScreenTarY(this._y));
        this.startMapEvent(this.x, this.y, triggers, false);
    }
};
Game_Player.prototype.startMapEvent = function(x, y, triggers, normal) {
    if ($gameMap.isEventRunning()) return;
    for (let i of $gameMap.events()) {
        if (i._pageIndex<0) continue;
        let result = QJ.Matter.judge(this.QJBodyForJudge,i.QJBody);
        if (!result.collided) continue;
        if (i.isTriggerIn(triggers) && i.isNormalPriority() === normal) {
            if (!normal && i._trigger == 1) {
                if (this._escapeAndStart.includes(i)) continue;
                else this._escapeAndStart.push(i);
            }
            if (result.normal.x>0) this.setDirection(6);
            if (result.normal.x<0) this.setDirection(4);
            if (result.normal.y>0) this.setDirection(2);
            if (result.normal.y<0) this.setDirection(8);
            i.start();
        }
    }
};
Game_CharacterBase.prototype.checkEventTriggerTouchFront = function(d,distance) {
    distance=this.dealDistance(distance)/48;
    let direction = this.direction();
    let x2 = $gameMap.roundXWithDirection(this._x,d,distance);
    let y2 = $gameMap.roundYWithDirection(this._y,d,distance);
    this.setBodyForJudgePosition(this.boxScreenTarX(x2),this.boxScreenTarY(y2));
    this.checkEventTriggerTouch(x2, y2);
};
Game_Event.prototype.checkEventTriggerTouch = function(x, y) {
    if (!$gameMap.isEventRunning()&&this.QJBody&&$gamePlayer.QJBody) {
        if (this._trigger === 2 && QJ.Matter.judge(this.QJBodyForJudge,$gamePlayer.QJBody).collided) {
            if (!this.isJumping() && this.isNormalPriority()) {
                this.start();
            }
        }
    }
};
//=============================================================================
//setDestination
//=============================================================================
Game_Map.prototype.canvasToMapXReal = function(x) {
    let tileWidth = this.tileWidth();
    let originX = this._displayX * tileWidth;
    let mapX = (originX + x) / tileWidth;
    return this.roundX(mapX);
};
Game_Map.prototype.canvasToMapYReal = function(y) {
    let tileHeight = this.tileHeight();
    let originY = this._displayY * tileHeight;
    let mapY = (originY + y) / tileHeight;
    return this.roundY(mapY);
};
Scene_Map.prototype.processMapTouch = function() {
    if (TouchInput.isTriggered() || this._touchCount > 0) {
        if (TouchInput.isPressed()) {
            if (this._touchCount === 0 || this._touchCount >= 15) {
                let x = $gameMap.canvasToMapXReal(TouchInput.x);
                let y = $gameMap.canvasToMapYReal(TouchInput.y);
                $gameTemp.setDestination(x, y);
            }
            this._touchCount++;
        } else {
            this._touchCount = 0;
        }
    }
};
Game_Temp.prototype.isDestinationValid = function() {
    if (Math.abs($gamePlayer.x-this.destinationX())<=$gamePlayer.dealDistance()/48 && 
        Math.abs($gamePlayer.y-this.destinationY())<=$gamePlayer.dealDistance()/48) {
        this.clearDestination();
    }
    return this._destinationX !== null;
};
//=============================================================================
//
//=============================================================================
const PM_Game_CharacterBase_updateMove = Game_CharacterBase.prototype.updateMove;
Game_CharacterBase.prototype.updateMove = function() {
    PM_Game_CharacterBase_updateMove.call(this);
    if (this._x!=this.getRemXYD(0)[1]||this._y!=this.getRemXYD(0)[2]) {
        this.dealRemXYD();
    }
};
const PM_Game_CharacterBase_locate = Game_CharacterBase.prototype.locate;
Game_CharacterBase.prototype.locate = function(x, y) {
    PM_Game_CharacterBase_locate.call(this,x, y);
    if (!this._remXYD) this.initRemXYD();
};
Game_CharacterBase.prototype.initRemXYD = function() {
    this._remXYD = [0,[]];
    for (let i=0;i<256;i++) this._remXYD[1].push([this._x,this._y,this.direction()]);
};
Game_CharacterBase.prototype.dealRemXYD = function() {
    this._remXYD[0]++;
    if (this._remXYD[0]>=this._remXYD[1].length) this._remXYD[0]-=this._remXYD[1].length;
    this._remXYD[1][this._remXYD[0]] = [this._x,this._y,this.direction()];
};
Game_CharacterBase.prototype.getRemXYD = function(index) {
    index=this._remXYD[0]+index;
    if (index>=this._remXYD[1].length) index-=this._remXYD[1].length;
    if (index<0) index+=this._remXYD[1].length;
    return this._remXYD[1][index];
};
const PM_Game_CharacterBase_jump = Game_CharacterBase.prototype.jump;
Game_CharacterBase.prototype.jump = function(xPlus,yPlus) {
    PM_Game_CharacterBase_jump.call(this,xPlus,yPlus);
    this.initRemXYD();
};
//=============================================================================
//
//=============================================================================
Game_Follower.prototype.chaseCharacter = function(character) {
    if (!character._remXYD) return;
    let lastXYD = character.getRemXYD($gamePlayer.followers().areGathering()?0:-6);
    this._x = lastXYD[0];
    this._y = lastXYD[1];
    this.setDirection(lastXYD[2]);
    this.setMoveSpeed($gamePlayer.realMoveSpeed());
};
//=============================================================================
//
//=============================================================================
Game_CharacterBase.prototype.setPosition = function(x, y) {
    this._x = x;
    this._y = y;
    this._realX = x;
    this._realY = y;
};
Game_CharacterBase.prototype.animationWait = function() {
    return Math.max(Math.floor((9 - this.realMoveSpeed())*(100/animSpeed)),1);
};
//=============================================================================
//
//=============================================================================
})();
//=============================================================================
//
//=============================================================================