//=============================================================================
// RIN_textSpeed.js
//=============================================================================
 
/*:
 * @plugindesc 覆盖法修改文本显示速度
 * @author yuyering
 *
 * @param speed
 * @desc 文本速度减缓程度（帧数）
 * @default 0
 * 
 * 
 * @help 2021/5/18
 * RIN_textSpeed 1.0
 * 用了自定义的方法覆盖了原本的Window_Message的update在内的部分函数
 * 可能会和其他同样影响该功能的函数产生冲突，到时请抛弃本插件X.X
 * 
 * 参数说明：
 * speed:
 * 0为默认设置，此时速度和原本无区别。
 * 推荐速度区间0~5，数字越大，文本速度越慢。
 * 
 */
 
//-----------------------------------------------------------------------------

function TextSpeed(){};

TextSpeed.parameters = PluginManager.parameters('RIN_textSpeed');
TextSpeed.temp=TextSpeed.parameters['speed'] || '0';
TextSpeed.intTemp=parseInt(TextSpeed.temp);
//alert(TextSpeed.intTemp);
Window_Message.prototype.initMembers = function() {
    this._imageReservationId = Utils.generateRuntimeId();
    this._background = 0;
    this._positionType = 2;
    this._waitCount = 0;
    //自定义的参数，其他部分与原函数一致
    this.speedCount = TextSpeed.intTemp;
    this.respeedCount=0;
    this.allowSwitch=0;
    //自定义的参数，其他部分与原函数一致

    this._faceBitmap = null;
    this._textState = null;
    this.clearFlags();
};

Window_Message.prototype.waitBySpeed = function() {
    this.updateShowFast();
    if(TextSpeed.intTemp==0){
        return false;
    }
    else if(this._showFast)
    {
        return false;
    }
    else if(this.allowSwitch==1){    
        this.allowSwitch=0;
        this.speedCount=this.respeedCount;
        this.respeedCount=0;
        this.speedCount--;
        this.respeedCount++;
        return true;
    }
    else if (this.speedCount > 0) {
        this.speedCount--;
        this.respeedCount++;
        return true;
    } 
    else if(this.speedCount==0){
        this.allowSwitch=1;
        return false;
    }
    else {
        return false;
    }
    
};//关键函数

Window_Message.prototype.update = function() {
    this.checkToNotClose();
    Window_Base.prototype.update.call(this);
    while (!this.isOpening() && !this.isClosing()) {
        if (this.updateWait()) {
            return;
        } 
        else if (this.updateLoading()) {
            return;
        } else if (this.updateInput()) {
            return;
        } 
        else if (this.waitBySpeed()){ 
            return;
            //在此处插入该函数实现控制速度的作用
        }
         
        else if (this.updateMessage()) {
            return;
        } else if (this.canStart()) {
            this.startMessage();
        } else {
            this.startInput();
            return;
        }
    }
};

 
Window_Message.prototype.updateMessage = function() {
    if (this._textState) {
        while (!this.isEndOfText(this._textState)) {
            if (this.needsNewPage(this._textState)) {
                this.newPage(this._textState);
            }
            this.updateShowFast();
            this.processCharacter(this._textState);
            if (!this._showFast && !this._lineShowFast) {
                break;
            }
            if (this.pause || this._waitCount > 0) {
                break;
            }
        }
        if (this.isEndOfText(this._textState)) {
            this.onEndOfText();
        }
        return true;
    } else {
        return false;
    }
};

