//=================================================================================================
// Operation_Event.js
//=================================================================================================
/*:
* @target MZ
* @plugindesc 【MV + MZ】 操控事件。
* @author 芯☆淡茹水
* @help
*
* 〓 MV 插件命令 〓
* 设置操控对象 => SetOperation id
*  id : 操控对象ID。 角色ID为 0 ;  事件为该事件的ID。
*  操控事件只能是当前地图的事件！
*  若在操控事件时转换了地图，则操控对象自动变更为角色。
*
*
* @command SetOperation
* @text 设置操控的对象
* @desc 设置操控的对象。
* 
* @arg id
* @type number
* @default 0
* @text 操控的对象ID
* @desc 角色ID为 0 ;  事件为该事件的ID。
*/
//=================================================================================================
;((isMZ) => {
//=================================================================================================
const XR_Game_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
    XR_Game_System_initialize.call(this);
    this._currentOperationId = 0;
};
Game_System.prototype.isInOperation = function(character) {
    return character && character.operationId() === this._currentOperationId;
};
Game_System.prototype.setOperation = function(operationId) {
    if (this._currentOperationId !== operationId) {
        const result = operationId === 0 || $gameMap.event(operationId);
        if (result) {
            $gameTemp.clearDestination();
            this._currentOperationId = operationId;
            this.operationCharacter().centerSelf();
        }
    }
};
Game_System.prototype.operationCharacter = function() {
    return $gameMap.event(this._currentOperationId) || $gamePlayer;
};
//=================================================================================================
Game_Character.prototype.operationId = function() {
    return 0;
};
Game_Character.prototype.centerSelf = function() {
    this.center && this.center(this._x, this._y);
};
//=================================================================================================
const XR_Game_Player_canStartLocalEvents = Game_Player.prototype.canStartLocalEvents;
Game_Player.prototype.canStartLocalEvents = function() {
    return $gameSystem.isInOperation(this) && XR_Game_Player_canStartLocalEvents.call(this);
};
const XR_Game_Player_center = Game_Player.prototype.center;
Game_Player.prototype.center = function(x, y) {
    return $gameSystem.isInOperation(this) && XR_Game_Player_center.call(this, x, y);
};
const XR_Game_Player_moveByInput = Game_Player.prototype.moveByInput;
Game_Player.prototype.moveByInput = function() {
    $gameSystem.isInOperation(this) && XR_Game_Player_moveByInput.call(this);
};
const XR_Game_Player_updateScroll = Game_Player.prototype.updateScroll;
Game_Player.prototype.updateScroll = function(lastScrolledX, lastScrolledY) {
    $gameSystem.isInOperation(this) && XR_Game_Player_updateScroll.call(this, lastScrolledX, lastScrolledY);
};
const XR_Game_Player_updateNonmoving = Game_Player.prototype.updateNonmoving;
Game_Player.prototype.updateNonmoving = function(wasMoving) {
    $gameSystem.isInOperation(this) && XR_Game_Player_updateNonmoving.call(this, wasMoving);
};
const XR_Game_Player_reserveTransfer = Game_Player.prototype.reserveTransfer;
Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
    $gameSystem.setOperation(0);
    XR_Game_Player_reserveTransfer.call(this, mapId, x, y, d, fadeType);
};
//=================================================================================================
Game_Event.prototype.operationId = function() {
    return this.eventId();
};
Game_Event.prototype.turnTowardPlayer = function() {
    this.turnTowardCharacter($gameSystem.operationCharacter());
};
Game_Event.prototype.centerX = function() {
    return Game_Player.prototype.centerX.call(this);
};
Game_Event.prototype.centerY = function() {
    return Game_Player.prototype.centerY.call(this);
};
Game_Event.prototype.center = function(x, y) {
    return Game_Player.prototype.center.call(this, x, y);
};
Game_Event.prototype.locate = function(x, y) {
    Game_Character.prototype.locate.call(this, x, y);
    $gameSystem.isInOperation(this) && this.center(x, y);
};
Game_Event.prototype.isInVehicle = function() {
    return false;
};
Game_Event.prototype.moveByInput = function() {
    Game_Player.prototype.moveByInput.call(this);
};
Game_Event.prototype.getInputDirection = function() {
    return Game_Player.prototype.getInputDirection.call(this);
};
Game_Event.prototype.executeMove = function(direction) {
    Game_Player.prototype.executeMove.call(this, direction);
};
Game_Event.prototype.areFollowersGathering = function() {
    return false;
};
Game_Event.prototype.getOnOffVehicle = function() {
    return false;
};
Game_Event.prototype.isInBoat = function() {
    return false;
};
Game_Event.prototype.isInShip = function() {
    return false;
};
Game_Event.prototype.isInAirship = function() {
    return false;
};
const XR_Game_Event_canMove = Game_Event.prototype.canMove;
Game_Event.prototype.canMove = function() {
    if (!$gameSystem.isInOperation(this)) return XR_Game_Event_canMove.call(this);
    else return Game_Player.prototype.canMove.call(this);
};
const XR_Game_Event_update = Game_Event.prototype.update;
Game_Event.prototype.update = function() {
    const lastScrolledX = this.scrolledX();
    const lastScrolledY = this.scrolledY();
    const wasMoving = this.isMoving();
    XR_Game_Event_update.call(this);
    this.moveByInput();
    this.updateScroll(lastScrolledX, lastScrolledY);
    !this.isMoving() && this.updateNonmoving(wasMoving);
};
Game_Event.prototype.updateScroll = function(lastScrolledX, lastScrolledY) {
    Game_Player.prototype.updateScroll.call(this, lastScrolledX, lastScrolledY)
};
Game_Event.prototype.updateNonmoving = function(wasMoving) {
    Game_Player.prototype.updateNonmoving.call(this, wasMoving);
};
Game_Event.prototype.updateEncounterCount = function() {
};
Game_Event.prototype.canStartLocalEvents = function() {
    return Game_Player.prototype.canStartLocalEvents.call(this);
};
Game_Event.prototype.triggerAction = function() {
    return Game_Player.prototype.triggerAction.call(this);
};
Game_Event.prototype.triggerButtonAction = function() {
    return Game_Player.prototype.triggerButtonAction.call(this);
};
Game_Event.prototype.checkEventTriggerHere = function(triggers) {
    Game_Player.prototype.checkEventTriggerHere.call(this, triggers);
};
Game_Event.prototype.checkEventTriggerThere = function(triggers) {
    Game_Player.prototype.checkEventTriggerThere.call(this, triggers);
};
Game_Event.prototype.triggerTouchAction = function() {
    return Game_Player.prototype.triggerTouchAction.call(this);
};
Game_Event.prototype.triggerTouchActionD1 = function(x1, y1) {
    return Game_Player.prototype.triggerTouchActionD1.call(this, x1, y1);
};
Game_Event.prototype.triggerTouchActionD2 = function(x2, y2) {
    return Game_Player.prototype.triggerTouchActionD2.call(this, x2, y2);
};
Game_Event.prototype.triggerTouchActionD3 = function(x2, y2) {
    return Game_Player.prototype.triggerTouchActionD3.call(this, x2, y2);
};
Game_Event.prototype.startMapEvent = function(x, y, triggers, normal) {
    Game_Player.prototype.startMapEvent.call(this, x, y, triggers, normal);
};
const XR_Game_Event_checkEventTriggerTouch = Game_Event.prototype.checkEventTriggerTouch;
Game_Event.prototype.checkEventTriggerTouch = function(x, y) {
    if (!$gameSystem.isInOperation(this)) XR_Game_Event_checkEventTriggerTouch.call(this, x, y);
    else if (this.canStartLocalEvents()) this.startMapEvent(x, y, [1,2], false);
};
//=================================================================================================
if (isMZ) {
    PluginManager.registerCommand('XdRs_OperationEvent', 'SetOperation', args => {
        $gameSystem.setOperation(parseInt(args.id));
    });
} else {
    const XR_Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        XR_Game_Interpreter_pluginCommand.call(this, command, args);
        command === 'SetOperation' && $gameSystem.setOperation(parseInt(args[0]));
    };
}
//=================================================================================================
})(Utils.RPGMAKER_NAME === 'MZ');
//=================================================================================================
// end
//=================================================================================================