//=============================================================================
// YHD_RenWuQiPao.js
//=============================================================================

/*:
 * @plugindesc 事件气泡显示
 * @author 永恒
 *
 * @help
 * ============================================================================
 *    插件说明 【插件打上即可使用】
 * ============================================================================
 *  注意事项：确保 文件夹 img\system 里面有图片“Balloon.png”，这个气泡图片！
 * ============================================================================
 * 例子：
 *    【事件执行内容：】
 *           注释：气泡_3 （事件指令：第一页-流程控制-注释...）
 *           事件开始执行.....
 * 说明：
 *
 *  事件页的注释说明下加入“气泡_3”，即显示【Balloon.png】第3行的表情
 *  
 *  【如果每页事件的注释不一样，也会显示不一样的气泡效果！！】
 * ============================================================================
 *
 * ============================================================================ 
 */
//-----------------------------------------------------------------------------
var Imported = Imported || {};
Imported.QIPAO_AutoBalloon = true;

var YHD = YHD || {};
YHD.QIPAO_AutoBalloon = YHD.QIPAO_AutoBalloon || {};



  var parameters = PluginManager.parameters('YHD_RenWuQiPao'); 
  var YHDQPXS = String(parameters['YHDQPXS']);
  YHDQPXS = false;
  
YHD.QIPAO_AutoBalloon.Game_Character_initialize = Game_Character.prototype.initialize;
  Game_Character.prototype.initialize = function() {
    YHD.QIPAO_AutoBalloon.Game_Character_initialize.call(this);
    this._auto_balloon = 0;
};

Game_Character.prototype._auto_balloon = function() {
	return this._auto_balloon;
};

  
YHD.QIPAO_AutoBalloon.Game_Event_refresh = Game_Event.prototype.refresh;
Game_Event.prototype.refresh = function() {
	YHD.QIPAO_AutoBalloon.Game_Event_refresh.call(this); 
	if((this._erased == false)&&(this._trigger == 0)){
	var list = this.list();
	for(var i=0 ;i<list.length;i++){
		if (list[i].code == 108){
			var num =list[i].parameters[0].match(/气泡_(\d+)/g);
			if (num){
				var num1 = Number((String(num)).match(/\d+(\.\d+)?/g));
				this._auto_balloon = num1;
			}
		}
	}
	}
};

Game_Event.prototype.setupPage = function() {
    if (this._pageIndex >= 0) {
		this._auto_balloon = 0;
        this.setupPageSettings();
    } else {
		this._auto_balloon = 0;
        this.clearPageSettings();
    }
    this.refreshBushDepth();
    this.clearStartingFlag();
    this.checkEventTriggerAuto();
};




  
  
YHD.QIPAO_AutoBalloon.Sprite_Character_initialize = Sprite_Character.prototype.initialize;
Sprite_Character.prototype.initialize = function(character) {
    YHD.QIPAO_AutoBalloon.Sprite_Character_initialize.call(this,character);
	this.createAutoBalloon();
	this._dis_flag = 0;
	this._flag = 0;
	this._bx = 0
	this.character = character;
};
Sprite_Character.prototype.createAutoBalloon = function() {
    this._auto_balloon_sprite = new Sprite();
    this._auto_balloon_sprite.bitmap = ImageManager.loadSystem('Balloon');
	this._auto_balloon_sprite.opacity = 0;
	this._auto_balloon_sprite.z = 7;
	this._auto_balloon_sprite.x = this.x;
    this._auto_balloon_sprite.y = this.y-40;
	this._auto_balloon_sprite.anchor.x = 0.5;
    this._auto_balloon_sprite.anchor.y = 1;	
    this.addChild(this._auto_balloon_sprite);
	if (YHDQPXS){
		this._p_balloon_sprite = new Sprite();
		this._p_balloon_sprite.bitmap = ImageManager.loadSystem('Balloon');
		this._p_balloon_sprite.opacity = 0;
		this._p_balloon_sprite.z = 7;
		this.parent.addChild(this._p_balloon_sprite);
	}
}	

YHD.QIPAO_AutoBalloon.Sprite_Character_update = Sprite_Character.prototype.update;  
Sprite_Character.prototype.update = function() {
	YHD.QIPAO_AutoBalloon.Sprite_Character_update.call(this);
	if ((this.character._auto_balloon == 0)  || ! (this._balloonDuration == 0 ) || ($gameMap._interpreter.isRunning()) || ($gameSwitches[212] == true)){
      this.clear_auto_balloon();
	}
    else{
      this.update_auto_balloon();
	}
}


Sprite_Character.prototype.face_to_event = function() {
    return true;
}


Sprite_Character.prototype.distance_balloom_opacity = function() {
   this._auto_balloon_sprite.opacity += 70;
    if (YHDQPXS){
      this._p_balloon_sprite.opacity += 70;
	}
}


Sprite_Character.prototype.clear_auto_balloon = function() {
	if (this._auto_balloon_sprite.opacity == 0){
      this._dis_flag = 255;
      return;
	}
    this._auto_balloon_sprite.opacity = this._dis_flag;
    if (YHDQPXS){
      this._p_balloon_sprite.opacity = this._dis_flag;
	}
    this._dis_flag -= 35;
}



Sprite_Character.prototype.start_auto_balloon = function() {
    this._flag = 1;
    this._balloon_id = this.character._auto_balloon;
    this._ry = (this.character._auto_balloon - 1) * 48;
}

Sprite_Character.prototype.set_rect = function(index) {
    this._auto_balloon_sprite.setFrame(48 * index, this._ry, 48, 48);
    if (YHDQPXS){
      this._p_balloon_sprite.setFrame(48 * index, this._ry, 48, 48);
	}
}



Sprite_Character.prototype.update_auto_balloon = function() {
    if ((!this._auto_balloon_sprite) ||  (this._balloon_id != this._character._auto_balloon) || (this._flag == 0)){ 
	  this.start_auto_balloon();
    }
    if (YHDQPXS){
		this._p_balloon_sprite.x = $gamePlayer.x;
        this._p_balloon_sprite.y = $gamePlayer.y;
	}
    if (this.face_to_event()){
      this.distance_balloom_opacity();
	}else{
      this.clear_auto_balloon();
	}
    if (this._flag == 10){
      this._flag = 0; 
	  if(this._bx == 7){
		  this._bx = 0;
	  }
	  else{
		  this._bx++;
	  }
	}
    else{
      this._flag++;
	}
	this.set_rect(this._bx);
}
