cordova.define("cordova-plugin-ImagePicker.ImagePicker", function(require, exports, module) {
/**
 * Created by zhongpeng on 2017/5/31.
 */
var exec = require('cordova/exec');

var PickUploader = function() {
    this.listeners = {
        'picked': [],
        'progress': [],
        'success': [],
        'error': [],
        'galleryClosed': [],
        'delete': [] 
    };
};

PickUploader.prototype.on = function(event, callback) {
    if (!this.listeners[event]) {
        this.listeners[event] = [];
    }
    this.listeners[event].push(callback);
};

PickUploader.prototype.trigger = function(event, params) {
    if (this.listeners[event]) {
        this.listeners[event].forEach(function(callback) {
            callback(params)
        });
    } 
};

module.exports = {
    initUpload: function(callback) {
        exec(callback, null, "ImagePicker", "initUpload", []);
    },
    /**
     * 获取图片地址
     * @param onSuccess
     * @param onFail
     * @param params
     */
    getPictures: function(onSuccess, onFail, params) {
        exec(onSuccess, onFail, "ImagePicker", "getPictures", [params]);
    },
    pickPicturesThenUploadToQiniu: function(params, token, uploadParams) {
        // new object on every call to avoid same listeners registered
        var pickUploader = new PickUploader();
        var puCallback = function (params) {
            pickUploader.trigger(params.msg, params.data)
        };
        exec(puCallback, puCallback, "ImagePicker", "pickPicturesThenUploadToQiniu", [params, token, uploadParams]);
        return pickUploader;
    },
    reorderPhotosForGallery: function(newIndex, oldIndex, onSuccess) {
        exec(onSuccess, null, "ImagePicker", "reorderPhotosForGallery", [newIndex, oldIndex]);
    },
    removeUpload: function(key, onSuccess) {
        exec(onSuccess, null, "ImagePicker", "removeUpload", [key]);
    },
    removeAllUploads: function(onSuccess) {
        exec(onSuccess, null, "ImagePicker", "removeAllUploads", []);
    },
    // only implemented for ios
    showGallery: function(index) {
        // new object on every call to avoid same listeners registered
        var pickUploader = new PickUploader();
        var puCallback = function (params) {
            pickUploader.trigger(params.msg, params.data)
        };
        exec(puCallback, null, "ImagePicker", "showGallery", [index]);
        return pickUploader;
    },
    // only implemented for ios
    uploadSessionEnd: function() {
        exec(null, null, "ImagePicker", "uploadSessionEnd", []);
    }
};


});
