(function(window) {
    if (!window.GraphicsClass) {
        window.GraphicsClass = {};
    }
    var diviceRatio = window.devicePixelRatio;
    //工具
    var GraphicsUtil = {};
    GraphicsUtil.drawLine = function(ctx, x, y, x1, y1) {
        ctx.beginPath();
        ctx.moveTo(x, y);
        ctx.lineTo(x1, y1);
        ctx.stroke();
    }
    GraphicsUtil.getCrossPoint = function(line1, line2) {
        var a1 = (line1[1] - line1[3]) / (line1[0] - line1[2]);
        var b1 = line1[1] - a1 * (line1[0]);
        var a2 = (line2[1] - line2[3]) / (line2[0] - line2[2]);
        var b2 = line2[1] - a2 * (line2[0]);
        var cx = (b1 - b2) / (a2 - a1);
        var cy = a1 * cx + b1;
        return [cx, cy];
    }
    GraphicsUtil.standard = function(cormax, cormin, cornumber) {
        var tmpmax, tmpmin, corstep, tmpstep, tmpnumber, temp, extranumber;
        if (cormax <= cormin)
            return new Array();
        cornumber = cornumber - 1;
        corstep = (cormax - cormin) / (cornumber);
        if (Math.pow(10, parseInt((Math.log(corstep) / Math.log(10)))) == corstep) {
            temp = Math.pow(10, parseInt((Math.log(corstep) / Math.log(10))));
        } else {
            temp = Math.pow(10, parseInt(((Math.log(corstep) / Math.log(10)) + 1)));
        }
        tmpstep = (corstep / temp);

        //选取规范步长
        if (tmpstep >= 0 && tmpstep <= 0.005) {
            tmpstep = 0.005;
        } else if (tmpstep >= 0.005001 && tmpstep <= 0.01) {
            tmpstep = 0.01;
        } else if (tmpstep >= 0.010001 && tmpstep <= 0.015) {
            tmpstep = 0.015;
        } else if (tmpstep >= 0.015001 && tmpstep <= 0.02) {
            tmpstep = 0.02;
        } else if (tmpstep >= 0.020001 && tmpstep <= 0.05) {
            tmpstep = 0.05;
        } else if (tmpstep >= 0.050001 && tmpstep <= 0.1) {
            tmpstep = 0.1;
        } else if (tmpstep >= 0.100001 && tmpstep <= 0.2) {
            tmpstep = 0.2;
        } else if (tmpstep >= 0.200001 && tmpstep <= 0.3) {
            tmpstep = 0.3;
        } else if (tmpstep >= 0.300001 && tmpstep <= 0.4) {
            tmpstep = 0.4;
        } else if (tmpstep >= 0.400001 && tmpstep <= 0.5) {
            tmpstep = 0.5;
        } else {
            tmpstep = 1;
        }
        tmpstep = tmpstep * temp;
        if (parseInt((cormin / tmpstep)) != (cormin / tmpstep)) {
            if (cormin < 0) {
                cormin = (-1) * Math.ceil(Math.abs(cormin / tmpstep)) * tmpstep;
            } else {
                cormin = parseInt((Math.abs(cormin / tmpstep))) * tmpstep;
            }

        }
        if (parseInt(cormax / tmpstep) != (cormax / tmpstep)) {
            cormax = parseInt((cormax / tmpstep + 1)) * tmpstep;
        }
        tmpnumber = Math.round((cormax - cormin) / tmpstep);
        if (tmpnumber < cornumber) {
            extranumber = cornumber - tmpnumber;
            tmpnumber = cornumber;
            if (extranumber % 2 == 0) {
                cormax = cormax + tmpstep * parseInt((extranumber / 2));
            } else {
                cormax = cormax + tmpstep * parseInt((extranumber / 2 + 1));
            }
            cormin = cormin - tmpstep * parseInt((extranumber / 2));
        }
        cornumber = tmpnumber;
        console.log(">>>>" + cormax + " " + cormin + " " + cornumber + " " + tmpstep);
        return [cormax, cormin, Math.round(cornumber), tmpstep];
    }
    //动画类
    function Animation(startValue, endValue, duration, interpolator, changeListener, overListener) {
        this.startValue = startValue;
        this.endValue = endValue;
        this.duration = duration;
        this.interpolator = interpolator;
        this.timer;
        this.changeListener = changeListener;
        this.overListener = overListener;
        this.time = 0;
    }
    Animation.prototype.start = function() {
        var _this = this;
        this.timer = window.setInterval(function() {
            _this.time++;
            if (_this.time > _this.duration) {
                _this.stop();
            }
            if (_this.interpolator != undefined) {
                var interpolation = _this.interpolator.getInterplation(_this.time / _this.duration);
                if (_this.changeListener != undefined) {
                    var value = _this.startValue + interpolation * (_this.endValue - _this.startValue);
                    if (value > _this.endValue) {
                        value = _this.endValue;
                    }
                    _this.changeListener(value);
                }
            }
        }, 10);
    }

    Animation.prototype.stop = function() {
        if (this.timer != undefined) {
            window.clearInterval(this.timer);
            this.timer = null;
        }
        if (this.overListener != undefined) {
            this.overListener();
        }
    }

    //插值器
    function SpringInterpolator(factor) {
        this.factor = factor;
    }
    SpringInterpolator.prototype.getInterplation = function(input) {
        return Math.pow(2, -10 * input) * Math.sin((input - this.factor / 4) * (2 * Math.PI) / this.factor) + 1;
    }

    function BounceInterpolator(factor) {
        this.factor = factor;
    }

    BounceInterpolator.prototype.bounce = function(t) {
        return t * t * 8.0;
    }
    BounceInterpolator.prototype.getInterplation = function(input) {
        input *= 1.1226;
        if (input < 0.3535) return this.bounce(input);
        else if (input < 0.7408) return this.bounce(input - 0.54719) + 0.7;
        else if (input < 0.9644) return this.bounce(input - 0.8526) + 0.9;
        else return this.bounce(input - 1.0435) + 0.95;
    }


    function LinearInterpolater() {

    }
    LinearInterpolater.prototype.getInterplation = function(input) {
        return input;
    }

    function DecelerateInterpolator(factor) {
        this.factor = factor;
    }
    DecelerateInterpolator.prototype.getInterplation = function(input) {
        var result;
        if (this.factor == 1.0) {
            result = (1.0 - (1.0 - input) * (1.0 - input));
        } else {
            result = (1.0 - Math.pow((1.0 - input), 2 * this.factor));
        }
        return result;
    }
    //图表类
    function PolyLineChart(canvas, options) {
        this.canvas = canvas;
        this.options = options
        this.ctx = canvas.getContext("2d");
        this.inited = false;
        this.touchPoint;
        this.touchIndex;
        this.canTouch = true;
        this.points = [];
        this.digitCount;
        this.markCount = options.markCount;
        this.digitCount;
        this.datas;
        this.labels;
        this.maxIndex;
        this.minIndex;
    }
    PolyLineChart.prototype.update = function(options) {
        this.options = options;
        if (this.inited) {
            this.init();
        }
    }
    PolyLineChart.prototype.init = function() {
        this.datas = this.options.datas;
        this.labels = this.options.labels;
        var minValue = Number.MAX_VALUE;
        var maxValue = Number.MIN_VALUE;

        for (var i = 0; i < this.datas.length; i++) {
            if (this.datas[i] < minValue) {
                minValue = this.datas[i];
                this.minIndex = i;
            }
            if (this.datas[i] > maxValue) {
                maxValue = this.datas[i];
                this.maxIndex = i;
            }
        }

        minValue = parseFloat(minValue);
        maxValue = parseFloat(maxValue);
        this.digitCount = GraphicsUtil.standard(maxValue, minValue, this.markCount);
        this.markCount = parseInt(this.digitCount[2]) + 1;

        var fontSize = this.options.fontSize;
        var padding = this.options.padding;
        this.ctx.font = fontSize + "px serif";
        var outSpace = fontSize;
        var labelSpace = (fontSize * 1.5);
        var dataTextWidth = this.ctx.measureText("0.000").width;
        var maxWidth = this.canvas.width - dataTextWidth - padding * 2 - 2 * outSpace;
        var _this = this;
        var animation = new Animation(0, maxWidth, 100, new DecelerateInterpolator(0.5), function(value) {
            _this.draw(value);
        });
        animation.start();

        this.canvas.onclick = function(e) {
            if (_this.canTouch && _this.points != undefined) {
                var x = e.x * diviceRatio;
                var y = e.y * diviceRatio;
                for (var i = 0; i < _this.points.length; i++) {
                    if (Math.abs((x - _this.points[i].x)) <= 30 && Math.abs((y - _this.points[i].y)) <= 30) {
                        _this.touchPoint = _this.points[i];
                        _this.touchIndex = i;
                        break;
                    } else {
                        _this.touchPoint = undefined;
                        _this.touchIndex = -1;
                    }
                }
                console.log(_this.touchPoint);
            }

            _this.draw(maxWidth);
        }
        this.inited = true;
    }
    PolyLineChart.prototype.draw = function(curValue) {
        var fontSize = this.options.fontSize;
        var padding = this.options.padding;
        this.ctx.save();
        this.points = [];
        this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);

        this.ctx.fillStyle = this.options.backgroundColor;
        this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.ctx.font = fontSize + "px Arial";

        var outSpace = fontSize;
        var labelSpace = (fontSize * 1.5);

        var dataTextWidth = this.ctx.measureText("0.000").width;

        var startX = padding + dataTextWidth + outSpace;
        var startY = this.canvas.height - padding - outSpace - labelSpace;


        var maxWidth = this.canvas.width - dataTextWidth - padding * 2 - 2 * outSpace;
        var maxHeight = this.canvas.height - padding * 2 - 2 * outSpace - labelSpace;
        var cellHeight = maxHeight / (this.markCount - 1);
        var cellWidth = maxWidth / (this.datas.length - 1);

        this.ctx.strokeStyle = this.options.lineColor;
        for (var i = 0; i < this.markCount; i++) {
            GraphicsUtil.drawLine(this.ctx, padding, startY - cellHeight * i, this.canvas.width, startY - cellHeight * i);
        }

        for (var i = 0; i <= this.datas.length; i++) {
            GraphicsUtil.drawLine(this.ctx, startX + cellWidth * i, startY + outSpace, startX + cellWidth * i, padding);
        }

        this.ctx.strokeStyle = this.options.lineColor;
        GraphicsUtil.drawLine(this.ctx, 0, startY + outSpace, this.canvas.width, startY + outSpace);

        this.ctx.fillStyle = this.options.markColor;
        for (var i = 0; i < this.markCount; i++) {
            var markString = ("" + (this.digitCount[1] + this.digitCount[3] * i).toFixed(3));
            var textWidth = this.ctx.measureText(markString) + 10;
            this.ctx.fillText(markString, padding, startY - cellHeight * i - 10);
        }

        console.log(this.datas.length)
        if (this.datas.length > 28) {
            for (var i = 0; i < this.datas.length; i++) {
                if (i != 28 && (i % 7 == 0 || i == 0 || i == this.datas.length - 1)) {
                    var textWidth = this.ctx.measureText(this.labels[i]).width;
                    this.ctx.fillText(this.labels[i], startX + cellWidth * i - textWidth / 2, startY + outSpace + labelSpace);
                }
            }
        } else if (this.datas.length > 7) {
            for (var i = 0; i < this.datas.length; i++) {
                if (i % 7 == 0 || i == 0 || i == this.datas.length - 1) {
                    var textWidth = this.ctx.measureText(this.labels[i]).width;
                    this.ctx.fillText(this.labels[i], startX + cellWidth * i - textWidth / 2, startY + outSpace + labelSpace);
                }
            }
        } else {
            for (var i = 0; i < this.datas.length; i++) {

                var textWidth = this.ctx.measureText(this.labels[i]).width;
                this.ctx.fillText(this.labels[i], startX + cellWidth * i - textWidth / 2, startY + outSpace + labelSpace);
            }
        }


        //绘制折线
        this.ctx.shadowOffsetX = 1 * diviceRatio; // 阴影Y轴偏移
        this.ctx.shadowOffsetY = 1 * diviceRatio; // 阴影X轴偏移
        this.ctx.shadowBlur = 2 * diviceRatio; // 模糊尺寸
        this.ctx.shadowColor = 'rgba(0, 0, 0, 0.3)'; //

        var curPoint = { "x": +startX + curValue, "y": 0 };
        var startIndex = -1;
        var endIndex = -1;
        //计算坐标
        for (var i = 0; i < this.datas.length; i++) {
            var x = startX + cellWidth * i;
            var y = startY - ((this.datas[i] - this.digitCount[1]) / (this.digitCount[0] - this.digitCount[1])) * maxHeight;
            this.points.push({ "x": x, "y": y });

        }

        for (var i = 0; i < this.datas.length; i++) {
            if (curPoint.x < this.points[i].x && endIndex == -1) {
                endIndex = i;
            }
        }
        startIndex = endIndex - 1;


        var curCrossPoint;
        var curPoints;
        if (startIndex != -1 && endIndex != -1) {
            //求交点
            curPoints = this.points.slice(0, endIndex);
            var scanLine = [startX + curValue, 0, startX + curValue + 1, this.canvas.width];
            var curLine = [this.points[startIndex].x, this.points[startIndex].y, this.points[endIndex].x, this.points[endIndex].y];
            curCrossPoint = GraphicsUtil.getCrossPoint(scanLine, curLine);
            curPoints.push({ "x": curCrossPoint[0], "y": curCrossPoint[1] });
            //绘制交点

            //GraphicsUtil.drawLine(ctx,scanLine[0], scanLine[1], scanLine[2],scanLine[3]);
            //GraphicsUtil.drawLine(ctx,curLine[0], curLine[1], curLine[2], curLine[3]);
            //curCrossPoint = GraphicsUtil.getCrossPoint(scanLine, curLine);
        } else {
            curPoints = this.points;
        }

        //绘制折线
        var grad = this.ctx.createLinearGradient(startX, 0, this.canvas.width, 0);
        for (var i = 0; i < this.options.gradient.length; i++) {
            grad.addColorStop(this.options.gradient[i][0], this.options.gradient[i][1]);
        }
        this.ctx.strokeStyle = grad;
        this.ctx.lineWidth = 2 * diviceRatio;
        //画线
        this.ctx.beginPath();
        this.ctx.moveTo(curPoints[0].x, curPoints[0].y);
        for (var i = 0; i < curPoints.length; i++) {
            if (i < curPoints.length - 1) {
                this.ctx.lineTo(curPoints[i + 1].x, curPoints[i + 1].y);
            }
        }
        this.ctx.stroke();


        this.ctx.fillStyle = "#000000";
        //画点
        if (this.options.showPoint && this.datas.length < 8) {
            for (var i = 0; i < this.datas.length; i++) {
                this.ctx.strokeStyle = "#414050";
                this.ctx.beginPath();
                this.ctx.arc(this.points[i].x, this.points[i].y, 3.5 * diviceRatio, 0, Math.PI * 2);
                this.ctx.fill();

                this.ctx.strokeStyle = "#FFFFFF";
                this.ctx.lineWidth = 1 * diviceRatio;
                this.ctx.beginPath();
                this.ctx.arc(this.points[i].x, this.points[i].y, 3.5 * diviceRatio, 0, Math.PI * 2);
                this.ctx.stroke();
            }
        }

        if (this.touchPoint != undefined) {
            this.ctx.shadowOffsetX = 0;
            this.ctx.shadowOffsetY = 0;
            this.ctx.shadowBlur = 0;
            this.ctx.font = (fontSize + 2) + "px Arail";
            var dataTextWidth = this.ctx.measureText("0.000").width + 10 * diviceRatio;
            this.ctx.fillStyle = "#f9a96c";
            this.ctx.fillRect(this.touchPoint.x - dataTextWidth / 2, this.touchPoint.y + 10 * diviceRatio, dataTextWidth, fontSize + 4 * diviceRatio);

            this.ctx.beginPath();
            this.ctx.moveTo(this.touchPoint.x, this.touchPoint.y + 5 * diviceRatio);
            this.ctx.lineTo(this.touchPoint.x + 7 * diviceRatio, this.touchPoint.y + 11 * diviceRatio);
            this.ctx.lineTo(this.touchPoint.x - 7 * diviceRatio, this.touchPoint.y + 11 * diviceRatio);
            this.ctx.lineTo(this.touchPoint.x, this.touchPoint.y + 5 * diviceRatio);
            this.ctx.fill();

            this.ctx.fillStyle = "#FFFFFF";
            this.ctx.fillText("" + this.datas[this.touchIndex], this.touchPoint.x - dataTextWidth / 2 + 5 * diviceRatio, this.touchPoint.y + 12 * diviceRatio + fontSize);
        }

        this.ctx.restore();
    }

    function CircleChart(canvas, options) {
        this.canvas = canvas;
        this.options = options
        this.ctx = canvas.getContext("2d");
        this.inited = false;
        this.innerActive = false;
        this.value;
        this.ivalue;
    }
    CircleChart.prototype.update = function(options) {
        this.options = options;
        if (this.inited) {
            this.init();
        }
    }
    CircleChart.prototype.init = function() {
        var _this = this;
        //var innerMaxValue = (this.options.innerValue/this.options.outValue)*this.options.outMaxValue;
        var innerValueRate = (this.options.innerValue / this.options.outMaxValue) * 360 - 90;
        // if(innerMaxValue>360){
        //     innerMaxValue=360;
        // }
        var ianimation = new Animation(-90, innerValueRate, 100, new BounceInterpolator(), function(value) {
            _this.ivalue = value;
            _this.draw();
        });

        var outValueRate = (this.options.outValue / this.options.outMaxValue) * 360 - 90;
        var animation = new Animation(-90, outValueRate, 100, new BounceInterpolator(), function(value) {
            _this.value = value;
            _this.draw();
        }, function() {
            _this.innerActive = true;
            ianimation.start();
        });
        animation.start();
        //this.draw();
        this.inited = true;
    }
    CircleChart.prototype.draw = function() {
        this.ctx.save();
        this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);
        this.ctx.fillStyle = this.options.backgroundColor;
        this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
        var fontSize1 = 15;
        var fontSize2 = 21;
        var fontSize3 = 18;

        var strokeWidth = 10 * diviceRatio;
        this.ctx.lineWidth = strokeWidth;
        this.ctx.lineCap = "round";

        var maxWidth = this.canvas.width > this.canvas.height ? this.canvas.height : this.canvas.width - this.padding * 2 - strokeWidth * 2;
        var centerX = this.canvas.width / 2;
        var centerY = this.canvas.height / 2;
        var diameter1 = maxWidth - 50 * diviceRatio;
        var diameter2 = maxWidth - 75 * diviceRatio;

        this.ctx.fillStyle = this.options.circleColors[0];
        this.ctx.beginPath();
        this.ctx.arc(centerX, centerY, maxWidth / 2, 0, Math.PI * 2);
        this.ctx.fill();

        this.ctx.beginPath();
        this.ctx.fillStyle = this.options.circleColors[1];
        this.ctx.arc(centerX, centerY, diameter1 / 2 - strokeWidth / 2, 0, Math.PI * 2);
        this.ctx.fill();

        this.ctx.strokeStyle = this.options.lineColors[0];
        this.ctx.beginPath();
        this.ctx.arc(centerX, centerY, diameter1 / 2, -Math.PI / 2, this.value / 180 * Math.PI);
        this.ctx.stroke();

        this.ctx.fillStyle = "#FFFFFF";
        this.ctx.beginPath();
        this.ctx.arc(centerX, centerY - diameter1 / 2, 2 * diviceRatio, 0, Math.PI * 2);
        this.ctx.fill();

        if (this.innerActive) {
            this.ctx.strokeStyle = this.options.lineColors[1];
            this.ctx.beginPath();
            this.ctx.arc(centerX, centerY, diameter2 / 2, -Math.PI / 2, this.ivalue / 180 * Math.PI);
            this.ctx.stroke();

            this.ctx.fillStyle = "#FFFFFF";
            this.ctx.beginPath();
            this.ctx.arc(centerX, centerY - diameter2 / 2, 2 * diviceRatio, 0, Math.PI * 2);
            this.ctx.fill();
        }

        var diffValue = this.options.outValue - this.options.innerValue;
        var titleLabel = "";
        if (diffValue > 0) {
            titleLabel = "多赚";
        }
        if (diffValue < 0) {
            titleLabel = "少赚";
        }
        var textWidth = 0;
        var fontSize = fontSize1 * diviceRatio;

        this.ctx.fillStyle = this.options.labelColors[0];
        this.ctx.font = fontSize + "px " + this.options.fontName;
        var textWidth1 = this.ctx.measureText("¥").width;
        fontSize = fontSize1 * diviceRatio;
        this.ctx.font = fontSize2 + "px " + this.options.fontName;
        diffValue = diffValue.toFixed(2);
        var textWidth2 = this.ctx.measureText("" + diffValue).width;

        fontSize = fontSize1 * diviceRatio;
        this.ctx.font = fontSize + "px " + this.options.fontName;
        this.ctx.fillText("¥", (centerX - textWidth1 - textWidth2 / 2) - 8, centerY);

        fontSize = fontSize2 * diviceRatio;
        this.ctx.font = fontSize + "px " + this.options.fontName;
        this.ctx.fillText("" + diffValue, (centerX - textWidth2 / 2) - 8, centerY);

        this.ctx.fillStyle = this.options.labelColors[1];
        fontSize = fontSize3 * diviceRatio;
        this.ctx.font = fontSize + "px Arail";
        var textWidth3 = this.ctx.measureText(titleLabel).width;
        this.ctx.fillText(titleLabel, centerX - textWidth3 / 2, centerY + 30 * diviceRatio);

        this.ctx.restore();

    }


    function TimeScaleChart(canvas, options) {
        this.canvas = canvas;
        this.options = options
        this.ctx = canvas.getContext("2d");
        this.inited = false;
        this.touchPoint;
        this.value;
        this.canTouch = true;
        this.options.chooseIndex = options.chooseIndex * 2 - 1;
        //生成x轴刻度点
        this.scaleXpointArr = new Array();
        this.perStep = this.canvas.width / 24;
        for (var i = 0; i < 23; i++) {
            this.scaleXpointArr.push((i + 1) * this.perStep);
        }
        var _this = this;
        this.canvas.addEventListener('touchend', function(eve) {
            var tempLength = 100000;
            var tempIndex = 0;
            var selectX = eve.changedTouches[0].clientX;
            for (var i = 0; i < _this.scaleXpointArr.length; i++) {
                var tmpValue = Math.abs(_this.scaleXpointArr[i] - selectX * diviceRatio);
                if (tmpValue <= tempLength) {
                    tempLength = tmpValue;
                    tempIndex = i;
                }
            }
            options.chooseIndex = tempIndex + 1;
            _this.update(options);
            _this.options.callback.call((tempIndex + 1 + 1) / 2);
        });
        this.canvas.addEventListener('touchmove', function(evt) {
            var tempLength = 100000;
            var tempIndex = 0;
            var selectX = evt.changedTouches[0].clientX;
            for (var i = 0; i < _this.scaleXpointArr.length; i++) {
                var tmpValue = Math.abs(_this.scaleXpointArr[i] - selectX * diviceRatio);
                if (tmpValue <= tempLength) {
                    tempLength = tmpValue;
                    tempIndex = i;

                }
            }
            options.chooseIndex = tempIndex + 1;
            _this.update(options);
        });
    }

    TimeScaleChart.prototype.init = function() {
        var _this = this;
        _this.draw();
        this.inited = true;
    }
    TimeScaleChart.prototype.update = function(options) {
        this.options = options;
        if (this.inited) {
            this.init();
        }
    }

    TimeScaleChart.prototype.draw = function() {
        var _this = this;
        var offsetY = 13 * diviceRatio;

        this.ctx.save();
        this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height);
        this.ctx.fillStyle = this.options.backgroundColor;
        this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
        //横线
        this.ctx.beginPath();
        this.ctx.strokeStyle = this.options.lineColors[0];
        this.ctx.lineWidth = 1 * diviceRatio;
        this.ctx.moveTo(0, this.canvas.height - offsetY);
        this.ctx.lineTo(this.canvas.width, this.canvas.height - offsetY)
        this.ctx.stroke();

        for (var i = 0; i < this.scaleXpointArr.length; i++) {
            //刻度
            this.ctx.beginPath();
            this.ctx.strokeStyle = this.options.lineColors[1];
            this.ctx.lineWidth = 1 * diviceRatio;
            //整数刻度
            var scaleY = 20 * diviceRatio;
            if (i % 2) {
                //半数刻度
                scaleY = 10 * diviceRatio;
            }
            this.ctx.moveTo(this.scaleXpointArr[i], this.canvas.height - offsetY - scaleY);
            this.ctx.lineTo(this.scaleXpointArr[i], this.canvas.height - offsetY)
            this.ctx.stroke();
            //文字
            if (i % 2 == 0) {
                this.ctx.fillStyle = this.options.labelColors[0];
                // this.ctx.font = this.options.fontSize + this.options.fontName;
                var fontSize1 = 12 * diviceRatio;
                //字向下偏移量
                var font_offsetY = fontSize1 + 1 * diviceRatio;
                this.ctx.font = fontSize1 + "px Arial";
                var text1 = i / 2 + 1;
                var textWidth1 = this.ctx.measureText(text1).width;
                var textHeight1 = this.ctx.measureText(text1).height;
                this.ctx.fillText(text1, this.scaleXpointArr[i] - textWidth1, (this.canvas.height - offsetY + font_offsetY));

                var fontSize2 = 10 * diviceRatio;
                this.ctx.font = fontSize2 + "px Arial";
                var text2 = "月";
                var textWidth2 = this.ctx.measureText(text2).width;
                this.ctx.fillText(text2, this.scaleXpointArr[i], (this.canvas.height - offsetY + font_offsetY));
            }
        }
        if (diviceRatio > 2) {
            _this.options.chooseImg = _this.options.chooseImg.replace('@2x', '@3x');
        }
        //选中图片
        preImage(_this.options.chooseImg, function() {
            //此处的this指img，实际月份等于_this.options.chooseIndex * 2 - 1
            _this.ctx.drawImage(this, (_this.options.chooseIndex) * _this.perStep - this.width / 2, _this.canvas.height - offsetY - this.height);
        });

    }

    window.GraphicsClass.PolyLineChart = PolyLineChart;
    window.GraphicsClass.CircleChart = CircleChart;
    window.GraphicsClass.CircleChart = TimeScaleChart;

    function preImage(url, callback) { //图片异步加载，加载完后再canvas中画出
        var img = new Image(); //创建一个Image对象，实现图片的预下载  
        img.src = url;
        if (img.complete) { // 如果图片已经存在于浏览器缓存，直接调用回调函数  
            callback.call(img);
            return; // 直接返回，不用再处理onload事件  
        }
        img.onload = function() { //图片下载完毕时异步调用callback函数。  
            callback.call(img); //将回调函数的this替换为Image对象  
        };
    }
})(window)