cordova.define("cordova-plugin-wechat.Wechat", function(require, exports, module) {
var WeChat = function() {
};
WeChat.share = function (message, scene, onfulfilled, onrejected) {
    var ThenFail = window.ThenFail;
    var promise;

    if (ThenFail && !onfulfilled && !onrejected) {
        promise = new ThenFail();
    }

    var text = null;

    if (typeof message == 'string') {
        text = message;
        message = null;
    }

    cordova
        .exec(function () {
            if (promise) {
                promise.resolve();
            } else if (onfulfilled) {
                onfulfilled();
            }
        }, function (err) {
            if (promise) {
                promise.reject(err);
            } else if (onrejected) {
                onrejected(err);
            }
        }, 'WeChat', 'share', [
            {
                message: message,
                text: text,
                scene: scene
            }
        ]);

    return promise;
};

WeChat.Scene = {
    chosenByUser: 0,
    session: 1,
    timeline: 2
};

WeChat.ShareType = {
    app: 1,
    emotion: 2,
    file: 3,
    image: 4,
    music: 5,
    video: 6,
    webpage: 7
};

WeChat.isInstalled = function (onfulfill, onreject) {
    var ThenFail = window.ThenFail;
    var promise;

    if (ThenFail && !onfulfill && !onreject) {
        promise = new ThenFail();
    }

    cordova
        .exec(function (isInstalled) {
            if (promise) {promise.resolve(isInstalled);}
            if (onfulfill) {onfulfill(isInstalled);}
        }, function (err) {
            if (promise) {promise.reject(err);}
            if (onreject) {onreject(err);}
        }, 'WeChat', 'isInstalled', []);

    return promise;
};

WeChat.login = function (onfulfill, onreject) {
    var ThenFail = window.ThenFail;
    var promise;

    if (ThenFail && !onfulfill && !onreject) {
        promise = new ThenFail();
    }

    cordova
        .exec(function (userinfo) {
            if (promise) {promise.resolve(userinfo);}
            if (onfulfill) {onfulfill(userinfo);}
        }, function (err) {
            if (promise) {promise.reject(err);}
            if (onreject) {onreject(err);}
        }, 'WeChat', 'login', []);

    return promise;
};


module.exports = WeChat;
});
