cordova.define("com.paf.hybridframe.bridge.bridge", function(require, exports, module) { var cordova = require('cordova');

var Bridge = function() {};
property = {}
function converJsonToArr(property,refArr){
	
	var arrLen = refArr.length;
	if(arrLen < 1){
		return [];
	}
	var arrB = [];
	for (var i=0;i<arrLen;i++){
		var temp =(property[refArr[i]]) ? property[refArr[i]]:"";
		arrB.push(temp)
	}
	return arrB;

}

//transitionType 0:右 1:左 2:上 3:下 
//isPreLoad 0:不预加载 1:预加载 isRefresh
Bridge.prototype.hfOpen = function(success, error, property){
	var arrayRef = ["viewId","transitionType","width","height","outOrIn","url","isPreLoad","isRefresh","isCloseAnim","isLoading", "backJs", "h5Header", "hideBehind", "noNeedCheckFile"];//定义参数位置
	var arrB = converJsonToArr(property,arrayRef);
	console.log(JSON.stringify(arrB))
	console.log(JSON.stringify(property))
    cordova.exec(success, error, 'Bridge', 'open', arrB, false);
};

Bridge.prototype.hfUpdateHeaderTitle = function(success, error, property){
	var arrayRef = ["title", "url", "titleStyle", "rightMark", "rightButton", "leftBtnShow", "rightColor","rightTitleSize","barTranslucentAlpha","stretchToTop","navbarHidden"];//定义参数位置
	var arrB = converJsonToArr(property,arrayRef);
    cordova.exec(success, error, 'Bridge', 'updateHeaderTitle', arrB);
};

Bridge.prototype.hfUpdateNavigationBarStatus = function(success, error, property){
	var arrayRef = ["url", "status", "height", "alphaValue"];//定义参数位置
	var arrB = converJsonToArr(property,arrayRef);
    cordova.exec(success, error, 'Bridge', 'updateNavigationBarStatus', arrB);
};

Bridge.prototype.hfPageLoadFinish = function(success, error, property){
	var arrayRef = ["viewId","transitionType","width","height","outOrIn","url","isPreLoad","isRefresh", "readyCallback"];//定义参数位置
	var arrB = converJsonToArr(property,arrayRef);
    cordova.exec(success, error, 'Bridge', 'pageLoadFinish', arrB, false);
};

// 1 = out , 0 = in
Bridge.prototype.hfModify= function(success, error, property) {

	var arrayRef = ["viewId","transitionType","width","height","outOrIn","url","isPreLoad","isRefresh","isCloseAnim","isLoading", "backJs", "h5Header", "hideBehind"];//定义参数位置
	var arrB = converJsonToArr(property,arrayRef);
    cordova.exec(success, error, 'Bridge', 'replaceAndOpen', arrB, false);
};

Bridge.prototype.hfRefresh = function(success, error, refreshUrl){
    cordova.exec(success, error, 'Bridge', 'refresh', refreshUrl, false);
};

//callback success {viewList:{viewId:{url:"",height:"",width:""},viewId:{url:"",height:""},viewId:{url:"",height:""}},numView:3}
Bridge.prototype.hfGetWebViewInfos = function(success, error) {
    cordova.exec(success, error, 'Bridge', 'getWebViewInfos',[], false);
};

//callback success {length:xx}
Bridge.prototype.hfGetWebViewInfosLen = function(success, error) {
    cordova.exec(success, error, 'Bridge', 'getWebViewInfoLen',[], false);
};

//callback success {url:"",height:"",width:""} CURR  为获取当前webview
Bridge.prototype.hfGetViewById = function(success, error, viewId) {

    cordova.exec(success, error, 'Bridge', 'getWebViewInfo', [viewId], false);
};

Bridge.prototype.hfClose = function(success, error, property) {
	var arrayRef = ["viewId","transitionType"];
	var arrB = converJsonToArr(property,arrayRef);
	
    cordova.exec(success, error, 'Bridge', 'close', arrB, false);
};



Bridge.prototype.hfReload = function(success, error, fileName) {

    cordova.exec(success, error, 'Bridge', 'reload', [fileName], false);
};

Bridge.prototype.hfSetBackPage = function(success, error, viewId, url) {
	cordova.exec(success, error, 'Bridge', 'setBackPage', [viewId, url], false);
};

Bridge.prototype.hfShowProgress = function(success, error, text) {
	cordova.exec(success, error, 'Bridge', 'showProgress', [text], false);
};

Bridge.prototype.hfDismissProgress = function(success, error) {
	cordova.exec(success, error, 'Bridge', 'dismissProgress', false);
};

Bridge.prototype.hfShowToast = function(success, error, text, duration) {
	cordova.exec(success, error, 'Bridge', 'showToast', [text, duration], false);
};

Bridge.prototype.localstoarge = function(text) {
	return cordova.exec(function(){}, function(){}, 'Bridge', 'localStoarge', text, true);
};
	
//urlArr like this ['1.html','2.html','3.html','4.html','5.html','6.html'] 
//eventId  0:show 1:open 2:Modify 3:realTime
//jsString like this javascript:cordova.fireDocumentEvent('backbutton');
Bridge.prototype.hfSetNewAutoRunJs = function(success, error, jsString, eventId, urlArr) {
	cordova.exec(success, error, 'Bridge', 'setNewAutoRunJs', [jsString, eventId, urlArr], true);
};

Bridge.prototype.hFTransmitRealTime = function(arr){
	return cordova.exec(function(){}, function(){},'Bridge', 'throughRealTime', arr, true);
}

Bridge.prototype.hFGetFrameworkInfo = function(){
	var arr = [];
	return cordova.exec(function(){}, function(){},'Bridge', 'getFrameworkInfo', arr, true);
}

Bridge.prototype.hFTransmit = function(success, error, arr){
	cordova.exec(success, error,'Bridge', 'through', arr, false);
}

Bridge.prototype.hFAC_InstallApp_OffLine = function(success, error, manifestName, zipName){
	cordova.exec(success, error, 'Bridge', 'installApp_OffLine', [manifestName, zipName], false);
}

Bridge.prototype.hFAC_StartAppByAppId = function(success, error, appId){
	cordova.exec(success, error, 'Bridge', 'startAppByAppId', [appId], false);
}

Bridge.prototype.hFAC_StartPage = function(success, error, appId, pageUrl, js){
	cordova.exec(success, error, 'Bridge', 'startPage', [appId,pageUrl,js], false);
}

Bridge.prototype.hFAC_StartCellApp = function(success, error, pageUrl, js, configString){
	cordova.exec(success, error, 'Bridge', 'startCellApp', [pageUrl,js,configString], false);
}

Bridge.prototype.hFAC_CheckUpdate = function(success, error, appId){
	cordova.exec(success, error, 'Bridge', 'checkUpdate', [appId], false);
}

//[{IsOnLine:"", IsCompulsivelyUpgrade:"", IsUpgradeInStart:"", OnlyUpgradeInWifi:"", UpdateTime:"", VersionsNow:"", VersionsMD5:"", InstallationPackageMD5:"", InstallationPackageURL:"", IncrementalPacketMD5:"", IncrementalPacketURL:"", Message:"", AppName:"", AppDescribe:"", AppId:""},{}]
Bridge.prototype.hFAC_GetNativeAppsInfo = function(success, error){
	cordova.exec(success, error, 'Bridge', 'getNativeAppsInfo', [], false);
}

//[{appId:"",appDescribe:"",appName:""},{}]
Bridge.prototype.hFAC_GetAllAppsInfo = function(success, error){
	cordova.exec(success, error, 'Bridge', 'getAllAppsInfo', [], false);
}

Bridge.prototype.hFAC_InstallApp_Net = function(success, error, appInfo){
	cordova.exec(success, error, 'Bridge', 'installApp_Net', [appInfo], false);
}

//module : {"moduleName":"xxx","moduleState":0,"moduleData":"data"}
Bridge.prototype.hFAC_UpdateModuleState = function(success, error, module){
	cordova.exec(success, error, 'Bridge', 'updateModuleState', [module], false);
}

Bridge.prototype.hFAC_GetModuleInfo = function(success, error, moduleName){
	cordova.exec(success, error, 'Bridge', 'getModuleInfo', [moduleName], false);
}

Bridge.prototype.hfCloseApp = function(success, error) {
	navigator.app.exitApp();
}

Bridge.prototype.hFConsoleLog = function(success, error, text){
	cordova.exec(success, error, 'Bridge', 'consoleLog', [text]);
}

var bridge = new Bridge();
module.exports = bridge;

});
