(function(window) {
    /**
     * [比较两个SDK版本号的先后]
     * @param {[String]} sdkVer 
     * @param {[String]} funNeedVer 
     * @return {[Boolean]}
     */
    function ealierThan (sdkVer, funNeedVer) {
        if (sdkVer === funNeedVer) return true
        var sdkArr = sdkVer.split(".")
        var funNeedArr = funNeedVer.split(".")
        //分割后数组长度须为3
        while (sdkArr.length < 3) {
            sdkArr.push('0')
        }
        while (funNeedArr.length < 3) {
            funNeedArr.push('0')
        }
        var r
        for (var i = 0; i < 3; i++) {
            if (parseInt(sdkArr[i]) > parseInt(funNeedArr[i])) {
                r = true
                break
            } else if (parseInt(sdkArr[i]) < parseInt(funNeedArr[i])) {
                r = false
                break
            }
        }
        return r
    }

    var sdkVer = '', isYQB = '1'

    function checkApiAvailable(funNeedVer, funName, mustYQB) {
        if(mustYQB && isYQB !== '1') {
            return false
        }

        if(typeof window[funName+'_useflag'] === 'boolean') {
            return window[funName+'_useflag']
        }else {
            if(!sdkVer) {
                var appInfo = JSON.parse (WEBVIEW.pb_getAppInfo() || '{}')
                sdkVer = appInfo.sdkVersion || ''
                isYQB = appInfo.isYQB
            }
            

            window[funName+'_useflag'] =  ealierThan(sdkVer, funNeedVer) && (mustYQB ? isYQB === '1' : true)
            return window[funName+'_useflag']
        }
    }

    var ext = {
        pb_walletLog: function(string) {
            var funNeedVer = '3.3.0'

            if(!checkApiAvailable(funNeedVer, 'pb_walletLog', true)) return 

            if(!string || typeof string !== 'string') return

            window.Bridge.hFTransmit(function () {}, function () {}, ["pb_walletLog", [string]])
        },
        /**
         * [cat 日志上传]
         * @param  {[String]} type    [类型: 1: 表示时间耗能，content为一个时间差值, 2: 百分比的分子, content不传, 3: 百分比的分母，content不传]
         * @param  {[String]} eid     [日志名称]
         * @param  {[String]} content [上传内容]
         * @return {[null]}
         * 
         * |-----监听对象-----|------type-----|---------eid---------|-----content------|--------备注--------|
         * |拉起成功率        | 2             | CAT_PLUGIN_INVOKE    | 无                 | 需native补充分母  |
         * |启动执行js代码     | 1             | CAT_PLUGIN_WEBLOAD  | Numbe -> String    |                 |
         * |页面完全ready     | 1             | CAT_PLUGIN_WEBDONE   | Number -> String  |                  |
         * |错误日志          | 4             | CAT_PLUGIN_JSERROR   | String            |   
         * |提交支付接口       | 1             | CAT_PLUGIN_SUBMINTPAY| Number -> String  | v2接口时间
         * |拉起订单          | 1             | CAT_PLUGIN_READY     | Number -> String  |
         * |风控请求时间       | 1             | CAT_PLUGIN_POLICYPAY | Number -> String  |
         * |支付出错的数据     | 4             | CAT_PLUGIN_PAYERROR   | String           |不包括能处理的返回码|
         * |登录态异常        | 1              | CAT_PLUGIN_LOGINERROR |Number(1024) -> String|
         */
        pb_catReport: function(type, eid, content) {
            var funNeedVer = '3.3.0'

            if(!checkApiAvailable(funNeedVer, 'pb_catReport', true)) return 

            if(!type || !eid) return

            var params = {type: type+'', eid: eid, arg0: content+''}
            window.Bridge.hFTransmit(function () {}, function () {}, ["pb_catReport", [JSON.stringify(params)]])
        },
        pb_getMzoneToken: function() {
            var funNeedVer = '3.3.0'
            var timeoutId = null
            return new Promise(function(resolve, reject){
                if(!checkApiAvailable(funNeedVer, 'pb_getMzoneToken', true)) {
                    resolve()
                    return
                }
                var args = ['MA', 'plugin.1qianbao.com']
                window.Bridge.hFTransmit(function (data) {
                    clearTimeout(timeoutId)
                    resolve(data)
                }, function () {}, ["pb_getMzoneToken", args])

                timeoutId = setTimeout(function () {
                    resolve()
                }, 5000)
            })
        },
        pb_openPluginWithWalletLog: function(pluginId, businessParams, extraData, callbackName, hideBehind) {
            var funName = 'FUN_' + Date.now()
            var _t = this
            window[funName] = function(res) {
                _t.pb_walletLog(JSON.stringify({resultCode: res && res.resultCode, pluginId: pluginId, params: businessParams, status: 'close'}))
                if(typeof callbackName === 'function') {
                    callbackName(res)
                }else if(typeof callbackName === 'string') {
                    window[callbackName](res)
                } 
                window[funName] = null
            }
            WEBVIEW.pb_openPlugin(pluginId, businessParams, extraData, funName, hideBehind)
            var p = JSON.parse(businessParams || '{}')
            WEBVIEW.extend(p, {pluginId: pluginId, status: 'open'}, false)
            this.pb_walletLog(JSON.stringify(p))
        },
        pb_onPluginCallbackWithWalletLog: function(res) {
            this.pb_walletLog(JSON.stringify({exit:res}))
            WEBVIEW.pb_onPluginCallback(res)
        },
        pb_openVariousCashier : function (url, callback, frontEndUrl) {
            var funNeedVer = '1.6.6' 
            if (!checkApiAvailable(funNeedVer, 'pb_openVariousCashier', false)) {
                return false
            }

            var args = [];
            args[0] = url;
            args[1] = "window[\'" + callback + "\']";
            args[2] = frontEndUrl;
            Bridge.hFTransmit(function () {}, function () {}, ["pb_openVariousCashier", args]);
            return true
        },
        pb_callNativeAsyncFunc : function (pluginId, nativeFunName, isOpen, params, extraParams, callback) {
            if (!nativeFunName) {
                console.warn('PB_CALLNATIVEASYNCFUNC')
            }
            if (!callback) {
                callback = function (res) {}
            }
            var args = []
            args[0] = pluginId;
            args[1] = nativeFunName;
            args[2] = isOpen;
            args[3] = JSON.stringify(params || {});
            args[4] = JSON.stringify(extraParams || {});
            args[5] = "window[\'" + callback + "\']";

            return Bridge.hFTransmit(function () {}, function () {}, ["pb_callNativeFunction", args])
        }
    }

    window.nativeApiExt = ext
})(window);
