
var News = {};

News.showHtml = document.getElementById('showHtml');

// Initializations
News.callback = function() {
    window.location.href = "re-callback://" + encodeURI(RE.getHtml());
}

News.setShowHtml = function(contents){
    RE.showHtml.innerHTML = decodeURIComponent(contents.replace(/\+/g, '%20'));
}

News.setShowPadding = function(left, top, right, bottom) {
  News.showHtml.style.paddingLeft = left;
  News.showHtml.style.paddingTop = top;
  News.showHtml.style.paddingRight = right;
  News.showHtml.style.paddingBottom = bottom;
}

News.setBackgroundColor = function(color) {
    document.body.style.backgroundColor = color;
}

News.setHeight = function(size) {
    document.body.style.minHeight = size;
}

// 图片添加点击事件
News.setImageClick = function(){
    window.control.log('绑定图片点击监听');
    var objs = document.getElementsByTagName("img");
    for(var i=0;i<objs.length;i++){
        objs[i].onclick=function(){
            window.control.clickImage(this.src);
        }
    }
}

// 设置加载图片错误回调
News.setLoadImgError = function(){
    var imgs = document.getElementsByTagName("img");
    if(imgs==undefined){
        console.log("暂无图片");
        return;
    }
    console.log("遍历图片数量:"+imgs.length);
    if(imgs.length == 0){
        console.log();
        return;
    }
    for(var i=0;i<imgs.length;i++){
        var item = imgs[i];
        item.onerror = imgLoadError;
    }
}

//加载图片回调
function imgLoadError(){
    console.log('错误回调成功');
    var tagImg = event.srcElement;
    tagImg.src = 'error.png';
}


//滑动显示图片
News.scrollLoadItemImg = function(scrollTop,screenHeight){
    console.log("滑动:"+scrollTop+"  "+screenHeight);
    var imgs = document.getElementsByTagName("img");
    if(imgs==undefined){
        console.log("暂无图片");
        return;
    }
    console.log("遍历图片数量:"+imgs.length);
    if(imgs.length == 0){
        console.log();
        return;
    }
    for(var i=0;i<imgs.length;i++){
        var item = imgs[i];
        var top = item.offsetTop;
        var left = item.offsetLeft;

        console.log("遍历:"+i)
        if(window.app!=undefined){
            var tagUrl = parseQueryString(item.src);
            if(tagUrl==undefined){
                window.app.log("图片已经加载了:"+i);
            }else{
                //判断位置
                var startY = scrollTop;
                var endY = scrollTop + screenHeight/2;
                window.app.log(startY+"  "+endY+"  "+top);
                if(startY <= top && top <= endY){
                    item.src = tagUrl;
                    window.app.log(i+"位置加载图片:"+top+"  "+i);
                    //一次加载多张图片
                }else{
                    //window.app.log(i+"位置不加图片:"+top+"  "+i);
                    //停止遍历后面的
                    continue;
                }

            }
        }
    }
}

News.scrollLoadImg = function(){
    var imgs = document.getElementsByTagName("img");
    if(imgs==undefined){
        console.log("暂无图片");
        return;
    }
    console.log("遍历图片数量:"+imgs.length);
    if(imgs.length == 0){
        console.log();
        return;
    }
    for(var i=0;i<imgs.length;i++){
        var item = imgs[i];
        var top = item.offsetTop;
        var left = item.offsetLeft;
        if(window.app!=undefined){
            var tagUrl = parseQueryString(item.src);
            if(tagUrl==undefined){
                window.app.log("图片已经加载了:"+item.src);
            }else{
                window.app.log(i+"位置:"+top+"  "+left+" "+tagUrl);
                item.src = tagUrl;
            }
        }
    }
}

function parseQueryString(url){
    //用来匹配的key
    var key = "default_logo.png?mddImageUrl=";
    var start = url.indexOf(key);
    if(start<0){
        console.log("匹配失败")
        return undefined;
    }
    var str = url.substr(start+key.length);
    console.log(str);
    return str;
}
