(function () {
  var EFSJsBridge = window.EFSJsBridge || (window.EFSJsBridge = {});
  var JSBRIDGE_PROTOCOL = 'EFSJsBridge';

  var dyShareText = '{{dyShareText}}';
  var dyShareHostId = '{{dyShareHostId}}';
  var parseType = '{{parseType}}';
  var cp = '{{cp}}';
  var ci = '{{ci}}';
  var cv = '{{cv}}';
  var deviceId = '{{deviceId}}';
  var uid = '{{uid}}';
  var token = '{{token}}';
  var api_host = '{{api_host}}';
  var dy_account_id='{{dy_account_id}}';

  function _call(action, params) {
    var paramsStr = params || '';
    if (params && typeof params === 'object') {
      paramsStr = JSON.stringify(params);
    }

    var efsJsCall = EFSJsCall || window.EFSJsCall;
    if (efsJsCall) {
        EFSJsCall.invoke(action, paramsStr);
    } else {
        var url = JSBRIDGE_PROTOCOL + '://' + action + '?' + paramsStr;
        var iframe = document.createElement("iframe");
        iframe.src = url;
        iframe.style.display = 'none';
        document.body.appendChild(iframe);
        iframe.parentNode.removeChild(iframe);
        iframe = null;
    }

  }

  function getClipBoardData(){
    var efsJsCall = EFSJsCall || window.EFSJsCall;
    if (efsJsCall) {
            return EFSJsCall.getClipBoard();
        } else{
            return "";
        }
  }

  function saveImageToNativeTo(path){
      var efsJsCall = EFSJsCall || window.EFSJsCall;
          if (efsJsCall) {
                  return EFSJsCall.saveImageToNative(path);
              }
  }

  function _parseOpt(opt) {
    if (opt) {
      var keys = Object.keys(opt);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (opt.hasOwnProperty(key) && typeof opt[key] === 'function') {
          opt[key] = opt[key].toString();
        }
      }
    }
    return opt;
  }

  EFSJsBridge.Common = {
    toast: function (message) {
      _call('toast', {
        message: message,
      });
    },
    getDyShareText: function () {
      return dyShareText;
    },
    getWatermarkCrawlHostId: function() {
        return dyShareHostId;
    },
    getParseType: function () {
      return parseType;
    },
    onVideoUrlCrawled: function (url , image , text) {
      _call('onVideoUrlCrawled', {
        videoUrl: url,
        image : image ,
        text : text,
      });
    },
    redirectWithJsList: function (url, jsList) {
      _call('redirectWithJsList', {
        redirectUrl: url,
        jsList: jsList,
      });
    },
    onXhsResourcesCrawled: function (imageList, videoUrl, words, image , text) {
          _call('onXhsResourcesCrawled', {
            imageList: imageList,
            videoUrl: videoUrl,
            words: words,
            image : image ,
            text : text,
          });
    },
    onXhsResourcesCrawledFailed: function () {
       _call('onXhsResourcesCrawledFailed');
    },

    onDyImageUrlCrawled: function (imageList) {
          _call('onDyImageUrlCrawled', {
            imageList: imageList,
          });
    },
    onDyImageUrlFail: function () {
       _call('onDyImageUrlFail');
    },

    getClipBoard: function () {
          return getClipBoardData();
        },
     saveImageToNative:function(path){
        saveImageToNativeTo(path)
     },
    onVideoUrlFail: function () {
      _call('onVideoUrlFail');
    },
    onArticleCrawled: function (content) {
      _call('onArticleCrawled', {
        content: content,
      });
    },
    onArticleFail: function () {
      _call('onArticleFail');
    },
    onArticleSearchVideoSuccess: function (videos) {
          _call('onArticleSearchVideoSuccess', {
            videos: videos,
          });
        },
    onArticleSearchVideoFail: function () {
          _call('onArticleSearchVideoFail');
        },
    getUserInfo: function () {
      return {
        uid: uid,
        token: token,
        deviceId: deviceId
      };
    },
    getClientInfo: function () {
      return {
        api_host: api_host,
        cp: cp,
        cv: cv,
        ci: ci
      };
    },
    getDyAccountId: function () {
          return dy_account_id;
        },
    displayInfobar: function (type, info) {
      _call('infobar', {
        type: type,
        info: info
      });
    },

    navigateTo: function (type, data) {
      _call('navigateTo', {
        type: type,
        data: data,
      });
    },
    closeWindow: function () {
      _call('closeWindow');
    },

    dispatchEvent: function (eventName) {
      var event = new Event(eventName);
      document.dispatchEvent(event);
    },

    onScrolled: function (bottom) {
      _call('onScrolled', {
        bottom: bottom,
      });
    },

    onTouchStart: function () {
      _call('onTouchStart');
    },
    sendRequest: function (opt) {
      opt = _parseOpt(opt);
      _call('sendRequest', opt);
    },
    onEmojiCrawled: function (list) {
      _call('onEmojiCrawled', {
        list: list,
      });
    },
    encryptParams: function (opt) {
      opt = _parseOpt(opt);
      _call('encryptParams', opt);
    },
    onVerifyDyAccount: function (opt) {
        opt = _parseOpt(opt);
          _call('onVerifyDyAccount',opt);
        },
    onVerifyDyContent: function (opt) {
            opt = _parseOpt(opt);
              _call('onVerifyDyContent',opt);
            },
  };

  EFSJsBridge.Utils = {
    savePhoto: function (imgUrl, opt) {
      opt = _parseOpt(opt);
      _call('savePhoto', {
        imgUrl: imgUrl,
        opt: opt,
      });
    },

    showLargeImg: function(imgList, index) {
      _call('showLargeImg', {
        imgList: imgList,
        index: index,
      });
    },

    highUserPaySuccess: function (opt) {
      opt = _parseOpt(opt);
      _call('highUserPaySuccess', {
        opt: opt,
      });
    },

    cityLordUpgraded: function (opt) {
      opt = _parseOpt(opt);
      _call('cityLordUpgraded', {
        opt: opt,
      });
    },

    monthCardPaySuccess: function (opt) {
      opt = _parseOpt(opt);
      _call('monthCardPaySuccess', {
        opt: opt,
      });
    },

    downloadApp: function (opt) {
      opt = _parseOpt(opt);
      _call('downloadApp', opt);
    },

    saveToClipboard: function (text, opt) {
      opt = _parseOpt(opt);
      _call('saveToClipboard', {
        text: text,
        opt: opt,
      });
    },

    showShareMenu: function (info, opt) {
      opt = _parseOpt(opt);
      _call('showShareMenu', {
        info: info,
        opt: opt,
      });
    },

    shareWechat: function (info, opt) {
      opt = _parseOpt(opt);
      _call('shareWechat', {
        info: info,
        opt: opt,
      });
    },

    shareWechatMoment: function (info, opt) {
      opt = _parseOpt(opt);
      _call('shareWechatMoment', {
        info: info,
        opt: opt,
      });
    },

    openWxmini: function (wxmini, opt) {
      opt = _parseOpt(opt);
      _call('openWxmini', {
        wxmini: wxmini,
        opt: opt,
      });
    },
  };

  document.dispatchEvent(new Event('EFSJsBridgeReady'));
})();