/*
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

precision mediump float;
varying vec2 v_TexCoord;
uniform sampler2D sTexture;

uniform float u_whRatio;
uniform int u_isZoomed;
uniform float u_zoomValue;// [0,1], 0 - not zoomed, 1 - fully zoomed
uniform vec2 u_magnifierPosition;
uniform vec2 u_zoomPosition;// [0,1]x[0,1]
uniform float u_zoomAreaR;
uniform float u_zoomMax;
uniform float u_offset;


void main() {
    if (u_isZoomed > 0) {
        mediump vec2 dr = (v_TexCoord - u_magnifierPosition);
        float d = length(dr * vec2(u_whRatio, 1.0));

        if (d < u_zoomAreaR && d >= 0.98 * u_zoomAreaR) {
            gl_FragColor = vec4(0, 0, 0, 1);
        } else if (d < u_zoomAreaR) {
            if ((abs(dr.x * u_whRatio) < 0.01 * u_zoomAreaR && abs(dr.y) < 0.25 * u_zoomAreaR) || (abs(dr.y) < 0.01 * u_zoomAreaR && abs(dr.x * u_whRatio) < 0.25 * u_zoomAreaR)) {
                gl_FragColor = vec4(1, 1, 1, 1);
            } else {
                gl_FragColor =  vec4(0, 0, 0, 0);
            }
        } else {
            gl_FragColor = texture2D(sTexture, v_TexCoord);
        }
    } else {
        gl_FragColor = texture2D(sTexture, v_TexCoord);
    }
}