/*
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#extension GL_OES_EGL_image_external : require

precision mediump float;
varying vec2 v_TexCoord;
uniform samplerExternalOES sTexture;


const float M_PI_2 = 1.5707963267948966192313216916398;
const float M_2_PI = 0.63661977236758134307553505349006;

uniform float u_whRatio;
uniform int u_isZoomed;
uniform float u_zoomValue;// [0,1], 0 - not zoomed, 1 - fully zoomed
uniform vec2 u_magnifierPosition;
uniform vec2 u_zoomPosition;// [0,1]ox[0,1]
uniform float u_zoomAreaR;
uniform float u_zoomMax;
uniform float u_offset;

void main() {
    if (u_isZoomed > 0) {
        mediump vec2 dr = (v_TexCoord - u_magnifierPosition);
        float d = length(dr * vec2(1.0, u_whRatio));

        if (d < u_zoomAreaR) {
            float t = d / u_zoomAreaR;
            if (t < 0.85) {
                gl_FragColor = texture2D(sTexture, u_zoomPosition + dr / u_zoomMax);
            } else {
                t = 1.0 - asin(pow((t - 0.85) / 0.15, 4.0)) * M_2_PI;
                gl_FragColor = texture2D(sTexture, u_zoomPosition + dr / (1.0 + t * (u_zoomMax - 1.0)));
            }
        } else {
            gl_FragColor = texture2D(sTexture, v_TexCoord);
        }
    } else {
        gl_FragColor = texture2D(sTexture, v_TexCoord);
    }
}
