var h5d = h5d || Object.create(null);


document.documentElement.style.fontSize = window.innerWidth * 100 / 375 + "px";


(function () {

    var dom = document.createElement('style'),
        text = '*{box-sizing:border-box}.h5c-host{position:relative;padding:.1rem;min-height:.5rem;background-color:#fff;line-height:1.6em;font:.16rem "Lucida Grande","Helvetica Neue",Helvetica,"Microsoft YaHei","Apple Color Emoji","Segoe UI Symbol",Arial,sans-serif}.h5c-host>*{display:block;margin:.02rem 0;width:100%}.h5c-block{position:relative;display:block;padding:.02rem;width:100%}.h5c-row{position:relative;display:-webkit-flex;display:flex;justify-content:space-between;align-items:stretch}.h5c-row>*{display:-webkit-flex;display:flex}.h5c-cell{padding:.04rem;align-items:center;align-content:center;flex-grow:1}.h5c-space-x,.h5c-space-y{flex-shrink:0}.h5c-block{padding:.04rem}.h5c-vertical-lr .h5c-text,.h5c-vertical-lr.h5c-text,.h5c-vertical-rl .h5c-vertical-lr .h5c-text,.h5c-vertical-rl .h5c-vertical-rl .h5c-vertical-lr .h5c-text{writing-mode:vertical-lr;text-orientation:upright}.h5c-vertical-lr .h5c-vertical-lr .h5c-vertical-rl .h5c-text,.h5c-vertical-lr .h5c-vertical-rl .h5c-text,.h5c-vertical-rl .h5c-text,.h5c-vertical-rl.h5c-text{writing-mode:vertical-rl;text-orientation:upright}.h5c-image{width:100%}.h5c-icon{background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAoAAAABQCAYAAAH+a/SzAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAKLZJREFUeNpi/P//P8MoIB+wjHD/ywExGxD/AuJHRKhXgdIvgPjLSA9AFTkF1X4Y59GD24VA6g4utZMmTxPv6e2vQFfPOEKzMErgEQhERk1t/Wlfv36TwaaeCZcNlmYmEvhcAJSHYZEhFnjysMA7k2DiAQogeH6GiMujqVeGBd7lnnw3ZPXAgC1mwhE4/4+fOvOCGNcA1b0hpOby5ctEJfP+/n6i1C1ZsoQodWvXrl2MRZgVxvj38gXD7UAFbyD2wSaPDjguHGT7//8vEzDXgsMNFLBMWAJPHBgojEB6LQH3iULVzyHkEV1dXUZiPFxYWEiUupiYGKLUBQcHx2IR/g1j/H3+hsF7060LKuvub8Mmjw7+vXuHwufm5no6WgYSVwZOB6Y2aWj2/U9UGTjMwR1oYBEKPBD4f/3qxZ70tJQe9MAbybUwvEKBlnmgbPuQnHYgQAAxjvZERnsiFJWFsCxNhFoeIJZAVz9SAxCjEiHUE0FWX1Jc2JGXm/VypJaBWGtgPIGIVT2wCfMEWLlkMaG1AdmJdQWsJzKUwb2GKB9CakC9DRibjZmR6VpfkQesEQ3qpaA3Y0yAgaIKxB+B+AyewHOGVultQPZZfA64ffv2TyYmJmFCDl2xYsUvoDoLQuq8vLwsgOqECKm7devW//3798/Ep+bvxWOgnojPnURTnAGJ1AdmFGVj4mU5sB6l2CM7C8NSH7DXMmSz8CVjTh+tk593s7Cw/MSVhYEpcAasES3NxsC3z1zQVv3w+y0w9aNlIOllILg3AurGAcvAzJHYE8HohRCohdHV/wf1SkC9ExB7pDekKW4HAgTQaE9kFIz25EbBgJRaeKsJMs0WB2JeAmo+A/HL0QQ4QhMergYclvYIKQkRbLa8olo3sEbFm6YYGRn/PLx/qxRmPsEqGNjdAM06rwbiLiCeC+x2aFASCtDuyzEgrgPi6UDzVEfTxsD1HIhIiHeolbCxJXImAollHTCBgJY8FIASISzxAcUnkJn4jsCYQLwHiDdAxWdQErrATPSbiYmJEYipElu3b9/+v2PHjv+urq5S1DAP5K5fv37VU8t9IHMePnw49fLly5bkVrmnw7Q87sTp+4Dw3aoQHwakuW5Sq2wsiY/xTrK5jwwXC9////+Yb4dr+cCmgdH1EKqCtaH0cyDORxLfT2bYoa+M+Aql91ISIczMzOEMaLONlAB1dXUFIKUDxG+oVAKJcXBwvALSHED8gxoGrl279n5JScnzf//+kaX/77PnDH/ZmMHsnw8fM0gz/xZ79IvxPTMzyy9quO/fxw8M///9ZQRFyb9373FXycT0goEl1GQgZQXEjcBScBMVquDZQGwIqtaB5q0arSHpXwX/+fOHHZQ4gAnuN7Bd9o/KVTDj798/OZmYmEE1078/v39zsLCyfUe2B1YFjw7DjHZC6N0J+QvshJQQ3QkZBaPDMCQA0EAzDwE1oKUwL0iqgkfBKKAVAAjAzvW8NhFE4UmyaTx5sIinEjEFI9QopBRF9ODJYhAxCl5iQVA8ebLxD+glF0/9C4qHoEQRctFDaqEHiyRUUFuD/aFFSA6JNG1t0mS363vprC7b3WZ/TCjtzgfDhO3OazLz7Zt5s98bTkCOfYWXdwHHfoK/CXEn1MIABf+kygygpM0pMEyf41Owu2D5XW23AxxOQJdFv9o8UzVUam87kXDHbR697R1OQBeRz45YgBX5jEjIg5DDj/Y7Xswu6EQ+BN6jykTwsCSf5r5+U0HIxaHBt1ChWCAE5deHj/kXTnoD7KGy5jX9Ap/AXpZzpKvAcSN6JxQYQXVvyIwXtKqEwfvNqmHyQJBrUN5AeYbkg2sTDshXhOoOlDSUMShZuPacc6S7UOdWUS/nWXx0KTZ+/8ZZs20MEDTyuvPjT9v5Wy8fXB96eCHcZ9R+TwIC4QYpcWQovfTaiN2OgLan6cd7hCpX4FrCaQdXq9VXDKVORwuFglwsFmUWNtFGuVw+6WX0BdFMOp0Or6ysPLbh0RQKeuXNDTIs/gwujJyPjd2+Gu7cRhe6p3FIkiT4ZycFzJk5U/tx/BxZO2HU3kqnVBg+lJhOL7EyViqVbiWTSVaetG9qaorMzMyYXQN1XIPlcrnlbDbL6veGo9HofKVSGXZiRF6v7ZS1VXJXWur/Hg/FkDDMRrjRIO34tl4npLlleJtgwXt5qDc8BZ+XHH69DdW0fAzs/XZiLBKJoG5xLpVKsei64ujoKE4fy4SNvlBOJBJxqMt2tXsafIPfOxCLxXozmYxtI9u1/3vOs9U/JJ5fnRSEHgiC2Wgq5XqD1nUiN5v2CAjkmAZyXFbIp/JedteA6FYwfTqr+t941pEjAsLAzrF6cMGWCNU7hvYIDbpY2vtqpQ0m4dLsZpUH3CSfaw1y80v9vdcnbPn9AUn9wGEbkzOZX5+A9Z0aPWHLkDItMzkhmEePiuV1IOIVpx1I15LT2JdQBg5gavtBw65tEpTHi2LziNcrNH0+n6Tn6S1oAneJXXENuC2JAX9PYFMUWwHcblbS/zX2uR7QBcDZKwRR7ROtF9zLY9LM+0UTyxCjfUAlRUKZPWU9cvON6MOP9sAjofAtR0e2ejwSJR8xuQZe0JCKaNrKRuRrR/V8fFyB9mDjKzZ62qEu8G9qubxV+3pnnnSa1vkU7C5YlszbWW+aISsnoLvRbT1gUBMdGx6jygnIsa/4KwB71xvaRhnG3ze31FyrLUUYW3EfJqxu+yDin4KTMVeYf7ZA2w1EtH6qE6z9UnTt/DMZsxtunQycKHSIIIVhZZb1Q0c30MHWwqyWEXVZZ2yprWtqV9M0Sa/pkjufJ7mU7GzSJjmTy+X5wZvL/em9v96998vz3Pu+z0MNkEAgFCzICSYQCAULmhNHIJjcy2PRkGD3pfG32Hk6wXQK+WVE7uQCEwjmxH96BL7rPl/2/gcfNgQC84mGp+MggPGjbUe+3FtX411mt8ts3EkACQQTC98jWx5tkSRpfbonE0VxctjpOJElIcw6dxJAAsEcuCfiymriD6Tki94bqwCRSfQWw3CnThACIf+xISYgpz/7fC2OS9dTQBB4Pjwvnl/d9IBab15zz8gCfLrqSTwJJhF5KsH+7bD4CPY/m4tWAfWXw+IalMoEhyC/j4HfM/QMEfIUS4M6z53rLmt+u+VwMmOo/aUdW8oeXGt944tvHSzNzo1Tn5w4vG9fXew9WyYDSFPhrgu03DPJFHwRhOM5zbbNsO3mMse2w+IY7PNkUfy6ob66uHzaOMkcszLhhJwn1HcBXpwOCsccg+8nM50Yb1Zg9imPx3PcZrMdwPYCLsWPoihidiZZp0n2hPSx9N5speBQmK3qp9ce31Vus6oWFme84mHWPeIdfafzwo1UBFEz78f1f3OP8f99/7YXBc5Y9dmfL4/57wYwvtFvrz6228YVdnHsn8k3r4wPQftUVss9Exf4tEZwMNegU41fhGV/bB8IC/rf32e5YZzVrF9g0YBcTLUKW+P4vceieRNzBhCY4NTUFNxPJeR0Oveg6BjoIdvU399/oKOjg2HUk76+vqrGxsbdTJ+QOXoINJb7R0ZGFEzvNzs7K8G6YYZ4ARer2+3Gl/FKT09P5+Dg4DcDAwNnckLGD8aa36eWOabcus5qQ6MbXS9v3uN6Zav9j9Y6+6Ga7ZuMcm/jrVdZViw8dJcpwSALhWUharzJXFmQFIwAoywu8lR5Z9JIMMBafEjJ+Ip/BVHR3mB/th/aFI8P5/LuulwuAR6MyaampoOqQOuWclEHeO12e0N9fX1DcXGxWFtb+xVs+8VA/PBaVXZ1dU0IgvBQb2/vp7COgWT+Ngi/koqKih+am5u3VVdXW6enp32lpaVCLojIvjkmBxNXvXBngG2dma9cb5Xv3F7k3kTZA3MFjDDE0OuI81wjYa/wSzCYesPJwAXGvKh/gdBdXcWxo3DcxmxeKKizBhYzUK7GiX0o7oGJRcXMCb88c4Fj18yqeg0YZC3yYBjBBVb54UcJiw6axR/bIHBTDHT9YtcQk6bg5GhFJ34pucDXqkp3lRcJS4bPIlC46ZVYy/D80C1J9nKLELJwHuYWSziZK5kDF5hjpCvX3srn4QvbeWnsysSCPAct0OLYue4FG3jzl9wB91s3AkMriXY897QtwFiAchCPr2FxG9YPagQIOx4wqPmOXIgL1Hle5dHJogEmD8W3BSiRDhLYbyfxW8FqiIqcogqfUfnhh08tRuQXu4ZBnU+PnRCRjgR8wb9SR8KEJxAeDctr2v5cdFyX2AwIXYhzS9hiWSNbi7iyGqse69HUnxXuiIDPzwRFBssNCo8agkFpgQvwG1OihItS5U7jAAmE/McG1fKNDCVpP3nq3SQeH8f3ZmCXKqqFl5IAaBJooZiPZ4l7JJYq/JigOQ26HbFQ0RfmsE3AvjkwtGXOBTnR/7QcdxJAAsEcoIHQaXAnASQQzAXtdLJWSZLWpXsyURTdw07Hcc1ml1m4kwASCAUghAg1oMDrydKuYUaEo21Hzhg0GILu3EkACQRzg8JhJauABJBAIBQqKBgCgUAoWPwrAHvXAxTFdcbf7R1XNUQINn86ZBjbKQVtxAyTioptU2sMToKdzqRjxyFqnHTiZLBCKh07aUbSRIxDgsaMnTZpE01J0umM4zRmgo6pSoU4UiRwKAdEEK6ggEDuEIG729vt993tXZfLHveH+7t8v5lv3u3bd29/t/feb7/3Z98jD5BAIJAHSCAQCCSABAKBQAJIIBAI6gbtCkcgzJ26jivkLPSTbgwM18Xk5wJ3GgQhENQNz6rLIWA2qz0nBHcSQAJBncCVUTLClJeJRXcloKhxJwEkENSHNMmmYcMTP1t79Wrbk8z3qsni0iXZn5yqOam0evuoZKriTgJIIKgLuI/uXfKInIcfec5stmQHk0lqaorR0Nz4tlf0HbCbauJOo8AEgnpwn1xA3NtMBisgCPjOEq+tJJmU931q4k4eIIGgDuB6eve7DzYXbc2tq/v86XBkvGbN6r99WH2sSRaFa+ndVgN38gAJBHXAIyA7f136vXAJCALzKt5ZmqV0rUTnTh4ggZD4wBFT534Y/f39ulX5j1ZG4iIX68+Xpaenu+fY4ciqKdG5kwASCIkPzwKi4V5Ofpq3pNE4eq937pZFXUt07rO+2KoVjzwFwatgf2WuzcXvBdsitesLLzY0TsWyZAC/H0HwLtg/wM4x125wz0lPAeTHU/0hJDA8Hft7y1/JiJSAICBvLV7j5fKXTLJrDyUy91l5gCAuZyDYByJy3sf5egiehvPdMRK/ExDgJt4f+0jyH7BfAL8eqkeERPf+MhZnVjHf8+ScjpDhzbLHnnrt3frOmyMTLLSVnkVTz5cvhMkLDIZ7WHTQm3vIgyAgLujxbfclfs52d0NjPgTVkHZ+DMSvAoI9M4gf4gdgH0HaeVSPCCrAjOInig7uLmO9vmZT7k++fKN4w+Jvps4PQXQ0MeDuxPZVSx80vrWn4ETxz/Pc6ZO0Gq7t4G8KWvc/vz6APL52ngtRXFIhuA0C919ZXDLYPQoiuBqCT6MsfihoGXDtDikK/+g10mct2EYZv1UQnKW6owyO49CSeJ4XJycnRbvdLlZVVaVhPCHmSHZ/2Lrt2eX+EguCyIm8nYnjZqYxXuI+25z70/bXdhQ8kJIc1J4b2575VY4Sh0hyx/2MV9zN369vrdVljffd69rfmGnSkrh5+sv/0ukN/9aLosAFyz3UUvwiCEeJV1wD2CiIz0sK6QejXDBKgF+R7Pj3YBekzz8E+6eX+HfFWGQeFATB1tTUlCMJTjxVMm1fX9+n165dY4cPH2ZdXV2sqKgIH3xxs5KQdM80Vqt1t8ViycXP8XQP3fzGx8cbIVw0NDT0Ohcegp69dA2tV3ID8rJsNuYx8wjTtV3U1m/Ofazt1WcLFiXP1wdy0eaWljwlDpHmLgqCRnQ4GJprc3eRCSB6KOoaiEOB9+cFenMP9U9YqxDnHkz4A4jgAJhWdu5YlMvcJq9jmwJPOd6JcR1Ju3XrVlJubm7L6OjohY6Oju/EkQB+o7u7O6uzs5PduHGDYdje3r5gFk/+iIg03LcOk8lUCffx8pEjR+Lp/jHg9Dt8iIBAL9u1a1c+PEyWQfSiMGTt6bqxWMyB/Wab9WsmfjXE9FfqdA2/XL6+de/WxxfO0yfNlMXY2O10efmIFnen8PFQfR08eIQuoRMFCDHObg/oot7cQ32Ka/2cx8mG30dxd5eBKJe5e4JM3xsHlcRpvb292WfOnPnxoUOHuuNFXMrLyw9v3LixMisri4EYsuHh4b8HUAaiiQUNDQ3fBc/K3VzC/iB8F9QRD+TMZnO5w+HQgwBiLU2GUAxTX5rnP+B5R0APJNE6NcO5ATZvZCCpadNDj3/cNdzzQp3pKlMYKOF5PkV2qIsWd+YQnAIo8nIfRmQiiJ+I5wKAN/dQPcARRff6/9gCTVCD7HhFlMucIcj0j8a6kkDlFUtLS6sLCwvXQ1PzwzgSl6mzZ8/WV1ZWHgTvr726uvr9iooKHFmfiCOOOrh3vx0cHGRgluLiYkMccWOZmZkr8/Lynh8ZGdGdPn26X6vVhmsgwSPwOp02oHX7xCnrjNY3Msaqzrfe3FV7vcPnzdbpLH5aVJHhjs1fp7fHy+SPuY75wGh4cw9VvSuhibsERM4oi8MpJfh4WQPxVq/0O8H+GMUyh/yygUe7dCy/wXb5vZPwYgya6dOchHXr1uF8ys+Ya1XbeALeryv9/f08CHMtfB4GM0r/dbzgjtFoPFdWVrYD7yVYD3YSxRG/LywWS9uBAwew+6C/pKRkP7b8wvFwYtICAikpqd0gsDn+PUDlpuKNCRs70Td+q7Jr4ioINM9xnM8pMgsX3t0vO7RGizvDJrAdPUDZb4C2MIqiKATm7HtzD0kAQVhOgcBch4/flsVtV0oL6bDTsSKapQ24XIDr4tI335Ki3gA7KH2+xFyv3ogSP5yL9FYsa4cgCDg508TiF/jy+BdgrdIT38FCm0MWKdgkbj0Sv/E44+esbMePH8epY0Jzc3N3mAT6tltEcpY91HTufK1/EfESwIFJOzs5cGd033WrQctxDvCQUPwEjYYTfN3Dh5cvv+TFITrcBcElfnbeu13rPBcIvLnPZiRvNYjHSRCbQl8J4Dy+FfImpFkZgwKXC9evgXCD+/YpeIHYmV8D/DIZwZc4y5s6fBxztPnomomnexjuVZU9LZtjR//SkrHYfzEWba6iPzjFs5qhSfPLJnsLCB8PwucA4XPMJHxuHH3vHYMSh0hzx8EPV3N3ugfo7BcMUAC9uYc8FA+igR7WDvQEwbIUxG8fBIdiJH5ufuiVoqearpAEZ4QfJ/EjqAh+vV7jVxOs2jRmWdk4VvtKn+MyCJ9Vq9PZoNlrB/ELxLMXY8V9gSjo7SDgU+DFajSu9NiZOgFxk3Y+pGuEZTEEEDv0AndLLi16lXVge0FcYv5EBm4Y4FLa+yTPDydFN0sCOAgcqdoQEhn4TqtztzR81/W9o++X+kincTgcWlFwOKe4aMDbc3l8GgFlINCLPbNty0HZ+7TYXz0UBe44ss8B/yTgr0PukmALEKcTBN75mzjOKeQ+RVyJO60GQyAkPuQrqryOL/77EBGcPOxs9QUrfNJ3Ir0ajE/uTHqVD1q6nPNHaNFbRfkSIU7A74iuvkuNEAx3ep+JQEh8ePoWP687t2cGAROxmetq6mqC9ny88rZFkzsKnEajFZwj1E4vz8UfBQ/j0PPzJX4zcScBJBASH54ZBLjoZ+GTT/w53BeAPN+WLSg67ZpR5C7KTCk+aO7UBCYQ1IGI7auRn7/6g48+OCbvLE+YPUH8cScPkEBQB7BSeybR40ZAZbtL9882U8zDS0DGwix+MeVOHiCBoC4o7a27w2y2ZAWTSWpqSoehufFPXtGx2Bc4otxJAAkE9SFNsmko2FC4ts3YjlPCfL2LLC5dkv3JqZqTSutjjkqmKu4kgASCOoGve2aEKS8cNLCpkTsJIIGgbuBSUw+E+N0BFvqrbgnBnQSQQJgb0ElNy4V+0o1JzUV+LnAnASQQCHMWNA2GQCCQABIIBMJcw/8EaO9coKOqzj2+z8zkrRICCegVCKIg0itVot4qq40QRAQqD29FAwWEqve21vbWVmpxEWrB27uw1NJ6WVhRRCyuopWHLywQKmgVUakJkAJ5AHkwJGEmyWQmM3Pm9Pvm7MgEzkxek5nJ5P9b61tn5uxzzsx8c87Z//Ptvb+NR2AAAAAAADwBAwAAAAAACEAAAAAAABA3WOACAAAAIG7h+SJ4IqwkoQ+yt0gLnHtCleaRxpN2O+U6EKd+hwAEAAAAej88xz0nD+Hs6koXxIpZCpVQ8Fh7TjDSDHf3fr9DAAIAAAC9U3gM7IB4CCeXibYJmTjNZm0fE4Rx43cIQAAAAKB3wFGmTNGJ/vt7Cvemvrxx09XlZeVD7A2NWQ6HI9PjcV+qqr40TdMUnincbDY5EhISm1JSkmvT+6Vbh1+VXfHdefnHb8/9VnsCg0XQFfI1z8h9VoR/ujT4vYf8jjQwAAAAQGyTJdpPhS6WFTw1dNu2HZPqz50bwyIjXB/OYiWjf//ib3972vvLC5482YFduMnSCr/Htt8hAAEAAIDY5KI5sgMpL6+wLHzge5NLy8pzqS6PWIseCRPv8OzsvS+9+Py72dnDQs2909NziMPv3fA7BCAAAAAQW2RIM+QHj/x41Ftvv7NAVdXkaH9Rs9ncMvWuKS/+fs3qkhCb1UuD32PI7xCAAAAAQGyQQDZEBOlrdv/c+eP27fswX3R+tGkk0MaPv3XTq69sOBiknPuqnRJ6uhP4PQb8jkTQAAAAQPTh0aXDjOrldc+/MHD4iGufJhEyN0ZFCKPw9+Pvyd/XoNwkf18q/B4bfkcEEAAAAIgunEdusFFB7u13TCstK5vY237QVcOH7yrcs3NHkOIaoee1g9+j6PeYEYDfuDknnRY3kbHDxwm9Hd4kVTdnxbaRfUb2PtmBjz759BzuGX6/BT7FXEM2hexGshFk/WUZ/+FlZF+QvUdWJPTRQoL8CCcCAED04MEGlxsVXP/1nIdsNvu1vfWHpaf3K/nHF5+uDVLMgxQc8Hv0/B5VAUjihYdYryCbRLaNbD0Jki/a2effabGQbCZZIdkTtE91X7xrkC/4BF5KNk/6gv/wfe3sdj3Z98hmkL0r/XcW92AAAIg4PII026jghhtvWVRXX/+1MHxGa9NlVCr7ARkZRZ9/9vELQYrLybxx6veo0hG/R0UASuG3SZ6Qi0iAnOricTgR4vNCD+PO6StCkH43J6XcIPR2fe6YerSLh+LQ98tCT3I5m/xXhfsxAABEDMM8c3dOmT7h8JGj07sj+jgfXdFD4yelZQ5OEMmpQk1N9/316OnK/9taeKzMes4ZSVF43ehrt7/7zvbdBkXRyhfYU343Et6BaGHYNmx+j7gAJPEyixbPkC0kwVEYpmOOp8VGoUez/hTn4i+XFpvJHqTfui2gCbhLcBMwHYOb3t8k+ym9fxX3ZNAZTCZT4E3MZLfbp6akpPwXrR/p8/nqvV7vG9u3b19z7733OgJvalQG54G+jGEUavuOty79/g9+tFx0fdCBX/zR9WX6bOFNef2TEy1tdEZKmlDSM4U3Ld33dvGpk89s/9vx0/UNLT0sBrUNL/1xaZAZLspFZKOAPeX3Nv7/y6yxt4wdmjVAeD1CmOkjW1wib/PB3WV2p5M3kW5RLk9LTPrgP8fmiaRkIdz0N5jM4lBlbd2sd459zImgu/m/hPR7REcBk9CYTIunyaYHE3+0TSLZ02RWsjeluGtPxHCzJx97GW1/VxyLP+4buV76b5vBJvfJk4WnhLk1YP1osipZ9vCFJzgd6wAtbiZbQZ8xpQ8LmWSXy/X2qVOnFtBrCwsbIwOGT68JX3755d0NDQ3e5ubmrbW1tXdardaraJljs9lW5uXlNdL7dbRdsojd0XSgFz+EBNry5cstZWVlY+n8m8bXcmVl5ZVHjx4dQOtNMXQN9zNa+ZvfPPvN7l8jPBuFZhIeEh8ed4CRwGioF9rJEmE+8rFpurk6u/C+G/JOLP3O1MMrH5zy6/vuGJ11aWpSD1yjyrKCp4INqEiPH7+fF99nmpwezdHkF36iuUm4XC3C41XNVN46toG3NXlpHZVpotEuNJdT+ByNoqbB6eFjyFlFlJ7ye6SvhJ+RrSPBURRim+EscIQ+797dZB+QKNHIdpLdHkIE/pMWz8nPiFd+TrZJCjYjRsklN4kPC1g/QOghb2ao0QlFx6ykxa+lQO+rjHC73RMGDRr0Il18HhIyNVSJ/GTcuHEJqGJDwv7JNJvNa4qKisSJEyfEihUrxMyZM0V+fr4oLS0VR44cEdXV1YtXrVrFN9kUiEBDAaOQmemcm+DxeBrpYURj81INUV9f/4h8KFHwEBK6wlu9evWgxYsXb83Ozj546NChGbNmzbqB/LdUVdW1CxYs4C5DaTHyXQ3ToVRV14wJ2ye43XpUKZixOLHVCq2sWCQW7zfPNleN+Oj+GyadWDJratEvF05ePjt3VP/UpIRwXK9nzliv64wferXfWdypPqGpqm5erxCqV2iaz6THYc4bi0DN69G3YfPIZZjukaH8bomw41mI/L2dbXzSLoQHikwiEVhLy1wSLMVGOpBsfhzf3Li99/9DPfZ18/g7yR7sw5WHuampSamrq2t9P8hisaw6cODAKhKGtsbGxsLMzEzuc9ksQCAcMcj4/PPPj5E4uZKEs8jLyxPTp+tdaUpKSgT5UaSnp9uWLFnSJG/ALhGlTukxTGJBQcFoh8Oxa//+/W304SWXXPK73bt3uyZMmMB9p53w3UVkkVA+Teef/2GtsrJSnD171kPCLzE1NfXfqGxoQ0NDgtVqbZAPyI5Y+L+NVpLozwrbJ7SQyFPUTu1CTx1C1J3hUH1Cvtl0zdw5Y68RGYOFI+Uy958+KSl9dvfBsmaPv/9Gp85Buof2D1JkiTu/+5UMuYjEn+Budhq99qp+j9Fbv7BTAofmsOgzKSwQhb9bnqqG7WuE8nukHc+/amA39ufKg/sPHgtSzqHkeH48tosQ09SESaAniz4MVRp0z2zxv6aK2L1z587ijRs37qiqquIURP9E5Crode3Mz89/9p577jk9ceLEOcePH0/weDw8XZFIS0sTNTU1H69cufI5n8/H17AHAubiiAELYxKA5iFDhhRTZTSGzj9/ZZCUlCSysrLsjz32WKnQB2y1SJ+D8/SbPXv2GhJ5I0aOHHnFokWLckj4KQkJCWYSfwqtdyiKcmlycrK5L517mqdFaEr3utdpzmbhrD4tap3uxJvc6qhJAxPcb1a5Tiu6gsF1HPSuqPojeSzqWPVpXikGL4racJlHaCQAhU9XiCJC/aMjLQD3CD1CtzXU+XbB9+KnXR7g8Yxs5g0FH/vDOD6leKAG9+H7cwf+z8DXLIrN8rU5hIh5QOi5AvvsJXv48OEze/fuPfnaa69ts9vtPLUOz7PIaXLcuNkFhaN5Z/iZd8uWLQ1kPOosUz5McO3DOTt5pD/noqyWD3Lw5cWwMG4k8bKUKteRY4hEgs7JoyQIW8/DFvjOkBNbt259gqM7e/bsGbx///68efPmPZCTk5O8efPm0hkzZnCmhMHr16/fJqKTdsQwOCP06HkbSKRanU7n5WERgC4SFl0QEy7VJ+pcXmF1usXfzrqsb1S7yk+6fE2KYlLJfF3phkCncrDcvd5487vf9/6mXw939NOFnVcNrnhkBNAvFDkKqIbPJaH8HmkB+Cuy179xcw6LuZ8YbUDrj1P5BHrJeXhKOpoihvbhfILcv21mHN/kVpHdRr/1D+SX7xuUr5MRAv7DAweJcJ/BH5NxX4AXjKIHdEwu54Ejk/twJVKan59/k7whNcobBWgfrmEc8mGNheCXQm/mTZDnmkuWu6RvIWCMq4FmKZTtmqaVFBUVFcqHtyZ5TdukDzF82vgcbJHWRL6rfvzxx9+VD7u2OXPmrJavHXKbWKDZSIhccfng4hOlZeERgG43nVjmdrdrUTVR3+IVZ0gw/r3eXff6GXfZMYfaZFIUjR5GfMIv+iw+RREaC8CujE4dNCjrcAg/xJXf9XCCqgu7VlEXJALojwFypNAvAPVoYTibgEP5PaICkESLjYTGNHq5lpYcqZtF62oMtuN1NR0Uftxs+brcfgrt64jXOxz9tkY5yvk5Wn5Cy6kyKtAKVx4/MtiVK+bfBvEfR2m2CL1fRG5fnmHF5/M5pa9A5/zWKmBUeXNFH8muixinFHlWKViUAMEH4Rz6HAwU000iNqYaCwV36bmof9ajjz7ywQ8f/Z+JIgzdTbQWj94EeQFunybOub3C6vKKT+yec29YveWHm332QMFnsZDgE/TexGLPv17rxnmoLS94cleQMlu8+b1VAHIE8KtmXX8EUDN+9POejwDqAjBsz3gh/R7pCCCLGL7BzSfhcTUt/yzz2P2M1n/UmePQfv9Bi/+VSn4B7V/SF2509Ds5KrWYfj9P9bZDRlR+SHawk4fiaeO4PyWPHL6fjntQAABiRcBA8MU/fO/mQSltEhLPuHt6w9q163aEIyGxP7JEus3Lgs+j+gXfwUav7S+1asWhZs1m8os9hSN6LPhY6PlM4RF8bbhu9LU7guSiaxCRbwLucb8zZp+qKCz6fOcHdigGnlSEXxwqmlkKQMGyWwuLCG3P71GfC5iEDKeEmM2ihmyQ0PugcV6/42R18uTjKB8LxtuEPs8tR73+SLaFhEufjjbICN49ZA+RXSF9x9FVHiV9WkYPOKzNzb+3kOXKJ2OeSeRl8p8d92EAAIgKPTElmcLpRjiP3G1pWtZ1yVrWgSat9lOHdo4jfK2CTxd4gYKP69rwD+zoY1PBteYBNN89OOnKyQMtnAzfxB5tVEXDsmPOg15FeLgZ3e9oTTOZNJ+lIDvhxnQTD2LVOBDo22XTjr1e6ztlMnGfy64lg47ZqeAAAAAA4CdNPqRfxPVfz3nYZrOP6oIIYc1AIpCTDmsBCUcUracFXyDp6f1K/vHFp2uDFPOAMEcc+V1IUafovvcncm5N+sxxPV14m77qQ+nfVpPbaUJrHVnjb4Yn8ecTQvEFRGLD7ncIQAAAACC6cG7CwUYFubffMa20rGxiF46ptNV2X7UqRqTSv2r48F2Fe3buCFLMffab4tTvgdqqTVOugehW9GTQF/U71LqaZqczfkdKeQAAACC6cKVcZVTAlfnSXyxZYTabXZ08pqbPOdtqorvzynYI/p6/eOLxlSFESJWInQE6PeH3VgGnKeeb2/0W8D+0+Y8u3K4rzb5d8TsigAAAAEBswKmThoggwZn7584ft2/fhzwbUSwmpNfGj79106uvbAg2oJD7vXGmCg/8Hht+hwAEAAAAYosMEWLWp4f/+5HR7733/nxVVZOi/UVNJlPLnXfesWHtc2uOhNisXhr8HkN+hwAEAAAAYhMepJAWrLC8vMLy3QWL7qqoOPktOeAgInAz5bBhQ/e+/NILb2dnDws1ipcHG1TD77HpdwhAAAAAILbJEhfkrTNi6ZMFw9566528uvr6MSK8zZXagIyM4mnT7vrrU79cVtGB7TnPnBV+j22/QwACAAAAvQOe6pPn2e5w1GlP4d7UDRteubqiomKIzd6Q1dzcnOnxeNKo7k9UVTWZBw8oiuK2WCzNqakp59L7pVdnZw+rmD9/7vEgSYSDwX3NOEdvI/zeO/wOAQgAAAD0PriJkidJSIzid+CZqXjCBgf83vv8bsE1BAAAAPQ6HBcIgDRpl/XgZzYYfC783kv9DgEIAAAAxI8wsRrU8zxlKI9cTZTvzUJvzmTzBZhHmkuaF26NX79DAAIAAADxC4uJJhE7yZfh9xgBM4EAAAAAAPQxIAABAAAAAPoY/wI2YEJ95liO6gAAAABJRU5ErkJggg==)}.h5c-play{background-position:-472px 0}.h5c-pause{background-position:-566px 0}.h5c-audio{position:relative;padding:8px;text-align:left;border:1px solid #bfbfbf}.h5c-audio>span:first-child{display:inline-block;margin-bottom:.04rem;font-size:0.16rem}.h5c-audio>.h5c-icon{position:absolute;display:inline-block;top:50%;left:auto;right:-.1rem;width:.8rem;height:.8rem;margin-top:-.4rem;transform:scale(.6,.6)}.h5c-video{position:relative;text-align:center}.h5c-video>.h5c-icon{position:absolute;display:inline-block;top:50%;left:50%;right:.08rem;width:.8rem;height:.8rem;margin-left:-.4rem;margin-top:-.4rem}.h5c-video-tool{display:-webkit-flex;display:flex;-wekit-align-items:center;align-items:center;height:.16rem;line-height:.16rem;background-color:#191514;font-size:.1rem;color:#bfbfbf}.h5c-video-play{width:16px;height:16px;background-position:-192px -31px}.h5c-video-pause{width:16px;height:16px;background-position:-192px -31px}.h5c-video-progress{position:relative;-webkit-flex-grow:1;flex-grow:1;margin:0 .08rem;height:100%}.h5c-video-all{position:absolute;margin-top:.06rem;left:0;width:100%;height:.04rem;background-color:#383533}.h5c-video-step{position:absolute;margin-top:.06rem;left:0;height:.04rem;background-color:#f86e42}.h5c-video-slider{position:absolute;margin-left:-8px;left:0;width:16px;height:16px;background-position:-272px -30px}.h5c-video-time{margin:0 .02rem;width:.3rem;text-align:right}.h5c-video-sep{width:1px;height:.08rem;background-color:#bfbfbf}.h5c-video-duration{margin:0 .02rem;width:.3rem;text-align:left}.h5c-video-audio{margin-right:.04rem;width:16px;height:16px;background-position:-432px -32px}.h5c-video-vol{position:relative;margin:0 .04rem;width:.44rem;height:100%}.h5c-video-vol>.h5c-video-slider{background-position:-351px -31px}.h5c-video-full{width:.27rem}';
			
    dom.setAttribute('type', 'text/css');  

    if (dom.styleSheet) // IE
    {
        dom.styleSheet.cssText = text;  
    }
    else // w3c  
    {
        dom.appendChild(document.createTextNode(text));  
    }

    (document.head || document.getElementsByTagName('head')[0]).appendChild(dom);

})();



h5d.audio = function (dom) {

    var audio = new Audio(),
        play;

    audio.src =  dom.getAttribute('src');

    if (dom.firstChild)
    {
        dom.classList.add('no-content');
    }
    else
    {
        dom.innerHTML = '<span></span>' +
            '<br>' +
            '<span></span>' +
            '<div class="h5c-icon h5c-play"></div>';

        play = dom.getElementsByTagName('span');
        play[0].textContent = dom.getAttribute('name');
        play[1].textContent = dom.getAttribute('author');
    }

    audio.onplay = function () {

        play.classList.add('h5c-pause');
    }

    audio.onpause = function () {

        play.classList.remove('h5c-pause');
    }

    play = dom.lastChild;

    play.onclick = function () {

        if (audio.paused || audio.ended)
        {
            audio.play();
            h5d.audio.play = audio;
        }
        else if (audio.played)
        {
            h5d.audio.play = null;
            audio.pause();
        }
    }
}



h5d.video = function (dom) {

    var video, play1, play2, show;

    if (show = dom.firstChild)
    {
        var vstep = dom.querySelector('.h5c-video-progress>.h5c-video-step');
        var vslider = dom.querySelector('.h5c-video-progress>.h5c-video-slider');
        var vtime = dom.querySelector('.h5c-video-time');

        var astep = dom.querySelector('.h5c-video-vol>.h5c-video-step');
        var aslider = dom.querySelector('.h5c-video-vol>.h5c-video-slider');

        var start;

        dom.classList.add('no-content');

        video = dom.firstChild.nextSibling;

        video.onclick = play;

        video.ontimeupdate = function () {
            
            var time = this.currentTime;

            vstep.style.width = vslider.style.left = (time * 100 / this.duration) + '%';
            vtime.innerHTML = format(time | 0);
        }

        video.onvolumechange = function () {
        
            astep.style.width = aslider.style.left = (this.volume * 100) + '%';
        }

        dom.querySelector('.h5c-video-progress').onmousedown = function (event) {

            video.currentTime = event.offsetX * video.duration / this.offsetWidth;

            event.stopPropagation();
            return false;
        }

        dom.querySelector('.h5c-video-vol').onmousedown = function (event) {

            video.volume = event.offsetX / this.offsetWidth;

            event.stopPropagation();
            return false;
        }

        vslider.onmousedown = aslider.onmousedown = function (event) {

            start = [
                this.offsetLeft + this.offsetWidth / 2, 
                event.clientX, 
                this.parentNode.offsetWidth, 
                this === vslider ? 1 : 0
            ];
            
            event.stopPropagation();
            return false;
        }

        dom.onmousemove = function (event) {

            if (start)
            {
                var value = start[0] + event.clientX - start[1];

                if (value < 0)
                {
                    value = 0;
                }
                else if ((value = value / start[2]) > 1)
                {
                    value = 1;
                }
        
                if (start[3])
                {
                    video.currentTime = value * video.duration;
                }
                else
                {
                    video.volume = value;
                }
            }
        }

        dom.onmouseup = function () {

            start = null;
        }

        video.onvolumechange();
    }
    else
    {
        dom.innerHTML = '<div></div>' +
            '<video style="width:100%;"></video>' +
            '<div class="h5c-video-tool">' +
                '<span class="h5c-icon h5c-video-play"></span>' +
                '<span class="h5c-video-progress">' +
                    '<span class="h5c-video-all"></span>' +
                    '<span class="h5c-video-step"></span>' +
                    '<span class="h5c-icon h5c-video-slider"></span>' +
                '</span>' +
                '<span class="h5c-video-time">00:00</span>' +
                '<span class="h5c-video-sep"></span>' +
                '<span class="h5c-video-duration">00:00</span>' +
                '<span class="h5c-icon h5c-video-audio"></span>' +
                '<span class="h5c-video-vol">' +
                    '<span class="h5c-video-all"></span>' +
                    '<span class="h5c-video-step"></span>' +
                    '<span class="h5c-icon h5c-video-slider"></span>' +
                '</span>' +
                '<span class="h5c-video-full">全屏</span>' +
            '</div>' +
            '<div class="h5c-icon h5c-play"></div>';

        video = dom.firstChild;
        video.textContent = dom.getAttribute('name');

        video = video.nextSibling;
        video.src = dom.getAttribute('src');

        video.onloadedmetadata = function () {

            video.style.height = this.offsetHeight / 100 + 'rem';
            dom.querySelector('.h5c-video-duration').innerHTML = format(this.duration | 0);
        }
    }



    play1 = dom.querySelector('.h5c-play');

    play2 = dom.querySelector('.h5c-video-play');

    play1.onclick = play2.onclick = play;


    dom.querySelector('.h5c-video-full').onclick = function () {

        var fn = video.requestFullscreen || video.webkitRequestFullscreen;

        if (fn)
        {
            fn.call(video);
        }
    }


    function format(time) {

        var seconds = time % 60;

        time -= seconds;
        time /= 60;

        time = (time > 9 ? '' : '0') + time;
        seconds = (seconds > 9 ? '' : '0') + seconds;
    
        return time + ':' + seconds;
    }


    function play() {

        if (video.paused || video.ended)
        {
            video.play();
            h5d.video.play = video;
        }
        else if (video.played)
        {
            h5d.video.play = null;
            video.pause();
        }
    }


    video.onplay = function () {

        if (show)
        {
            play1.style.display = 'none';
        }
        else
        {
            play1.classList.add('h5c-pause');
        }

        play2.classList.add('h5c-video-pause');
    }


    video.onpause = function () {

        if (show)
        {
            play1.style.display = '';
        }
        else
        {
            play1.classList.remove('h5c-pause');
        }
        
        play2.classList.remove('h5c-video-pause');
    }

}



h5d.render = function (dom) {

    var list = (dom || document).querySelectorAll('.h5c-audio');

    for (var i = list.length; i--;)
    {
        h5d.audio(list[i]);
    }

    list = (dom || document).querySelectorAll('.h5c-video');

    for (var i = list.length; i--;)
    {
        h5d.video(list[i]);
    }
}
