// fix iPhone10.0.2浏览器兼容性问题
if (!Object.entries) {
    Object.entries = function (obj) {
        var ownProps = Object.keys(obj),
            i = ownProps.length,
            resArray = new Array(i); // preallocate the Array
        while (i--)
            resArray[i] = [ownProps[i], obj[ownProps[i]]];
        return resArray;
    };
}
// plugin.js
var _rt = {};

function loadRuntime() {
    return _rt;
}

(function() {
    // 将 customPromise 取到本地变量，因为在运行期间 wx. 的版本会被删除
    var customPromise = wx.customPromise;

    wx.callCustomCommand = function (param) {
        customPromise("CustomCommand", param);
    }

    // 将 onCustomEvent, offCustomEvent 取到本地变量，因为在运行期间 wx. 的版本会被删除
    var onCustomEvent = wx.onCustomEvent;
    var offCustomEvent = wx.offCustomEvent;
    // 注册
    wx.registerCustomCommandEvent = function(cb) {
        onCustomEvent("CustomCommandEvent", cb);
    }
    // 取消
    wx.unregisterCustomCommandEvent = function(cb) {
        offCustomEvent("CustomCommandEvent", cb);
    }


if (!_rt.callCustomCommand) {
    _rt.callCustomCommand = function (object, cmd, param, state, dataJson) {
        if (typeof object !== "object") {
            object = {};
        }
        wx.callCustomCommand({
            cmd: cmd,
            param: param,
            state: state,
            dataJson: JSON.parse(dataJson),
            success: function (res) {
                if (typeof object.success == "function") {
                    object.success(JSON.stringify(res));
                }
                if (typeof object.complete == "function") {
                    object.complete(JSON.stringify(res));
                }
            },
            fail: function (res) {
                if (typeof object.fail == "function") {
                    object.fail(JSON.stringify(res));
                }
                if (typeof object.complete == "function") {
                    object.complete(JSON.stringify(res));
                }
            },
        });
    };
}

//
// 小游戏和App交互
//
var kLogLevelVerbose = 2;
var kLogLevelDebug = 3;
var kLogLevelInfo = 4;
var kLogLevelWarn = 5;
var kLogLevelError = 6;

var _stateHandlerMap = {};
var _debug = true;
var _logLevel = kLogLevelWarn;
var _kTag = "SudMGP-MGSDK";
var _kVersion = "0.0.0.0";

var kCmdTypeGame = "game";
var kCmdTypePlayer = "player";

// sdk接口
var kApp2MgStateNotifyNetStatus = "a2ms-notify-net-status";
var kApp2MgStateNotifyDestroyGame = "a2ms-notify-destroy-game";
var kApp2MgStateNotifyPauseGame = "a2ms-notify-pause-game";
var kApp2MgStateNotifyResumeGame = "a2ms-notify-resume-game";

var kMg2AppStateGetNetStatus = "m2as-get-net-status";
var kMg2AppStateGetGameViewInfo = "m2as-get-game-view-info";
var kMg2AppStateGetGameCfg = "m2as-get-game-cfg";
var kMg2AppStateVibrate = "m2as-vibrate";
var kMg2AppStateGetSDKInfo = "m2as-get-sdk-info";
var kMg2AppStateGetState = "m2as-get-state";
var kMg2AppStateNotifyGameLoadStarted = "m2as-notify-game-load-started";
var kMg2AppStateNotifyGameLoadCompleted = "m2as-notify-game-load-completed";
var kMg2AppStateNotifyGameStarted = "m2as-notify-game-started";
var kMg2AppStateGetMGPVersion = "m2as-get-mgp-version";
var kMg2AppStateSetDebug = "m2as-set-debug";
var kMg2AppStateMGLog = "m2as-mg-log";

// 业务
var kApp2MgStateUpdateCode = "a2ms-update-code";
var kApp2MgStateStateChange = "a2ms-state-change";
var kMg2AppStateExpireCode = "m2as-expire-code";
var kMg2AppStateLogin = "m2as-login";

if (!_rt.getMGPVersion) {
    _rt.getMGPVersion = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getMGPVersion");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetMGPVersion, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getMGPVersion");
    };
}

if (!_rt.mgSdkLog) {
    _rt.mgSdkLog = function (level, msg) {
        if (_debug) {
            if (kLogLevelVerbose === level && _logLevel <= kLogLevelVerbose) {
                console.log(_kTag + " " + msg);
            } else if (kLogLevelDebug === level && _logLevel <= kLogLevelDebug) {
                console.log(_kTag + " " + msg);
            } else if (kLogLevelInfo === level && _logLevel <= kLogLevelInfo) {
                console.log(_kTag + " " + msg);
            } else if (kLogLevelWarn === level && _logLevel <= kLogLevelWarn) {
                console.warn(_kTag + " " + msg);
            } else if (kLogLevelError === level && _logLevel <= kLogLevelError) {
                console.error(_kTag + " " + msg);
            } else {
//                console.log(_kTag + " " + msg);
            }
        }
    };
}

if (!_rt.setDebug) {
    _rt.setDebug = function (debug, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> setDebug");

        if (typeof debug === "boolean") {
            _debug = debug;

            _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateSetDebug, JSON.stringify({"debug":debug}), callback);
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== setDebug");
    };
}

if (!_rt.setLogLevel) {
    _rt.setLogLevel = function (level, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> setLogLevel");

        if (typeof level === "number" && kLogLevelVerbose <= level && level >= kLogLevelError) {
            _logLevel = level;
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== setLogLevel");
    };
}

if (!_rt.mgLog) {
    _rt.mgLog = function (dataJson, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> mgLog");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateMGLog, dataJson, callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== mgLog");
    };
}



// var callback = {
//     success: function(dataJson) {
//         console.log("resp result dataJson=" + dataJson);
//     },
//     fail: function(errMsg) {
//         console.log("errMsg=" + errMsg);
//     }
//     complete: function(res) {
//         console.log("res=" + res);
//     }
// };
// 1.小游戏==调用==>APP（公共接口）
if (!_rt.expireCode) {
    _rt.expireCode = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> expireCode");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateExpireCode, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== expireCode");
    };
}

if (!_rt.login) {
    _rt.login = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> login");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateLogin, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== login");
    };
}

if (!_rt.getNetStatus) {
    _rt.getNetStatus = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getNetStatus");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetNetStatus, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getNetStatus");
    };
}

if (!_rt.getGameViewInfo) {
    _rt.getGameViewInfo = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getGameViewInfo");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetGameViewInfo, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getGameViewInfo");
    };
}

if (!_rt.getGameCfg) {
    _rt.getGameCfg = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getGameCfg");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetGameCfg, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getGameCfg");
    };
}

if (!_rt.vibrate) {
    _rt.vibrate = function (milliseconds, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> vibrate");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateVibrate, JSON.stringify({ "milliseconds": milliseconds }), callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== vibrate");
    };
}

if (!_rt.getSDKInfo) {
    _rt.getSDKInfo = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getSDKInfo");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetSDKInfo, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getSDKInfo");
    };
}

if (!_rt.getState) {
    _rt.getState = function (state, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getState");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateGetState, JSON.stringify({"state": state}), callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getState");
    };
}

if (!_rt.notifyGameLoadStarted) {
    _rt.notifyGameLoadStarted = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyGameLoadStarted");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateNotifyGameLoadStarted, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyGameLoadStarted");
    };
}

if (!_rt.notifyGameLoadCompleted) {
    _rt.notifyGameLoadCompleted = function (callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyGameLoadCompleted");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateNotifyGameLoadCompleted, "{}", callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyGameLoadCompleted");
    };
}

if (!_rt.notifyGameStarted) {
    _rt.notifyGameStarted = function (dataJson, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyGameStarted");

        _rt.notifyStateChange(kCmdTypeGame, "", kMg2AppStateNotifyGameStarted, dataJson, callback);

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyGameStarted");
    };
}

// var callback = {
//     success: function(dataJson) {
//         console.log("resp result dataJson=" + dataJson);
//     },
//     fail: function(errMsg) {
//         console.log("errMsg=" + errMsg);
//     }
// };

// state: "state-mg-xx-yy-zz"
if (!_rt.notifyStateChange) {
    _rt.notifyStateChange = function (type, param, state, dataJson, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyStateChange");

        if (typeof state === "string" && typeof dataJson === "string") {
            _rt.callCustomCommand({
                success: function (res) {
                    if (callback != null && typeof callback.success == "function") {
                        callback.success(res);
                    }
                },
                fail: function (res) {
                    if (callback != null && typeof callback.fail == "function") {
                        callback.fail(res);
                    }
                },
                complete: function (res) {
                    if (callback != null && typeof callback.complete == "function") {
                        callback.complete(res);
                    }
                }
            }, type, param, state, dataJson);
        } else {
            _rt.mgSdkLog(kLogLevelError, "notifyStateChange state=" + state);
            _rt.mgSdkLog(kLogLevelError, "notifyStateChange dataJson=" + dataJson);
            var errMsg = "notifyStateChange state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog(kLogLevelError, errMsg);
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyStateChange");
    };
}

if (!_rt.notifyGameStateChange) {
    _rt.notifyGameStateChange = function (state, dataJson, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyGameStateChange state=" + state + "dataJson=" + dataJson);

        if (typeof state === "string" && typeof dataJson === "string") {
            _rt.notifyStateChange(kCmdTypeGame, "", state, dataJson, callback)
        } else {
            _rt.mgSdkLog(kLogLevelError, "notifyGameStateChange state=" + state);
            _rt.mgSdkLog(kLogLevelError, "notifyGameStateChange dataJson=" + dataJson);
            var errMsg = "notifyGameStateChange state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog(kLogLevelError, errMsg);
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyGameStateChange");
    };
}

if (!_rt.notifyPlayerStateChange) {
    _rt.notifyPlayerStateChange = function (userId, state, dataJson, callback) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> notifyPlayerStateChange");

        if (typeof userId === "string" && typeof state === "string" && typeof dataJson === "string") {
            _rt.notifyStateChange(kCmdTypePlayer, userId, state, dataJson, callback)
        } else {
            _rt.mgSdkLog(kLogLevelError, "userId=" + userId);
            _rt.mgSdkLog(kLogLevelError, "state=" + state);
            _rt.mgSdkLog(kLogLevelError, "dataJson=" + dataJson);
            var errMsg = "notifyPlayerStateChange userId state and dataJson type must be string";
            if (callback != null && typeof callback.fail == "function") {
                callback.fail(JSON.stringify({ "ret_code": -1, "ret_msg": errMsg }));
            }
            _rt.mgSdkLog(kLogLevelError, errMsg);
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== notifyPlayerStateChange");
    };
}

// 3.APP==调用==>小游戏（公共接口）

// var handler = {
//     state: "on-app-state-xx-yy-zz",
//     onHandler: function(dataJson) {}
// };
// 4.APP==调用==>小游戏（透传通道接口）
if (!_rt.addApp2MgStateChangeHandler) {
    _rt.addApp2MgStateChangeHandler = function (handler) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> addApp2MgStateChangeHandler");

        if (typeof handler === "object") {
            var state = handler.state;
            if (typeof state === "string" && state.length != 0) {
                _stateHandlerMap[state] = handler;
                _rt.mgSdkLog(kLogLevelInfo, "addApp2MgStateChangeHandler success");
            } else {
                _rt.mgSdkLog(kLogLevelError, "addApp2MgStateChangeHandler handler invalid");
            }
        } else {
            _rt.mgSdkLog(kLogLevelError, "addApp2MgStateChangeHandler handler invalid");
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== addApp2MgStateChangeHandler");
    };
}

if (!_rt.removeApp2MgStateChangeHandler) {
    _rt.removeApp2MgStateChangeHandler = function (handler) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> removeApp2MgStateChangeHandler");

        if (typeof handler === "object") {
            var state = handler.state;
            if (typeof state === "string" && state.length != 0) {
                _stateHandlerMap[state] = null;
                _rt.mgSdkLog(kLogLevelInfo, "removeApp2MgStateChangeHandler success");
            } else {
                _rt.mgSdkLog(kLogLevelError, "removeApp2MgStateChangeHandler handler invalid");
            }
        } else {
            _rt.mgSdkLog(kLogLevelError, "removeApp2MgStateChangeHandler handler invalid");
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== removeApp2MgStateChangeHandler");
    };
}

if (!_rt.removeAllApp2MgStateChangeHandlers) {
    _rt.removeAllApp2MgStateChangeHandlers = function () {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> removeAllApp2MgStateChangeHandlers");

        _stateHandlerMap = {};

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== removeAllApp2MgStateChangeHandlers");
    };
}


// var _appStateMap = {};
// if (!_rt.putState) {
//     _rt.putState = function (state, dataJson) {
//         _rt.mgSdkLog(kLogLevelInfo, "enter ====> putState");
//
//         _appStateMap[state] = dataJson;
//
//         _rt.mgSdkLog(kLogLevelInfo, "leave <==== putState");
//     };
// }
//
// if (!_rt.getState) {
//     _rt.getState = function (state) {
//         _rt.mgSdkLog(kLogLevelInfo, "enter ====> getState");
//
//         return _appStateMap[state];
// //        if (callback != null && typeof callback.success == "function") {
// //            callback.success(_appStateMap[state]);
// //        } else {
// //            _rt.mgSdkLog(kLogLevelInfo, "getState callback or callback.success invalid");
// //        }
//
//         _rt.mgSdkLog(kLogLevelInfo, "leave <==== getState");
//     };
// }

var _FSTMG = {
    setDebug: _rt.setDebug,
    setLogLevel: _rt.setLogLevel,
    mgLog: _rt.mgLog,
    login: _rt.login,
    expireCode: _rt.expireCode,
    getNetStatus: _rt.getNetStatus,
    getGameViewInfo: _rt.getGameViewInfo,
    getGameCfg: _rt.getGameCfg,
    vibrate: _rt.vibrate,
    getSDKInfo: _rt.getSDKInfo,
    getState: _rt.getState,
    notifyGameLoadStarted: _rt.notifyGameLoadStarted,
    notifyGameLoadCompleted: _rt.notifyGameLoadCompleted,
    notifyGameStarted: _rt.notifyGameStarted,
    notifyGameStateChange: _rt.notifyGameStateChange,
    notifyPlayerStateChange: _rt.notifyPlayerStateChange
};
if (!_rt.getFSTMG) {
    _rt.getFSTMG = function () {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> getFSTMG");
        return _FSTMG;
        _rt.mgSdkLog(kLogLevelInfo, "leave <==== getFSTMG");
    };
}


//var IFSMAPP = {
//     onNotifyNetStatus: function(dataJson) {
//     },
//     onUpdateCode: function(dataJson) {
//         console.log(dataJson);
//     },
//     onStateChange: function(state, dataJson) {
//     }
// };
var _FSMAPP = {};
if (!_rt.setFSMAPP) {
    _rt.setFSMAPP = function (fsmApp2Mg) {
        _rt.mgSdkLog(kLogLevelInfo, "enter ====> setFSMAPP");

        if (typeof fsmApp2Mg === "object") {
            _FSMAPP = fsmApp2Mg;
            var onUpdateCodeStateHandler = {
                state: kApp2MgStateUpdateCode,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onUpdateCode === "function") {
                        fsmApp2Mg.onUpdateCode(dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onUpdateCode function");
                    }
                }
            };
            var onNotifyNetStatusStateHandler = {
                state: kApp2MgStateNotifyNetStatus,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onNotifyNetStatus === "function") {
                        fsmApp2Mg.onNotifyNetStatus(dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onNotifyNetStatus function");
                    }
                }
            };
            var onNotifyDestroyGameStateHandler = {
                state: kApp2MgStateNotifyDestroyGame,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onNotifyDestroyGame === "function") {
                        fsmApp2Mg.onNotifyDestroyGame(dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onNotifyDestroyGame function");
                    }
                }
            };
            var onStateChangeHandler = {
                state: kApp2MgStateStateChange,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onStateChange === "function") {
                        fsmApp2Mg.onStateChange(state, dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onStateChange function");
                    }
                }
            };
            var onPauseGameStateHandler = {
                state: kApp2MgStateNotifyPauseGame,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onPauseGame === "function") {
                        fsmApp2Mg.onStateChange(state, dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onPauseGame function");
                    }
                }
            };
            var onResumeGameStateHandler = {
                state: kApp2MgStateNotifyResumeGame,
                onHandler: function (state, dataJson) {
                    if (typeof fsmApp2Mg.onResumeGame === "function") {
                        fsmApp2Mg.onStateChange(state, dataJson);
                    } else {
                        _rt.mgSdkLog(kLogLevelError, "setFSMAPP not set fsmApp2Mg.onResumeGame function");
                    }
                }
            };
            _rt.addApp2MgStateChangeHandler(onUpdateCodeStateHandler);
            _rt.addApp2MgStateChangeHandler(onNotifyNetStatusStateHandler);
            _rt.addApp2MgStateChangeHandler(onNotifyDestroyGameStateHandler);
            _rt.addApp2MgStateChangeHandler(onStateChangeHandler);
            _rt.addApp2MgStateChangeHandler(onPauseGameStateHandler);
            _rt.addApp2MgStateChangeHandler(onResumeGameStateHandler);
        } else {
            _rt.mgSdkLog(kLogLevelError, "setFSMAPP fsmApp2Mg invalid");
        }

        _rt.mgSdkLog(kLogLevelInfo, "leave <==== setFSMAPP");
    };
}

var _app2MgStateChangeNotify = function (state, dataJson) {
    _rt.mgSdkLog(kLogLevelInfo, "_app2MgStateChangeNotify state=" + state + " dataJson=" + dataJson);
    if (typeof state === "string" && state.length != 0) {
        // _rt.putState(state, dataJson);
        var handler = _stateHandlerMap[state];
        if (handler != null) {
            if (typeof handler.onHandler === "function") {
                handler.onHandler(state, dataJson);
                return JSON.stringify({ "ret_code": 0, "ret_msg": "success" });
            } else {
                var errorMsg = "mg implement state=" + state + " but onHandler not ok";
                _rt.mgSdkLog(kLogLevelError, errorMsg);
                return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
            }
        } else {
            var handler2 = _stateHandlerMap[kApp2MgStateStateChange];
            if (handler2 != null) {
                if (typeof handler2.onHandler === "function") {
                    handler2.onHandler(state, dataJson);
                    return JSON.stringify({ "ret_code": 0, "ret_msg": "success" });
                } else {
                    var errorMsg = "mg implement state=" + state + " but onHandler not ok";
                    _rt.mgSdkLog(kLogLevelError, errorMsg);
                    return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
                }
            } else {
                var errorMsg = "mg not implement FSMAPP.onStateChange function";
                _rt.mgSdkLog("warning", errorMsg);
                return JSON.stringify({ "ret_code": -1, "ret_msg": errorMsg });
            }
        }
    } else {
        _rt.mgSdkLog(kLogLevelError, "_app2MgStateChangeNotify state Invalid");
        return JSON.stringify({ "ret_code": -1, "ret_msg": "state Invalid" });
    }
};

function onCustomCommandEventCallback(res) {
    _rt.mgSdkLog(kLogLevelInfo, "onCustomCommandEventCallback");
    var ret = _app2MgStateChangeNotify(res.state, JSON.stringify(res.dataJson));
    return ret;
}

wx.registerCustomCommandEvent(onCustomCommandEventCallback);

})();