//iOS 4.0.x and under has a bug where OFFSET.TOP() REPORTS WRONG POSITION AFTER SCROLL 
OF.device.ios4_0_x = /iPhone.*4\.0.*/.test(OF.device.os);

// Open the dashboard (or prompt login) when the leaf bar button is tapped.
OF.barButtonTouch = function() {
  OF.trackEvent('game_channel', 'dashboard_button');
  if (OF.user && OF.user.id) {
    OF.action('dashboard');
  } else {
    OF.action('showEnableView', { message: "Join the OpenFeint Community!", button: "Sign me up!" });
  }
};

OF.api.handleDisconnect = function() {
  OF.action('reload');
};

OF.appStore = function(gameId) {
  OF.action('openMarket', {
    url: OF.serverUrl +'client_applications/'+ gameId +'/buy_now'+
                      '?user_id='+ (OF.user.id ? OF.user.id : '') +
                      '&ga_id='+ OF.GA.cookie.id
  });
};

// Send pings to tapjoy
OF.tapjoy = (function() {
  var params = {
    udid:             OF.device.identifier,
    device_type:      OF.device.hardware,
    os_version:       U.last(OF.device.os.split(' ')),
    app_id:           '00b2897c-eadf-4ac6-a69b-701ca6734214',
    app_version:      OF.game.version,
    library_version:  '7.4.0',
    country_code:     'US',
    language_code:    'en',
    lad:              '0', // '0' for normal, '42' for jailbroken.
  };
  
  var sendReq = function(reqParams) {
    var tapJoyReq = new Image();
    tapJoyReq.src = 'https://ws.tapjoyads.com/connect?'+ $.urlEncode(reqParams);
  };
  
  return {
    install: function() {
      sendReq(params);
    },
    action: function() {
      var actionParams = U.clone(params);
      actionParams.app_id = '7f2d2441-626a-4755-983c-5ece2809c015';
      sendReq(actionParams);
    }
  }
}());

(function($){
  $.fn.countDownOld = function(options) {
    var endHour = (options && options.endHour) || 24; //24:00 UTC is 5:00pm PST
    var el = this;
    
    var intervalID = setInterval(function() {
      
      var now = new Date(); // Get Current Time

      var end = new Date(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate()); // get target hour today
      end.setUTCHours(endHour,00,0); //Make sure we are seting 24:00 UTC (5:00pm PST)
      
      if (now > end) end.setDate(end.getDate() + 1);  // ensure target end time is in the future
      
      var nowInMilliseconds = now.getTime(); // Convert Now to millseconds
      var endInMilliseconds = end.getTime(); // Convert end target time to millseconds
      var millsecondsTillEnd = (endInMilliseconds - nowInMilliseconds); // end minus now equals remaining time. Easy math in milli 
      var hoursTillEnd = Math.floor(millsecondsTillEnd / 3600000); // Multiplying buy millseconds in an hour and rounding the number down gives us the hours remaining 
      
       
      var minTillEnd = Math.floor(59 - now.getMinutes());
      var secondsTillEnd = (59 - now.getSeconds());
      secondsTillEnd = (secondsTillEnd < 10 ? '0' : '') + secondsTillEnd;
      
      $(el).html(hoursTillEnd + 'h ' +  minTillEnd + 'm ' +  secondsTillEnd + 's');

    }, 1000);
  }
})(jQuery);

OF.getTemperature = function(vote_target, vote_count, votes_bubble) {
    $('.thermometer .mercury').width(0);
    maxWidth = $('.thermometer').width() - 9;
    var x = vote_target / vote_count;
    var temperature = maxWidth / x;
    temperatureSpeed = 1500 / x;
    $('.thermometer .mercury').animate(
      {
        width: temperature
      }, 
      temperatureSpeed,
      function() {
        if (votes_bubble) {
          var exclamation = (vote_count == vote_target) ? "!" : '';
          $('.ammount span').text(addCommas(vote_count) + " votes" + exclamation);
          if ( vote_count > vote_target - (vote_target * .25)) { //greater than 75% full
            $('.ammount').css({
              'left' : (temperature - 54) + 'px', 
              'font-weight' : 'bolder'
            }).unhide();
            $('.ammount span').css('color', '#ea2929');
            $('.ammount .indicator').css({'left' : '61px'})
          } else if ( vote_count < vote_target * .25) { //less than 25% full
            $('.ammount').css({
              'left' : (temperature + 9) + 'px', 
              'font-weight' : 'bolder'
            }).unhide();
            $('.ammount .indicator').css({'left' : '-2px'})
          } else {
            $('.ammount').css({
              'left' : (temperature - 22) + 'px',
              'font-weight' : 'bolder'
            }).unhide();
          }
        } else {
          var exclamation = (vote_count == vote_target) ? "!" : '';
          $('.thermometer .mercury').text(addCommas(vote_count) + " votes" + exclamation);
        }
    });
};

OF.gcTime = {
  timerID: null,
  totalSecsTillEnd: 0,
  cleanTime : function(ISO8601) {
    // Cleans up ISO8601 time format and makes it work for webkit on iphone
    // For some reason ISO8601 format works on FF, and desktop versions of Webkit
    
    // Only works for dates in this format:
    // 2011-03-18T22:27:14Z
    
    // Returns: 
    // 2008/12/19 16:39:57.67
    return $.trim(ISO8601.replace(/-/g,"/").replace(/[TZ]/g," "));
  },
  formatTimeLeft : function(tL) {
    var r = (tL.hours / 24);
    var t = ' Days';
      if (tL.hours < 48) { 
        r = tL.hours;
        t = ' Hours'; 
        if (tL.hours < 2) {
        var r = (tL.hours * 60) + tL.minutes;
          t = ' min';
        }            
      }
    return {
      time: parseInt(r),
      type: t
    };
  },
  secondsToHoursMinutes : function(totalSecsTillEnd) { // Returns Object {hours : 19, minutes : 23, : seconds : 10}
    if (!totalSecsTillEnd) {
      totalSecsTillEnd = null;
    } else {
      this.totalSecsTillEnd = totalSecsTillEnd;
    }
    if (this.totalSecsTillEnd > 0) {
      var totalSecsTillEnd = this.totalSecsTillEnd;
      var now = new Date(); // Get Current Time
      var hoursTillEnd = Math.floor(totalSecsTillEnd / 3600); //Hours Remaining
      var hoursTillEndInSecs = (hoursTillEnd * 3600);
      var secsTillEndLeft = (totalSecsTillEnd - hoursTillEndInSecs);
      var minTillEnd = Math.floor(secsTillEndLeft / 60);
      var minTillEndLeftInSecs = (minTillEnd * 60);
      var secsTillEnd = Math.floor(secsTillEndLeft - minTillEndLeftInSecs);

      if (totalSecsTillEnd <= -1) {
        OF.stop();
      } else {
        timeRemaining = {
          hours   : hoursTillEnd,
          minutes : minTillEnd,
          seconds : secsTillEnd
        }
      }
    }
    return timeRemaining;
  }
};

Date.prototype.abbrMonths = [
  'Jan',
  'Feb',
  'Mar',
  'Apr',
  'May',
  'Jun',
  'Jul',
  'Aug',
  'Sep',
  'Oct',
  'Nov',
  'Dec'
];

Date.prototype.DaysOfTheWeek = [
  'Sunday',
  'Monday',
  'Tuesday',
  'Wednesday',
  'Thursday',
  'Friday',
  'Saturday'
];

function addCommas(nStr) {
	nStr += '';
	x = nStr.split('.');
	x1 = x[0];
	x2 = x.length > 1 ? '.' + x[1] : '';
	var rgx = /(\d+)(\d{3})/;
	while (rgx.test(x1)) {
		x1 = x1.replace(rgx, '$1' + ',' + '$2');
	}
	return x1 + x2;
}

//http://james.padolsey.com/javascript/recursive-pretty-date/
var niceTime = function(time) {
  var ints = {
    second: 1,
    minute: 60,
    hour: 3600,
    day: 86400,
    week: 604800,
    month: 2592000,
    year: 31536000
  };

  time = +new Date(time);

  var gap = ((+new Date()) - time) / 1000,
  amount, measure;

  for (var i in ints) {
    if (gap > ints[i]) { measure = i; }
  }

  amount = gap / ints[measure];
  amount = gap > ints.day ? (Math.round(amount * 100) / 100) : Math.round(amount);
  amount = parseInt(amount)
  amount += ' ' + measure + (amount > 1 ? 's' : '') + ' ago';
  return amount;

}