#ifdef GL_ES
precision lowp float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
varying vec4 v_position;

uniform vec2 line_pos1;
uniform vec2 line_pos2;
uniform vec2 line_pos3;
uniform vec2 line_pos4;
uniform vec2 line_pos5;
uniform vec2 line_pos6;
uniform vec2 line_pos7;
uniform vec2 line_pos8;
uniform vec2 line_pos9;
uniform vec2 line_pos10;

void main()
{
    vec4 c = v_fragmentColor * texture2D(CC_Texture0, v_texCoord);

    vec2 line_pos[10];
    line_pos[0] = line_pos1;
    line_pos[1] = line_pos2;
    line_pos[2] = line_pos3;
    line_pos[3] = line_pos4;
    line_pos[4] = line_pos5;
    line_pos[5] = line_pos6;
    line_pos[6] = line_pos7;
    line_pos[7] = line_pos8;
    line_pos[8] = line_pos9;
    line_pos[9] = line_pos10;

    int bfind = 0;
    for(int i=0;i<9;i++){
        vec2 p1 = line_pos[i];
        vec2 p2 = line_pos[i+1];
        if(v_position.x >= p1.x && v_position.x < p2.x){
            float a = (p1.y - p2.y)/(p1.x - p2.x);
            float b = p1.y - a * p1.x;
            //y = ax + b;=>
            float line_y = v_position.x * a + b;

            float distance = v_position.y - line_y;
            if(distance > 30.0) distance = 30.0;
            if(distance < -30.0) distance = -30.0;
            
            float factor = distance/60.0;
            factor = factor +0.5;
            
            gl_FragColor.xyz = vec3(0.2126*c.r + 0.7152*c.g + 0.0722*c.b) * factor + c.xyz * (1.0-factor);
            bfind = 1;
            break;
        }
    }

    if(bfind == 0) gl_FragColor.xyz = c.xyz;
   

    gl_FragColor.w = c.w;
}