import Vue from 'vue';
import VueI18n from 'vue-i18n'
import zh from './zh'
import en from './en'
Vue.use(VueI18n)

//实例化vue-i18n
export default new VueI18n({
  // 从本地存储中取，如果没有默认为中文，
  // 这样可以解决切换语言后，没记住选择的语言，刷新页面后还是默认的语言
  locale: uni.getStorageSync('lang') || 'zh',
  messages: {
    'zh': zh, // 中文语言包
    'en': en  // 英文语言包
  },
  silentTranslationWarn: true
})