#extension GL_OES_EGL_image_external : require

precision mediump float;
// External texture containing video decoder output.
uniform samplerExternalOES tex_sampler_0;
// Texture containing the overlap bitmap.
uniform sampler2D tex_sampler_1;
varying vec2 v_texcoord;

void main() {
    vec4 videoColor = texture2D(tex_sampler_0, v_texcoord);
    vec4 overlayColor = texture2D(tex_sampler_1,
    vec2(v_texcoord.x, v_texcoord.y));
    // Blend the video decoder output and the overlay bitmap.
    gl_FragColor = videoColor * (1.0 - overlayColor.a) + overlayColor * overlayColor.a;
}
