precision mediump float;

uniform sampler2D uSampler;

varying vec2 vTextureCoord;
uniform float uWidthOffset;
uniform float uHeightOffset;

void main() {
  if (vTextureCoord.y < uWidthOffset || vTextureCoord.y > (1.0 - uWidthOffset) || vTextureCoord.x < uHeightOffset || vTextureCoord.x > (1.0 - uHeightOffset) ) {
    gl_FragColor = vec4(0, 0, 0, 1.0);
  } else {
    gl_FragColor = texture2D(uSampler, vTextureCoord);
  }
}