var GAME_TIME = 10000; //ms

/* User Environment */
var HIT_COUNT_PER_ONE = 10;
var HIT_COUNT_PER_ONE_ON_ANGRY = 15;
var NUM_OF_HIT_PER_COIN = 10;
var MAX_COIN_LIMIT = 6
var HIT_VALID_TERM = 80; //ms
var COMBO_DISABLE_TERM = 500; //ms
var g_wlogo="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJYAAACRCAYAAAAhBEFaAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKTWlDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVN3WJP3Fj7f92UPVkLY8LGXbIEAIiOsCMgQWaIQkgBhhBASQMWFiApWFBURnEhVxILVCkidiOKgKLhnQYqIWotVXDjuH9yntX167+3t+9f7vOec5/zOec8PgBESJpHmomoAOVKFPDrYH49PSMTJvYACFUjgBCAQ5svCZwXFAADwA3l4fnSwP/wBr28AAgBw1S4kEsfh/4O6UCZXACCRAOAiEucLAZBSAMguVMgUAMgYALBTs2QKAJQAAGx5fEIiAKoNAOz0ST4FANipk9wXANiiHKkIAI0BAJkoRyQCQLsAYFWBUiwCwMIAoKxAIi4EwK4BgFm2MkcCgL0FAHaOWJAPQGAAgJlCLMwAIDgCAEMeE80DIEwDoDDSv+CpX3CFuEgBAMDLlc2XS9IzFLiV0Bp38vDg4iHiwmyxQmEXKRBmCeQinJebIxNI5wNMzgwAABr50cH+OD+Q5+bk4eZm52zv9MWi/mvwbyI+IfHf/ryMAgQAEE7P79pf5eXWA3DHAbB1v2upWwDaVgBo3/ldM9sJoFoK0Hr5i3k4/EAenqFQyDwdHAoLC+0lYqG9MOOLPv8z4W/gi372/EAe/tt68ABxmkCZrcCjg/1xYW52rlKO58sEQjFu9+cj/seFf/2OKdHiNLFcLBWK8ViJuFAiTcd5uVKRRCHJleIS6X8y8R+W/QmTdw0ArIZPwE62B7XLbMB+7gECiw5Y0nYAQH7zLYwaC5EAEGc0Mnn3AACTv/mPQCsBAM2XpOMAALzoGFyolBdMxggAAESggSqwQQcMwRSswA6cwR28wBcCYQZEQAwkwDwQQgbkgBwKoRiWQRlUwDrYBLWwAxqgEZrhELTBMTgN5+ASXIHrcBcGYBiewhi8hgkEQcgIE2EhOogRYo7YIs4IF5mOBCJhSDSSgKQg6YgUUSLFyHKkAqlCapFdSCPyLXIUOY1cQPqQ28ggMor8irxHMZSBslED1AJ1QLmoHxqKxqBz0XQ0D12AlqJr0Rq0Hj2AtqKn0UvodXQAfYqOY4DRMQ5mjNlhXIyHRWCJWBomxxZj5Vg1Vo81Yx1YN3YVG8CeYe8IJAKLgBPsCF6EEMJsgpCQR1hMWEOoJewjtBK6CFcJg4Qxwicik6hPtCV6EvnEeGI6sZBYRqwm7iEeIZ4lXicOE1+TSCQOyZLkTgohJZAySQtJa0jbSC2kU6Q+0hBpnEwm65Btyd7kCLKArCCXkbeQD5BPkvvJw+S3FDrFiOJMCaIkUqSUEko1ZT/lBKWfMkKZoKpRzame1AiqiDqfWkltoHZQL1OHqRM0dZolzZsWQ8ukLaPV0JppZ2n3aC/pdLoJ3YMeRZfQl9Jr6Afp5+mD9HcMDYYNg8dIYigZaxl7GacYtxkvmUymBdOXmchUMNcyG5lnmA+Yb1VYKvYqfBWRyhKVOpVWlX6V56pUVXNVP9V5qgtUq1UPq15WfaZGVbNQ46kJ1Bar1akdVbupNq7OUndSj1DPUV+jvl/9gvpjDbKGhUaghkijVGO3xhmNIRbGMmXxWELWclYD6yxrmE1iW7L57Ex2Bfsbdi97TFNDc6pmrGaRZp3mcc0BDsax4PA52ZxKziHODc57LQMtPy2x1mqtZq1+rTfaetq+2mLtcu0W7eva73VwnUCdLJ31Om0693UJuja6UbqFutt1z+o+02PreekJ9cr1Dund0Uf1bfSj9Rfq79bv0R83MDQINpAZbDE4Y/DMkGPoa5hpuNHwhOGoEctoupHEaKPRSaMnuCbuh2fjNXgXPmasbxxirDTeZdxrPGFiaTLbpMSkxeS+Kc2Ua5pmutG003TMzMgs3KzYrMnsjjnVnGueYb7ZvNv8jYWlRZzFSos2i8eW2pZ8ywWWTZb3rJhWPlZ5VvVW16xJ1lzrLOtt1ldsUBtXmwybOpvLtqitm63Edptt3xTiFI8p0in1U27aMez87ArsmuwG7Tn2YfYl9m32zx3MHBId1jt0O3xydHXMdmxwvOuk4TTDqcSpw+lXZxtnoXOd8zUXpkuQyxKXdpcXU22niqdun3rLleUa7rrStdP1o5u7m9yt2W3U3cw9xX2r+00umxvJXcM970H08PdY4nHM452nm6fC85DnL152Xlle+70eT7OcJp7WMG3I28Rb4L3Le2A6Pj1l+s7pAz7GPgKfep+Hvqa+It89viN+1n6Zfgf8nvs7+sv9j/i/4XnyFvFOBWABwQHlAb2BGoGzA2sDHwSZBKUHNQWNBbsGLww+FUIMCQ1ZH3KTb8AX8hv5YzPcZyya0RXKCJ0VWhv6MMwmTB7WEY6GzwjfEH5vpvlM6cy2CIjgR2yIuB9pGZkX+X0UKSoyqi7qUbRTdHF09yzWrORZ+2e9jvGPqYy5O9tqtnJ2Z6xqbFJsY+ybuIC4qriBeIf4RfGXEnQTJAntieTE2MQ9ieNzAudsmjOc5JpUlnRjruXcorkX5unOy553PFk1WZB8OIWYEpeyP+WDIEJQLxhP5aduTR0T8oSbhU9FvqKNolGxt7hKPJLmnVaV9jjdO31D+miGT0Z1xjMJT1IreZEZkrkj801WRNberM/ZcdktOZSclJyjUg1plrQr1zC3KLdPZisrkw3keeZtyhuTh8r35CP5c/PbFWyFTNGjtFKuUA4WTC+oK3hbGFt4uEi9SFrUM99m/ur5IwuCFny9kLBQuLCz2Lh4WfHgIr9FuxYji1MXdy4xXVK6ZHhp8NJ9y2jLspb9UOJYUlXyannc8o5Sg9KlpUMrglc0lamUycturvRauWMVYZVkVe9ql9VbVn8qF5VfrHCsqK74sEa45uJXTl/VfPV5bdra3kq3yu3rSOuk626s91m/r0q9akHV0IbwDa0b8Y3lG19tSt50oXpq9Y7NtM3KzQM1YTXtW8y2rNvyoTaj9nqdf13LVv2tq7e+2Sba1r/dd3vzDoMdFTve75TsvLUreFdrvUV99W7S7oLdjxpiG7q/5n7duEd3T8Wej3ulewf2Re/ranRvbNyvv7+yCW1SNo0eSDpw5ZuAb9qb7Zp3tXBaKg7CQeXBJ9+mfHvjUOihzsPcw83fmX+39QjrSHkr0jq/dawto22gPaG97+iMo50dXh1Hvrf/fu8x42N1xzWPV56gnSg98fnkgpPjp2Snnp1OPz3Umdx590z8mWtdUV29Z0PPnj8XdO5Mt1/3yfPe549d8Lxw9CL3Ytslt0utPa49R35w/eFIr1tv62X3y+1XPK509E3rO9Hv03/6asDVc9f41y5dn3m978bsG7duJt0cuCW69fh29u0XdwruTNxdeo94r/y+2v3qB/oP6n+0/rFlwG3g+GDAYM/DWQ/vDgmHnv6U/9OH4dJHzEfVI0YjjY+dHx8bDRq98mTOk+GnsqcTz8p+Vv9563Or59/94vtLz1j82PAL+YvPv655qfNy76uprzrHI8cfvM55PfGm/K3O233vuO+638e9H5ko/ED+UPPR+mPHp9BP9z7nfP78L/eE8/sl0p8zAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAABKqSURBVHja7J15vBTVlce/j319CDxEERiSURAim4iEZRwQE5GHEdRxHE00cWbiaDQTESUuJEEZPxONGuOSKAnojBhHRKMRUYRoBkVxiZABJkYU2WQPYNh5vJM/zmkpO71UVVd3V/W7v8+nP/1e962qe6t/de65y/mdKhHBIdZoBgwGOgLjgaZAa2BklvK/B9bZ378BNgBvAJ+UstJVjlixxIlALTAAGAH0KPB8HwPLgXeAZ4C3gHpHrIaBJsAE4CpgCNC8iNdaATwKPAasdcSqTBxrZKoF+pf42nuB2cA9wLuOWJWBKmAy8B2gc5nrchiYBfwQWOmIlVyMBaYAX4xZvXYBPwB+7IiVLLQDbgWuMJ8qrlgAfAv4oyNW/NEDmAv0SUh9dwOXAE+HObiR+71LgouAlxNEKoA2wFPA/WGHuA7FxSXAIwmu/5U20LjSEStepHo44nN+CByy97fTvusGDLW/exohosAVgJjf5YhVZnzNSFXoj3sQnSn/NbDY/j5gP3S2aQyAgUBfdOZ+NPC5CCyXoHNuznkvI6keKZBUHwI/A+ahyzGFoIVNcVyPrjsW4lvfB1ztiFV69DIihO0N1gD3AtOJfuG4Cl1/vBE4v4Dz3Ap8zxGrdOgGzEcXkcN0efcC04CdJajr+cDUkCPVfei65ouOWKXB7JCWYKl1Uy+VuL41wC3mnAfFWmAQsM0Rq7i4CF1vC0PGb5bISmXDN9D5qpYBj3sJ+LIjVvHQAXjPLEAQTEXX5uKAseiEaNDtOrXA8+kfupn3aHBTCFLdEiNSYeQ4z6YyguCnQFtHrOgxCJgY8JgfAd+PYVvmmo+4N8Ax3YF/ccSKHjcGLL/EusC44jng9oDHTASqHbGiw6k27PaL9eaT7I55u25B98b7RVcbADhiRYQLCDa7fjWwPQHtEuDfA9Z1ktfXcsQKj47AxQHKvwL8KkHtWwNcF9BqDXXEKhyjgWN8lt0NXJ7ANs7kr3dQ5PO1HLEKxD8EKPswBWzzLTOmBSg7zEaJjlghUUP2SOR07LHphaRiLvCmz7Jtgd6OWOExCP8TokvMX0kq6oCfBCh/LlBVzo1+PW24nsJm6893JOBmfylA2bsr4EFagK5lHuWj7BlAoyZl+lEmA8PRDWhe7EB3SkYWOFkk9PBZbgOwqAKItRl4FRjnszvsVMqusAUwB92vNDoDqQDao/vEXweuielNbm8PhR+sRINAKwGP+yzXCTipVMRqBTxp/a8fVAN3kWeXYpkg1h4/eKWC/Mr3ApTtVypi3YcuZQTFDWl+WBww3CexBPiggoj1PrDaZ9khpSDWF4CvFtB93hazG3wM/vaz11uXXinYBez3WfZgKYh1LapCFxajbaQRp+G3H1QV2O444i2/BYtNrBpgTATnOSeBP8LbHJFsrBT4DUOrLzaxuqDCYoWiKdFF9ZYKn6CRN5WEZj7LtSk2sQ5HdJ7aAI2KCxryqkbrYjc+Kivz+wC+jUP5DcWmYhNrP8E352fCqgitX6lwChrAWkk4yme5xsUm1ipUyKJQrE7gj9A2gd13PoyNkx/wdIHHHyJeOy/9TiHUA40rjFh+teGblIJYs1Bd8bC4B/goRjf3d6h2Qd7ugCxRwglFtwBd+8elINafCB9CvoJ4BXWCLtP4fXK7VBCxTkIjvv1gXqmGxIuBswm20r8CnVzdE7MbXBfA5/sKlSNuF2T1o0kp51peNXK948PC/ac1ZH0Mb/Ae/G/V7QOcXCHEGuaznAB1pX6aFqG7Fb6Cpvc4Pc0SPGuOety38s4HLvNRrgrN2PVmwkk1AJWe9IMNwBtObSYceqJrgW19lF1lD9HeBLf3IeBffZb9COjpginCYRWw0WfZ40kLP08YOhBg/gqdu6tyxAqHeuCFAOUnoYL8ScQ3geMClF9NCXY3VDJm4H/jWw90L3/ScDzBYw9eA+ocscJjGcFy/E3Gf0h+XHArcHTAY5qCC1gtFPcEKNsdDWtLCi5AFf6CookjVuF4yiyXX1yCJr6MO7oADxJua/VCR6zCcQj4j4DHTEX38ccVnWxgclTI49c4YkWDXwW0WtV2zOkxbc9taA6esGjmiBWd1QoaotYGlWKMG7nuJINQbQAcTI2U3cx7NKgCniB4Vord6PLWy2Wuf2dUZO2sCEbKAwFxFisaCKovui2k5frHMtb9VDQnzlkRnKve7oXrCiPEJnSWOmjQR1tUcONRSrt/qzHwdXTXSf+IzvlpVgtHrGjxNPBAyGMvRndBTEKz3RcTA9AZ8plEG629zBGreLgGXe4Jg+OAO9BsYNcVMOTP5geOs7otAYYUoe2fhuA75704aIKGo/cq8Dyr0Rw3c1CBkf0Bj2+GbimutdeQIrf7u9jqgiNW8XC8OcWfj+h866yrXG9k25mnqzsFDeboSumihW5Ad/86YhUZJxi5PtcA2lqP5pv+nfOxio/3gb8D/jvBbfAbgS5ovIJz3kuEDcClaBKBpOF/gZsDTmE4YpUQgm5P/irxjDzKhLtQhes/hDnYEau0mIUmMvpljOu4Ft2HdS269jfC53GfEZpzxCo91qOJyS9G9dPjgkNo3pyB6D4z7wjTD3bjEZpzxCofHrMfcSq6HFROQs206YkpXgcc3ZbcJ4yT74dYTYETHQ+Kgo2oNsVA4FsEEI+NqMubiS5CX4aK26WjLf6lPp/z/pMpEro5Oqk3Bg0PH4IuNfS0EY5D9NiErjE+aD/0eFSOoHfE11mHprf7CRqVni9v0SgbeORTZqxP50ZqgvRYO8m51phM5u/LwEsN8EfvZb7QzhJftzE64TjYuqkzrIfxG+mzA10CescINc+mD4IIs7wAnOmj3D7gb4CtXmLNA04jf7aFn+M/zLpS0NGe8J8BN5W5Lq2MWCPInIcoHUuMRGFD+7uhuYD8BNquRrfe/NnbFY7Cs48mB860cgcaELGuQkPMJ5uzvaKMddnrsSKlwBj8R28/4yVVynl/MQCDv9aASNXfRkmpbulWKk/6MReCpCZemP5BI2B2gBNc59O6JR2NgO+nEWkCycyQEQYj8B+itoMMCckboVpPfrOa9kQn9iod5xuR0jEN/3KJScbN+J/jXESGebhGwBZ037NffBdoWeEO+w+yfNcb+HaFk2oYwVIT/zKbyQf4nwAnOqHCrdZEcs8fXUNhAZ1xRmvg/gDWanU2Vyp1gtkBRzx3oiIXlYZ+NhLMhWrgpxXqyF+M/7XBlEE6nItYB7EtpT6RurmVhGp7Wqt9lB1OfHNWh0V34PYA5XehM/jkIlbKav1/gBOPpbImTKfhf4sI5ocNqpC2twAeIVjY2QPkkMv0EusAwTUIbkOXHJKOS9FI5qD+yONURhbVG4CRAcp/Atybq0C6kzYbXcLwixo0YiTJ5Oob0A3w4njzM5KcjOl64HsBj7mDPOK+maJ0xgJzA15omx33VsJu6knoykOhoe1PAxeSvIyq1xNcZXClDXIOB7FYmAWaHvBiNejqeZIsV190cjgKvYQJCbRc14UgVT0qAZA/ckdEMr3ai8gqCY4tIjIoyznj9BopIhskeswRkRYJaP+kkO170O81cn05TkTqQlx8s4hcEuOb+m0pLpaJSP+Ytr2NiNwVsl2rzeAUTCxEZEoBN/gOEamO0U3tJCKPSmmw1QgcJ1INEJGFIduzRUR6BrlevgItROTJAm7wuyIyOgY39VwRWS+lx0wR6V3mtrc3A7GzgHZcGvS6fgo1FZFXC6jUQbMU5ege+ojIggLJsUBE1hRw/A4RmSgiHUrc9ioRuUBElhZQ9zoRuTzM9f0W7CsiGwv8gfaLyH+ZSS72DR0kIjNEZG+BdX5eRBrbQ7GlwHOtNYJ1L3L7O4rIBBF5LQKLe3fYegTtozdHUNkDIvKiPQlR3eRGItJVRC4TkUURdWPzRKSl5xr/bNa3UOwWkekiUisibSNqf2MRGSwiUyPs8n8tIq3D1imojNFAdM/10RHNpewFfosq2L2O6gSss/mSbJONTW1nQRfgC2gESy0a+9g6onrNt7mpvRkWn59B92xFgbXAG3a9jei+uE8lrXOs62HtrkFDxfrZroSqiOo1BfgRwYXecs68+5mt/iHBctj5xR50N+sBu9npE3FV6Ca0VqiMYjFStb2IhsFli24ZbJPINUW49iZUHPdDMgeQdka1H0AF1YqBK4lg50pY4bWmqK75+ArbOnI3ui03X8jUYFTzqlcFtX0XcCPhxXkjIRa2fHEVcEuEXVC5sNHM/y8CHNPGyFUJD9cf0Kic5VGdsBBRkIOohtJQ4L0E39TX0JjJXwQ8brf5YZfjP41v3CBoarxToiRVocRK4f9QvYFJhTh7ZbJSNwF/b20Ii4fsHHMSRqrlqGzCd8y3jRRRi9v2QwW7LozxSv8h4Enr+j6I8l6iYWMTgS/GmFDr0S3F0ymiHkWxVJO/hGaRGh8jgtUZoW4nWMrdML3ABWYJhsSIUOvQXZ8zgO3Fvlix5bj7oUEH56FaS+V6Ql+w0c67JbxuFZp8aRI6/1cukbs1qDzSdIInkYotsVLoYg7yeag8dXWRr7cHjdB9Ct3dua2MlqIRqjNWi6aQO7kE1/wQlZx6Bp10/XOpG12OBALdUCWTAah8Up+InublwGKzSvPsSY0bqoxYY9BZ/N5AjwjOu93I9Dw6k78YDXgoX0NjkJmiHzoPNhwV78KsWrZlk10cSRz5MfAKKvy1NIHD/TboFumWqIJfE7Pmp+cZhacGHYvMd1pLzNQW45rypFEOp/8Q/rMlJBW5hNUSMaXjcuk4FM0yODg4Yjk4Yjk4Yjk4OGI5OGI5OGI5ODhiOThiOThiOTg4Yjk4Yjk4Yjk4OGI5OGI5OGI5ODhiOThiOThiOTg4Yjk4Yjk4Yjk4OGI5xA5NynDNVkboOj4bfNkclaBM/xw0YrjKvtuX49wpTdIDaGBrLrQkd/rdg+TO5nUcn5UrWkn+RKKpNh6yOqb/FqlA1X1k1l9tRXYB28N57k1pUQZR/3kisklEZqV9/pB9/o6ItPN8fpp9vt4SAuTKkbPJXtf6qMcCK7tFRHZleE3KceydGTI97BeRB/IkaZpq1/xxhu9qPfU/OUuGiT/a9zvS6rpFRD4SkTPjkmKlHF3hMlT99/McyU7aBtXS6oyKZvTzlB9jn28nu1BaNTDZynVG9TTz4RgrW42qFae/sqnc3YmKq7VD9SKmoErLzYErUIWbVlmOPcqu2SGLJU/Vv1kWt6Wrff9JWl07oboXTxET0bdyEOtVez+FI3rxJ9pNT8ErinGavS/O0H2kMAyVSkp1fwPInzsxVXY+qn6c/sokST3SSAWalXUImkt6jBEM4CxUlzRbd4V16emo93Ykeepcm1bXs+3etAL6N1RivW0+VBOOaJafatYrpZhyrr3XACd4CJAN59n7E2hCyubAZT7rUxeg7pPtfSma7tbrg01DVZRBxeaKqQFWn/b/cxzRha9vqMTaauTCY7bH2fuTqC5mD6A9qh91NKpQnE2NryuqeQowC00ADnAO/jJoHGMW0vsamKFclTnsKQJnGhzMsvdORu5iIZWdI/WaaFYaYHNDHRUeRiWwR6CaWB2BUfak3WefDzI/a7gd8xrwUZbznWU+2jbgN+afbAeOte8eyVOfocDCtM9WoBk4vOhrRIfsCdk/8LRRfHTDgcda9v6Cx1qK+Vd1wGOo6FyDJFaKKPVoFvh/sqd7DSoittiINYEjQmxLcpzrfHt/yxzbOusWRlkXmY9Yq4FnsxDEi532qslh6dt5rFsu9LIHIGxy8maeOrTydIEH49IVlotYr9ucS7U5vlWoVugBIwioBnln+3tBlvMMBEZ7LFe6PORoVIpyZY66vIsqHOdDSjWvxkg7O0OZczxzYJKlO8Uc7MYZ5s1SyDa/VuW5N8s9I81r0eThX0cTAixtiD4WqNzjMvMVzrDPXvFYM7FupwOwJQcxJtiPsMe6s5fttdD8slaegUAufyWIpcWmRnqmfdcauMj+/i3wpxznqeKvkzyNtPdNwPt56rHPHsID5lPdzhHN9lMbqvOe8jGesBvc3Ejwpn23js9mvppPZl3ylkYsgJ8bQVPO9xkeok4gunRrd9iPeqzNXY0yq3m21fNvrdz0LBbrcfu8nXW/w+z4m9GsWyn/bWueeqRbtG0eC7YnDsQq5+zs0LTM7009383wfHd1luMv9JQ5LcP33/B8Pz7D9+/bdwsD1nuciOzLkUByUp7jZ+Q4dqeIDMxyXI2nXKYstcvsu/vjMPPepIycftv8gY7WdXlHSjM9XVS2HDUtbXi/1eOXefGsnadZFsv8BNCd4EkFnrPR6uXm17W1UeDLwMPA3DzH/5u1fbxnEnc/qst+G5qJKxP2myVsmcWCzzFLvyUOBusvAwDEC0c2iD7MoAAAAABJRU5ErkJggg==";
var g_gameoverFlag = false;
var g_lastTouch = 0;

var g_topPadding = 0;
var g_bottomPadding = 0;
var AudioWrapper = cc.Class.extend({
    _Bgm: undefined,
    _Effect: undefined,
    _vibe: undefined,
    ctor: function () {
        this.getConfigs();
    },
    enable: function () {
        this._Bgm = true;
        this._Effect = true;
        return true;
    },
    disable: function () {
        this._Bgm = false;
        this._Effect = false;
        return true;
    },
    playMusic: function (res, repeat) {
        if (this._Bgm === undefined) this.getConfigs();
        console.log("bgm is")
        console.log(this._Bgm)
        if (!this._Bgm) return false;
        if (!cc.sys.isNative) {
            return cc.audioEngine.playEffect(res, repeat);
        }
        return cc.audioEngine.playMusic(res, repeat);
    },
    stopMusic: function () {
        if (!this._Bgm) return false;
        if (!cc.sys.isNative) {
            return cc.audioEngine.stopAllEffects();
        }
        return cc.audioEngine.stopMusic();
    },
    playEffect: function (res, repeat) {
        if (this._Effect === undefined) this.getConfigs();
        if (!repeat)
            repeat = false;
        if (!this._Effect) return false;

        if (cc.sys.isNative) {
            return jsb.AudioEngine.play2d(res, repeat)
        }
        return cc.audioEngine.playEffect(res, repeat);
    },
    stopEffect: function (id) {
        if (!this._Effect) return false;
        if (cc.sys.isNative) {
            if (!id)
                return jsb.AudioEngine.stopAll();
            return jsb.AudioEngine.stop(id);
        }
        if (!id)
            return cc.audioEngine.stopAllEffects();
        return cc.audioEngine.stopEffect(id);
    },
    setMusicVolume: function (vol) {
        if (!cc.sys.isNative) return;
        return cc.audioEngine.setMusicVolume(vol);
    },
    preloadEffect: function () {
        for (var el in g_effectSnd) {
            if (cc.sys.isNative) {
                jsb.AudioEngine.preload(g_effectSnd[el])
            } else {
                cc.loader.getRes(g_effectSnd[el]);
            }
        }
    },
    preloadBgm: function () {
        for (var el in g_bgmSnd) {
            if (cc.sys.isNative) {
                jsb.AudioEngine.preload(g_bgmSnd[el])
            } else {
                cc.loader.getRes(g_bgmSnd[el]);
            }
        }
    },
    applyPreload: function () {
        this.preloadBgm();
        this.preloadEffect();
    },
    getConfigs: function () {
        var self = this;
        W.getConfig("bgmDisable").then(
            function (r) {
                if (r === true) {
                    console.log("BGM DISABLE!")
                    self._Bgm = false;
                    self.stopMusic();
                } else if (r === false) {
                    self._Bgm = true;
                }
            });

        W.getConfig("effectDisable").then(
            function (r) {
                if (r === true) {
                    console.log("Sound EFFECT DISABLE!")
                    self._Effect = false;
                    self.stopEffect();
                } else if (r === false) {
                    self._Effect = true;
                }
            });

        W.getConfig("vibrateDisable").then(
            function (r) {
                if (r === true) {
                    console.log("Vibrate DISABLE!")
                    self._vibe = false;
                } else if (r === false) {
                    self._vibe = true;
                }
            });



    },
    vibrate: function (duration) {
        if (this._vibe === undefined) this.getConfigs();
        if (cc.sys.isNative && this._vibe) {
            cc.Device.vibrate(duration);
        }
    }
});
var AudioManager;

var ResPreloader = cc.Layer.extend({
    ctor: function (p) {
        this._super();
        this.spaceLayer=p;

        this.processCnt=0;
        this.resCnt = 0;        
        this.imgArr = new Array();

        this.getImageArr();
        p.addChild(this);
        
        this.resCnt +=Object.keys(g_effectSnd).length;
        this.resCnt +=Object.keys(g_bgmSnd).length;

        this.loadProcess();
        this.imgPreload();
        this.audioPreload(g_effectSnd);
        this.audioPreload(g_bgmSnd);

        this.scheduleUpdate();        
    },
    getImageArr:function() {        
        for(var i in g_resources) {
            if(g_resources[i].indexOf(".png") >=0 ||
               g_resources[i].indexOf(".jpg") >=0 ||
               g_resources[i].indexOf(".bmp") >=0 ||  
               g_resources[i].indexOf(".jpge") >=0 || 
               g_resources[i].indexOf(".gif") >=0) {
                  this.resCnt++;
                  this.imgArr.push(g_resources[i]);
            }
        }
    },
    audioPreload: function (resArr) {
        for (var el in resArr) {
            if(cc.sys.isNative) {
                jsb.AudioEngine.preload(resArr[el])
            } else {
                cc.loader.getRes(resArr[el]);
            }
            this.processCnt++;
        }
    },
    loadProcess:function() {
        var circleBg = new cc.Sprite(g_imgs.java_in3_ffe357_opa15);
        var circle = new cc.Sprite(g_imgs.java_in3_ffe357_f);
        this.addChild(circleBg);
        this.addChild(circle);
        circle.setScale(2);
        circleBg.setScale(2);
        circle.setPosition(cc.winSize.width/2,cc.winSize.height/2);
        circleBg.setPosition(cc.winSize.width/2,cc.winSize.height/2);
        circle.runAction(cc.sequence(
            cc.rotateBy(2,360),
            cc.callFunc(function() {
                circle.setRotation(0);
            })
        ).repeatForever());

        this.loadTxt = new cc.LabelBMFont("0", g_fonts.Roboto_75);        
        
        this.loadTxt.setColor(cc.color(0xff, 0xff, 0xff, 0xff));        
        this.addChild(this.loadTxt);
        this.loadTxt.setScale(0.4)
        this.loadTxt.setPosition(cc.winSize.width/2,cc.winSize.height/2);

        this.loadDes = new cc.LabelBMFont("Loading", g_fonts.Roboto_75);        
        
        this.loadDes.setColor(cc.color(0xff, 0xff, 0xff, 0xff));        
        this.addChild(this.loadDes);
        this.loadDes.setScale(0.4)
        this.loadDes.setPosition(cc.winSize.width/2,cc.winSize.height/2-100);

        this.slot = new Array();       
    },
    imgPreload: function () {
        var self = this;
        for (var i in this.imgArr) {
            cc.textureCache.addImage(this.imgArr[i], function (tex) {                
                self.processCnt++;                                        
           });          
        }
      },
    
    imgPreload: function () {
        var self = this;
        for (var i in this.imgArr) {
            cc.textureCache.addImage(this.imgArr[i], function (tex) {                
                self.processCnt++;                                        
           });          
        }
      },

    displayProcess:function() {       
        var percent = ((this.processCnt / this.resCnt )* 100).toFixed(1);
        this.loadTxt.setString(percent+"%");

    },
    update:function() {
        this.displayProcess();
        if(this.processCnt >= this.resCnt) {
            this.spaceLayer.initialize();
            this.removeFromParent();
        }
    }
    
});



var WUtils = WUtils || {};

WUtils.now = function () {
	return (new Date()).getTime();
}

WUtils.getScreenSize = function () {
	return cc.director.getVisibleSize();
}

WUtils.randInt = function (s, e) {
	if (s == undefined) s = 0;
	if (e == undefined) e = 1000000;
	var min = Math.ceil(s);
	var max = Math.floor(e);
	return Math.floor(Math.random() * (max - min + 1)) + min;

}
var Button = cc.Sprite.extend({    
  label:null,
  ctor: function (resource,func,idx) {    
      this._super();
      this.label = new cc.MenuItemLabel(new cc.Sprite(resource), func, this);      
      var buttonTemp = new cc.Menu(this.label);
      //buttonTemp.alignItemsVerticallyWithPadding(10);    
      this.addChild(buttonTemp);
      buttonTemp.setPosition(cc.p(0,0));  
  }
});
var ButtonHit = cc.Sprite.extend({
  label: null,
  lastClick:0,
  ctor: function (res1, res2, pos, func) {
    this._super(g_imgs.noneImg);
    this.label = new cc.MenuItemLabel(new cc.Sprite(res1), func, this);
    var buttonTemp = new cc.Menu(this.label);
    //buttonTemp.alignItemsVerticallyWithPadding(10);    
    this.addChild(buttonTemp);
    this.cb = func;
    var canvasSize = WUtils.getScreenSize();
    this.width = canvasSize.width;
    this.height = canvasSize.height;    
    buttonTemp.setPosition(pos);
    this.btnTop = new cc.Sprite(res2);
    this.label.addChild(this.btnTop);
    this.btnTop.setPosition(this.btnTop.width*0.5, this.btnTop.height*0.5);    
    //this.btnTop.setPosition(_pos);
    //this.text = new cc.LabelBMFont(txt, g_fonts.Roboto_75);
    //this.text.setPosition(cc.p(0,0))
    //this.addChild(this.text);
  },
  onClicked: function () {
    var self=this;
    this.btnTop.runAction(
      cc.sequence(
        cc.callFunc(function() {
            self.btnTop.setPosition(self.btnTop.width*0.5, self.btnTop.height*0.5)
        }),     
        cc.moveTo(0.07,self.btnTop.width*0.5, self.btnTop.height*0.4),
        cc.moveTo(0.07,self.btnTop.width*0.5, self.btnTop.height*0.5)
        )
    );
    //this.cb();
  },
  validClick: function() {    
    if(WUtils.now() - this.lastClick > HIT_VALID_TERM) {
      this.lastClick = WUtils.now();
      return true;
    }
    return false;
  }
});
var CoinRain = cc.Sprite.extend({
    ctor: function (par, objPig) {
        this._super(g_imgArr.coin[0]);
        this.gameLayer = par
        par.addChild(this);
        this.setVisible(false)
        this.objPig = objPig;
        this.setPosition(objPig.getPosition())
        this.dtStack = 0;
        this.nextCoinGenScore = (HIT_COUNT_PER_ONE*NUM_OF_HIT_PER_COIN);
        this.scheduleUpdate();
        return this;
    },
    doCoinRain: function () {
        this.stopAllActions();
        var animation = new cc.Animation();
        for (var i = 0; i < g_imgList["coin"]; i++) {
            animation.addSpriteFrameWithFile(g_imgArr["coin"][i]);
        }
        animation.setDelayPerUnit(0.06);
        var action = cc.animate(animation);
        var self = this;
        this.gameLayer.onScoring()
        this.runAction(cc.sequence(
            action,
            cc.callFunc(function () {
                self.setVisible(false)                                
            })
        ));
    },
    update: function (dt) {
        this.dtStack += dt;
        if (this.dtStack > 0.3) {
            this.dtStack = 0;
            if (this.gameLayer.hitCnt > this.nextCoinGenScore) {
                this.setVisible(true)
                AudioManager.playEffect(g_effectSnd.g4_point);
                this.nextCoinGenScore += (HIT_COUNT_PER_ONE*NUM_OF_HIT_PER_COIN);
                if(this.gameLayer.getScore() < MAX_COIN_LIMIT)
                    this.doCoinRain();
            }
        }
    }

});
var Hand = cc.Sprite.extend({
    ctor: function (par, onDismiss) {
        this._super(g_imgArr.hand[0]);
        this.gameLayer = par
        par.addChild(this);
        var size = cc.director.getWinSize();
        this.setPosition(size.width * 0.7, size.height - (this.height / 2));
        //this.scheduleUpdate();        
        this.comboInterval = 1000;
        this.angry = false;
        this.onDismiss = onDismiss;
        return this;
    },
    dispose: function () {
        this.removeFromParent();
        this.onDismiss();
    },
    coinInsert: function () {
        this.stopAllActions();
        var hand = this;
        var animation = new cc.Animation();
        for (var i = 0; i < g_imgList["hand"]; i++) {
            animation.addSpriteFrameWithFile(g_imgArr["hand"][i]);
        }
        animation.setDelayPerUnit(0.11);
        var action = cc.animate(animation);
        this.runAction(cc.sequence(
            cc.delayTime(0.3),
            cc.callFunc(function () {
                AudioManager.playEffect(g_effectSnd.g4_put);
            })
        ));
        this.runAction(cc.sequence(
            action,
            cc.callFunc(function () {
                ;
                hand.dispose();
            })
        ));
    }

});
var Pig = cc.Sprite.extend({
    combo: 0,
    lastPunchTS: 0,
    dtStack: 0,
    ctor: function (par) {
        this._super(g_imgArr.pig_basic[3]);
        this.gameLayer = par
        //this.onStandby()
        par.addChild(this);
        var size = cc.director.getWinSize();
        this.setPosition(size.width / 2, size.height * 0.692);
        this.scheduleUpdate();
        //this.onCoinInsert()        
        this.angry = false;
        return this;
    },
    dispose: function () {
        this.removeFromParent();
    },
    onCoinInsert: function (coinListener) {
        var self = this;
        this.stopAllActions();
        this.runAction(cc.sequence(
            cc.moveBy(0.2, 0, -50),
            cc.delayTime(0.05),
            cc.moveBy(0.25, 0, 200),
            cc.delayTime(0.15),
            cc.callFunc(function() {
                AudioManager.playEffect(g_effectSnd.g4_oink)
            }),
            cc.moveBy(0.2, 0, -190),
            cc.moveBy(0.07, 0, 50),
            cc.moveBy(0.07, 0, -10),
            cc.callFunc(function () {
                coinListener()
            })
        ));
    },
    onLeftPunch: function () {
        if (!this.angry && this.combo++ >= 5) {
            this.setAngry(true);
        }
        this.lastPunchTS = this.dtStack;
        AudioManager.playEffect(g_effectSnd.g4_hit);
        if (this.angry)
            this.changeAnimation("pig_hit_l_an");
        else
            this.changeAnimation("pig_hit_l");
    },
    onRightPunch: function () {
        if (!this.angry && this.combo++ >= 5) {
            this.setAngry(true);
        }
        this.lastPunchTS = this.dtStack;
        AudioManager.playEffect(g_effectSnd.g4_hit);
        if (this.angry)
            this.changeAnimation("pig_hit_r_an");
        else
            this.changeAnimation("pig_hit_r");
    },
    setAngry: function (yn) {
        this.angry = yn;
        if (!yn) {
            this.changeAnimation("pig_basic");
        } else {
            AudioManager.playEffect(g_effectSnd.g4_scream);
        }
    },
    changeAnimation: function (res) {
        this.stopAllActions();
        var pig = this;
        var animation = new cc.Animation();
        for (var i = 0; i < g_imgList[res]; i++) {
            animation.addSpriteFrameWithFile(g_imgArr[res][i]);
        }
        animation.setDelayPerUnit(0.1);
        var action = cc.animate(animation);
        //this.circleSp.setPosition(this.circleSp.width/2,this.circleSp.height/2);
        //this.pigShield.setPosition(this.circleSp.width/2,this.circleSp.height/2);
        this.runAction(cc.sequence(
            action,
            cc.delayTime(1),
            cc.callFunc(function () {
                pig.onAnimationFinish();
            })
        ));
    },
    onAnimationFinish: function () {

    },
    update: function (dt) {
        this.dtStack += dt
        if (this.angry && this.dtStack - this.lastPunchTS > (COMBO_DISABLE_TERM / 1000)) {
            this.setAngry(false);
            this.combo = 0;
        }
    }
});
var Weapon = cc.Sprite.extend({
    ctor: function (par, res, dir) {
        this._super(res);
        this.gameLayer = par
        par.addChild(this);
        //var xPos = WUtils.getScreenSize().width * 0.102
        var xPos = WUtils.getScreenSize().width * 0 
        if (dir == -1) {
            //xPos = WUtils.getScreenSize().width * 0.861 ;
            xPos = WUtils.getScreenSize().width * 1 + (1 - 0.861);
        }
        this.oriPos = cc.p(xPos, WUtils.getScreenSize().height * 0.416);
        this.targetPos = cc.p(WUtils.getScreenSize().width * 0.264, WUtils.getScreenSize().height * 0.570)
        if (dir == -1) {
            this.targetPos = cc.p(WUtils.getScreenSize().width * 0.736, WUtils.getScreenSize().height * 0.570)
        }
        this.setPosition(this.oriPos);        
        this.scheduleUpdate();        
        this.comboInterval = 1000;
        this.angry = false;
        return this;
    },
    dispose: function () {
        this.removeFromParent();
    },
    attack: function (onHit) {
        var self = this;
        this.runAction(cc.sequence(
            cc.moveTo(0.1, self.targetPos.x, self.targetPos.y),
            cc.callFunc(function() {
                onHit();
            }),
            cc.moveTo(0.1, self.oriPos.x, self.oriPos.y)
        ))
    }

});
var GameBgLayer = cc.LayerColor.extend({
  ctor: function (p) {
    var canvasSize = WUtils.getScreenSize();
    this.defColor = cc.color(0xfe, 0xf6, 0xc8);
    this._super(this.defColor, canvasSize.width, canvasSize.height);
    p.addChild(this);
    //this.width = canvasSize.width;
    //this.height = canvasSize.height;
    this.hitColorArr = [
      cc.color(0xfe, 0xc8, 0xfd, 0xff),
      cc.color(0xd2, 0xc8, 0xfe, 0xff),
      cc.color(0xc8, 0xfe, 0xe4, 0xff),
      cc.color(0xd9, 0xfe, 0xc8, 0xff),
    ];
    //this.setColor(this.defColor)

    //this.gradient = cc.LayerGradient.create(this.defColor, this.defColor);
    //this.gradient = new cc.Sprite(this.defColor);
    //this.gradient.width = canvasSize.width;
    //this.gradient.height = canvasSize.height;
    //this.gradient.setOpacity(0xff);
    //this.addChild(this.gradient);
    //노 - (핑 - 보 - 초 - 연)
  },
  onHit: function () {
    var self = this;
    this.stopAllActions();    
    this.setBgColor(this.defColor);
    this.runAction(
      cc.sequence(
        self.getColorChangeFunc(self.hitColorArr[0]),
        cc.delayTime(0.1),
        self.getColorChangeFunc(self.hitColorArr[1]),
        cc.delayTime(0.1),
        self.getColorChangeFunc(self.hitColorArr[2]),
        cc.delayTime(0.1),
        self.getColorChangeFunc(self.hitColorArr[3]),
        cc.delayTime(0.1),
        self.getColorChangeFunc(self.defColor)
      )
    );
  },
  setBgColor: function (color) {
    this.setColor(color);
    //this.gradient.setColor(color);
    //this.gradient.setStartColor(color);
    //this.gradient.setEndColor(color);
  },

  getColorChangeFunc: function (color) {
    var self = this;
    return cc.callFunc(function () {
      self.setBgColor(color)
    });
  }

});
var TopTxtLayer = cc.Layer.extend({
  ctor: function (gl) {
    this._super();
    this.gameLayer = gl;

    gl.addChild(this);
    this.initailize();
  },
  initailize: function () {
    //this.setPosition(0, WUtils.getScreenSize().height * 0.9);
    this.remainTxt = new cc.Sprite(g_imgs.remain_txt);
    var time_10 = Math.floor(GAME_TIME / 10000);
    var time_01 = Math.floor((GAME_TIME % 10000) / 1000);
    this.remainTxt_10 = new cc.Sprite(g_imgArr.number[time_10]);
    this.remainTxt_01 = new cc.Sprite(g_imgArr.number[time_01]);
    this.coinIcon = new cc.Sprite(g_imgs.g4_score);
    this.coinScore = new cc.Sprite(g_imgArr.number[0]);
    var self = this;
    this.escBtn = new Button(g_imgs.close_btn, function () {
      self.escBtn.stopAllActions();
      self.escBtn.runAction(
        cc.sequence(
          cc.scaleTo(0.1, 1.2),
          cc.delayTime(0.1),
          cc.scaleTo(0.1, 1),
          cc.callFunc(function () {
            self.gameLayer.finishGame();
          })
        )
      );
      //Todo : EXIT
    });


    var sc = WUtils.getScreenSize();
    this.width = sc
    this.height = sc;
    this.escBtn.setPosition(sc.width * 0.9152, sc.height * (1 - 0.06109));
    this.remainTxt.setPosition(sc.width * 0.12, sc.height * (1 - 0.049));
    this.remainTxt_10.setPosition(sc.width * 0.207, sc.height * (1 - 0.06));
    this.remainTxt_01.setPosition(sc.width * 0.25, sc.height * (1 - 0.06));
    this.coinIcon.setPosition(sc.width * 0.3444, sc.height * (1 - 0.06));
    this.coinScore.setPosition(sc.width * 0.4083, sc.height * (1 - 0.06));

    this.addChild(this.remainTxt)
    this.addChild(this.remainTxt_10)
    this.addChild(this.remainTxt_01)
    this.addChild(this.coinIcon)
    this.addChild(this.coinScore)
    this.addChild(this.escBtn)
  },
  setTime: function (ms) {
    if (ms < 0) ms = 0
    var time_10 = Math.floor(ms / 10000);
    var time_01 = Math.floor((ms % 10000) / 1000);
    this.remainTxt_10.setTexture(g_imgArr.number[time_10])
    this.remainTxt_01.setTexture(g_imgArr.number[time_01])
  },
  setScore: function (s) {
    if (s < 0 || s > MAX_COIN_LIMIT) return;
    this.coinScore.setTexture(g_imgArr.number[s])
  }
});
var GameLayer = cc.Layer.extend({
    canvasSize: null,
    space: null,
    lastUpdate: 0,
    spaceLayer: null,
    gameLayer: null,
    gameBg: null,
    clickMgr: null,
    bgMusic: null,
    charStr: null,
    parLayer: null,
    lastBtn: 0,
    lastBtnTS: 0,
    hitCnt: 0,
    ctor: function (p, r) {
        this._super();
        p.addChild(this);
        this.canvasSize = cc.director.getVisibleSize();
        this.gameLayer = this;
        this.spaceLayer = p;
        this.dtStack = 0;
        this.gameStatus = "prepare";
        this.initializeGame();
        this.scheduleUpdate();
        //this.addDefaultHandler();
        //cc.director.getScheduler().setTimeScale(0.5);
        //this.initDebugMode();
    },
    initializeGame: function () {
        //this.initPhysics();
        AudioManager.stopMusic();
        AudioManager.stopEffect();
        this.restartGame();
    },
    restartGame: function () {
        this.lastBtn = 0;
        this.lastBtnTS = 0;
        this.hitCnt = 0;
        this.dtStack = 0;
        this.score = 0;
        this.gameStatus = "prepare";
        this.removeAllChildren();
        this.startGame();;
    },
    startGame: function () {
        var self = this;
        //AudioManager.playMusic(g_bgmSnd.bgm_basic,true);
        g_gameoverFlag = false;
        this.backGround = new GameBgLayer(this);

        this.scoreLayer = new TopTxtLayer(this);
        this.bgBottom = new cc.Sprite(g_imgs.bg_bottom);
        this.bgBottom.setPosition(cc.p(this.width / 2, 0));
        //this.addChild(this.bgBottom);
        //this.topTxtLayer = new TopTxtLayer(this);
        this.pig = new Pig(this);
        this.handTrigger = new Hand(this, function () {
            self.pig.onCoinInsert(function () {
                self.addChild(self.leftBtn);
                self.addChild(self.rightBtn);
                self.onGameStart();
            });
        });
        this.handTrigger.coinInsert();
        this.leftBtn = new ButtonHit(g_imgs.left_btn, g_imgs.left_guide,
            cc.p(WUtils.getScreenSize().width * 0.384, WUtils.getScreenSize().height * 0.423),
            function () {
                if (self.gameStatus == "end") return;
                if (self.lastBtn != 1 && self.leftBtn.validClick()) {
                    self.lastEffect = self.dtStack;
                    self.lastBtn = 1;
                    self.lastBtnTS = self.dtStack;
                    self.leftBtn.onClicked();
                    self.leftHand.attack(function () {
                        self.backGround.onHit();
                        self.pig.onLeftPunch();
                        if (self.pig.angry) {
                            self.hitCnt += HIT_COUNT_PER_ONE_ON_ANGRY;
                        } else {
                            self.hitCnt += HIT_COUNT_PER_ONE;
                        }
                    });

                }
            });
        this.coinRain = new CoinRain(this, this.pig);
        this.rightBtn = new ButtonHit(g_imgs.right_btn, g_imgs.right_guide,
            cc.p(WUtils.getScreenSize().width * 0.617, WUtils.getScreenSize().height * 0.423),
            function () {
                if (self.gameStatus == "end") return;
                if (self.lastBtn != 2 && self.rightBtn.validClick()) {
                    self.lastEffect = self.dtStack;
                    self.lastBtn = 2;
                    self.lastBtnTS = self.dtStack;
                    self.rightBtn.onClicked();
                    self.rightHand.attack(function () {
                        self.backGround.onHit();
                        self.pig.onRightPunch()
                        if (self.pig.angry) {
                            self.hitCnt += HIT_COUNT_PER_ONE_ON_ANGRY;
                        } else {
                            self.hitCnt += HIT_COUNT_PER_ONE;
                        }
                    })
                }
            });
        this.leftBtn.setPosition(cc.p(this.width / 2, this.height / 2));
        this.rightBtn.setPosition(cc.p(this.width / 2, this.height / 2));
        var rand = WUtils.randInt(0, 100);
        var resNum = 0;
        if (rand >= 40 && rand < 60) {
            resNum = 1;
        } else if (rand >= 60 && rand < 80) {
            resNum = 2;
        } else if (rand >= 80 && rand < 90) {
            resNum = 3;
        } else if (rand >= 90) {
            resNum = 4;
        }
        var lres = g_imgArr["weapon_l"][resNum];
        var rres = g_imgArr["weapon_r"][resNum];
        this.banner = new cc.Sprite(g_imgs.banner);
        this.banner.setPosition(WUtils.getScreenSize().width * 0.5, WUtils.getScreenSize().height * 0.208);
        //this.addChild(this.banner)
        this.leftHand = new Weapon(this, lres, 1);
        this.rightHand = new Weapon(this, rres, -1);


    },
    finishGame: function () {
        this.onGameEnd();
        var score = parseFloat(this.score);
        W.stop(score);
    },
    onScoring: function () {
        if (this.score == undefined) this.score = 0;
        this.score++;

        if (this.score >= MAX_COIN_LIMIT) {
            this.score = MAX_COIN_LIMIT;
            this.finishGame();
        }
        this.scoreLayer.setScore(this.score);

    },
    getScore: function () {
        return this.score;
    },
    onGameEnd: function () {
        this.gameStatus = "end"
    },
    onGameStart: function () {
        this.gameStatus = "start"
    },
    onTouch: function (touches, event) {
        var self = event.getCurrentTarget();
        //console.log(self.readyComplete,self.shootFlag,g_gameoverFlag)
        if (!self.readyComplete) return;
        if (self.shootFlag || g_gameoverFlag) return;
    },
    initPhysics: function () {
        this.space = new cp.Space();
        space = this.space;
        space.iterations = 10;
        space.damping = 1;
        space.collisionSlop = 0.1;
        space.gravity = cp.v(0, 0);
        var staticBody = space.staticBody;
    },
    update: function (dt) {
        //this.space.step(dt);
        if (this.gameStatus == "start") {
            this.dtStack += dt;
        }
        var timeMS = GAME_TIME - this.dtStack * 1000;
        this.scoreLayer.setTime(timeMS);
        if (timeMS <= 0) {
            this.finishGame();
            return;
        }
        if (this.dtStack - this.lastBtnTS > 0.4) {
            this.lastBtn = 0;
        }

        if (this.gameStatus == "start" && this.dtStack - this.lastEffect > 1) {
            this.lastEffect = this.dtStack;
            AudioManager.playEffect(g_effectSnd.g4_oink);
        }
    },
    onGameOver: function () {
        if (g_gameoverFlag) return;
        this.shootFlag = false;
        g_gameoverFlag = true;
        //this.dispose();
        this.spaceLayer.onGameOver();
        //console.log("gameOver!");
    },
    resumeGame: function () {
        g_gameoverFlag = false;
        this.shootFlag = false;

    },
    initDebugMode: function () {
        var phDebugNode = new cc.PhysicsDebugNode(this.space);
        this.addChild(phDebugNode);
    },

    dispose: function () {
        cc.eventManager.removeListener(this.listener);
    },

    addDefaultHandler: function () {
        var beginHandler = function (arbiter, space) {
            return false;
        };

        var preSolveHandler = function (arbiter, space) {
            return true;
        };

        var postSolveHandler = function (arbiter, space) {
            return true;
        };

        var separateHandler = function (arbiter, space) {
            return true;
        };

        this.gameLayer.space.setDefaultCollisionHandler(beginHandler, preSolveHandler,
            postSolveHandler, separateHandler);
    }
});
var SpaceLayer = cc.Layer.extend({
  GameLayer: null,
  TextLayer: null,
  BgLayer: null,
  topLayer: null,
  titleLayer: null,
  ctor: function () {
    this._super();
    var self = this;
    W.on('message', function (msg) {
      var m = JSON.parse(msg);
      console.log(">>>>>>>>>>>>> on message", msg, m.type, m.arg0)
      if (m.type == "config") {
        self.setConfig(m);
      } else if (m.type == "action" && m.arg0 == "type=start") {
        setTimeout(function() {
          AudioManager.getConfigs()
        }, 0)
        setTimeout(function() {
          self.onGameStart();
        }, 500)
      }
    });
    W.getConfig("enableButton");
    this.initialize();
    this.isStartGame = false;

  },
  setConfig: function (conf) {
    var confStr = conf.arg0.split("&");
    this.conf = {};
    for (var i in confStr) {
      var key = confStr[i].split("=")[0];
      var value = confStr[i].split("=")[1];
      if (key == "time")
        this.conf.time = value
      else if (key == "max")
        this.conf.max = value
      else if (key == "tune0")
        this.conf.tune0 = value
      else if (key == "tune1")
        this.conf.tune1 = value
      else if (key == "tune2")
        this.conf.tune2 = value
    }


    if (this.conf == undefined) this.conf = {};
    if (this.conf.max == undefined || this.conf.max == 0) this.conf.max = 6
    if (this.conf.time == undefined || this.conf.time == 0) this.conf.time = 10
    if (this.conf.tune0 == undefined || this.conf.tune0 == 0) this.conf.tune0 = 10
    if (this.conf.tune1 == undefined || this.conf.tune1 == 0) this.conf.tune1 = 15
    if (this.conf.tune2 == undefined || this.conf.tune2 == 0) this.conf.tune2 = 10

    GAME_TIME = this.conf.time * 1000; //ms
    /* User Environment */
    HIT_COUNT_PER_ONE = parseInt(this.conf.tune0);
    HIT_COUNT_PER_ONE_ON_ANGRY = parseInt(this.conf.tune1);
    NUM_OF_HIT_PER_COIN = parseInt(this.conf.tune2);
    MAX_COIN_LIMIT = parseInt(this.conf.max);
  },
  getConfig: function () {
    return this.conf;
  },
  onGameStart: function () {
    var self = this;
    W.start().then(function (r) {
      self.startSeq(r);
      AudioManager.stopEffect();
    })
  },
  startSeq: function (r) {
    var self = this;
    if (r.err === 'ok') {
      self.isStartGame = true;
      self.GameLayer = new GameLayer(self, r);
    }
  },
  initialize: function () {
    //this.onGameStart();
    this.canvasSize = cc.director.getVisibleSize();
    this.backGround = new GameBgLayer(this);
    this.bgBottom = new cc.Sprite(g_imgs.bg_bottom);
    this.bgBottom.setPosition(cc.p(this.width / 2, 0));
    //this.addChild(this.bgBottom);
    //this.topTxtLayer = new TopTxtLayer(this);
    this.pig = new Pig(this);
    //console.log("???");
    //this.onGameStart();
    /*
    this.startSeq({
      err: "ok"
    });
    */
  },
  onGameOver: function () {
    if (this.deadLayer) {
      this.deadLayer.removeFromParent();
      this.deadLayer = null
    }
    this.deadLayer = new DeadLayer(this);
    this.deadLayer.zIndex = 0;
  },
  resetAll: function (obj) {
    obj.isStartGame = false;
    obj.removeAllChildren(true);
    obj.GameLayer = null;
    obj.TextLayer = null;
    obj.deadLayer = null;
    //obj.BgLayer = null;
    obj.topLayer = null;
    obj.titleLayer = null;
    g_gameoverFlag = false;
  }

});
var GameLoader = cc.Scene.extend({
  GameLayer: null,
  SpaceLayer: null,
  onEnter: function () {
    this._super();    
    this.resPreloader = new ResPreloader(this);

  },
  initialize: function () {
    this.SpaceLayer = new SpaceLayer();
    this.addChild(this.SpaceLayer);
  }
});
var g_imgs = {
  noneImg: "noneImg",
  bg_bottom: "bg_bottom",
  g4_dust: "g4_dust",
  remain_txt: "g4_time",
  g4_score: "g4_score",
  banner: "banner",
  java_in3_ffe357:"java_in3_ffe357.png",
  java_in3_ffe357_f:"java_in3_ffe357_f.png",
  java_in3_ffe357_opa15:"java_in3_ffe357_opa15.png",
  left_btn: "btn/btn_ctn_hit_l_bg",
  left_guide: "btn/btn_ctn_hit_l2",
  right_btn: "btn/btn_ctn_hit_r_bg",
  right_guide: "btn/btn_ctn_hit_r2",
  close_btn:"btn/g2_btn_close"
};

var g_fonts = {
  ceviche: "CevicheOne-Regular.fnt",
  Roboto_75: "Roboto_75.fnt"
};

var g_resources = [];

for (var i in g_imgs) {
  if (g_imgs[i].indexOf(".") < 0)
    g_imgs[i] = "res/assets/imgs/" + g_imgs[i] + ".png";
  else
    g_imgs[i] = "res/assets/imgs/" + g_imgs[i];
  g_resources.push(g_imgs[i]);
}


for (var i in g_fonts) {
  g_fonts[i] = "res/assets/font/" + g_fonts[i];
  g_resources.push(g_fonts[i]);
}


var g_imgArr = {};
var g_imgList = {
  "coin": 13,
  "hand":5,
  "number":10,
  "pig_basic": 4,  
  "pig_hit_l": 4,
  "pig_hit_l_an": 4,
  "pig_hit_r": 5,
  "pig_hit_r_an": 5,
  "pig_play": 11,
  "weapon_l": 5,
  "weapon_r": 5,
}


for (var i in g_imgList) {
  var limit = g_imgList[i];
  g_imgArr[i] = {};
  for (j = 0; j < limit; j++) {
    g_imgArr[i][j] = "res/assets/imgs/" + i + "/" + j + ".png";
    g_resources.push(g_imgArr[i][j]);
  }
}

var g_effectSnd = {
  g4_hit: "g4_hit.wav",
  g4_oink: "g4_oink.wav",
  g4_point: "g4_point.wav",
  g4_put: "g4_put.wav",
  g4_scream: "g4_scream.wav",
}

for (var i in g_effectSnd) {
  g_effectSnd[i] = "res/assets/snd/" + g_effectSnd[i];
  //g_resources.push(g_effectSnd[i]);
}

var g_bgmSnd = {
  //bgm_basic: "bgm_basic.mp3"
}

for (var i in g_bgmSnd) {
  g_bgmSnd[i] = "res/assets/snd/" + g_bgmSnd[i];
  //g_resources.push(g_bgmSnd[i]);
}

var g_etc = {


}

for (var i in g_etc) {
  g_resources.push(g_etc[i]);
}

window.onload = function () {
  cc.game.onStart = function () {
    //load resources
    cc._loaderImage = undefined
    cc.view.setDesignResolutionSize(720, 1280, cc.ResolutionPolicy.EXACT_FIT);
    cc.sys.isMobile = false;
    AudioManager = new AudioWrapper();
    AudioManager.applyPreload(); 
    cc.LoaderScene.preload(g_resources, function () {
      cc.director.runScene(new GameLoader());
    }, this);
  };
  W.CONFIG = {};
  var canvas = document.body.getElementsByTagName('canvas')[0]
  
  //W.startCapture(canvas, 360, 640, 15)
  cc.game.run("gameCanvas");

};

if(cc.sys.isNative) {
  cc.game.onStart = function(){
    var sys = cc.sys;
    if(!sys.isNative && document.getElementById("cocosLoading")) //If referenced loading.js, please remove it
      document.body.removeChild(document.getElementById("cocosLoading"));

    // Pass true to enable retina display, on Android disabled by default to improve performance
    cc.view.enableRetina(sys.os === sys.OS_IOS ? true : false);
    // Disable auto full screen on baidu and wechat, you might also want to eliminate sys.BROWSER_TYPE_MOBILE_QQ
    if (sys.isMobile && 
      sys.browserType !== sys.BROWSER_TYPE_BAIDU &&
      sys.browserType !== sys.BROWSER_TYPE_WECHAT) {
      cc.view.enableAutoFullScreen(true);
    }

    // Adjust viewport meta
    cc.view.adjustViewPort(true);

    // Uncomment the following line to set a fixed orientation for your game
    cc.view.setOrientation(cc.ORIENTATION_PORTRAIT);

    // Setup the resolution policy and design resolution size
    cc.view.setDesignResolutionSize(720, 1280, cc.ResolutionPolicy.SHOW_ALL);

    // The game will be resized when browser size change
    cc.view.resizeWithBrowserSize(true);

    //load resources
    AudioManager = new AudioWrapper();
    AudioManager.applyPreload(); 
    cc.LoaderScene.preload(g_resources, function () {
      cc.director.runScene(new GameLoader());
    }, this);
  };
  cc.game.run();
}
