(function (root) {
  var exports = undefined,
      module = undefined,
      require = undefined;
  var define = undefined;
  var self = root,
      window = root,
      global = root,
      globalThis = root;
  (function () {
    window.defaultProxy = {
      login_handle: null,

      init(data, handler) {
        handler && handler(0);
      },

      login(data, handler) {
        this.login_handle = handler;
        const user = localStorage.getItem("user");

        if (!user || user == "") {
          this.openAccount();
          return;
        }

        const loginData = JSON.stringify({
          "openId": user
        });
        handler && handler(0, loginData);
      },

      openAccount(data) {
        GameMgr.inst.sendMsgToCreater(-3, {
          handle: () => {
            this.login("", this.login_handle);
          }
        }, "ST_Canvas", "ST_Top");
      },

      async pay(data, handle) {
        console.log("defaultsdk pay ::" + JSON.stringify(data));
        const jdata = JSON.parse(data.arg);
        const p = {
          orderId: jdata.custom,
          rmb: jdata.postAmount
        };
        const msg = await GameMgr.inst.sendMsgToServer(2353, p);
        handle(msg.code);
      },

      xCopy(str) {
        window.XEClipboard(str);
        return;
      },

      initAD(data, handler) {
        handler(0, JSON.stringify({
          action: "adInit"
        }));
      },

      openAD(data, handler) {
        handler(0, JSON.stringify({
          action: "adLoad"
        }));
        handler(0, JSON.stringify({
          action: "adShow"
        }));
        handler(0, JSON.stringify({
          action: "adRet"
        }));
      },

      submit(data, handle) {}

    };
  }).call(root);
})( // The environment-specific global.
function () {
  if (typeof globalThis !== 'undefined') return globalThis;
  if (typeof self !== 'undefined') return self;
  if (typeof window !== 'undefined') return window;
  if (typeof global !== 'undefined') return global;
  if (typeof this !== 'undefined') return this;
  return {};
}.call(this));