(function (root) {
  var exports = undefined,
      module = undefined,
      require = undefined;
  var define = undefined;
  var self = root,
      window = root,
      global = root,
      globalThis = root;
  (function () {
    cc.UI.spriteAssembler.getAssembler(new cc.Sprite()).updateUVs = function (sprite) {
      if (!sprite.spriteFrame) return;
      const renderData = sprite.renderData;
      const vData = renderData.chunk.vb;
      const uv = sprite.spriteFrame.uv;

      if (!uv) {
        console.log("如果发现这个报错 请把这个报错发给程序:" + sprite.spriteFrame._uuid);
      }

      vData[3] = uv[0];
      vData[4] = uv[1];
      vData[12] = uv[2];
      vData[13] = uv[3];
      vData[21] = uv[4];
      vData[22] = uv[5];
      vData[30] = uv[6];
      vData[31] = uv[7];
    };

    cc.Layout.prototype._doLayoutHorizontally = function (baseWidth, rowBreak, fnPositionY, applyChildren) {
      const trans = this.node._uiProps.uiTransformComp;
      const layoutAnchor = trans.anchorPoint;

      const limit = this._getFixedBreakingNum();

      let sign = 1;
      let paddingX = this._paddingLeft;

      if (this._horizontalDirection === cc.Layout.HorizontalDirection.RIGHT_TO_LEFT) {
        sign = -1;
        paddingX = this._paddingRight;
      }

      const startPos = (this._horizontalDirection - layoutAnchor.x) * baseWidth + sign * paddingX;
      let nextX = startPos - sign * this._spacingX;
      let totalHeight = 0; // total content height (not including spacing)

      let rowMaxHeight = 0; // maximum height of a single line

      let tempMaxHeight = 0; //

      let maxHeight = 0;
      let isBreak = false;
      const activeChildCount = this._usefulLayoutObj.length;
      let newChildWidth = this._cellSize.width;

      const paddingH = this._getPaddingH();

      if (this._layoutType !== cc.Layout.Type.GRID && this._resizeMode === cc.Layout.ResizeMode.CHILDREN) {
        newChildWidth = (baseWidth - paddingH - (activeChildCount - 1) * this._spacingX) / activeChildCount;
      }

      const children = this._usefulLayoutObj;

      for (let i = 0; i < children.length; ++i) {
        const childTrans = children[i];
        const child = childTrans.node;
        const scale = child.scale;

        const childScaleX = this._getUsedScaleValue(scale.x);

        const childScaleY = this._getUsedScaleValue(scale.y); // for resizing children


        if (this._resizeMode === cc.Layout.ResizeMode.CHILDREN) {
          childTrans.width = newChildWidth / childScaleX;

          if (this._layoutType === cc.Layout.Type.GRID) {
            childTrans.height = this._cellSize.height / childScaleY;
          }
        }

        const anchorX = Math.abs(this._horizontalDirection - childTrans.anchorX);
        const childBoundingBoxWidth = childTrans.width * childScaleX;
        const childBoundingBoxHeight = childTrans.height * childScaleY;

        if (childBoundingBoxHeight > tempMaxHeight) {
          maxHeight = Math.max(tempMaxHeight, maxHeight);
          rowMaxHeight = tempMaxHeight || childBoundingBoxHeight;
          tempMaxHeight = childBoundingBoxHeight;
        }

        nextX += sign * (anchorX * childBoundingBoxWidth + this._spacingX);
        const rightBoundaryOfChild = sign * (1 - anchorX) * childBoundingBoxWidth;

        if (rowBreak) {
          if (limit > 0) {
            isBreak = i / limit > 0 && i % limit === 0;

            if (isBreak) {
              rowMaxHeight = tempMaxHeight > childBoundingBoxHeight ? tempMaxHeight : rowMaxHeight;
            }
          } else if (childBoundingBoxWidth > baseWidth - paddingH) {
            if (nextX > startPos + sign * (anchorX * childBoundingBoxWidth)) {
              isBreak = true;
            }
          } else {
            Math.arou;
            const boundary = (1 - this._horizontalDirection - layoutAnchor.x) * baseWidth;
            const rowBreakBoundary = nextX + rightBoundaryOfChild + sign * (sign > 0 ? this._paddingRight : this._paddingLeft);
            isBreak = Math.abs(rowBreakBoundary) - Math.abs(boundary) > 1e-8;
          }

          if (isBreak) {
            nextX = startPos + sign * (anchorX * childBoundingBoxWidth);

            if (childBoundingBoxHeight !== tempMaxHeight) {
              rowMaxHeight = tempMaxHeight;
            } // In unconstrained mode, the second height size is always what we need when a line feed condition is required to trigger


            totalHeight += rowMaxHeight + this._spacingY;
            rowMaxHeight = tempMaxHeight = childBoundingBoxHeight;
          }
        }

        const finalPositionY = fnPositionY(child, childTrans, totalHeight);

        if (applyChildren) {
          child.setPosition(nextX, finalPositionY);
        }

        nextX += rightBoundaryOfChild;
      }

      rowMaxHeight = Math.max(rowMaxHeight, tempMaxHeight);

      const containerResizeBoundary = Math.max(maxHeight, totalHeight + rowMaxHeight) + this._getPaddingV();

      return containerResizeBoundary;
    };

    cc.assetManager.downloader.setRemoteServerAddress = function (remoteServerAddress) {
      this._remoteServerAddress = remoteServerAddress;
    };
  }).call(root);
})( // The environment-specific global.
function () {
  if (typeof globalThis !== 'undefined') return globalThis;
  if (typeof self !== 'undefined') return self;
  if (typeof window !== 'undefined') return window;
  if (typeof global !== 'undefined') return global;
  if (typeof this !== 'undefined') return this;
  return {};
}.call(this));