// (function sdkInit(){

//     callback = function (code, msg) {
//         console.log(code, msg);
//         switch (code) {
//             case youaiH5SDK.code.INIT_SUCCESS://初始化成功 msg为描述
//                 console.log("game init success")
//                 break;
//             case youaiH5SDK.code.LOGIN_SUCCESS://登录成功
//                 /**
//                 *custom: "test"//透传参数
//                 *userTYpe:"用户类型"
//                 *openId: "x1111dc104b800724d112195b61e1ff5"
//                 *serverSign: "ccb0488a46be85b9fc1b5bd55b532376"//签名校验sign
//                 *timestamp: "1554174508038"
//                 *other:""
//                 **/
//                 console.log("game login success");
//                 console.log("openId:" + msg.openId + "custom:" + msg.custom + "serverSign:" + msg.serverSign + "timestamp:" + msg.timestamp);
//                 break;
//             case youaiH5SDK.code.LOGOUT_SUCCESS:
//                 console.log("game logout success")
//                 //回到游戏登录入口，然后调用登录接口
//                 login();
//                 break;
//             case youaiH5SDK.code.SWITCH_SUCCESS:
//                 console.log("game switch account success")
//                 //游戏处理切换账号成功逻辑
//                 break;
//             case youaiH5SDK.code.PAY_SUCCESS:
//                 console.log("game pay success")
//                 break;
//             case youaiH5SDK.code.EXIT_SUCCESS:
//                 //游戏处理退出逻辑
//                 break;
//         }
//     }

// })()


window.publicAgent = {

    _initResolve: Promise.resolve,
    _loginResolve: Promise.resolve,
    _payResolve: Promise.resolve,
    callback(code, msg) {
        console.log(code, msg);
        switch (code) {
            case youaiH5SDK.code.INIT_SUCCESS: //初始化成功 msg为描述
                console.log("game init success")
                const p11 = {
                    code: 0
                }
                this._initResolve(JSON.stringify(p11))
                break;
            case youaiH5SDK.code.LOGIN_SUCCESS: //登录成功
                console.log("game login success");
                console.log("openId:" + msg.openId + "custom:" + msg.custom + "serverSign:" + msg.serverSign + "timestamp:" + msg.timestamp);
                this._loginResolve(JSON.stringify(msg));
                break;
            case youaiH5SDK.code.LOGOUT_SUCCESS:
                console.log("game logout success")
                //回到游戏登录入口，然后调用登录接口
                login();
                break;
            case youaiH5SDK.code.SWITCH_SUCCESS:
                console.log("game switch account success")
                //游戏处理切换账号成功逻辑
                break;
            case youaiH5SDK.code.PAY_SUCCESS:
                console.log("game pay success")
                const p0 = {
                    code: 0
                }
                this._payResolve(JSON.stringify(p0))
                break;
            case youaiH5SDK.code.EXIT_SUCCESS:
                //游戏处理退出逻辑
                break;
            case youaiH5SDK.code.PAY_CANCEL:
                const p = {
                    code: -1000
                }
                this._payResolve(JSON.stringify(p))

                break;
            case youaiH5SDK.code.PAY_FAIL:
                const p1 = {
                    code: -2000
                }
                this._payResolve(JSON.stringify(p1))
                break;
            case youaiH5SDK.code.INIT_FAIL:
                const p12 = {
                    code: -1
                }
                this._initResolve(JSON.stringify(p11))
                break;
        }
    },



    async init(data) {
        function loadScript(url) {
            const p = new Promise((resolve, reject) => {
                const script = document.createElement('script')
                script.type = 'text/javascript';
                // 处理IE
                if (script.readyState) {
                    script.onreadystatechange = function () {
                        if (script.readyState === 'loaded' || script.readyState === 'complete') {
                            script.onreadystatechange = null;
                            resolve();
                        }
                    }
                } else {
                    // 处理其他浏览器的情况
                    script.onload = function () {
                        resolve();
                    }
                }
                script.src = url;
                document.body.append(script);
            })
            return p;
        }
        if (window.location.hash.indexOf("ya_game") == -1)
            window.location.hash += "?ya_game=zjbxyx&ya_sn=jingyou_h5&ya_sv=2.0&ya_ssv=V1_0"
        await loadScript("https://static.public.sdk.gzyouai.com/h5_sdk/youaiH5SDK.js?" + Date.now())
        const p = new Promise((resolve, reject) => {
            this._initResolve = resolve;
            youaiH5SDK.init(this.callback.bind(this));
        })
        return p;
    },

    openAccount(data) {
        const has = youaiH5SDK.hasSwitchAccount()
        if (has) {
            youaiH5SDK.switchAccount();
        }
    },

    login(data) {
        const p = new Promise((resolve, reject) => {
            this._loginResolve = resolve;
            youaiH5SDK.login(data);
        })
        return p;
    },

    recharge(data) {
        const p = new Promise((resolve, reject) => {
            this._payResolve = resolve;
            var payInfo = {
                "serverId": data.sid,
                "serverName": data.sname,
                "playerId": data.playerId,
                "openId": data.openId,
                "playerName": data.nickName,
                "playerLevel": data.level,
                "postAmount": data.Amount,
                "productId": data.productId,
                "productName": data.productName,
                "productDesc": data.productDesc,
                "custom": data.orderId + "#" + data.playerId,
                "exchange": 10,
                "timestamp": data.time
            };
            //以上信息中，游戏如没有传空值即可
            //启用支付接口
            youaiH5SDK.pay(payInfo);
        })
        return p
    },

    submit(data) {
        /**
         *  在游戏中对应点根据不同的type进行调用
        /**
         * 为youaiH5SDK.type中对应类型值
            type: {
                arriveServerSelectPage: 1,//到达选服页面
                createRole: 2,//创建角色时调用
                enterGame: 3,//进入游戏时调用
                upRoleLevel: 4,//角色升级日志
                // arriveEntrance: 5,//首屏日志
                enterServer: 6,//选服完成，点击进入对应服时
                arriveFirstScene: 7,//到达游戏内第一场景时调用
                arriveLoadingFinish: 8,//资源加载完成
                arriveLoadingZero: 9,//刚开始加载资源类型
                // arriveCreateRolePage: 10, //到达创建角色页面
                newcomerFinish:11, //新手完成上报
                checkpointStart:12,//关卡开始
                checkpointEnd:13,//关卡结束
                // selectRole:14,//选角色
                renameRole:15,//角色改名
                newcomerStart:16//新手开始
            }
        var submitType = youaiH5SDK.type.enterGame;//进入游戏
        //设置角色信息
        
         */


        var roleInfo = {
            "roleId": data.playerId,
            "roleName": data.nickName,
            "roleLevel": data.level,
            "roleSex": 0,
            "serverId": data.sid,
            "serverName": data.sname,
            "roleCTime": data.roleCTime,
            "partyName": "",
            "roleType": "",
            "roleChangeTime": data.time,
            "vipLevel": data.vipLevel,
            "diamond": data.diamond,
            "moneyType": "",
            "custom": "",
            "isNew": data.isNew, //"新创建角色第一次登录进游戏为1，其他为0",
            "score": data.power,
            "roleLevelReborn": 0,
            "isFinishNewComer": data.isFinishGuide,
            "partyId": "0",
            "checkPointId": data.passId,
            "checkPointName": data.passName,
            "checkPointResult": data.result,
            "professionId": 0,
            "professionName": "无"
        };
        //以上信息中，游戏如没有传空值即可
        //启用提交信息接口
        youaiH5SDK.submitData(data.submitType, roleInfo);
    },

    loadSubPackage(data, progress) {
        const p = new Promise((resolve, reject) => {
            cc.assetManager.loadBundle('scripts', {
                onFileProgress: (e) => {
                    progress(1)
                }
            }, () => {
                progress(1)
                resolve()
            })
        })
        return p
    },

    openAD(data, onLoad, onError) {
        const p = {}
        p.code = 0
        return Promise.resolve(JSON.stringify(p))
    }

}