(function (root) {
  var exports = undefined,
      module = undefined,
      require = undefined;
  var define = undefined;
  var self = root,
      window = root,
      global = root,
      globalThis = root;
  (function () {
    /**
     * 运行时加载 label plus 默认材质
     */
    const labelPlusMats = {
      '03a67161-4837-41c1-bb2e-8a4a5b502e11': 'label-plus-material'
    };

    if (CocosEngine < '3.6.0') {
      cc.game.on(cc.Game.EVENT_GAME_INITED, () => {
        cc.assetManager.loadBundle('label-plus', (err, bundle) => {
          if (err) {
            console.error('[label-plus] load materials fail.', err);
          } else {
            console.log('[label-plus] bundle load success.');
            bundle.loadDir('materials', (err, assets) => {
              if (err) {
                console.error('[label-plus] load materials fail.', err);
                reject(err);
              } else {
                for (const mat of assets) {
                  mat.addRef();
                  const assetUuid = mat.name || labelPlusMats[mat._uuid];
                  cc.builtinResMgr._resources[assetUuid] = mat;

                  for (let j = 0; j < mat.passes.length; ++j) {
                    mat.passes[j].tryCompile();
                  }
                }

                console.log('[label-plus] load materials success.');
              }
            });
          }
        });
      });
    } else {
      cc.game.onPostProjectInitDelegate.add(() => {
        return new Promise((resolve, reject) => {
          cc.assetManager.loadBundle('label-plus', (err, bundle) => {
            if (err) {
              console.error('[label-plus] load materials fail.', err);
              reject(err);
              return;
            }

            bundle.loadDir('materials', (err, assets) => {
              if (err) {
                console.error('[label-plus] load materials fail.', err);
                reject(err);
              } else {
                for (const mat of assets) {
                  for (let i = 0; i < mat.passes.length; ++i) {
                    mat.passes[i].tryCompile();
                  }

                  const assetUuid = mat.name || labelPlusMats[mat._uuid];
                  cc.builtinResMgr.addAsset(assetUuid, mat);

                  cc.assetManager._releaseManager.addIgnoredAsset(mat);

                  cc.assetManager._releaseManager.addIgnoredAsset(mat.effectAsset);
                }

                console.log('[label-plus] load materials success.');
                resolve();
              }
            });
          });
        });
      });
    }
  }).call(root);
})( // The environment-specific global.
function () {
  if (typeof globalThis !== 'undefined') return globalThis;
  if (typeof self !== 'undefined') return self;
  if (typeof window !== 'undefined') return window;
  if (typeof global !== 'undefined') return global;
  if (typeof this !== 'undefined') return this;
  return {};
}.call(this));