#ifndef _CLOUDEWALK_AUTHORIZATION_HEADER_2019_
#define _CLOUDEWALK_AUTHORIZATION_HEADER_2019_

//Version: 1.0.20191213

#if defined LINUX || defined ANDROID || defined _IOS || defined _MAC_OS
#define CW_AUTH_API __attribute__((visibility("default")))
#else
#define CW_AUTH_API
#endif


#if defined (__cplusplus)
extern "C" {
#endif

/* 
* 函数功能：
*         验证调用该函数的机器传入的授权内容，是否合法授权
* 参数说明：
*        【IN】int authorization_content：通过授权工具生成的授权内容
*        【IN】int content_length：授权内容长度（字节数）
*        【IN】const char* packet_name：(IOS,Android)包名,PC端传NULL
*        【OUT】char *authorization_key：合法授权码明文，该内存由外部应用分配，最小空间为256字节。
* 返回值：
*         0：通过授权；
*         其它值：授权失败错误码，定义如下：
*                -1：传入参数错误
*                -2：授权文件内容异常
*                -3：绑定网卡非法
*                -4：授权公司名称不匹配
*                -5：包名不匹配
*********************************************************************************/
CW_AUTH_API int check_authorization(/*[IN]*/const char * authorization_content, /*[IN]*/int content_length, /*[IN]*/const char* packet_name,/*[OUT]*/char *authorization_key);

#if defined (__cplusplus)
}
#endif

#endif
