#include "LogUtil.h"
#include <stdlib.h>
#include <stdio.h>
#include <cwAuth.h>
#include <string>
#include "jni.h"
#include "../Algorithm/cwAuth.h"

#define MAX_FACE_NUM 2 //需和CloudwalkSDK.java中maxFaceNum一致


JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM *vm, void *reserved) {


    return JNI_VERSION_1_4; //这里很重要，必须返回版本，否则加载会失败。
}

static jstring str2jstring(JNIEnv *env, const char *pat) {
    //定义java String类 strClass
    jclass strClass = env->FindClass("java/lang/String");
    //获取String(byte[],String)的构造器,用于将本地byte[]数组转换为一个新String
    jmethodID ctorID = (env)->GetMethodID(strClass, "<init>", "([BLjava/lang/String;)V");
    //建立byte数组
    jbyteArray bytes = (env)->NewByteArray(strlen(pat));
    //将char* 转换为byte数组
    (env)->SetByteArrayRegion(bytes, 0, strlen(pat), (jbyte *) pat);
    // 设置String, 保存语言类型,用于byte数组转换至String时的参数
    jstring encoding = (env)->NewStringUTF("utf-8");
    //将byte数组转换为java String,并输出
    return (jstring) (env)->NewObject(strClass, ctorID, bytes, encoding);
}


static std::string jstring2str(JNIEnv *env, jstring jstr) {
    char *rtn = NULL;
    jclass clsstring = env->FindClass("java/lang/String");
    jstring strencode = env->NewStringUTF("utf-8");
    jmethodID mid = env->GetMethodID(clsstring, "getBytes", "(Ljava/lang/String;)[B");
    jbyteArray barr = (jbyteArray) env->CallObjectMethod(jstr, mid, strencode);
    jsize alen = env->GetArrayLength(barr);
    jbyte *ba = env->GetByteArrayElements(barr, JNI_FALSE);
    if (alen > 0) {
        rtn = (char *) malloc(alen + 1);
        memcpy(rtn, ba, alen);
        rtn[alen] = 0;
    }
    env->ReleaseByteArrayElements(barr, ba, 0);
    std::string stemp(rtn);
    free(rtn);
    return stemp;
}

extern "C" JNIEXPORT jstring JNICALL
Java_cn_cloudwalk_jni_AuthLibrary_cwGetLicenseFromFile__Ljava_lang_String_2Ljava_lang_String_2(
        JNIEnv *env, jobject thiz, jstring packageName, jstring pLicenseFile) {
    std::string licenseFile = jstring2str(env, pLicenseFile);

    std::string packName = jstring2str(env, packageName);

    char authorization_content[1024] = {0};
    int content_length = 0;
    char cwkey[256] = {0};

    //char filename[] = "/home/tester/icbc-auth/src/auth_client_20191216190916.cw";
    if (pLicenseFile == nullptr) {
        return nullptr;
    }

    const char *filename = licenseFile.c_str();
    const char *input_packageName = packName.c_str();


    FILE *fp = fopen(filename, "rb");
    if (fp) {
        int ret = fread(authorization_content, 1, sizeof(authorization_content), fp);

        if (ret > 0) {
            content_length = ret;

        } else {
            LOGE("err:%d\n", ret);
        }

        fclose(fp);
    } else {
        LOGE("Failed to open file:%s\n", filename);
        return nullptr;
    }

    //int check_authorization(/*[IN]*/const char * authorization_content, /*[IN]*/int content_length, /*[OUT]*/char *authorization_key);
    int ret = check_authorization(authorization_content, content_length, input_packageName, cwkey);


    if (ret != 0) {
        LOGE("Authorization failed! ret:%d\n", ret);
        return nullptr;
    } else {
        LOGE("cwkey:%s\n", cwkey);
    }


    jstring licenseString = str2jstring(env, cwkey);
//    if(authorization_content != nullptr){
//        //delete(authorization_content);
//        delete(cwkey);
//    }
    return licenseString;

}


