(function () {
    if (window.WebViewJavascriptBridge) {
        return '-1';
    }

    var messagingIFrame;
    var bizMessagingIFrame;
    var sendMessageQueue = [];
    var receiveMessageQueue = [];
    var messageHandlers = {};

    var CUSTOM_PROTOCOL_SCHEME = 'yy';
    var QUEUE_HAS_MESSAGE = '__QUEUE_MESSAGE__/';

    var responseCallbacks = {};
    var uniqueId = 1;

    function _createQueueReadyIFrame(doc) {
        messagingIFrame = doc.createElement('iframe');
        messagingIFrame.style.display = 'none';
        doc.documentElement.appendChild(messagingIFrame);
    }
    function _createQueueReadyIFrame4biz(doc) {
        bizMessagingIFrame = doc.createElement('iframe');
        bizMessagingIFrame.style.display = 'none';
        doc.documentElement.appendChild(bizMessagingIFrame);
    }

    function init(messageHandler) {
        if (WebViewJavascriptBridge._messageHandler) {
            throw new Error('WebViewJavascriptBridge.init called twice');
        }
        WebViewJavascriptBridge._messageHandler = messageHandler;
        var receivedMessages = receiveMessageQueue;
        receiveMessageQueue = null;
        for (var i = 0; i < receivedMessages.length; i++) {
            _dispatchMessageFromNative(receivedMessages[i]);
        }
    }

    function send(data, responseCallback) {
        _doSend({
            data: data
        }, responseCallback);
    }

    function registerHandler(handlerName, handler) {
        messageHandlers[handlerName] = handler;
    }

    function callHandler(handlerName, data, responseCallback) {
        _doSend({
            handlerName: handlerName,
            data: data
        }, responseCallback);
    }

    function _doSend(message, responseCallback) {
        if (responseCallback) {
            var callbackId = 'cb_' + (uniqueId++) + '_' + new Date().getTime();
            responseCallbacks[callbackId] = responseCallback;
            message.callbackId = callbackId;
        }

        sendMessageQueue.push(message);
        if (_isNewBridgeValid()) {
            window.NewWebViewJavascriptBridge.call(CUSTOM_PROTOCOL_SCHEME + '://' + QUEUE_HAS_MESSAGE);
        } else {
            messagingIframe.src = CUSTOM_PROTOCOL_SCHEME + '://' + QUEUE_HAS_MESSAGE;
        }
    }

    function _isNewBridgeValid() {
        return window.NewWebViewJavascriptBridge && window.NewWebViewJavascriptBridge.call;
    }

    function _fetchQueue() {
        var messageQueueString = JSON.stringify(sendMessageQueue);
        sendMessageQueue = [];
        if (messageQueueString !== '[]') {
            if (_isNewBridgeValid()) {
                window.NewWebViewJavascriptBridge.call(CUSTOM_PROTOCOL_SCHEME + '://return/_fetchQueue/' + encodeURIComponent(messageQueueString));
            } else {
                bizMessagingIframe.src = CUSTOM_PROTOCOL_SCHEME + '://return/_fetchQueue/' + encodeURIComponent(messageQueueString);
            }
        }
    }

    function _dispatchMessageFromNative(messageJSON) {
        setTimeout(function () {
            var message = JSON.parse(messageJSON);
            var responseDataStr = message.responseData;
            var responseData;
            try {
                responseData = JSON.parse(message.responseData);
            } catch (ignore) {
                responseData = message.responseData;
            }
            var responseCallback;
            if (message.responseId) {
                responseCallback = responseCallbacks[message.responseId];
                if (!responseCallback) {
                    return;
                }
                if (responseDataStr) {
                    responseCallback(responseDataStr);
                }
                if (responseData && !responseData.retain) {
                    delete responseCallbacks[message.responseId];
                }
            } else {
                if (message.callbackId) {
                    var callbackResponseId = message.callbackId;
                    responseCallback = function (responseData) {
                        _doSend({
                            responseId: callbackResponseId,
                            responseData: responseData
                        });
                    };
                }

                var handler = WebViewJavascriptBridge._messageHandler;
                if (message.handlerName) {
                    handler = messageHandlers[message.handlerName];
                }
                try {
                    handler(message.data, responseCallback);
                } catch (exception) {
                    if (typeof console != 'undefined') {
                        console.log(exception + '   ' + JSON.stringify(message) + '  ' + (typeof handler))
                    }
                }
            }
        });
    }

    function _handleMessageFromNative(messageJSON) {
        if (receiveMessageQueue) {
            receiveMessageQueue.push(messageJSON);
        }
        _dispatchMessageFromNative(messageJSON);
    }

    var WebViewJavascriptBridge = window.WebViewJavascriptBridge = {
        init: init,
        send: send,
        registerHandler: registerHandler,
        callHandler: callHandler,
        _fetchQueue: _fetchQueue,
        _handleMessageFromNative: _handleMessageFromNative
    };
    var doc = document;
    _createQueueReadyIFrame(doc);
    _createQueueReadyIFrame4biz(doc);
    var readyEvent = doc.createEvent('Events');
    readyEvent.initEvent('WebViewJavascriptBridgeReady');
    readyEvent.bridge = WebViewJavascriptBridge;
    doc.dispatchEvent(readyEvent);
    return '1';
})();

